/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.fc.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.fc.domain.FcInvestigateDomain;
import com.qjsoft.laser.controller.facade.fc.domain.FcInvestigateReDomain;
import com.qjsoft.laser.controller.facade.fc.repository.FcInvestigateServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.repository.OcServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/fc/investigate"}, name="\u8003\u5bdf\u670d\u52a1")
public class InvestigateCon
extends SpringmvcController {
    private static String CODE = "fc.investigate.con";
    @Autowired
    private FcInvestigateServiceRepository fcInvestigateServiceRepository;
    @Autowired
    private OcServiceRepository ocServiceRepository;

    protected String getContext() {
        return "investigate";
    }

    @RequestMapping(value={"saveInvestigate.json"}, name="\u589e\u52a0\u8003\u5bdf\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveInvestigate(HttpServletRequest request, FcInvestigateDomain fcInvestigateDomain) {
        if (null == fcInvestigateDomain) {
            this.logger.error(CODE + ".saveInvestigate", (Object)"fcInvestigateDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        fcInvestigateDomain.setTenantCode(this.getTenantCode(request));
        return this.fcInvestigateServiceRepository.saveInvestigate(fcInvestigateDomain);
    }

    @RequestMapping(value={"saveInvestigateToPC.json"}, name="PC\u7aef\u589e\u52a0\u8003\u5bdf\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveInvestigateToPC(HttpServletRequest request, FcInvestigateDomain fcInvestigateDomain) {
        if (null == fcInvestigateDomain) {
            this.logger.error(CODE + ".saveInvestigateToPC", (Object)"fcInvestigateDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        fcInvestigateDomain.setTenantCode(this.getTenantCode(request));
        return this.fcInvestigateServiceRepository.saveInvestigate(fcInvestigateDomain);
    }

    @RequestMapping(value={"getInvestigate.json"}, name="\u83b7\u53d6\u8003\u5bdf\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public FcInvestigateReDomain getInvestigate(Integer investigateId) {
        if (StringUtils.isBlank((Integer)investigateId)) {
            this.logger.error(CODE + ".getInvestigate", (Object)"investigateId is null");
            return null;
        }
        return this.fcInvestigateServiceRepository.getInvestigate(investigateId);
    }

    @RequestMapping(value={"updateInvestigate.json"}, name="\u66f4\u65b0\u8003\u5bdf\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateInvestigate(HttpServletRequest request, FcInvestigateDomain fcInvestigateDomain) {
        if (null == fcInvestigateDomain) {
            this.logger.error(CODE + ".updateInvestigate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        fcInvestigateDomain.setTenantCode(this.getTenantCode(request));
        HtmlJsonReBean htmlJsonReBean = this.fcInvestigateServiceRepository.updateInvestigate(fcInvestigateDomain);
        if (null != htmlJsonReBean && htmlJsonReBean.isSuccess()) {
            htmlJsonReBean = this.saveOrder(request, fcInvestigateDomain, (String)htmlJsonReBean.getDataObj());
        }
        return htmlJsonReBean;
    }

    private HtmlJsonReBean saveOrder(HttpServletRequest request, FcInvestigateDomain fcInvestigateDomain, String code) {
        if (null == fcInvestigateDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrderDomain orderDomain = new OrderDomain();
        String shoppingType = "11";
        TypeBean typeBean = this.ocServiceRepository.getOcSetting(shoppingType, fcInvestigateDomain.getTenantCode());
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
        }
        orderDomain.setAreaCode(fcInvestigateDomain.getAreaCode());
        orderDomain.setContractRemark(fcInvestigateDomain.getInvestigateMemo());
        orderDomain.setContractType(shoppingType);
        orderDomain.setGoodsReceiptArrdess(fcInvestigateDomain.getAddressDetail());
        orderDomain.setGoodsReceiptMem(fcInvestigateDomain.getMemberBname());
        orderDomain.setGoodsReceiptPhone("");
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        PackageDomain packageDomain = new PackageDomain();
        packageList.add(packageDomain);
        ArrayList contractGoodsList = new ArrayList();
        packageDomain.setContractGoodsList(contractGoodsList);
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        ocContractGoodsDomain.setAppmanageIcode(this.getProappCode(request));
        ocContractGoodsDomain.setContractGoodsInmoney(fcInvestigateDomain.getInvestigateAamt());
        ocContractGoodsDomain.setContractGoodsMoney(fcInvestigateDomain.getInvestigateAamt());
        ocContractGoodsDomain.setContractGoodsPrice(fcInvestigateDomain.getInvestigateAamt());
        ocContractGoodsDomain.setGoodsCamount(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsNum(new BigDecimal("1"));
        ocContractGoodsDomain.setGoodsName(fcInvestigateDomain.getMemberBname() + fcInvestigateDomain.getInvestigateName() + "\u8003\u5bdf");
        ocContractGoodsDomain.setGoodsNo(code);
        ocContractGoodsDomain.setGoodsCode(code);
        ocContractGoodsDomain.setSkuCode(code);
        ocContractGoodsDomain.setSkuNo(code);
        ocContractGoodsDomain.setSkuName(fcInvestigateDomain.getMemberBname() + fcInvestigateDomain.getInvestigateName() + "\u8003\u5bdf");
        ocContractGoodsDomain.setMemberBcode(fcInvestigateDomain.getMemberBcode());
        ocContractGoodsDomain.setMemberBname(fcInvestigateDomain.getMemberBname());
        ocContractGoodsDomain.setMemberCode(fcInvestigateDomain.getMemberCode());
        ocContractGoodsDomain.setMemberName(fcInvestigateDomain.getMemberName());
        UserSession userSession = this.getUserSession(request);
        ArrayList<OrderDomain> orderDomainList = new ArrayList<OrderDomain>();
        orderDomainList.add(orderDomain);
        return this.ocServiceRepository.createOcOrder(orderDomainList, shoppingType, userSession, this.getProappCode(request));
    }

    @RequestMapping(value={"deleteInvestigate.json"}, name="\u5220\u9664\u8003\u5bdf\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteInvestigate(Integer investigateId) {
        if (StringUtils.isBlank((Integer)investigateId)) {
            this.logger.error(CODE + ".deleteInvestigate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fcInvestigateServiceRepository.deleteInvestigate(investigateId);
    }

    @RequestMapping(value={"queryInvestigatePage.json"}, name="\u67e5\u8be2\u8003\u5bdf\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<FcInvestigateReDomain> queryInvestigatePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.fcInvestigateServiceRepository.queryInvestigatePage(param);
    }

    @RequestMapping(value={"updateInvestigateState.json"}, name="\u66f4\u65b0\u8003\u5bdf\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateInvestigateState(String investigateId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)investigateId)) {
            this.logger.error(CODE + ".updateInvestigateState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fcInvestigateServiceRepository.updateInvestigateState(Integer.valueOf(investigateId), dataState, oldDataState);
    }
}

