/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.file.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileDomainBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/fm/file"}, name="\u6587\u4ef6\u670d\u52a1")
public class FileCon
extends SpringmvcController {
    private static String CODE = "fm.file.con";
    @Autowired
    private FileServiceRepository fileServiceRepository;

    protected String getContext() {
        return "file";
    }

    @RequestMapping(value={"updateFile.json"}, name="\u66f4\u65b0\u6587\u4ef6\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateFile(HttpServletRequest request, FmFileDomainBean fmFileDomainBean) {
        if (null == fmFileDomainBean) {
            this.logger.error(CODE + ".updateFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        fmFileDomainBean.setTenantCode(this.getTenantCode(request));
        return this.fileServiceRepository.updateFile(fmFileDomainBean);
    }

    @RequestMapping(value={"deleteFile.json"}, name="\u5220\u9664\u6587\u4ef6\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteFile(String fileId) {
        if (StringUtils.isBlank((String)fileId)) {
            this.logger.error(CODE + ".deleteFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fileServiceRepository.deleteFile(Integer.valueOf(fileId));
    }

    @RequestMapping(value={"queryFilePage.json"}, name="\u67e5\u8be2\u6587\u4ef6\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<FmFileReDomainBean> queryFilePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.fileServiceRepository.queryFilePage(param);
    }

    @RequestMapping(value={"queryFilelist.json"}, name="\u6587\u4ef6\u5b58\u50a8\u4fe1\u606f\u67e5\u8be2")
    @ResponseBody
    public Object queryFilelist(HttpServletRequest request, String fileCode) {
        if (StringUtils.isBlank((String)fileCode)) {
            this.logger.error(CODE + ".queryFilelist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        return this.fileServiceRepository.queryFilelist(fileCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"queryFileAndListPage.json"}, name="\u67e5\u8be2\u6587\u4ef6\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<FmFileReDomainBean> queryFileAndListPage(HttpServletRequest request) {
        SupQueryResult result;
        List list;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (!(list = (result = this.fileServiceRepository.queryFilePage(param)).getList()).isEmpty()) {
            for (FmFileReDomainBean fmFileReDomainBean : list) {
                String fileCode = fmFileReDomainBean.getFileCode();
                List fileList = this.fileServiceRepository.queryFilelist(fileCode, this.getTenantCode(request));
                if (fileList == null || list.isEmpty()) continue;
                fmFileReDomainBean.setFileList(fileList);
            }
        }
        return result;
    }

    @RequestMapping(value={"uploadFileBase64.json"}, name="\u4e0a\u4f20Base64\u683c\u5f0f\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadFileBase64(HttpServletRequest request, String base64Data, String fileSort) {
        if (StringUtils.isBlank((String)base64Data) || StringUtils.isBlank((String)fileSort)) {
            this.logger.error(CODE + ".uploadFileBase64", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String dataPrix = "";
        String data = "";
        String[] d = base64Data.split("base64,");
        if (d == null || d.length != 2) {
            this.logger.error(CODE + ".uploadFileBase641.check", (Object)"param is null");
            return null;
        }
        dataPrix = d[0];
        data = d[1];
        String suffix = "";
        if ("data:image/jpeg;".equalsIgnoreCase(dataPrix)) {
            suffix = ".jpg";
        } else if ("data:image/x-icon;".equalsIgnoreCase(dataPrix)) {
            suffix = ".ico";
        } else if ("data:image/gif;".equalsIgnoreCase(dataPrix)) {
            suffix = ".gif";
        } else if ("data:image/png;".equalsIgnoreCase(dataPrix)) {
            suffix = ".png";
        } else {
            this.logger.error(CODE + ".uploadFileBase641.suffix", (Object)"param is null");
            return null;
        }
        byte[] bs = Base64Utils.decodeFromString((String)data);
        return this.fileServiceRepository.saveFile(bs, tenantCode, fileSort, "", suffix.substring(1), null);
    }

    @RequestMapping(value={"queryFilelistView.json"}, name="\u67e5\u8be2\u56fe\u7247\u89c6\u56fe")
    @ResponseBody
    public SupQueryResult<FmFileReDomainBean> queryFilelistView(HttpServletRequest request, String fileSort) {
        SupQueryResult result;
        List list;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("fileSort", fileSort);
        }
        if (!(list = (result = this.fileServiceRepository.queryFilePagePlus(param)).getList()).isEmpty()) {
            for (FmFileReDomainBean fmFileReDomainBean : list) {
                String fileCode = fmFileReDomainBean.getFileCode();
                List fileList = this.fileServiceRepository.queryFilelist(fileCode, this.getTenantCode(request));
                if (fileList == null || list.isEmpty()) continue;
                fmFileReDomainBean.setFileList(fileList);
            }
        }
        return result;
    }

    @RequestMapping(value={"uploadFiles.json"}, name="\u4e0a\u4f20\u538b\u7f29\u6587\u4ef6\u56fe\u7247")
    @ResponseBody
    public HtmlJsonReBean uploadFiles(HttpServletRequest request, MultipartFile file, String channelCodeStr) throws Exception {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFiles", (Object)"param is null");
            return null;
        }
        String fileSort = "FILE_";
        if (StringUtils.isBlank((String)channelCodeStr)) {
            fileSort = "FILE_GD";
        }
        this.fileServiceRepository.saveFiles(file, this.getTenantCode(request), fileSort, channelCodeStr);
        return new HtmlJsonReBean((Object)"success");
    }

    @RequestMapping(value={"queryExportExcelFile.json"}, name="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u8005\u7684\u6587\u4ef6")
    @ResponseBody
    public SupQueryResult<FmFileReDomainBean> queryExportExcelFile(HttpServletRequest request) {
        SupQueryResult result;
        List list;
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("fileSort", "FILE_11");
            param.put("fileOwner", userSession.getUserCode());
        }
        if (!(list = (result = this.fileServiceRepository.queryFilePagePlus(param)).getList()).isEmpty()) {
            for (FmFileReDomainBean fmFileReDomainBean : list) {
                String fileCode = fmFileReDomainBean.getFileCode();
                List fileList = this.fileServiceRepository.queryFilelist(fileCode, this.getTenantCode(request));
                if (fileList == null || list.isEmpty()) continue;
                fmFileReDomainBean.setFileList(fileList);
            }
        }
        return result;
    }

    @RequestMapping(value={"saveImsgservice.json"}, name="\u589e\u52a0\u6587\u4ef6\u5939")
    @ResponseBody
    public HtmlJsonReBean saveFile(HttpServletRequest request, FmFileDomainBean FmFileDomainBean2) {
        if (null == FmFileDomainBean2) {
            this.logger.error(CODE + ".saveImsgservice", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        FmFileDomainBean2.setTenantCode(this.getTenantCode(request));
        return this.fileServiceRepository.saveFolder(FmFileDomainBean2);
    }
}

