/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.file.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.fm.domain.FileBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileDomainBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsClassReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsClassServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/fm/file"}, name="\u6587\u4ef6\u670d\u52a1")
public class FileCon
extends SpringmvcController {
    private static String CODE = "fm.file.con";
    @Autowired
    private FileServiceRepository fileServiceRepository;
    @Autowired
    private RsGoodsClassServiceRepository rsGoodsClassServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "file";
    }

    @RequestMapping(value={"updateFile.json"}, name="\u66f4\u65b0\u6587\u4ef6\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateFile(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateSendgoodsByMemberCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        FmFileDomainBean fmFileDomainBean = (FmFileDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, FmFileDomainBean.class);
        fmFileDomainBean.setTenantCode(this.getTenantCode(request));
        return this.fileServiceRepository.updateFile(fmFileDomainBean);
    }

    @RequestMapping(value={"updateBatchFile.json"}, name="\u6279\u91cf\u66f4\u65b0\u6587\u4ef6\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateBatchFile(HttpServletRequest request, String paramStrs) {
        if (StringUtils.isEmpty((String)paramStrs)) {
            this.logger.error(CODE + ".updateSendgoodsByMemberCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        FmFileDomainBean[] fmFiles = (FmFileDomainBean[])JsonUtil.buildNormalBinder().getJsonToObject(paramStrs, FmFileDomainBean[].class);
        if (null == fmFiles || fmFiles.length < 0) {
            return new HtmlJsonReBean((Object)"\u8bf7\u4f20\u5165domain");
        }
        for (FmFileDomainBean fmFileDomainBean : fmFiles) {
            FmFileReDomainBean ft = this.fileServiceRepository.queryFileByFileCode(fmFileDomainBean.getFileCode());
            if (null == ft) {
                return new HtmlJsonReBean((Object)"\u6587\u4ef6\u5df2\u88ab\u5220\u9664");
            }
            ft.setTenantCode(this.getTenantCode(request));
            ft.setFileType(fmFileDomainBean.getFileType());
            ft.setFilePcode(fmFileDomainBean.getFilePcode());
            this.fileServiceRepository.updateFile((FmFileDomainBean)ft);
        }
        return new HtmlJsonReBean((Object)"\u6279\u91cf\u66f4\u65b0\u6587\u4ef6\u670d\u52a1\u6210\u529f");
    }

    @RequestMapping(value={"deleteFile.json"}, name="\u5220\u9664\u6587\u4ef6\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteFile(String fileId) {
        if (StringUtils.isBlank((String)fileId)) {
            this.logger.error(CODE + ".deleteFile", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fileServiceRepository.deleteFile(Integer.valueOf(fileId));
    }

    @RequestMapping(value={"queryFilePage.json"}, name="\u67e5\u8be2\u6587\u4ef6\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<FmFileReDomainBean> queryFilePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("orderStr", "GMT_MODIFIED desc");
            param.put("fuzzy", true);
        }
        String fileOwner = null;
        String ownFlag = null == param.get("ownFlag") ? null : (String)param.get("ownFlag");
        this.logger.error(CODE, (Object)("----------ownFlag---" + ownFlag));
        if (StringUtils.isNotBlank((String)ownFlag) && "1".equals(ownFlag)) {
            UserSession userSession = this.getUserSession(request);
            if ("plat".equals(userSession.getUserinfoQuality())) {
                fileOwner = this.getTeananMemberCode(request);
                this.logger.error(CODE, (Object)("--------getTeananMemberCode--------" + fileOwner));
            } else {
                fileOwner = userSession.getUserPcode();
                this.logger.error(CODE, (Object)("--------getUserPcode-----------" + fileOwner));
            }
        }
        this.logger.error(CODE, (Object)("----------fileOwner---" + fileOwner));
        param.put("fileOwner", fileOwner);
        this.logger.error(CODE, (Object)("------param----" + param));
        return this.fileServiceRepository.queryFilePage(param);
    }

    @RequestMapping(value={"queryFilelist.json"}, name="\u6587\u4ef6\u5b58\u50a8\u4fe1\u606f\u67e5\u8be2")
    @ResponseBody
    public Object queryFilelist(HttpServletRequest request, String fileCode) {
        if (StringUtils.isBlank((String)fileCode)) {
            this.logger.error(CODE + ".queryFilelist", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "param is null");
        }
        return this.fileServiceRepository.queryFilelist(fileCode, this.getTenantCode(request));
    }

    @RequestMapping(value={"queryFileAndListPage.json"}, name="\u67e5\u8be2\u6587\u4ef6\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<FmFileReDomainBean> queryFileAndListPage(HttpServletRequest request) {
        SupQueryResult result;
        List list;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (!(list = (result = this.fileServiceRepository.queryFilePage(param)).getList()).isEmpty()) {
            for (FmFileReDomainBean fmFileReDomainBean : list) {
                String fileCode = fmFileReDomainBean.getFileCode();
                List fileList = this.fileServiceRepository.queryFilelist(fileCode, this.getTenantCode(request));
                if (fileList == null || list.isEmpty()) continue;
                fmFileReDomainBean.setFileList(fileList);
            }
        }
        return result;
    }

    @RequestMapping(value={"uploadFileBase64.json"}, name="\u4e0a\u4f20Base64\u683c\u5f0f\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadFileBase64(HttpServletRequest request, String base64Data, String fileSort) {
        if (StringUtils.isBlank((String)base64Data) || StringUtils.isBlank((String)fileSort)) {
            this.logger.error(CODE + ".uploadFileBase64", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String dataPrix = "";
        String data = "";
        String[] d = base64Data.split("base64,");
        if (d == null || d.length != 2) {
            this.logger.error(CODE + ".uploadFileBase641.check", (Object)"param is null");
            return null;
        }
        dataPrix = d[0];
        data = d[1];
        String suffix = "";
        if ("data:image/jpeg;".equalsIgnoreCase(dataPrix)) {
            suffix = ".jpg";
        } else if ("data:image/x-icon;".equalsIgnoreCase(dataPrix)) {
            suffix = ".ico";
        } else if ("data:image/gif;".equalsIgnoreCase(dataPrix)) {
            suffix = ".gif";
        } else if ("data:image/png;".equalsIgnoreCase(dataPrix)) {
            suffix = ".png";
        } else {
            this.logger.error(CODE + ".uploadFileBase641.suffix", (Object)"param is null");
            return null;
        }
        byte[] bs = Base64Utils.decodeFromString((String)data);
        return this.fileServiceRepository.saveFile(bs, tenantCode, fileSort, "", suffix.substring(1), null);
    }

    @RequestMapping(value={"queryFilelistView.json"}, name="\u67e5\u8be2\u56fe\u7247\u89c6\u56fe")
    @ResponseBody
    public SupQueryResult<FmFileReDomainBean> queryFilelistView(HttpServletRequest request, String fileSort) {
        SupQueryResult result;
        List list;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("fileSort", fileSort);
        }
        if (!(list = (result = this.fileServiceRepository.queryFilePagePlus(param)).getList()).isEmpty()) {
            for (FmFileReDomainBean fmFileReDomainBean : list) {
                String fileCode = fmFileReDomainBean.getFileCode();
                List fileList = this.fileServiceRepository.queryFilelist(fileCode, this.getTenantCode(request));
                if (fileList == null || list.isEmpty()) continue;
                fmFileReDomainBean.setFileList(fileList);
            }
        }
        return result;
    }

    @RequestMapping(value={"queryFileForCms.json"}, name="\u7f16\u8f91\u5668\u56fe\u7247")
    @ResponseBody
    public Map<String, Object> queryFileForCms(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            String fileSort = null == param.get("fileSort") ? "FILE_02" : (String)param.get("fileSort");
            param.put("fileSort", fileSort);
        }
        HashMap<String, Object> rMap = new HashMap<String, Object>();
        SupQueryResult result = this.fileServiceRepository.queryFilePagePlus(param);
        if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
            this.logger.error(CODE + ".queryFileForCms.", (Object)("result is null " + param));
            return null;
        }
        ArrayList<FileBean> fileBeans = new ArrayList<FileBean>();
        FileBean fileBean = null;
        for (FmFileReDomainBean fmFileReDomainBean : result.getList()) {
            fileBean = new FileBean();
            try {
                BeanUtils.copyAllPropertys((Object)fileBean, (Object)fmFileReDomainBean);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fileBean.setSrc(fmFileReDomainBean.getFileUrl());
            fileBean.setTitle(fmFileReDomainBean.getFileName());
            fileBeans.add(fileBean);
        }
        rMap.put("total", result.getTotal());
        rMap.put("pageTools", result.getPageTools());
        rMap.put("list", fileBeans);
        return rMap;
    }

    @RequestMapping(value={"getFile.json"}, name="\u83b7\u53d6\u6587\u4ef6\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean getFile(Integer fileId) {
        if (StringUtils.isBlank((Integer)fileId)) {
            this.logger.error(CODE + ".getFile", (Object)"param is null");
            return null;
        }
        return this.fileServiceRepository.getFile(fileId);
    }

    @RequestMapping(value={"uploadFiles.json"}, name="\u4e0a\u4f20\u538b\u7f29\u6587\u4ef6\u56fe\u7247")
    @ResponseBody
    public HtmlJsonReBean uploadFiles(HttpServletRequest request, MultipartFile file, String channelCodeStr) throws Exception {
        if (null == file) {
            this.logger.error(CODE + ".uploadGoodsFiles", (Object)"param is null");
            return null;
        }
        String fileSort = "FILE_";
        if (StringUtils.isBlank((String)channelCodeStr)) {
            fileSort = "FILE_GD";
        }
        this.fileServiceRepository.saveFiles(file, this.getTenantCode(request), fileSort, channelCodeStr);
        return new HtmlJsonReBean((Object)"success");
    }

    @RequestMapping(value={"queryExportExcelFile.json"}, name="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u8005\u7684\u6587\u4ef6")
    @ResponseBody
    public SupQueryResult<FmFileReDomainBean> queryExportExcelFile(HttpServletRequest request) {
        SupQueryResult result;
        List list;
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("order", true);
            param.put("fileSort", "FILE_11");
            param.put("fileOwner", userSession.getUserCode());
        }
        if (!(list = (result = this.fileServiceRepository.queryFilePagePlus(param)).getList()).isEmpty()) {
            for (FmFileReDomainBean fmFileReDomainBean : list) {
                String fileCode = fmFileReDomainBean.getFileCode();
                List fileList = this.fileServiceRepository.queryFilelist(fileCode, this.getTenantCode(request));
                if (fileList == null || list.isEmpty()) continue;
                fmFileReDomainBean.setFileList(fileList);
            }
        }
        return result;
    }

    @RequestMapping(value={"saveFolder.json"}, name="\u589e\u52a0\u6587\u4ef6\u5939")
    @ResponseBody
    public HtmlJsonReBean saveFile(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateSendgoodsByMemberCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        FmFileDomainBean fmFileDomainBean = (FmFileDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, FmFileDomainBean.class);
        UserSession userSession = this.getUserSession(request);
        fmFileDomainBean.setFileOwner(null == userSession ? "" : userSession.getUserPcode());
        fmFileDomainBean.setTenantCode(this.getTenantCode(request));
        return this.fileServiceRepository.saveFolder(fmFileDomainBean);
    }

    @RequestMapping(value={"deleteSensitByIdBatch.json"}, name="\u6839\u636eID\u6279\u91cf\u5220\u9664")
    @ResponseBody
    public HtmlJsonReBean deleteSensitByIdBatch(List<Integer> idList) {
        if (ListUtil.isNotEmpty(idList)) {
            return this.fileServiceRepository.deleteSensitByIdBatch(idList);
        }
        return null;
    }

    @RequestMapping(value={"downloadFileByName.json"}, name="\u4e0b\u8f7d\u6587\u4ef6")
    @ResponseBody
    public HtmlJsonReBean downloadFileByName(String fileName, String tenantCode) {
        if (StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".downloadFileByName", (Object)"param is null");
            return null;
        }
        return this.fileServiceRepository.downloadFileByName(fileName, tenantCode);
    }

    @RequestMapping(value={"queryRsGoodsClassPageList.json"}, name="\u67e5\u8be2\u5546\u54c1\u865a\u62df\u5206\u7c7b\u5206\u9875\u5217\u8868-\u6811\u5f62")
    @ResponseBody
    public List<RsGoodsClassReDomain> queryRsGoodsClassPageList(HttpServletRequest request) {
        return this.getClasstreeLastMain(this.getTenantCode(request), this.getMerchantCode(request), null, true, null);
    }

    private List<RsGoodsClassReDomain> getClasstreeLastMain(String tenantCode, String memberCode, String goodsClassType, boolean flag, String channelCode) {
        SupQueryResult reDomainSupQueryResult;
        ArrayList<RsGoodsClassReDomain> reDomainList = new ArrayList<RsGoodsClassReDomain>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantCode", tenantCode);
        param.put("order", true);
        param.put("orderStr", "GOODS_CLASS_ORDER ASC");
        if (StringUtils.isNotBlank((String)channelCode)) {
            param.put("channelCode", channelCode);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            param.put("memberCode", memberCode);
        }
        if (StringUtils.isNotBlank((String)goodsClassType)) {
            param.put("goodsClassType", goodsClassType);
        }
        if (null == (reDomainSupQueryResult = this.rsGoodsClassServiceRepository.queryGoodsClassPage(param)) || null == reDomainSupQueryResult.getList() || reDomainSupQueryResult.getList().size() <= 0) {
            this.logger.error(CODE + ".getClasstreeLastMain.reDomainSupQueryResult", (Object)((Object)param).toString());
            return null;
        }
        List all = reDomainSupQueryResult.getList();
        ArrayList<RsGoodsClassReDomain> rootClass = new ArrayList<RsGoodsClassReDomain>();
        for (RsGoodsClassReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getGoodsClassParentcode().equals("-1")) continue;
            rootClass.add(rsClasstreeReDomain);
        }
        for (RsGoodsClassReDomain rsGoodsClassReDomain : rootClass) {
            List<RsGoodsClassReDomain> childList = this.getChild(rsGoodsClassReDomain.getGoodsClassCode(), all);
            if (flag) {
                rsGoodsClassReDomain.setChildList(childList);
                continue;
            }
            if (ListUtil.isNotEmpty(childList)) {
                ArrayList<RsGoodsClassReDomain> childList1 = new ArrayList<RsGoodsClassReDomain>();
                for (RsGoodsClassReDomain rsClasstreeReDomain1 : childList) {
                    if (!ListUtil.isNotEmpty((Collection)rsClasstreeReDomain1.getChildList()) && !rsClasstreeReDomain1.getGoodsClassLast().equals("0")) continue;
                    childList1.add(rsClasstreeReDomain1);
                    rsGoodsClassReDomain.setChildList(childList1);
                }
            }
            if (!ListUtil.isNotEmpty((Collection)rsGoodsClassReDomain.getChildList()) && !rsGoodsClassReDomain.getGoodsClassLast().equals("0")) continue;
            reDomainList.add(rsGoodsClassReDomain);
        }
        if (flag) {
            return rootClass;
        }
        return reDomainList;
    }

    public List<RsGoodsClassReDomain> getChild(String id, List<RsGoodsClassReDomain> all) {
        ArrayList<RsGoodsClassReDomain> childList = new ArrayList<RsGoodsClassReDomain>();
        for (RsGoodsClassReDomain rsClasstreeReDomain : all) {
            if (!rsClasstreeReDomain.getGoodsClassParentcode().equals(id)) continue;
            childList.add(rsClasstreeReDomain);
        }
        for (RsGoodsClassReDomain rsClasstreeReDomain : childList) {
            rsClasstreeReDomain.setChildList(this.getChild(rsClasstreeReDomain.getGoodsClassCode(), all));
        }
        if (childList.size() == 0) {
            return null;
        }
        return childList;
    }

    @RequestMapping(value={"addFile.json"}, name="\u589e\u52a0\u6587\u4ef6")
    @ResponseBody
    public HtmlJsonReBean addFile(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateSendgoodsByMemberCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        FmFileDomainBean fmFileDomainBean = (FmFileDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, FmFileDomainBean.class);
        UserSession userSession = this.getUserSession(request);
        fmFileDomainBean.setFileOwner(null == userSession ? null : userSession.getUserPcode());
        fmFileDomainBean.setTenantCode(this.getTenantCode(request));
        return this.fileServiceRepository.saveFile(fmFileDomainBean);
    }

    @RequestMapping(value={"queryFileAndListPageByfileOwner.json"}, name="\u67e5\u8be2\u6587\u4ef6\u670d\u52a1\u5206\u9875\u5217\u8868\u8fd4\u56de\u56fd\u5bb6")
    @ResponseBody
    public SupQueryResult<FmFileReDomainBean> queryFileAndListPageByfileOwner(HttpServletRequest request) {
        SupQueryResult result;
        List list;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (!(list = (result = this.fileServiceRepository.queryFilePage(param)).getList()).isEmpty()) {
            for (FmFileReDomainBean fmFileReDomainBean : list) {
                String fileCode = fmFileReDomainBean.getFileCode();
                List fileList = this.fileServiceRepository.queryFilelist(fileCode, this.getTenantCode(request));
                if (fileList != null && !list.isEmpty()) {
                    fmFileReDomainBean.setFileList(fileList);
                }
                if (!StringUtils.isNotBlank((String)fmFileReDomainBean.getFileOwner())) continue;
                SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(this.getQueryMapParam("userinfoCode", new Object[]{fmFileReDomainBean.getFileOwner()}));
                UmUserinfoReDomainBean um = (UmUserinfoReDomainBean)umUserinfoReDomainBeanSupQueryResult.getList().get(0);
                fmFileReDomainBean.setFileOpcode(um.getDepartName());
                fmFileReDomainBean.setFileOpcode1(um.getRoadName());
            }
        }
        return result;
    }

    @RequestMapping(value={"updateFileState.json"}, name="\u66f4\u65b0\u6587\u4ef6\u670d\u52a1\u5ba1\u6838\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean updateFileState(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateSendgoodsByMemberCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        FmFileDomainBean fmFileDomainBean = (FmFileDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, FmFileDomainBean.class);
        fmFileDomainBean.setTenantCode(this.getTenantCode(request));
        return this.fileServiceRepository.updateState(fmFileDomainBean.getFileId(), Integer.valueOf(1), Integer.valueOf(0));
    }

    @RequestMapping(value={"updateFileStateByid.json"}, name="\u66f4\u65b0\u6587\u4ef6\u670d\u52a1\u5ba1\u6838\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateFileStateByid(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateSendgoodsByMemberCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        FmFileDomainBean fmFileDomainBean = (FmFileDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, FmFileDomainBean.class);
        fmFileDomainBean.setTenantCode(this.getTenantCode(request));
        return this.fileServiceRepository.updateState(fmFileDomainBean.getFileId(), Integer.valueOf(2), Integer.valueOf(0));
    }
}

