/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.gt.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftFileReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftRelReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftSendReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftSendlistReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftUserrelReDomain;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftFileServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftRelServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftSendServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftSendlistServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftUserrelServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecValueDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/gt/gift"}, name="\u793c\u54c1\u670d\u52a1")
public class GiftCon
extends SpringmvcController {
    private static String CODE = "gt.gift.con";
    @Autowired
    private GtGiftServiceRepository gtGiftServiceRepository;
    @Autowired
    private GtGiftFileServiceRepository gtGiftFileServiceRepository;
    @Autowired
    private GtGiftRelServiceRepository gtGiftRelServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private RsGoodsOtherServiceRepository rsGoodsOtherServiceRepository;
    @Autowired
    private GtGiftSendlistServiceRepository gtGiftSendlistServiceRepository;
    @Autowired
    private GtGiftSendServiceRepository gtGiftSendServiceRepository;
    @Autowired
    private GtGiftUserrelServiceRepository gtGiftUserrelServiceRepository;

    protected String getContext() {
        return "gift";
    }

    @RequestMapping(value={"saveGift.json"}, name="\u589e\u52a0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveGift(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGift", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == gtGiftDomain.getGtGiftRelDomainList() || gtGiftDomain.getGtGiftRelDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        return this.gtGiftServiceRepository.saveGift(gtGiftDomain);
    }

    @RequestMapping(value={"getGift.json"}, name="\u83b7\u53d6\u793c\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public GtGiftReDomain getGift(Integer giftId) {
        if (StringUtils.isBlank((Integer)giftId)) {
            this.logger.error(CODE + ".getGift", (Object)"param is null");
            return null;
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGift(giftId);
        Map amap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        gtGiftReDomain.setGtGiftFileDomainList(this.gtGiftFileServiceRepository.queryGiftFilePage(amap).getList());
        gtGiftReDomain.setGtGiftRelDomainList(this.gtGiftRelServiceRepository.queryGiftRelPage(amap).getList());
        return gtGiftReDomain;
    }

    @RequestMapping(value={"updateGift.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateGift(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateGift.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == gtGiftDomain.getGtGiftRelDomainList() || gtGiftDomain.getGtGiftRelDomainList().size() == 0) {
            this.logger.error(CODE + ".updateGift.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        return this.gtGiftServiceRepository.updateGift(gtGiftDomain);
    }

    @RequestMapping(value={"deleteGift.json"}, name="\u5220\u9664\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteGift(String giftId) {
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".deleteGift", (Object)"giftId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        String[] s = giftId.split(",");
        if (null != s || s.length > 0) {
            for (String gid : s) {
                GtGiftReDomain gtGiftReDomain = this.getGift(Integer.valueOf(gid));
                gtGiftReDomain.setDataState(Integer.valueOf(-1));
                htmlJsonReBean = this.gtGiftServiceRepository.updateGift((GtGiftDomain)gtGiftReDomain);
            }
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryGiftPage.json"}, name="\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("notSendDataState", -1);
        return this.gtGiftServiceRepository.queryGiftPage(param);
    }

    @RequestMapping(value={"queryGiftPageToB.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToB(HttpServletRequest request, String giftName, String dataState, String sendState) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null != giftName) {
            param.put("giftName", giftName);
        }
        if (null != dataState) {
            if (Integer.valueOf(dataState) == 0) {
                param.put("dataState", 0);
            }
            if (Integer.valueOf(dataState) == 1) {
                param.put("dataState", 1);
            }
            if (Integer.valueOf(dataState) == 2) {
                param.put("giftCardEnddate", new Date());
            }
        }
        if (null != sendState) {
            if (Integer.valueOf(sendState) == 0) {
                param.put("sendState", 0);
            }
            if (Integer.valueOf(sendState) == 1) {
                param.put("sendState", 1);
            }
        }
        param.put("companyCode", userSession.getUserPcode());
        SupQueryResult giftSend = this.gtGiftSendServiceRepository.queryGiftSendPage(param);
        if (null == giftSend) {
            this.logger.error(CODE + ".queryGiftPageToB", (Object)"giftSend is null");
            return null;
        }
        List giftSendlist = giftSend.getList();
        if (null == giftSendlist || giftSendlist.size() == 0) {
            this.logger.error(CODE + ".queryGiftPageToB", (Object)"giftSendlist is null");
            return null;
        }
        ArrayList<GtGiftReDomain> gtGiftReDomainList = new ArrayList<GtGiftReDomain>();
        for (GtGiftSendReDomain gtSend : giftSendlist) {
            GtGiftReDomain gtGiftReDomain;
            if (gtSend.getGiftCardEnddate().getTime() < new Date().getTime()) {
                gtSend.setValidity("\u5df2\u751f\u6548");
            } else {
                gtSend.setValidity("\u5df2\u8fc7\u671f");
            }
            if (gtSend.getGiftCardEnddate().getTime() - new Date().getTime() < -1702967296L) {
                gtSend.setReminder("\u5373\u5c06\u8fc7\u671f");
            }
            if (null == (gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(this.getTenantCode(request), gtSend.getGiftCode()))) continue;
            gtGiftReDomain.setGiftSendListDataState(gtSend.getDataState());
            ArrayList<GtGiftSendReDomain> gtsendlist = new ArrayList<GtGiftSendReDomain>();
            gtsendlist.add(gtSend);
            gtGiftReDomain.setGtGiftSendDomainList(gtsendlist);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("giftCode", gtSend.getGiftCode());
            gtGiftReDomain.setGtGiftFileDomainList(this.gtGiftFileServiceRepository.queryGiftFilePage(map).getList());
            if (null == gtGiftReDomain) continue;
            gtGiftReDomainList.add(gtGiftReDomain);
        }
        SupQueryResult gtGiftReDomain = new SupQueryResult();
        if (null != gtGiftReDomainList) {
            gtGiftReDomain.setList(gtGiftReDomainList);
            gtGiftReDomain.setTotal(giftSend.getTotal());
            gtGiftReDomain.setPageTools(giftSend.getPageTools());
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToBNotState.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868\u8fc7\u6ee4\u72b6\u6001")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToBNotState(HttpServletRequest request, String giftName, String giftCardSdateStart, String giftCardSdateEnd) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null != giftName) {
            param.put("giftName", giftName);
        }
        if (null != giftCardSdateStart) {
            param.put("startDate", giftCardSdateStart);
        }
        if (null != giftCardSdateEnd) {
            param.put("endDate", giftCardSdateEnd);
        }
        param.put("companyCode", userSession.getUserPcode());
        param.put("notSendDataState", 0);
        SupQueryResult giftSend = this.gtGiftSendServiceRepository.queryGiftSendPage(param);
        if (null == giftSend) {
            this.logger.error(CODE + ".queryGiftPageToBNotState", (Object)"giftSend is null");
            return null;
        }
        List giftSendlist = giftSend.getList();
        if (null == giftSendlist || giftSendlist.size() == 0) {
            this.logger.error(CODE + ".queryGiftPageToBNotState", (Object)"giftSendlist is null");
            return null;
        }
        ArrayList<GtGiftReDomain> gtGiftReDomainList = new ArrayList<GtGiftReDomain>();
        for (GtGiftSendReDomain gtSend : giftSendlist) {
            GtGiftReDomain gtGiftReDomain;
            if (gtSend.getGiftCardEnddate().getTime() < new Date().getTime()) {
                gtSend.setValidity("\u5df2\u751f\u6548");
            } else {
                gtSend.setValidity("\u5df2\u8fc7\u671f");
            }
            if (null == (gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(this.getTenantCode(request), gtSend.getGiftCode()))) continue;
            gtGiftReDomain.setGiftSendListDataState(gtSend.getDataState());
            ArrayList<GtGiftSendReDomain> gtsendlist = new ArrayList<GtGiftSendReDomain>();
            gtsendlist.add(gtSend);
            gtGiftReDomain.setGtGiftSendDomainList(gtsendlist);
            if (null == gtGiftReDomain) continue;
            gtGiftReDomainList.add(gtGiftReDomain);
        }
        SupQueryResult gtGiftReDomain = new SupQueryResult();
        if (null != gtGiftReDomainList) {
            gtGiftReDomain.setList(gtGiftReDomainList);
            gtGiftReDomain.setPageTools(giftSend.getPageTools());
            gtGiftReDomain.setTotal(giftSend.getTotal());
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToC.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToC(HttpServletRequest request, String giftName, String dataState) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null != giftName) {
            param.put("giftName", giftName);
        }
        if (null != dataState) {
            if (Integer.valueOf(dataState) == 0) {
                param.put("dataState", 0);
            }
            if (Integer.valueOf(dataState) == 1) {
                param.put("dataState", 1);
            }
            if (Integer.valueOf(dataState) == 2) {
                param.put("giftCardEnddate", new Date());
            }
        }
        param.put("employeeCode", userSession.getUserPcode());
        SupQueryResult giftSendList = this.gtGiftSendlistServiceRepository.queryGiftSendlistPage(param);
        if (null == giftSendList) {
            this.logger.error(CODE + ".queryGiftPageToC", (Object)"giftSendList is null");
            return new SupQueryResult();
        }
        List giftSendList1 = giftSendList.getList();
        if (null == giftSendList1 || giftSendList1.size() == 0) {
            this.logger.error(CODE + ".queryGiftPageToC", (Object)"giftSendList1 is null");
            return new SupQueryResult();
        }
        ArrayList<GtGiftReDomain> gtGiftReDomainList = new ArrayList<GtGiftReDomain>();
        for (GtGiftSendlistReDomain gtSendList : giftSendList1) {
            GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(this.getTenantCode(request), gtSendList.getGiftCode());
            gtGiftReDomain.setGiftSendListDataState(gtSendList.getDataState());
            GtGiftSendReDomain gtGiftSendDomain = this.gtGiftSendServiceRepository.getGiftSendByCode(gtSendList.getTenantCode(), gtSendList.getGiftSendCode());
            if (gtGiftSendDomain.getGiftCardEnddate().getTime() < new Date().getTime()) {
                gtGiftSendDomain.setValidity("0");
            } else {
                gtGiftSendDomain.setValidity("1");
            }
            if (gtGiftSendDomain.getGiftCardEnddate().getTime() - new Date().getTime() < -1702967296L) {
                gtGiftSendDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
            }
            gtGiftReDomain.setGtGiftSendDomain(gtGiftSendDomain);
            gtGiftReDomain.setGiftSendNum(gtSendList.getGiftNum());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("giftCode", gtSendList.getGiftCode());
            gtGiftReDomain.setGtGiftFileDomainList(this.gtGiftFileServiceRepository.queryGiftFilePage(map).getList());
            if (null == gtGiftReDomain) continue;
            gtGiftReDomainList.add(gtGiftReDomain);
        }
        SupQueryResult gtGiftReDomain = new SupQueryResult();
        if (null != gtGiftReDomainList) {
            gtGiftReDomain.setList(gtGiftReDomainList);
            gtGiftReDomain.setTotal(giftSendList.getTotal());
            gtGiftReDomain.setPageTools(giftSendList.getPageTools());
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryRelToC.json"}, name="wap\u5458\u5de5\u9886\u53d6\u793c\u54c1\u65f6\u663e\u793a\u7684\u5546\u54c1")
    @ResponseBody
    public GtGiftReDomain queryRelToC(HttpServletRequest request, String giftCode, String giftSendCode) {
        UserSession userSession = this.getUserSession(request);
        if (null == giftCode) {
            this.logger.error(CODE + ".queryRelToC", (Object)"giftCode is null");
            return new GtGiftReDomain();
        }
        if (null == giftSendCode) {
            this.logger.error(CODE + ".queryRelToC", (Object)"giftSendCode is null");
            return new GtGiftReDomain();
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(this.getTenantCode(request), giftCode);
        Map amap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        gtGiftReDomain.setGtGiftFileDomainList(this.gtGiftFileServiceRepository.queryGiftFilePage(amap).getList());
        gtGiftReDomain.setGtGiftRelDomainList(this.gtGiftRelServiceRepository.queryGiftRelPage(amap).getList());
        gtGiftReDomain.setGtGiftSendDomain(this.gtGiftSendServiceRepository.getGiftSendByCode(this.getTenantCode(request), giftSendCode));
        Map sendlistmap = this.getQueryMapParam("giftSendCode,employeeCode", new Object[]{giftSendCode, userSession.getUserPcode()});
        List gtGiftSendlistDomainList = this.gtGiftSendlistServiceRepository.queryGiftSendlistPage(sendlistmap).getList();
        if (null == gtGiftSendlistDomainList || gtGiftSendlistDomainList.size() == 0) {
            this.logger.error(CODE + ".queryRelToC", (Object)"gtGiftSendlistDomainList is null");
            return new GtGiftReDomain();
        }
        Map userrelmap = this.getQueryMapParam("giftCode,memberBcode", new Object[]{giftCode, userSession.getUserPcode()});
        List gtGiftUserrelReDomainList = this.gtGiftUserrelServiceRepository.queryGiftUserrelPage(userrelmap).getList();
        int num = 0;
        if (null != gtGiftUserrelReDomainList) {
            for (GtGiftUserrelReDomain gtGiftUserrelReDomain : gtGiftUserrelReDomainList) {
                num += gtGiftUserrelReDomain.getGiftUserrelNum().intValue();
            }
        }
        int allnum = gtGiftReDomain.getGiftCnum().intValue() * ((GtGiftSendlistReDomain)gtGiftSendlistDomainList.get(0)).getGiftNum().intValue();
        gtGiftReDomain.setGiftCnum(BigDecimal.valueOf(allnum - num));
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftSendlistPageByGiftSendCodeToB.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u5305\u9886\u53d6\u7684\u8be6\u60c5\uff08\u67e5\u770b\u5458\u5de5\u9886\u53d6\u5217\u8868\uff09")
    @ResponseBody
    public GtGiftReDomain queryGiftSendlistPageByGiftSendCodeToB(String giftSendId) {
        if (null == giftSendId) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToB", (Object)"giftSendId is null");
            return null;
        }
        GtGiftSendReDomain gtGiftSendReDomain = this.gtGiftSendServiceRepository.getGiftSend(Integer.valueOf(giftSendId));
        ArrayList<GtGiftSendReDomain> gtGiftSendDomainList = new ArrayList<GtGiftSendReDomain>();
        gtGiftSendDomainList.add(gtGiftSendReDomain);
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftSendReDomain.getTenantCode(), gtGiftSendReDomain.getGiftCode());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("giftCode", gtGiftSendReDomain.getGiftCode());
        SupQueryResult gtGiftSendlistDomain = this.gtGiftSendlistServiceRepository.queryGiftSendlistPage(param);
        if (null == gtGiftSendlistDomain) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToB", (Object)"gtGiftSendlistDomain is null");
            return null;
        }
        List gtGiftSendlistDomainList = gtGiftSendlistDomain.getList();
        if (null == gtGiftSendlistDomainList || gtGiftSendlistDomainList.size() == 0) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToB", (Object)"gtGiftSendlistDomainList is null");
            return null;
        }
        gtGiftReDomain.setGtGiftSendlistDomainList(gtGiftSendlistDomainList);
        gtGiftReDomain.setGtGiftSendDomainList(gtGiftSendDomainList);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftSendlistPageByGiftSendCodeToC.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u8be2\u793c\u5305\u9886\u53d6\u7684\u8be6\u60c5\uff08\u67e5\u770b\u5458\u5de5\u9886\u53d6\u5217\u8868\uff09")
    @ResponseBody
    public GtGiftReDomain queryGiftSendlistPageByGiftSendCodeToC(String giftSendId) {
        if (null == giftSendId) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"giftSendId is null");
            return null;
        }
        GtGiftSendReDomain gtGiftSendReDomain = this.gtGiftSendServiceRepository.getGiftSend(Integer.valueOf(giftSendId));
        ArrayList<GtGiftSendReDomain> gtGiftSendDomainList = new ArrayList<GtGiftSendReDomain>();
        gtGiftSendDomainList.add(gtGiftSendReDomain);
        HashMap<String, GtGiftSendReDomain> maprel = new HashMap<String, GtGiftSendReDomain>();
        maprel.put("giftSendCode", gtGiftSendReDomain);
        List GtGiftRelReDomain = this.gtGiftRelServiceRepository.queryGiftRelPage(maprel).getList();
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftSendReDomain.getTenantCode(), gtGiftSendReDomain.getGiftCode());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("giftCode", gtGiftSendReDomain.getGiftCode());
        SupQueryResult gtGiftSendlistDomain = this.gtGiftSendlistServiceRepository.queryGiftSendlistPage(param);
        if (null == gtGiftSendlistDomain) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"gtGiftSendlistDomain is null");
            return null;
        }
        List gtGiftSendlistDomainList = gtGiftSendlistDomain.getList();
        if (null == gtGiftSendlistDomainList || gtGiftSendlistDomainList.size() == 0) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"gtGiftSendlistDomainList is null");
            return null;
        }
        gtGiftReDomain.setGtGiftSendlistDomainList(gtGiftSendlistDomainList);
        gtGiftReDomain.setGtGiftSendDomainList(gtGiftSendDomainList);
        gtGiftReDomain.setGtGiftRelDomainList(GtGiftRelReDomain);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"updateGiftState.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGiftState(String giftId, Integer dataState, Integer oldDataState) {
        String[] id;
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String a : id = giftId.split(",")) {
            this.gtGiftServiceRepository.updateGiftState(Integer.valueOf(a), dataState, oldDataState);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateGiftPrice.json"}, name="\u66f4\u65b0\u793c\u54c1\u552e\u4ef7")
    @ResponseBody
    public HtmlJsonReBean updateGiftPrice(String giftId, BigDecimal pricesetNprice) {
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftPrice", (Object)"giftId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == pricesetNprice) {
            this.logger.error(CODE + ".updateGiftPrice", (Object)"pricesetNprice is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        GtGiftReDomain gtGiftReDomain = this.getGift(Integer.valueOf(giftId));
        gtGiftReDomain.setPricesetNprice(pricesetNprice);
        gtGiftReDomain.setDataState(Integer.valueOf(2));
        return this.gtGiftServiceRepository.updateGift((GtGiftDomain)gtGiftReDomain);
    }

    private void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    @RequestMapping(value={"updateGiftShelfState.json"}, name="\u793c\u5305\u4e0a\u67b6\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean updateGiftShelfState(HttpServletRequest request, String giftId) {
        String[] giftIdArray;
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftShelfState", (Object)"giftId is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (String gid : giftIdArray = giftId.split(",")) {
            GtGiftReDomain gtGiftReDomain = this.getGift(Integer.valueOf(gid));
            if (null == gtGiftReDomain) {
                this.logger.error(CODE + ".updateGiftShelfState", (Object)"gtGiftReDomain is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "gtGiftReDomain");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsOrigin", "5");
            map.put("goodsNo", gtGiftReDomain.getGiftCode());
            map.put("tenantCode", gtGiftReDomain.getTenantCode());
            SupQueryResult rsList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
            if (null != rsList && null != rsList.getRows() && !rsList.getRows().isEmpty()) continue;
            RsResourceGoodsDomain rsResourceGoodsDomain = this.make(request, gtGiftReDomain);
            ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
            goodsList.add(rsResourceGoodsDomain);
            HtmlJsonReBean htmlJsonReBean1 = this.rsResourceGoodsServiceRepository.savePassResourceGoodsBatch(goodsList);
            String rs = htmlJsonReBean1.getErrorCode();
            if (StringUtils.isNotBlank((String)rs)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5931\u8d25");
            }
            htmlJsonReBean = this.gtGiftServiceRepository.updateGiftStateByCode(gtGiftReDomain.getTenantCode(), gtGiftReDomain.getGiftCode(), Integer.valueOf(1), Integer.valueOf(2));
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateGiftLowerState.json"}, name="\u793c\u5305\u4e0b\u67b6\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean updateGiftLowerState(HttpServletRequest request, String giftCode) {
        String[] giftCodeArray;
        if (StringUtils.isBlank((String)giftCode)) {
            this.logger.error(CODE + ".updateGiftLowerState", (Object)"giftCode is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (String gcode : giftCodeArray = giftCode.split(",")) {
            HtmlJsonReBean htmlJsonReBean1;
            String errorCode;
            HashMap<String, String> map = new HashMap<String, String>();
            String tenantCode = this.getTenantCode(request);
            map.put("goodsOrigin", "5");
            map.put("goodsNo", gcode);
            map.put("tenantCode", tenantCode);
            SupQueryResult rsResourceGoodsReDomainList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
            List list = rsResourceGoodsReDomainList.getList();
            HashMap<String, String> params = new HashMap<String, String>();
            if (null != list || list.size() != 0) {
                RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)list.get(0);
                String goodsCode = rsResourceGoodsReDomain.getGoodsCode();
                params.put("goodsOrigin", "5");
                params.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
                params.put("tenantCode", tenantCode);
            }
            if (StringUtils.isNotBlank((String)(errorCode = (htmlJsonReBean1 = this.rsResourceGoodsServiceRepository.delResourceGoodsByCode(params)).getErrorCode()))) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5220\u9664\u5546\u54c1\u5931\u8d25");
            }
            htmlJsonReBean = this.gtGiftServiceRepository.updateGiftStateByCode(tenantCode, gcode, Integer.valueOf(2), Integer.valueOf(1));
        }
        return htmlJsonReBean;
    }

    private RsResourceGoodsDomain make(HttpServletRequest request, GtGiftReDomain gtGiftReDomain) {
        List gtGiftRelReDomain;
        if (null == gtGiftReDomain || null == request) {
            return null;
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsName(gtGiftReDomain.getGiftName());
        rsResourceGoodsDomain.setGoodsNo(gtGiftReDomain.getGiftCode());
        rsResourceGoodsDomain.setPntreeCode(gtGiftReDomain.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(gtGiftReDomain.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(gtGiftReDomain.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(gtGiftReDomain.getClasstreeName());
        rsResourceGoodsDomain.setPricesetNprice(gtGiftReDomain.getPricesetNprice());
        rsResourceGoodsDomain.setPricesetMakeprice(gtGiftReDomain.getPricesetMakeprice());
        rsResourceGoodsDomain.setBrandCode(gtGiftReDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(gtGiftReDomain.getBrandName());
        UserSession userSession = this.getUserSession(request);
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(userSession.getUserName());
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsOrigin("5");
        rsResourceGoodsDomain.setPricesetMakeshow("1");
        rsResourceGoodsDomain.setPartsnameNumunit("\u4e2a");
        rsResourceGoodsDomain.setGoodsWeight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsSupplyweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsAhweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangnum(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsNum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsAhnum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsSupplynum(new BigDecimal("9999"));
        this.makeChannel(rsResourceGoodsDomain, request);
        List gtGiftFileReDomain = gtGiftReDomain.getGtGiftFileDomainList();
        if (!ListUtil.isEmpty((Collection)gtGiftFileReDomain)) {
            ArrayList<RsGoodsFileDomain> rsGoodsFileList = new ArrayList<RsGoodsFileDomain>();
            for (GtGiftFileReDomain gtGiftFile : gtGiftFileReDomain) {
                RsGoodsFileDomain rsGoodsFile = new RsGoodsFileDomain();
                rsGoodsFile.setGoodsFileName(gtGiftFile.getGiftFileFilename());
                rsGoodsFile.setAppmanageIcode(gtGiftFile.getAppmanageIcode());
                rsGoodsFile.setGoodsFileSort(gtGiftFile.getGiftFileSort());
                rsGoodsFile.setGoodsFileType(gtGiftFile.getGiftFileType());
                rsGoodsFile.setGoodsFilesortName(gtGiftFile.getGiftFilesortName());
                rsGoodsFile.setGoodsFileUrl(gtGiftFile.getGiftFileFileUrl());
                rsGoodsFile.setTenantCode(gtGiftFile.getTenantCode());
                rsGoodsFileList.add(rsGoodsFile);
            }
            rsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileList);
        }
        if (ListUtil.isNotEmpty((Collection)(gtGiftRelReDomain = gtGiftReDomain.getGtGiftRelDomainList()))) {
            ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
            for (GtGiftRelReDomain gtGiftRel : gtGiftRelReDomain) {
                RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
                rsGoodsRelDomain.setGoodsRelGcode(gtGiftRel.getGoodsCode());
                rsGoodsRelDomain.setMemberCcode(gtGiftRel.getMemberCcode());
                rsGoodsRelDomain.setMemberCname(gtGiftRel.getMemberCname());
                rsGoodsRelDomain.setSkuCode(gtGiftRel.getSkuCode());
                rsGoodsRelDomain.setSkuName(gtGiftRel.getSkuName());
                rsGoodsRelDomain.setSkuNo(gtGiftRel.getSkuNo());
                rsGoodsRelDomain.setSkuShowno(gtGiftRel.getSkuShowno());
                rsGoodsRelDomain.setPricesetNprice(gtGiftRel.getPricesetNprice());
                rsGoodsRelDomain.setPricesetMakeprice(gtGiftRel.getPricesetMakeprice());
                rsGoodsRelDomain.setPricesetBaseprice(gtGiftRel.getPricesetBaseprice());
                rsGoodsRelDomain.setGoodsWeight(gtGiftRel.getGoodsWeight());
                rsGoodsRelDomain.setGoodsNum(gtGiftRel.getGoodsNum());
                rsGoodsRelDomain.setDataPic(gtGiftRel.getDataPic());
                rsGoodsRelDomain.setDataPicpath(gtGiftRel.getDataPicpath());
                rsGoodsRelDomain.setAppmanageIcode(gtGiftRel.getAppmanageIcode());
                rsGoodsRelDomainList.add(rsGoodsRelDomain);
            }
            rsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomainList);
        }
        ArrayList<RsSpecValueDomain> RsSpecValueList = new ArrayList<RsSpecValueDomain>();
        RsSpecValueDomain rsSpecValue = new RsSpecValueDomain();
        rsSpecValue.setSpecCode("\u65e0");
        rsSpecValue.setSpecName("\u4e2a");
        rsSpecValue.setSpecGroupCode("\u65e0");
        rsSpecValue.setSpecValueBillno(gtGiftReDomain.getGiftCode());
        rsSpecValue.setSpecValueFlag("1");
        rsSpecValue.setSpecValueType("0");
        rsSpecValue.setSpecValueValue("1");
        rsSpecValue.setTenantCode(gtGiftReDomain.getTenantCode());
        RsSpecValueList.add(rsSpecValue);
        rsResourceGoodsDomain.setRsSpecValueDomainList(RsSpecValueList);
        return rsResourceGoodsDomain;
    }
}

