/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.gt.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftFileReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftRelReDomain;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftFileServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftRelServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsPropertiesValueDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecValueDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/gt/gift"}, name="\u793c\u54c1\u670d\u52a1")
public class GiftCon
extends SpringmvcController {
    private static String CODE = "gt.gift.con";
    @Autowired
    private GtGiftServiceRepository gtGiftServiceRepository;
    @Autowired
    private GtGiftFileServiceRepository gtGiftFileServiceRepository;
    @Autowired
    private GtGiftRelServiceRepository gtGiftRelServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private RsGoodsOtherServiceRepository rsGoodsOtherServiceRepository;

    protected String getContext() {
        return "gift";
    }

    @RequestMapping(value={"saveGift.json"}, name="\u589e\u52a0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveGift(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGift", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == gtGiftDomain.getGtGiftRelDomainList() || gtGiftDomain.getGtGiftRelDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        return this.gtGiftServiceRepository.saveGift(gtGiftDomain);
    }

    @RequestMapping(value={"getGift.json"}, name="\u83b7\u53d6\u793c\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public GtGiftReDomain getGift(Integer giftId) {
        if (StringUtils.isBlank((Integer)giftId)) {
            this.logger.error(CODE + ".getGift", (Object)"param is null");
            return null;
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGift(giftId);
        Map amap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        gtGiftReDomain.setGtGiftFileDomainList(this.gtGiftFileServiceRepository.queryGiftFilePage(amap).getList());
        gtGiftReDomain.setGtGiftRelDomainList(this.gtGiftRelServiceRepository.queryGiftRelPage(amap).getList());
        return gtGiftReDomain;
    }

    @RequestMapping(value={"updateGift.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateGift(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateGift.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == gtGiftDomain.getGtGiftRelDomainList() || gtGiftDomain.getGtGiftRelDomainList().size() == 0) {
            this.logger.error(CODE + ".updateGift.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        return this.gtGiftServiceRepository.updateGift(gtGiftDomain);
    }

    @RequestMapping(value={"deleteGift.json"}, name="\u5220\u9664\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteGift(Integer giftId) {
        if (StringUtils.isBlank((Integer)giftId)) {
            this.logger.error(CODE + ".deleteGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.gtGiftServiceRepository.deleteGift(giftId);
    }

    @RequestMapping(value={"queryGiftPage.json"}, name="\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.gtGiftServiceRepository.queryGiftPage(param);
    }

    @RequestMapping(value={"updateGiftState.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGiftState(String giftId, Integer dataState, Integer oldDataState) {
        String[] id;
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String a : id = giftId.split(",")) {
            this.gtGiftServiceRepository.updateGiftState(Integer.valueOf(a), dataState, oldDataState);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateGiftPrice.json"}, name="\u66f4\u65b0\u793c\u54c1\u552e\u4ef7")
    @ResponseBody
    public HtmlJsonReBean updateGiftPrice(String giftId, BigDecimal pricesetNprice) {
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftPrice", (Object)"giftId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftPrice", (Object)"pricesetNprice is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.gtGiftServiceRepository.updateGiftPrice(Integer.valueOf(giftId), pricesetNprice);
    }

    private void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    @RequestMapping(value={"updateGiftShelfState.json"}, name="\u793c\u5305\u4e0a\u67b6\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean updateGiftShelfState(HttpServletRequest request, String giftId) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftShelfState", (Object)"giftId is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGift(Integer.valueOf(giftId));
        if (null == gtGiftReDomain) {
            this.logger.error(CODE + ".updateGiftShelfState", (Object)"gtGiftReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "gtGiftReDomain");
        }
        map.put("goodsOrigin", "5");
        map.put("goodsNo", gtGiftReDomain.getGiftCode());
        map.put("tenantCode", gtGiftReDomain.getTenantCode());
        SupQueryResult rsList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
        if (null == rsList || null == rsList.getRows() || rsList.getRows().isEmpty()) {
            RsResourceGoodsDomain rsResourceGoodsDomain = this.make(request, gtGiftReDomain);
            ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
            goodsList.add(rsResourceGoodsDomain);
            HtmlJsonReBean htmlJsonReBean = this.rsResourceGoodsServiceRepository.savePassResourceGoodsBatch(goodsList);
            String rs = htmlJsonReBean.getErrorCode();
            if (StringUtils.isNotBlank((String)rs)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5931\u8d25");
            }
        }
        return this.gtGiftServiceRepository.updateGiftStateByCode(gtGiftReDomain.getTenantCode(), gtGiftReDomain.getGiftCode(), Integer.valueOf(1), Integer.valueOf(0));
    }

    private RsResourceGoodsDomain make(HttpServletRequest request, GtGiftReDomain gtGiftReDomain) {
        List gtGiftRelReDomain;
        if (null == gtGiftReDomain || null == request) {
            return null;
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setGoodsName(gtGiftReDomain.getGiftName());
        rsResourceGoodsDomain.setGoodsNo(gtGiftReDomain.getGiftCode());
        rsResourceGoodsDomain.setPntreeCode(gtGiftReDomain.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(gtGiftReDomain.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(gtGiftReDomain.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(gtGiftReDomain.getClasstreeName());
        rsResourceGoodsDomain.setPricesetNprice(gtGiftReDomain.getPricesetNprice());
        rsResourceGoodsDomain.setPricesetMakeprice(gtGiftReDomain.getPricesetMakeprice());
        rsResourceGoodsDomain.setBrandCode(gtGiftReDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(gtGiftReDomain.getBrandName());
        UserSession userSession = this.getUserSession(request);
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(userSession.getUserName());
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsOrigin("5");
        rsResourceGoodsDomain.setPricesetMakeshow("1");
        rsResourceGoodsDomain.setPartsnameNumunit("\u4e2a");
        rsResourceGoodsDomain.setGoodsWeight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsSupplyweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsAhweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangnum(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsNum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsAhnum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsSupplynum(new BigDecimal("9999"));
        this.makeChannel(rsResourceGoodsDomain, request);
        List gtGiftFileReDomain = gtGiftReDomain.getGtGiftFileDomainList();
        if (!ListUtil.isEmpty((Collection)gtGiftFileReDomain)) {
            ArrayList<RsGoodsFileDomain> rsGoodsFileList = new ArrayList<RsGoodsFileDomain>();
            for (GtGiftFileReDomain gtGiftFile : gtGiftFileReDomain) {
                RsGoodsFileDomain rsGoodsFile = new RsGoodsFileDomain();
                rsGoodsFile.setGoodsFileName(gtGiftFile.getGiftFileFilename());
                rsGoodsFile.setAppmanageIcode(gtGiftFile.getAppmanageIcode());
                rsGoodsFile.setGoodsFileSort(gtGiftFile.getGiftFileSort());
                rsGoodsFile.setGoodsFileType(gtGiftFile.getGiftFileType());
                rsGoodsFile.setGoodsFilesortName(gtGiftFile.getGiftFilesortName());
                rsGoodsFile.setGoodsFileUrl(gtGiftFile.getGiftFileFileUrl());
                rsGoodsFile.setTenantCode(gtGiftFile.getTenantCode());
                rsGoodsFileList.add(rsGoodsFile);
            }
            rsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileList);
        }
        if (ListUtil.isNotEmpty((Collection)(gtGiftRelReDomain = gtGiftReDomain.getGtGiftRelDomainList()))) {
            ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
            for (GtGiftRelReDomain gtGiftRel : gtGiftRelReDomain) {
                RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)rsGoodsRelDomain, (Object)gtGiftRel);
                }
                catch (Exception e) {
                    // empty catch block
                }
                rsGoodsRelDomain.setGoodsCode(gtGiftRel.getGoodsCode());
                rsGoodsRelDomain.setMemberCcode(gtGiftRel.getMemberCcode());
                rsGoodsRelDomain.setMemberCname(gtGiftRel.getMemberCname());
                rsGoodsRelDomain.setMemberCode(gtGiftRel.getMemberCode());
                rsGoodsRelDomain.setMemberName(gtGiftRel.getMemberName());
                rsGoodsRelDomain.setSkuCode(gtGiftRel.getSkuCode());
                rsGoodsRelDomain.setSkuName(gtGiftRel.getSkuName());
                rsGoodsRelDomain.setSkuNo(gtGiftRel.getSkuNo());
                rsGoodsRelDomain.setSkuShowno(gtGiftRel.getSkuShowno());
                rsGoodsRelDomain.setPricesetNprice(gtGiftRel.getPricesetNprice());
                rsGoodsRelDomain.setPricesetMakeprice(gtGiftRel.getPricesetMakeprice());
                rsGoodsRelDomain.setPricesetBaseprice(gtGiftRel.getPricesetBaseprice());
                rsGoodsRelDomain.setGoodsWeight(gtGiftRel.getGoodsWeight());
                rsGoodsRelDomain.setGoodsNum(gtGiftRel.getGoodsNum());
                rsGoodsRelDomain.setDataPic(gtGiftRel.getDataPic());
                rsGoodsRelDomain.setDataPicpath(gtGiftRel.getDataPicpath());
                rsGoodsRelDomain.setTenantCode(gtGiftRel.getTenantCode());
                rsGoodsRelDomain.setAppmanageIcode(gtGiftRel.getAppmanageIcode());
                rsGoodsRelDomainList.add(rsGoodsRelDomain);
            }
            rsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomainList);
        }
        ArrayList<RsSpecValueDomain> RsSpecValueList = new ArrayList<RsSpecValueDomain>();
        RsSpecValueDomain rsSpecValue = new RsSpecValueDomain();
        rsSpecValue.setSpecCode("\u65e0");
        rsSpecValue.setSpecName("\u4e2a");
        rsSpecValue.setSpecGroupCode("\u65e0");
        rsSpecValue.setSpecValueBillno(gtGiftReDomain.getGiftCode());
        rsSpecValue.setSpecValueFlag("1");
        rsSpecValue.setSpecValueType("0");
        rsSpecValue.setSpecValueValue("1");
        rsSpecValue.setTenantCode(gtGiftReDomain.getTenantCode());
        RsSpecValueList.add(rsSpecValue);
        rsResourceGoodsDomain.setRsSpecValueDomainList(RsSpecValueList);
        ArrayList<RsPropertiesValueDomain> RsPropertiesValueList = new ArrayList<RsPropertiesValueDomain>();
        RsPropertiesValueDomain rsPropertiesValue = new RsPropertiesValueDomain();
        rsPropertiesValue.setTenantCode(gtGiftReDomain.getTenantCode());
        rsPropertiesValue.setPropertiesCode("\u65e0");
        rsPropertiesValue.setPropertiesValueCode(gtGiftReDomain.getGiftCode());
        rsPropertiesValue.setPropertiesValueType("1");
        rsPropertiesValue.setPropertiesValueValue("\u4e2a");
        RsPropertiesValueList.add(rsPropertiesValue);
        rsResourceGoodsDomain.setRsPropertiesValueDomainList(RsPropertiesValueList);
        return rsResourceGoodsDomain;
    }
}

