/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.gt.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftReDomain;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftFileServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftRelServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/gt/gift"}, name="\u793c\u54c1\u670d\u52a1")
public class GiftCon
extends SpringmvcController {
    private static String CODE = "gt.gift.con";
    @Autowired
    private GtGiftServiceRepository gtGiftServiceRepository;
    @Autowired
    private GtGiftFileServiceRepository gtGiftFileServiceRepository;
    @Autowired
    private GtGiftRelServiceRepository gtGiftRelServiceRepository;

    protected String getContext() {
        return "gift";
    }

    @RequestMapping(value={"saveGift.json"}, name="\u589e\u52a0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveGift(String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveResourceGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        return this.gtGiftServiceRepository.saveGift(gtGiftDomain);
    }

    @RequestMapping(value={"getGift.json"}, name="\u83b7\u53d6\u793c\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public GtGiftReDomain getGift(Integer giftId) {
        if (StringUtils.isBlank((Integer)giftId)) {
            this.logger.error(CODE + ".getGift", (Object)"param is null");
            return null;
        }
        return this.gtGiftServiceRepository.getGift(giftId);
    }

    @RequestMapping(value={"updateGift.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateGift(HttpServletRequest request, GtGiftDomain gtGiftDomain) {
        if (null == gtGiftDomain) {
            this.logger.error(CODE + ".updateGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        return this.gtGiftServiceRepository.updateGift(gtGiftDomain);
    }

    @RequestMapping(value={"deleteGift.json"}, name="\u5220\u9664\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteGift(Integer giftId) {
        if (StringUtils.isBlank((Integer)giftId)) {
            this.logger.error(CODE + ".deleteGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.gtGiftServiceRepository.deleteGift(giftId);
    }

    @RequestMapping(value={"queryGiftPage.json"}, name="\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.gtGiftServiceRepository.queryGiftPage(param);
    }

    @RequestMapping(value={"updateGiftState.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGiftState(String giftId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.gtGiftServiceRepository.updateGiftState(Integer.valueOf(giftId), dataState, oldDataState);
    }
}

