/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.gt.controller;

import com.qjsoft.laser.controller.common.bean.FmFileDomainBean;
import com.qjsoft.laser.controller.common.bean.FmFileReDomainBean;
import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.common.util.ExportExcelUtlis;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftRelReDomain;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftRelServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftServiceRepository;
import com.qjsoft.laser.controller.gt.orderexceltemplate.ExcelExportTemplate;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/gt/upgift"}, name="\u793c\u5305\u5546\u54c1\u670d\u52a1")
public class GiftUpCon
extends SpringmvcController {
    private static String CODE = "gt.upgift.con";
    @Autowired
    private GtGiftServiceRepository gtGiftServiceRepository;
    @Autowired
    private GtGiftRelServiceRepository gtGiftRelServiceRepository;

    protected String getContext() {
        return "upgift";
    }

    @RequestMapping(value={"queryUpReGiftPage.json"}, name="\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u7684\u5546\u54c1\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftRelReDomain> queryUpReGiftPage(HttpServletRequest request, Integer giftId) {
        if (StringUtils.isBlank((Integer)giftId)) {
            this.logger.error(CODE + ".getGift", (Object)"param is null");
            return null;
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGift(giftId);
        String giftNo = gtGiftReDomain.getGiftNo();
        Map amap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("ntoDataState", -1);
        param.putAll(amap);
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        SupQueryResult rsResourceGoodsReDomainSupQueryResult = this.gtGiftRelServiceRepository.queryGiftRelPage(param);
        if (ListUtil.isNotEmpty((Collection)rsResourceGoodsReDomainSupQueryResult.getList())) {
            String fileName = "\u793c\u5305\u5546\u54c1\u5217\u8868";
            String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
            Boolean flag = Boolean.valueOf(exportFlag);
            if (flag.booleanValue()) {
                String userCode;
                String string = userCode = null == param.get("userCode") ? null : (String)param.get("userCode");
                if (StringUtils.isBlank((String)userCode)) {
                    UserSession userSession = this.getUserSession(request);
                    userCode = userSession.getUserCode();
                }
                infoMap.put("userCode", userCode);
                List jsonToList = null;
                infoMap.put("fileName", fileName);
                infoMap.put("headMap", ExcelExportTemplate.covertOrderMsHeadExcelParam());
                try {
                    List list = rsResourceGoodsReDomainSupQueryResult.getList();
                    String str = JsonUtil.buildNormalBinder().toJson((Object)list);
                    jsonToList = (List)JsonUtil.buildNormalBinder().getJsonToList(str, Map.class);
                    for (Map mp : jsonToList) {
                        mp.put("giftNo", giftNo);
                    }
                    this.exportExcel(request, param, infoMap, jsonToList);
                    System.out.println("\u5bfc\u51fa\u6210\u529f***********************" + jsonToList);
                }
                catch (Exception e) {
                    this.logger.error(CODE + ".excelExportGiftGoods.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                    return null;
                }
                return null;
            }
        }
        return rsResourceGoodsReDomainSupQueryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel(HttpServletRequest request, Map<String, Object> paramMap, Map<String, Object> infoMap, List<Map<String, Object>> fromDataList) {
        this.logger.info("=======================\u4f20\u5165\u7684\u6570\u91cf===================" + fromDataList.size());
        this.logger.error("paramMap-_=+is", paramMap);
        if (MapUtil.isEmpty(paramMap) || MapUtil.isEmpty(infoMap)) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"param is null");
            return;
        }
        String tenantCode = MapUtils.getString(paramMap, (Object)"tenantCode");
        if (null == infoMap.get("userCode")) {
            this.logger.error("SpringmvnNewController.exportComExcel", (Object)"userCode is null");
            return;
        }
        String userCode = (String)infoMap.get("userCode");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        long timeMillis = System.currentTimeMillis();
        String formatData = sdf.format(timeMillis);
        String fileName = null == infoMap.get("fileName") ? "" : (String)infoMap.get("fileName");
        fileName = formatData + "-" + fileName;
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = infoMap.get("headMap");
        if (null == headMap) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMap", (Object)(" =:= " + infoMap));
            return;
        }
        List headMapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(headMap), Map.class);
        if (ListUtil.isEmpty((Collection)headMapList)) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMapList", (Object)(" is null " + JsonUtil.buildNormalBinder().toJson(headMap)));
            return;
        }
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            HSSFCellStyle setBorder = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setFontHeightInPoints((short)10);
            font.setBold(true);
            setBorder.setFont(font);
            cell.setCellStyle(setBorder);
        }
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        ArrayList<String> data = null;
        for (Map<String, Object> map : fromDataList) {
            data = new ArrayList<String>();
            for (Map map1 : headMapList) {
                String beanName = map1.get("dataName").toString();
                String value = "";
                if (StringUtils.isNotBlank((String)beanName)) {
                    String string = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    if ("null".equals(value)) {
                        value = "";
                    }
                }
                data.add(value);
            }
            String[] array = data.toArray(new String[data.size()]);
            dataList.add(array);
            this.logger.info("================================\u6570\u91cf==================================" + dataList.size());
        }
        try {
            ExportExcelUtlis.exportExcel((HSSFSheet)sheet, (HSSFRow)row, (String[])headers, dataList, (String)"yyyy-MM-dd HH:mm:ss", (int)0);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.exportExcel", (Object)"Exception");
            return;
        }
        String fileType = "xls";
        String tempPath = request.getSession().getServletContext().getRealPath("/") + "../../temp/" + fileName + "." + fileType;
        if (StringUtils.isBlank((String)tempPath)) {
            this.logger.error("SpringmvnNewController.exportComExcel.tempPath", (Object)tempPath);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(tempPath);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            this.logger.error("SpringmvnNewController.exportComExcel.close", (Throwable)e);
            return;
        }
        finally {
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {}
            }
        }
        byte[] bytes = null;
        try {
            bytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.InputStreamByteArray", (Object)"Exception");
            return;
        }
        this.saveExcel(bytes, fileName, userCode, fileType, tenantCode);
    }

    public void saveExcel(byte[] bytes, String fileName, String userCode, String fileType, String tenantCode) {
        if (bytes == null || bytes.length <= 0 || StringUtils.isBlank((String)fileName) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveExcel", (Object)(bytes.length + "-" + fileName + "-" + userCode + "-" + "-" + fileType + "-" + tenantCode));
            return;
        }
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fileName);
        fmFileReDomainBean.setFileOwner(userCode);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileContext(bytes);
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])bytes));
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(fileName);
        fileBean.setSize(Long.valueOf(1L));
        this.saveFile(fileBean, tenantCode, "FILE_11", (FmFileDomainBean)fmFileReDomainBean);
    }

    private FmFileReDomainBean saveFile(FileBean fileBean, String tenantCode, String fileSort, FmFileDomainBean FmFileDomainBeanBean) {
        if (null == FmFileDomainBeanBean || null == fileBean) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"param is null");
            return null;
        }
        FmFileReDomainBean fmFileReDomainBean = null;
        try {
            String fileUrl;
            PostParamMap pmap = new PostParamMap("fm.file.saveFile");
            FmFileDomainBeanBean.setFileType("0");
            FmFileDomainBeanBean.setFileSort(StringUtils.isBlank((String)fileSort) ? "FILE_02" : fileSort);
            FmFileDomainBeanBean.setTenantCode(tenantCode);
            FmFileDomainBeanBean.setRootPath(tenantCode + "/");
            ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
            fileBeanList.add(fileBean);
            pmap.putParamToJson("fmFileDomainBean", (Object)FmFileDomainBeanBean);
            pmap.putParamToJson("fileBeanList", fileBeanList);
            String key = "filePath";
            String settingType = "0";
            fmFileReDomainBean = (FmFileReDomainBean)this.htmlIBaseService.senReObject(pmap, FmFileReDomainBean.class);
            String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + settingType + "-" + key));
            if (StringUtils.isBlank((String)httpPath)) {
                httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + settingType + "-" + key));
            }
            if (StringUtils.isNotBlank((String)(fileUrl = fmFileReDomainBean.getFileUrl()))) {
                String separator = System.getProperties().getProperty("file.separator");
                if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                    separator = "";
                }
                fmFileReDomainBean.setFileUrl(httpPath + separator + fileUrl);
            }
            fmFileReDomainBean.setRootPath(fileUrl);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.saveFile", (Object)"Exception", (Throwable)e);
            return null;
        }
        return fmFileReDomainBean;
    }
}

