/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.gt.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftFileReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftRelReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftSendReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftSpecDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftSpecReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftUserDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftUserReDomain;
import com.qjsoft.laser.controller.facade.gt.domain.GtGiftUserrelReDomain;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftFileServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftRelServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftSendServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftSendlistServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftSpecServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftUserServiceRepository;
import com.qjsoft.laser.controller.facade.gt.repository.GtGiftUserrelServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsFileDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsGoodsRelDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSpecValueDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.sp.domain.SpScontractReDomain;
import com.qjsoft.laser.controller.facade.sp.repository.SpScontractServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/gt/gift"}, name="\u793c\u54c1\u670d\u52a1")
public class GiftCon
extends SpringmvnNewController {
    private static String CODE = "gt.gift.con";
    @Autowired
    UserServiceRepository userServiceRepository;
    @Autowired
    private SpScontractServiceRepository spScontractServiceRepository;
    @Autowired
    private GtGiftServiceRepository gtGiftServiceRepository;
    @Autowired
    private GtGiftFileServiceRepository gtGiftFileServiceRepository;
    @Autowired
    private GtGiftRelServiceRepository gtGiftRelServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private RsGoodsOtherServiceRepository rsGoodsOtherServiceRepository;
    @Autowired
    private GtGiftSendlistServiceRepository gtGiftSendlistServiceRepository;
    @Autowired
    private GtGiftSendServiceRepository gtGiftSendServiceRepository;
    @Autowired
    private GtGiftUserrelServiceRepository gtGiftUserrelServiceRepository;
    @Autowired
    private GtGiftUserServiceRepository gtGiftUserServiceRepository;
    @Autowired
    private GtGiftSpecServiceRepository gtGiftSpecServiceRepository;

    protected String getContext() {
        return "gift";
    }

    @RequestMapping(value={"saveGift.json"}, name="\u589e\u52a0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveGift(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveGift", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == gtGiftDomain.getGtGiftRelDomainList() || gtGiftDomain.getGtGiftRelDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List gtGiftRelDomainArr = gtGiftDomain.getGtGiftRelDomainList();
        if (null != gtGiftRelDomainArr && gtGiftRelDomainArr.size() > 0) {
            for (GtGiftRelReDomain gtGiftRelReDomain : gtGiftRelDomainArr) {
                if (null == gtGiftRelReDomain.getPricesetBaseprice() || gtGiftRelReDomain.getPricesetBaseprice().equals("") || 0 == gtGiftRelReDomain.getPricesetBaseprice().intValue()) {
                    gtGiftRelReDomain.setPricesetBaseprice(gtGiftRelReDomain.getPricesetNprice());
                }
                gtGiftRelReDomain.getPricesetBaseprice();
            }
        }
        if (null == gtGiftDomain.getGtGiftSpecDomainList() || gtGiftDomain.getGtGiftSpecDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.relList", (Object)"getGtGiftSpecDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        gtGiftDomain.setGiftRemark(GiftCon.makeRemark(gtGiftDomain.getGiftRemark()));
        return this.gtGiftServiceRepository.saveGift(gtGiftDomain);
    }

    @RequestMapping(value={"getGift.json"}, name="\u83b7\u53d6\u793c\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public GtGiftReDomain getGift(Integer giftId) {
        if (StringUtils.isBlank((Integer)giftId)) {
            this.logger.error(CODE + ".getGift", (Object)"param is null");
            return null;
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGift(giftId);
        Map amap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        gtGiftReDomain.setGtGiftFileDomainList(this.gtGiftFileServiceRepository.queryGiftFilePage(amap).getList());
        gtGiftReDomain.setGtGiftRelDomainList(this.gtGiftRelServiceRepository.queryGiftRelPage(amap).getList());
        List gtGiftSpecReDomainList = this.gtGiftSpecServiceRepository.queryGiftSpecPage(amap).getList();
        ArrayList<GtGiftSpecReDomain> gtGiftSpecDomainArr = new ArrayList<GtGiftSpecReDomain>();
        if (null != gtGiftSpecReDomainList && gtGiftSpecReDomainList.size() > 0) {
            for (GtGiftSpecReDomain gtGiftSpecDomain : gtGiftSpecReDomainList) {
                gtGiftSpecDomainArr.add(gtGiftSpecDomain);
            }
        }
        gtGiftReDomain.setGtGiftSpecDomainList(gtGiftSpecDomainArr);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"getGiftReGoods.json"}, name="\u83b7\u53d6\u793c\u54c1\u670d\u52a1\u7684\u5546\u54c1\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<GtGiftRelReDomain> getGiftReGoods(HttpServletRequest request, Integer giftId) {
        if (StringUtils.isBlank((Integer)giftId)) {
            this.logger.error(CODE + ".getGift", (Object)"param is null");
            return null;
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGift(giftId);
        Map amap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("ntoDataState", -1);
        param.putAll(amap);
        return this.gtGiftRelServiceRepository.queryGiftRelPage(param);
    }

    @RequestMapping(value={"updateGift.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateGift(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateGift", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateGift.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == gtGiftDomain.getGtGiftRelDomainList() || gtGiftDomain.getGtGiftRelDomainList().size() == 0) {
            this.logger.error(CODE + ".updateGift.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        gtGiftDomain.setGiftRemark(GiftCon.makeRemark(gtGiftDomain.getGiftRemark()));
        return this.gtGiftServiceRepository.updateGift(gtGiftDomain);
    }

    private static String makeRemark(String remark) {
        if (StringUtils.isNotBlank((String)remark)) {
            Pattern scriptPattern = Pattern.compile("alert(.*?)", 42);
            remark = scriptPattern.matcher(remark).replaceAll(" ");
        }
        return remark;
    }

    @RequestMapping(value={"updateGiftNewC.json"}, name="\u7f16\u8f91\u793c\u54c1")
    @ResponseBody
    public HtmlJsonReBean updateGiftNewC(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updateGiftNewC", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".updateGift.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(null != gtGiftDomain.getGtGiftRelDomainList() && gtGiftDomain.getGtGiftRelDomainList().size() != 0 || "\u56fa\u5b9a\u4ef7\u683c\u5408\u540c".equals(gtGiftDomain.getClasstreeName()))) {
            this.logger.error(CODE + ".updateGift.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        gtGiftDomain.setGiftRemark(GiftCon.makeRemark(gtGiftDomain.getGiftRemark()));
        return this.gtGiftServiceRepository.updateGift(gtGiftDomain);
    }

    @RequestMapping(value={"deleteGift.json"}, name="\u5220\u9664\u793c\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteGift(String giftId) {
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".deleteGift", (Object)"giftId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        String[] s = giftId.split(",");
        if (null != s && s.length > 0) {
            for (String gid : s) {
                GtGiftReDomain gtGiftReDomain = this.getGift(Integer.valueOf(gid));
                htmlJsonReBean = this.gtGiftServiceRepository.updateGiftState(Integer.valueOf(giftId), Integer.valueOf(-1), gtGiftReDomain.getDataState());
            }
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryGiftPage.json"}, name="\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("ntoDataState", -1);
        this.makeDefPage(param);
        return this.gtGiftServiceRepository.queryGiftPage(param);
    }

    @RequestMapping(value={"queryGiftPageForUp.json"}, name="\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageForUp(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("ntoDataState", -1);
        return this.gtGiftServiceRepository.queryGiftPage(param);
    }

    @RequestMapping(value={"queryGiftPageToB.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToB(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("sendState", 1);
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult gtGiftUserrelReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        List gtGiftUserReDomainArr = gtGiftUserrelReDomainList.getList();
        ArrayList<GtGiftReDomain> gtGiftReDomainArr = new ArrayList<GtGiftReDomain>();
        if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
            long time = 2592000000L;
            for (GtGiftUserReDomain gtGiftUserReDomain : gtGiftUserReDomainArr) {
                GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(this.getTenantCode(request), gtGiftUserReDomain.getGiftCode());
                long endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime > 0L && endTime < time) {
                    gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
                }
                gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
                gtGiftReDomainArr.add(gtGiftReDomain);
            }
        }
        SupQueryResult gtGiftReDomainList = new SupQueryResult();
        if (null != gtGiftReDomainArr) {
            gtGiftReDomainList.setList(gtGiftReDomainArr);
            gtGiftReDomainList.setTotal(gtGiftUserrelReDomainList.getTotal());
            gtGiftReDomainList.setPageTools(gtGiftUserrelReDomainList.getPageTools());
        }
        return gtGiftReDomainList;
    }

    @RequestMapping(value={"queryGiftPageToB2.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u88682")
    @ResponseBody
    public SupQueryResult<GtGiftUserReDomain> queryGiftPageToB2(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("sendState", 1);
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult gtGiftUserrelReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        List gtGiftUserReDomainArr = gtGiftUserrelReDomainList.getList();
        if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
            long time = 2592000000L;
            for (GtGiftUserReDomain gtGiftUserReDomain : gtGiftUserReDomainArr) {
                long endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime <= 0L || endTime >= time) continue;
                gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
            }
        }
        return gtGiftUserrelReDomainList;
    }

    @RequestMapping(value={"queryGiftUnissued.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u672a\u53d1\u653e\u670d\u52a1")
    @ResponseBody
    public Long queryGiftUnissued(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("validState", "0");
        param.put("sendState", 1);
        param.put("dataState", 0);
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult gtGiftUserrelReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        return gtGiftUserrelReDomainList.getTotal();
    }

    @RequestMapping(value={"queryGiftSendlistPageByGiftSendCodeToB.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u5305\u9886\u53d6\u7684\u8be6\u60c5\uff08\u67e5\u770b\u5458\u5de5\u9886\u53d6\u5217\u8868\uff09")
    @ResponseBody
    public GtGiftReDomain queryGiftSendlistPageByGiftSendCodeToB(String giftUserId) {
        if (null == giftUserId) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToB", (Object)"giftUserId is null");
            return null;
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserServiceRepository.getGiftUser(Integer.valueOf(giftUserId));
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        HashMap<String, String> mapUserList = new HashMap<String, String>();
        if (null != gtGiftUserReDomain.getGiftSendCode()) {
            mapUserList.put("giftUserType", "1");
            mapUserList.put("giftSendCode", gtGiftUserReDomain.getGiftSendCode());
            SupQueryResult gtGiftUserReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(mapUserList);
            List gtGiftUserReDomainArr = gtGiftUserReDomainList.getList();
            Integer claimedNum = 0;
            Integer unclaimedNum = 0;
            Integer someClaimedNum = 0;
            if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
                ArrayList<GtGiftUserReDomain> gtGiftUserDomainArr = new ArrayList<GtGiftUserReDomain>();
                for (GtGiftUserReDomain gtGiftUserDomain : gtGiftUserReDomainArr) {
                    Integer n;
                    Integer n2;
                    if (gtGiftUserDomain.getDataState() == 0 || gtGiftUserDomain.getDataState() == 4) {
                        n2 = unclaimedNum;
                        n = unclaimedNum = Integer.valueOf(unclaimedNum + 1);
                    }
                    if (gtGiftUserDomain.getDataState() == 1) {
                        n2 = claimedNum;
                        n = claimedNum = Integer.valueOf(claimedNum + 1);
                    }
                    if (gtGiftUserDomain.getDataState() == 2) {
                        n2 = someClaimedNum;
                        n = someClaimedNum = Integer.valueOf(someClaimedNum + 1);
                    }
                    gtGiftUserDomainArr.add(gtGiftUserDomain);
                }
                gtGiftUserReDomain.setClaimedNum(claimedNum);
                gtGiftUserReDomain.setUnclaimedNum(unclaimedNum);
                gtGiftUserReDomain.setSomeClaimedNum(someClaimedNum);
                gtGiftReDomain.setGtGiftUserDomainList(gtGiftUserDomainArr);
            }
            gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
            HtmlJsonReBean htmlJsonReBean = this.gtGiftUserrelServiceRepository.countGoodsByGiftCode(gtGiftUserReDomain.getGiftSendCode(), gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getMemberCode());
            Object countGoods = htmlJsonReBean.getDataObj();
            this.logger.error("gift--------", (Object)(countGoods + "----------" + gtGiftUserReDomain.getGiftSendCode() + "-*-*-*-*----" + gtGiftUserReDomain.getMemberCode()));
            gtGiftReDomain.setCountGoods(countGoods);
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToBNotState.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868\u8fc7\u6ee4\u72b6\u6001")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToBNotState(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("notSendDataState", 0);
        param.put("companyCode", userSession.getUserPcode());
        SupQueryResult giftUserList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        List giftUserArr = giftUserList.getList();
        ArrayList<GtGiftReDomain> gtGiftReDomainArr = new ArrayList<GtGiftReDomain>();
        if (null != giftUserArr && giftUserArr.size() > 0) {
            for (GtGiftUserReDomain gtGiftUserReDomain : giftUserArr) {
                GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
                gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
                gtGiftReDomainArr.add(gtGiftReDomain);
            }
        }
        SupQueryResult gtGiftReDomain = new SupQueryResult();
        if (null != gtGiftReDomainArr) {
            gtGiftReDomain.setList(gtGiftReDomainArr);
            gtGiftReDomain.setPageTools(giftUserList.getPageTools());
            gtGiftReDomain.setTotal(giftUserList.getTotal());
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToBNotState2.json"}, name="wap\u7aef\u4f01\u4e1a\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868\u8fc7\u6ee4\u72b6\u60012")
    @ResponseBody
    public SupQueryResult<GtGiftUserReDomain> queryGiftPageToBNotState2(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "2");
        param.put("companyCode", userSession.getUserPcode());
        SupQueryResult gtGiftUserReDomainSupQueryResult = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        if (ListUtil.isNotEmpty((Collection)gtGiftUserReDomainSupQueryResult.getList())) {
            for (GtGiftUserReDomain gtGiftUserReDomain : gtGiftUserReDomainSupQueryResult.getList()) {
                GtGiftSendReDomain gtGiftSendReDomain;
                if (!StringUtils.isNotBlank((String)gtGiftUserReDomain.getGiftSendCode()) || null == (gtGiftSendReDomain = this.gtGiftSendServiceRepository.getGiftSendByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftSendCode())) || !gtGiftSendReDomain.getDataState().equals(1)) continue;
                gtGiftUserReDomain.setGrantNum(gtGiftSendReDomain.getEmployeeNum());
            }
        }
        return gtGiftUserReDomainSupQueryResult;
    }

    @RequestMapping(value={"queryGiftUserByGiftUserCodeToB.json"}, name="wap\u7aef \u4f01\u4e1a\u67e5\u770b\u53d1\u653e\u8bb0\u5f55\u91cc\u9762\u7684\u793c\u5305\u8be6\u60c5")
    @ResponseBody
    public GtGiftReDomain queryGiftUserByGiftUserCodeToB(HttpServletRequest request, String giftUserCode) {
        GtGiftSendReDomain gtGiftSendReDomain;
        if (null == giftUserCode) {
            this.logger.error(CODE + ".queryGiftUserByGiftUserCodeToB", (Object)"giftUserCode is null");
            return null;
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserServiceRepository.getGiftUserByCode(this.getTenantCode(request), giftUserCode);
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(this.getTenantCode(request), gtGiftUserReDomain.getGiftCode());
        if (StringUtils.isNotBlank((String)gtGiftUserReDomain.getGiftSendCode()) && null != (gtGiftSendReDomain = this.gtGiftSendServiceRepository.getGiftSendByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftSendCode())) && gtGiftSendReDomain.getDataState().equals(1)) {
            gtGiftUserReDomain.setGrantNum(gtGiftSendReDomain.getEmployeeNum());
        }
        gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
        if (StringUtils.isNotBlank((String)gtGiftUserReDomain.getGiftSendCode())) {
            HashMap<String, String> mapUserList = new HashMap<String, String>();
            mapUserList.put("giftUserType", "1");
            mapUserList.put("giftSendCode", gtGiftUserReDomain.getGiftSendCode());
            SupQueryResult gtGiftUserReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(mapUserList);
            List gtGiftUserReDomainArr = gtGiftUserReDomainList.getList();
            ArrayList<GtGiftUserReDomain> gtGiftUserDomainArr = new ArrayList<GtGiftUserReDomain>();
            if (null != gtGiftUserReDomainArr && gtGiftUserReDomainArr.size() > 0) {
                for (GtGiftUserReDomain gtGiftUserDomain : gtGiftUserReDomainArr) {
                    gtGiftUserDomainArr.add(gtGiftUserDomain);
                }
            }
            gtGiftReDomain.setGtGiftUserDomainList(gtGiftUserDomainArr);
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftSendlistPageByGiftSendCodeToC.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u8be2\u793c\u5305\u9886\u53d6\u7684\u8be6\u60c5\uff08\u67e5\u770b\u5458\u5de5\u9886\u53d6\u5217\u8868\uff09")
    @ResponseBody
    public GtGiftReDomain queryGiftSendlistPageByGiftSendCodeToC(String giftSendId) {
        if (null == giftSendId) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"giftSendId is null");
            return null;
        }
        GtGiftSendReDomain gtGiftSendReDomain = this.gtGiftSendServiceRepository.getGiftSend(Integer.valueOf(giftSendId));
        ArrayList<GtGiftSendReDomain> gtGiftSendDomainList = new ArrayList<GtGiftSendReDomain>();
        gtGiftSendDomainList.add(gtGiftSendReDomain);
        HashMap<String, GtGiftSendReDomain> maprel = new HashMap<String, GtGiftSendReDomain>();
        maprel.put("giftSendCode", gtGiftSendReDomain);
        List GtGiftRelReDomain2 = this.gtGiftRelServiceRepository.queryGiftRelPage(maprel).getList();
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftSendReDomain.getTenantCode(), gtGiftSendReDomain.getGiftCode());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("giftCode", gtGiftSendReDomain.getGiftCode());
        SupQueryResult gtGiftSendlistDomain = this.gtGiftSendlistServiceRepository.queryGiftSendlistPage(param);
        if (null == gtGiftSendlistDomain) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"gtGiftSendlistDomain is null");
            return null;
        }
        List gtGiftSendlistDomainList = gtGiftSendlistDomain.getList();
        if (null == gtGiftSendlistDomainList || gtGiftSendlistDomainList.size() == 0) {
            this.logger.error(CODE + ".queryGiftSendlistPageByGiftSendCodeToC", (Object)"gtGiftSendlistDomainList is null");
            return null;
        }
        gtGiftReDomain.setGtGiftSendlistDomainList(gtGiftSendlistDomainList);
        gtGiftReDomain.setGtGiftSendDomainList(gtGiftSendDomainList);
        gtGiftReDomain.setGtGiftRelDomainList(GtGiftRelReDomain2);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToC.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftReDomain> queryGiftPageToC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("giftUserType", "1");
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult gtGiftUserReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        List giftUserDomainArr = gtGiftUserReDomainList.getList();
        ArrayList<GtGiftReDomain> gtGiftReDomainList = new ArrayList<GtGiftReDomain>();
        long time = 2592000000L;
        if (null != giftUserDomainArr && giftUserDomainArr.size() > 0) {
            for (GtGiftUserReDomain gtGiftUserReDomain : giftUserDomainArr) {
                long endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime > 0L && endTime < time) {
                    gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
                }
                GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
                HashMap<String, String> fileMap = new HashMap<String, String>();
                fileMap.put("giftCode", gtGiftUserReDomain.getGiftCode());
                gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
                gtGiftReDomainList.add(gtGiftReDomain);
            }
        }
        SupQueryResult gtGiftReDomain = new SupQueryResult();
        if (null != gtGiftReDomainList) {
            gtGiftReDomain.setList(gtGiftReDomainList);
            gtGiftReDomain.setTotal(gtGiftUserReDomainList.getTotal());
            gtGiftReDomain.setPageTools(gtGiftUserReDomainList.getPageTools());
        }
        return gtGiftReDomain;
    }

    @RequestMapping(value={"queryGiftPageToC2.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u8be2\u793c\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<GtGiftUserReDomain> queryGiftPageToC2(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("validState", 0);
        }
        param.put("memberBcode", userSession.getUserPcode());
        SupQueryResult gtGiftUserReDomainList = this.gtGiftUserServiceRepository.queryGiftUserPage(param);
        List giftUserDomainArr = gtGiftUserReDomainList.getList();
        long time = 2592000000L;
        if (null != giftUserDomainArr && giftUserDomainArr.size() > 0) {
            for (GtGiftUserReDomain gtGiftUserReDomain : giftUserDomainArr) {
                long endTime = gtGiftUserReDomain.getGiftUserEnd().getTime() - new Date().getTime();
                if (endTime <= 0L || endTime >= time) continue;
                gtGiftUserReDomain.setReminder("\u5373\u5c06\u8fc7\u671f");
            }
        }
        return gtGiftUserReDomainList;
    }

    @RequestMapping(value={"queryRelToC.json"}, name="wap\u5458\u5de5\u9886\u53d6\u793c\u54c1\u65f6\u663e\u793a\u7684\u5546\u54c1")
    @ResponseBody
    public GtGiftReDomain queryRelToC(HttpServletRequest request, String giftUserCode) {
        UserSession userSession = this.getUserSession(request);
        if (null == giftUserCode) {
            this.logger.error(CODE + ".queryRelToC", (Object)"giftUserCode is null");
            return new GtGiftReDomain();
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserServiceRepository.getGiftUserByCode(userSession.getTenantCode(), giftUserCode);
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        Map amap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        Map map = this.assemMapParam(request);
        if (map.containsKey("goodsCode")) {
            amap.put("fuzzy", true);
            amap.put("goodsCode", map.get("goodsCode"));
        }
        gtGiftReDomain.setGtGiftRelDomainList(this.gtGiftRelServiceRepository.queryGiftRelPage(amap).getList());
        this.makeUserRelNum(gtGiftReDomain, (GtGiftUserDomain)gtGiftUserReDomain);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"getGiftByUser.json"}, name="\u7528\u6237\u67e5\u770b\u793c\u5305\u6d3b\u52a8")
    @ResponseBody
    public GtGiftReDomain getGiftByUser(HttpServletRequest request, String giftUserCode) throws Exception {
        if (StringUtils.isBlank((String)giftUserCode)) {
            this.logger.error(CODE + ".queryRelToC", (Object)"giftUserCode is null");
            return new GtGiftReDomain();
        }
        UserSession userSession = this.getUserSession(request);
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserServiceRepository.getGiftUserByCode(userSession.getTenantCode(), giftUserCode);
        if (null == gtGiftUserReDomain || StringUtils.isBlank((String)gtGiftUserReDomain.getMemberBcode()) || StringUtils.isBlank((String)gtGiftUserReDomain.getGiftCode()) || !userSession.getUserPcode().equals(gtGiftUserReDomain.getMemberBcode())) {
            this.logger.error(CODE + ".getGiftByUser.gtGiftUserReDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)gtGiftUserReDomain));
            throw new Exception("\u53c2\u6570\u9519\u8bef");
        }
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        this.makeUserRelNum(gtGiftReDomain, (GtGiftUserDomain)gtGiftUserReDomain);
        return gtGiftReDomain;
    }

    private void makeUserRelNum(GtGiftReDomain gtGiftReDomain, GtGiftUserDomain gtGiftUserReDomain) {
        BigDecimal userNum;
        String cType = gtGiftReDomain.getGiftChange();
        if ("1".equals(cType)) {
            BigDecimal userCnum = BigDecimal.ZERO;
            if (null != gtGiftUserReDomain.getGiftUserCnum()) {
                userCnum = gtGiftUserReDomain.getGiftUserCnum();
            }
            userNum = gtGiftUserReDomain.getGiftUserNum();
            BigDecimal num = gtGiftUserReDomain.getGiftCnum().multiply(userNum).subtract(userCnum);
            gtGiftUserReDomain.setUserRelNum(num);
        }
        if ("0".equals(cType)) {
            BigDecimal userAmt = BigDecimal.ZERO;
            if (null != gtGiftUserReDomain.getGiftUserCamt()) {
                userAmt = gtGiftUserReDomain.getGiftUserCamt();
            }
            userNum = gtGiftUserReDomain.getGiftUserNum();
            BigDecimal amt = gtGiftUserReDomain.getGiftCnum().multiply(userNum).subtract(userAmt);
            gtGiftUserReDomain.setUserRelNum(amt);
        }
        gtGiftReDomain.setGtGiftUserDomain(gtGiftUserReDomain);
    }

    @RequestMapping(value={"queryGiftUserRelToC.json"}, name="wap\u7aef\u5458\u5de5\u67e5\u770b\u793c\u5305\u8be6\u60c5")
    @ResponseBody
    public GtGiftReDomain queryGiftUserRelToC(HttpServletRequest request, String giftUserCode) {
        if (null == giftUserCode) {
            this.logger.error(CODE + ".queryGiftUserRelToC", (Object)"giftUserCode is null");
            return new GtGiftReDomain();
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserServiceRepository.getGiftUserByCode(this.getTenantCode(request), giftUserCode);
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        Map fileMap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        gtGiftReDomain.setGtGiftFileDomainList(this.gtGiftFileServiceRepository.queryGiftFilePage(fileMap).getList());
        Map amap = this.getQueryMapParam("giftSendCode,memberBcode,giftUserCode", new Object[]{gtGiftUserReDomain.getGiftSendCode(), gtGiftUserReDomain.getMemberBcode(), gtGiftUserReDomain.getGiftUserCode()});
        List gtGiftUserrelDomainArr = this.gtGiftUserrelServiceRepository.queryGiftUserrelPage(amap).getList();
        ArrayList<GtGiftUserrelReDomain> gtGiftUserrelDomainList = new ArrayList<GtGiftUserrelReDomain>();
        if (null != gtGiftUserrelDomainArr && gtGiftUserrelDomainArr.size() > 0) {
            for (GtGiftUserrelReDomain GtGiftUserrelReDomain2 : gtGiftUserrelDomainArr) {
                if (null == GtGiftUserrelReDomain2.getGiftUserrelNum()) continue;
                gtGiftUserrelDomainList.add(GtGiftUserrelReDomain2);
            }
        }
        gtGiftReDomain.setGtGiftUserrelDomainList(gtGiftUserrelDomainList);
        gtGiftReDomain.setGtGiftUserDomain((GtGiftUserDomain)gtGiftUserReDomain);
        return gtGiftReDomain;
    }

    @RequestMapping(value={"updateGiftState.json"}, name="\u66f4\u65b0\u793c\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateGiftState(String giftId, Integer dataState, Integer oldDataState) {
        String[] id;
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String a : id = giftId.split(",")) {
            this.gtGiftServiceRepository.updateGiftState(Integer.valueOf(a), dataState, oldDataState);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateGiftPrice.json"}, name="\u66f4\u65b0\u793c\u54c1\u552e\u4ef7")
    @ResponseBody
    public HtmlJsonReBean updateGiftPrice(String giftId, BigDecimal pricesetNprice) {
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftPrice", (Object)"giftId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null == pricesetNprice) {
            this.logger.error(CODE + ".updateGiftPrice", (Object)"pricesetNprice is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.gtGiftServiceRepository.updateGiftPrice(Integer.valueOf(giftId), pricesetNprice);
    }

    private void makeChannel(RsResourceGoodsDomain rsResourceGoodsDomain, HttpServletRequest request) {
        String[] s;
        if (null == rsResourceGoodsDomain || null == request) {
            return;
        }
        String channelInfo = this.getChannel(request);
        if (StringUtils.isNotBlank((String)channelInfo) && null != (s = channelInfo.split(",")) && s.length > 1) {
            rsResourceGoodsDomain.setChannelCode(s[0]);
            rsResourceGoodsDomain.setChannelName(s[1]);
        }
    }

    @RequestMapping(value={"updateGiftShelfState.json"}, name="\u793c\u5305\u4e0a\u67b6\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean updateGiftShelfState(HttpServletRequest request, String giftId) {
        String[] giftIdArray;
        if (StringUtils.isBlank((String)giftId)) {
            this.logger.error(CODE + ".updateGiftShelfState", (Object)"giftId is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (String gid : giftIdArray = giftId.split(",")) {
            GtGiftReDomain gtGiftReDomain = this.getGift(Integer.valueOf(gid));
            if (null == gtGiftReDomain) {
                this.logger.error(CODE + ".updateGiftShelfState", (Object)"gtGiftReDomain is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "gtGiftReDomain");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("goodsOrigin", "5");
            map.put("goodsNo", gtGiftReDomain.getGiftCode());
            map.put("tenantCode", gtGiftReDomain.getTenantCode());
            SupQueryResult rsList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
            if (null != rsList && null != rsList.getRows() && !rsList.getRows().isEmpty()) continue;
            RsResourceGoodsDomain rsResourceGoodsDomain = this.make(request, gtGiftReDomain);
            ArrayList<RsResourceGoodsDomain> goodsList = new ArrayList<RsResourceGoodsDomain>();
            goodsList.add(rsResourceGoodsDomain);
            this.logger.error(goodsList + ".updateGiftShelfState", (Object)"gtGiftReDomain is null");
            HtmlJsonReBean htmlJsonReBean1 = this.rsResourceGoodsServiceRepository.savePassResourceGoodsBatch(goodsList);
            this.logger.error(htmlJsonReBean1 + ".updateGiftShelfState", (Object)"gtGiftReDomain is null");
            String rs = htmlJsonReBean1.getErrorCode();
            if (StringUtils.isNotBlank((String)rs)) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u64cd\u4f5c\u5931\u8d25");
            }
            htmlJsonReBean = this.gtGiftServiceRepository.updateGiftStateByCode(gtGiftReDomain.getTenantCode(), gtGiftReDomain.getGiftCode(), Integer.valueOf(1), Integer.valueOf(2));
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateGiftLowerState.json"}, name="\u793c\u5305\u4e0b\u67b6\u64cd\u4f5c")
    @ResponseBody
    public HtmlJsonReBean updateGiftLowerState(HttpServletRequest request, String giftCode) {
        String[] giftCodeArray;
        if (StringUtils.isBlank((String)giftCode)) {
            this.logger.error(CODE + ".updateGiftLowerState", (Object)"giftCode is null");
            return new HtmlJsonReBean((Object)HtmlJsonReBean.ERRORCODE);
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (String gcode : giftCodeArray = giftCode.split(",")) {
            HtmlJsonReBean htmlJsonReBean1;
            String errorCode;
            HashMap<String, String> map = new HashMap<String, String>();
            String tenantCode = this.getTenantCode(request);
            map.put("goodsOrigin", "5");
            map.put("goodsNo", gcode);
            map.put("tenantCode", tenantCode);
            SupQueryResult rsResourceGoodsReDomainList = this.rsResourceGoodsServiceRepository.queryResourceGoodsPage(map);
            List list = rsResourceGoodsReDomainList.getList();
            HashMap<String, String> params = new HashMap<String, String>();
            if (null != list && list.size() != 0) {
                RsResourceGoodsReDomain rsResourceGoodsReDomain = (RsResourceGoodsReDomain)list.get(0);
                params.put("goodsOrigin", "5");
                params.put("goodsCode", rsResourceGoodsReDomain.getGoodsCode());
                params.put("tenantCode", tenantCode);
            }
            if (StringUtils.isNotBlank((String)(errorCode = (htmlJsonReBean1 = this.rsResourceGoodsServiceRepository.delResourceGoodsByCode(params)).getErrorCode()))) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5220\u9664\u5546\u54c1\u5931\u8d25");
            }
            htmlJsonReBean = this.gtGiftServiceRepository.updateGiftStateByCode(tenantCode, gcode, Integer.valueOf(2), Integer.valueOf(1));
        }
        return htmlJsonReBean;
    }

    private RsResourceGoodsDomain make(HttpServletRequest request, GtGiftReDomain gtGiftReDomain) {
        List gtGiftRelReDomain;
        if (null == gtGiftReDomain || null == request) {
            return null;
        }
        RsResourceGoodsDomain rsResourceGoodsDomain = new RsResourceGoodsDomain();
        rsResourceGoodsDomain.setMschannelCode(gtGiftReDomain.getMemberCcode().substring(0, 10));
        rsResourceGoodsDomain.setMschannelName(gtGiftReDomain.getMemberCname().substring(0, 10));
        rsResourceGoodsDomain.setGoodsName(gtGiftReDomain.getGiftName());
        rsResourceGoodsDomain.setGoodsNo(gtGiftReDomain.getGiftCode());
        rsResourceGoodsDomain.setPntreeCode(gtGiftReDomain.getPntreeCode());
        rsResourceGoodsDomain.setPntreeName(gtGiftReDomain.getPntreeName());
        rsResourceGoodsDomain.setClasstreeCode(gtGiftReDomain.getClasstreeCode());
        rsResourceGoodsDomain.setClasstreeName(gtGiftReDomain.getClasstreeName());
        rsResourceGoodsDomain.setPricesetNprice(gtGiftReDomain.getPricesetNprice());
        rsResourceGoodsDomain.setPricesetMakeprice(gtGiftReDomain.getPricesetMakeprice());
        rsResourceGoodsDomain.setBrandCode(gtGiftReDomain.getBrandCode());
        rsResourceGoodsDomain.setBrandName(gtGiftReDomain.getBrandName());
        UserSession userSession = this.getUserSession(request);
        rsResourceGoodsDomain.setMemberCode(userSession.getUserPcode());
        rsResourceGoodsDomain.setMemberName(userSession.getUserName());
        rsResourceGoodsDomain.setTenantCode(this.getTenantCode(request));
        rsResourceGoodsDomain.setGoodsOrigin("5");
        rsResourceGoodsDomain.setGoodsType("05");
        rsResourceGoodsDomain.setPricesetMakeshow("1");
        rsResourceGoodsDomain.setPartsnameNumunit("\u4e2a");
        rsResourceGoodsDomain.setGoodsWeight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsSupplyweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsAhweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangweight(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsHangnum(new BigDecimal("1"));
        rsResourceGoodsDomain.setGoodsNum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsAhnum(new BigDecimal("9999"));
        rsResourceGoodsDomain.setGoodsSupplynum(new BigDecimal("9999"));
        this.makeChannel(rsResourceGoodsDomain, request);
        List gtGiftFileReDomain = gtGiftReDomain.getGtGiftFileDomainList();
        if (!ListUtil.isEmpty((Collection)gtGiftFileReDomain)) {
            ArrayList<RsGoodsFileDomain> rsGoodsFileList = new ArrayList<RsGoodsFileDomain>();
            for (GtGiftFileReDomain gtGiftFile : gtGiftFileReDomain) {
                RsGoodsFileDomain rsGoodsFile = new RsGoodsFileDomain();
                rsGoodsFile.setGoodsFileName(gtGiftFile.getGiftFileFilename());
                rsGoodsFile.setAppmanageIcode(gtGiftFile.getAppmanageIcode());
                rsGoodsFile.setGoodsFileSort(gtGiftFile.getGiftFileSort());
                rsGoodsFile.setGoodsFileType(gtGiftFile.getGiftFileType());
                rsGoodsFile.setGoodsFilesortName(gtGiftFile.getGiftFilesortName());
                rsGoodsFile.setGoodsFileUrl(gtGiftFile.getGiftFileFileUrl());
                rsGoodsFile.setTenantCode(gtGiftFile.getTenantCode());
                rsGoodsFileList.add(rsGoodsFile);
            }
            rsResourceGoodsDomain.setRsGoodsFileDomainList(rsGoodsFileList);
        }
        if (ListUtil.isNotEmpty((Collection)(gtGiftRelReDomain = gtGiftReDomain.getGtGiftRelDomainList()))) {
            ArrayList<RsGoodsRelDomain> rsGoodsRelDomainList = new ArrayList<RsGoodsRelDomain>();
            for (GtGiftRelReDomain gtGiftRel : gtGiftRelReDomain) {
                RsGoodsRelDomain rsGoodsRelDomain = new RsGoodsRelDomain();
                rsGoodsRelDomain.setGoodsRelGcode(gtGiftRel.getGoodsCode());
                rsGoodsRelDomain.setMemberCcode(gtGiftRel.getMemberCcode());
                rsGoodsRelDomain.setMemberCname(gtGiftRel.getMemberCname());
                rsGoodsRelDomain.setSkuCode(gtGiftRel.getSkuCode());
                rsGoodsRelDomain.setSkuName(gtGiftRel.getSkuName());
                rsGoodsRelDomain.setSkuNo(gtGiftRel.getSkuNo());
                rsGoodsRelDomain.setSkuShowno(gtGiftRel.getSkuShowno());
                rsGoodsRelDomain.setPricesetNprice(gtGiftRel.getPricesetNprice());
                rsGoodsRelDomain.setPricesetMakeprice(gtGiftRel.getPricesetMakeprice());
                rsGoodsRelDomain.setPricesetBaseprice(gtGiftRel.getPricesetBaseprice());
                rsGoodsRelDomain.setGoodsWeight(gtGiftRel.getGoodsWeight());
                rsGoodsRelDomain.setGoodsNum(gtGiftRel.getGoodsNum());
                rsGoodsRelDomain.setDataPic(gtGiftRel.getDataPic());
                rsGoodsRelDomain.setDataPicpath(gtGiftRel.getDataPicpath());
                rsGoodsRelDomain.setAppmanageIcode(gtGiftRel.getAppmanageIcode());
                rsGoodsRelDomainList.add(rsGoodsRelDomain);
            }
            rsResourceGoodsDomain.setRsGoodsRelDomainList(rsGoodsRelDomainList);
        }
        ArrayList<RsSpecValueDomain> RsSpecValueList = new ArrayList<RsSpecValueDomain>();
        GtGiftSpecDomain gtGiftSpecDomain = (GtGiftSpecDomain)gtGiftReDomain.getGtGiftSpecDomainList().get(0);
        RsSpecValueDomain rsSpecValue = new RsSpecValueDomain();
        rsSpecValue.setSpecCode(gtGiftSpecDomain.getSpecCode());
        rsSpecValue.setSpecName(gtGiftSpecDomain.getSpecName());
        rsSpecValue.setSpecGroupCode(gtGiftSpecDomain.getSpecGroupCode());
        rsSpecValue.setSpecValueBillno(gtGiftReDomain.getGiftCode());
        rsSpecValue.setSpecValueFlag(gtGiftSpecDomain.getSpecValueFlag());
        rsSpecValue.setSpecValueType(gtGiftSpecDomain.getSpecValueType());
        rsSpecValue.setSpecValueValue(gtGiftSpecDomain.getSpecValueValue());
        rsSpecValue.setTenantCode(gtGiftReDomain.getTenantCode());
        RsSpecValueList.add(rsSpecValue);
        rsResourceGoodsDomain.setRsSpecValueDomainList(RsSpecValueList);
        return rsResourceGoodsDomain;
    }

    @RequestMapping(value={"saveGiftNew.json"}, name="\u589e\u52a0\u5408\u540c\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContract(HttpServletRequest request, String paramStr) {
        Date time;
        Calendar cal;
        Integer DateNum;
        Integer DateType;
        Map map = this.assemMapParam(request);
        this.logger.error(paramStr + "----------------", (Object)"param is null");
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveContract", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        GtGiftDomain gtGiftDomain = (GtGiftDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, GtGiftDomain.class);
        this.logger.error(gtGiftDomain + "gtGiftDomain", (Object)"*************++++++++****");
        if (null == gtGiftDomain.getGtGiftFileDomainList() || gtGiftDomain.getGtGiftFileDomainList().size() == 0) {
            this.logger.error(CODE + ".saveContract.fileList", (Object)"fileList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(null != gtGiftDomain.getGtGiftRelDomainList() && gtGiftDomain.getGtGiftRelDomainList().size() != 0 || "\u56fa\u5b9a\u4ef7\u683c\u5408\u540c".equals(gtGiftDomain.getClasstreeName()))) {
            this.logger.error(CODE + ".saveContract.relList", (Object)"relList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5408\u540c\u5173\u8054\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List gtGiftRelDomainArr = gtGiftDomain.getGtGiftRelDomainList();
        this.logger.error(CODE + gtGiftRelDomainArr, (Object)"gtGiftRelDomainArr++++++++++++");
        if (map.get("takeEffectTime") != null && !"".equals(map.get("takeEffectTime")) && Integer.valueOf(map.get("takeEffectTime").toString()) == 2) {
            DateType = 13;
            DateNum = 0;
            if (map.get("takeInput1") != null && !"".equals(map.get("takeInput1"))) {
                DateNum = Integer.valueOf(map.get("takeInput1").toString());
            }
            cal = Calendar.getInstance();
            if ("3".equals(map.get("takeRadio1").toString())) {
                DateType = 12;
            } else if ("6".equals(map.get("takeRadio1").toString())) {
                DateType = 10;
            } else if ("9".equals(map.get("takeRadio1").toString())) {
                DateType = 5;
            }
            cal.add(DateType, DateNum);
            time = cal.getTime();
            gtGiftDomain.setGiftOname(time.toString());
        }
        if (map.get("effectiveTime") != null && !"".equals(map.get("effectiveTime"))) {
            if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                DateType = 13;
                DateNum = 0;
                if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                    DateNum = Integer.valueOf(map.get("takeInput2").toString());
                }
                cal = Calendar.getInstance();
                if ("3".equals(map.get("takeRadio2"))) {
                    DateType = 1;
                } else if ("6".equals(map.get("takeRadio2"))) {
                    DateType = 2;
                } else if ("9".equals(map.get("takeRadio2"))) {
                    DateType = 5;
                }
                cal.add(DateType, DateNum);
                time = cal.getTime();
                gtGiftDomain.setAppmanageIcode(time.toString());
            }
            if (Integer.valueOf(map.get("effectiveTime").toString()) == 2) {
                String dateType = "";
                String dateNum = "";
                if (map.get("takeInput2") != null && !"".equals(map.get("takeInput2"))) {
                    dateNum = map.get("takeInput2").toString();
                }
                if ("3".equals(map.get("takeRadio2"))) {
                    dateType = "\u5e74";
                } else if ("6".equals(map.get("takeRadio2"))) {
                    dateType = "\u6708";
                } else if ("9".equals(map.get("takeRadio2"))) {
                    dateType = "\u65e5";
                }
                String time2 = dateNum + dateType;
                gtGiftDomain.setGiftOsku(time2);
            }
        }
        if (null != gtGiftRelDomainArr && gtGiftRelDomainArr.size() > 0) {
            for (GtGiftRelReDomain gtGiftRelReDomain : gtGiftRelDomainArr) {
                if (null == gtGiftRelReDomain.getPricesetBaseprice() || gtGiftRelReDomain.getPricesetBaseprice().equals("") || 0 == gtGiftRelReDomain.getPricesetBaseprice().intValue()) {
                    gtGiftRelReDomain.setPricesetBaseprice(gtGiftRelReDomain.getPricesetNprice());
                }
                gtGiftRelReDomain.getPricesetBaseprice();
            }
        }
        if (null == gtGiftDomain.getGtGiftSpecDomainList() || gtGiftDomain.getGtGiftSpecDomainList().size() == 0) {
            this.logger.error(CODE + ".saveGift.relList", (Object)"getGtGiftSpecDomainList is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u793c\u54c1\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        gtGiftDomain.setMemberCode(userSession.getUserPcode());
        gtGiftDomain.setMemberName(userSession.getUserName());
        gtGiftDomain.setTenantCode(this.getTenantCode(request));
        gtGiftDomain.setGiftRemark(GiftCon.makeRemark(gtGiftDomain.getGiftRemark()));
        return this.gtGiftServiceRepository.saveGift(gtGiftDomain);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"updateContractAll.json"}, name="\u7b7e\u7ea6\u6210\u529f\u540e\uff0c\u66f4\u65b0 \u5f00\u59cb/\u7ed3\u675f\u65f6\u95f4,\u5408\u540c\u7c7b\u578b\uff0c\u8fdb\u5ea6\uff0c\u5269\u4f59\u989d\u5ea6")
    @ResponseBody
    public HtmlJsonReBean updateContractAll(HttpServletRequest request) {
        SupQueryResult giftUserResult;
        Map map = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateContractList", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap checkMap = new HashMap();
        if (map.containsKey("giftCode") && map.containsKey("giftUserPhone")) {
            checkMap.put("giftCode", map.get("giftCode"));
            checkMap.put("giftUserPhone", map.get("giftUserPhone"));
            checkMap.put("fuzzy", true);
            checkMap.put("orderStr", "giftUserId");
        }
        if (null == (giftUserResult = this.gtGiftUserServiceRepository.queryGiftUserPage(checkMap)) || null == giftUserResult.getRows() || giftUserResult.getRows().isEmpty()) {
            this.logger.error(CODE + ".updateContractList", (Object)"giftUserResult is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "giftUserResult is null");
        }
        GtGiftUserReDomain updateGtGiftUserReDomain = (GtGiftUserReDomain)giftUserResult.getList().get(giftUserResult.getList().size() - 1);
        this.logger.error(CODE + "\u521d\u59cb\u7684updateGtGiftUserReDomain**********************", (Object)updateGtGiftUserReDomain);
        SupQueryResult getGiftResult = this.gtGiftServiceRepository.queryGiftPage(checkMap);
        if (null == getGiftResult || null == getGiftResult.getRows() || getGiftResult.getRows().isEmpty()) {
            this.logger.error(CODE + ".updateContractList", (Object)"getGiftResult is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "getGiftResult is null");
        }
        GtGiftReDomain getGtGiftReDomain = (GtGiftReDomain)getGiftResult.getList().get(0);
        this.logger.error(CODE + "getGtGiftReDomain**********************", (Object)getGtGiftReDomain);
        BigDecimal giftCnum = getGtGiftReDomain.getGiftCnum();
        this.logger.error(CODE + "getGtGiftReDomain*****************1", (Object)getGtGiftReDomain);
        BigDecimal unitPrice = new BigDecimal(0);
        if (map.containsKey("orderPrice")) {
            this.logger.error(CODE + "orderPrice*****************1", map.get("orderPrice"));
            unitPrice = new BigDecimal(map.get("orderPrice").toString());
        }
        BigDecimal amount = new BigDecimal(0);
        if (updateGtGiftUserReDomain.getAppmanageIcode() == null) {
            amount = giftCnum.subtract(unitPrice);
            this.logger.error(CODE + "amount*****************1", (Object)amount);
        } else {
            this.logger.error(CODE + "updateGtGiftUserReDomain////////////////", (Object)updateGtGiftUserReDomain);
            BigDecimal bd = new BigDecimal(updateGtGiftUserReDomain.getAppmanageIcode());
            amount = bd.subtract(unitPrice);
        }
        this.logger.error(CODE + "amount*****************2", (Object)amount);
        BigDecimal result1 = giftCnum.subtract(amount);
        BigDecimal schedule = result1.divide(giftCnum, 2, RoundingMode.HALF_UP);
        updateGtGiftUserReDomain.setAppmanageIcode(amount.toString());
        updateGtGiftUserReDomain.setGiftUserWeight(schedule);
        SimpleDateFormat sldf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = new Date();
        Calendar cal1 = Calendar.getInstance();
        sldf1.format(start);
        String GoodsNum = this.setStr(getGtGiftReDomain.getGoodsNum().toString());
        if (GoodsNum.equals("2")) {
            if (getGtGiftReDomain.getBrandName().toString().equals("3")) {
                cal1.setTime(start);
                cal1.add(12, Integer.parseInt(getGtGiftReDomain.getBrandCode()));
                start = cal1.getTime();
                this.logger.error(CODE + "start1*****************", (Object)start);
            } else if (getGtGiftReDomain.getBrandName().toString().equals("6")) {
                cal1.setTime(start);
                cal1.add(10, Integer.parseInt(getGtGiftReDomain.getBrandCode()));
                start = cal1.getTime();
                this.logger.error(CODE + "start2*****************", (Object)start);
            } else {
                if (!getGtGiftReDomain.getBrandName().toString().equals("9")) return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u6b63\u786e\u5339\u914d\u9009\u9879");
                cal1.setTime(start);
                cal1.add(5, Integer.parseInt(getGtGiftReDomain.getBrandCode()));
                start = cal1.getTime();
                this.logger.error(CODE + "start3*****************", (Object)start);
            }
        } else {
            if (!GoodsNum.equals("1")) return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u6b63\u786e\u5339\u914d\u9009\u98791");
            cal1.setTime(start);
            cal1.set(5, 1);
            cal1.add(2, 1);
            cal1.set(11, 0);
            cal1.set(12, 0);
            cal1.set(13, 0);
            start = cal1.getTime();
            this.logger.error(CODE + "start4*****************", (Object)start);
        }
        updateGtGiftUserReDomain.setMemberCcode(sldf1.format(start));
        SimpleDateFormat sldf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date end = new Date();
        Calendar cal2 = Calendar.getInstance();
        sldf2.format(end);
        String GoodsMinnum = this.setStr(getGtGiftReDomain.getGoodsMinnum().toString());
        if (GoodsMinnum.equals("2")) {
            String GoodsWeight = this.setStr(getGtGiftReDomain.getGoodsWeight().toString());
            if (GoodsWeight.equals("3")) {
                cal2.setTime(end);
                cal2.add(1, getGtGiftReDomain.getGoodsOneweight().intValue());
                end = cal2.getTime();
                this.logger.error(CODE + "end1*****************", (Object)end);
            } else if (GoodsWeight.equals("6")) {
                cal2.setTime(end);
                cal2.add(2, getGtGiftReDomain.getGoodsOneweight().intValue());
                end = cal2.getTime();
                this.logger.error(CODE + "end2*****************", (Object)end);
            } else {
                if (!GoodsWeight.equals("9")) return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u6b63\u786e\u5339\u914d\u9009\u98792");
                cal2.setTime(end);
                cal2.add(5, getGtGiftReDomain.getGoodsOneweight().intValue());
                end = cal2.getTime();
                this.logger.error(CODE + "end3*****************", (Object)end);
            }
        } else {
            if (!GoodsMinnum.equals("1")) return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u6b63\u786e\u5339\u914d\u9009\u98793");
            try {
                SimpleDateFormat sldf = new SimpleDateFormat("yyyy-MM-dd");
                end = sldf.parse(getGtGiftReDomain.getSpuCode());
                this.logger.error(CODE + "end4*****************", (Object)end);
            }
            catch (ParseException e) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        updateGtGiftUserReDomain.setMemberCname(sldf2.format(end));
        updateGtGiftUserReDomain.setDepartCode(getGtGiftReDomain.getClasstreeCode());
        this.logger.error(CODE + "**************\u63d2\u5165memo\u540e\u7684updateGtGiftUserReDomain**********************", (Object)updateGtGiftUserReDomain);
        return this.gtGiftUserServiceRepository.updateGiftUser((GtGiftUserDomain)updateGtGiftUserReDomain);
    }

    @RequestMapping(value={"updateContract.json"}, name="\u66f4\u65b0\u8fdb\u5ea6\uff0c\u5269\u4f59\u989d\u5ea6")
    @ResponseBody
    public HtmlJsonReBean updateContract(HttpServletRequest request) {
        Map map = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updateContractList", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        SupQueryResult giftUserResult = this.gtGiftUserServiceRepository.queryGiftUserPage(map);
        if (null == giftUserResult || null == giftUserResult.getRows() || giftUserResult.getRows().isEmpty()) {
            this.logger.error(CODE + ".updateContractList", (Object)"giftUserResult is null");
        }
        GtGiftUserReDomain updateGtGiftUserReDomain = (GtGiftUserReDomain)giftUserResult.getList().get(0);
        SupQueryResult getGiftResult = this.gtGiftServiceRepository.queryGiftPage(map);
        if (null == getGiftResult || null == getGiftResult.getRows() || getGiftResult.getRows().isEmpty()) {
            this.logger.error(CODE + ".updateContractList", (Object)"getGiftResult is null");
        }
        GtGiftReDomain getGtGiftReDomain = (GtGiftReDomain)getGiftResult.getList().get(0);
        BigDecimal giftCnum = getGtGiftReDomain.getGiftCnum();
        this.logger.error(CODE + "getGtGiftReDomain*****************1", (Object)getGtGiftReDomain);
        BigDecimal unitPrice = new BigDecimal(0);
        if (map.containsKey("orderPrice")) {
            this.logger.error(CODE + "orderPrice*****************1", map.get("orderPrice"));
            unitPrice = new BigDecimal(map.get("orderPrice").toString());
        }
        BigDecimal amount = new BigDecimal(0);
        if (updateGtGiftUserReDomain.getAppmanageIcode() == null) {
            amount = giftCnum.subtract(unitPrice);
            this.logger.error(CODE + "amount*****************1", (Object)amount);
        } else {
            this.logger.error(CODE + "updateGtGiftUserReDomain////////////////", (Object)updateGtGiftUserReDomain);
            BigDecimal bd = new BigDecimal(updateGtGiftUserReDomain.getAppmanageIcode());
            amount = bd.subtract(unitPrice);
        }
        this.logger.error(CODE + "amount*****************2", (Object)amount);
        BigDecimal result1 = giftCnum.subtract(amount);
        BigDecimal schedule = result1.divide(giftCnum, 2, RoundingMode.HALF_UP);
        updateGtGiftUserReDomain.setAppmanageIcode(amount.toString());
        updateGtGiftUserReDomain.setGiftUserWeight(schedule);
        updateGtGiftUserReDomain.setDepartCode(getGtGiftReDomain.getClasstreeCode());
        this.logger.error(CODE + "**************\u63d2\u5165memo\u540e\u7684updateGtGiftUserReDomain**********************", (Object)updateGtGiftUserReDomain);
        return this.gtGiftUserServiceRepository.updateGiftUser((GtGiftUserDomain)updateGtGiftUserReDomain);
    }

    public String setStr(String check) {
        if (check.contains(".")) {
            int indexOf = check.indexOf(".");
            check = check.substring(0, indexOf);
        }
        return check;
    }

    @RequestMapping(value={"insertContract.json"}, name="\u5408\u540c\u5217\u8868\u5bfc\u5165")
    @ResponseBody
    public HtmlJsonReBean insertContract(HttpServletRequest request, String paramStr) {
        Map map = this.assemMapParam(request);
        this.logger.error("paramStr", (Object)paramStr);
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".insertContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, GtGiftUserReDomain.class);
        if (ListUtil.isEmpty((Collection)list)) {
            this.logger.error(CODE + ".list", (Object)("list is null====>paramMap is" + paramStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        boolean flag = true;
        LinkedList returnlist = new LinkedList();
        String[] returnStr = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            UserSession userSession;
            HtmlJsonReBean htmlJsonReBean1;
            UmUserinfoReDomainBean umUserinfoReDomainBean;
            SupQueryResult userInfoList;
            HashMap<String, String> checkMap3;
            GtGiftUserReDomain upGtGiftUserDomain;
            SupQueryResult upList;
            HashMap<String, String> checkMap2;
            int count = i + 1;
            HashMap<String, String> checkMap1 = new HashMap<String, String>();
            checkMap1.put("giftCode", ((GtGiftUserReDomain)list.get(i)).getGiftCode());
            SupQueryResult qlist = this.gtGiftServiceRepository.queryGiftPage(checkMap1);
            this.logger.error("qlist******************************************", (Object)qlist.getList());
            checkMap1.put("scontractCode", ((GtGiftUserReDomain)list.get(i)).getGiftCode());
            SupQueryResult qlist2 = this.spScontractServiceRepository.queryScontractPage(checkMap1);
            this.logger.error("qlist2******************************************", (Object)qlist2.getList());
            if (qlist.getList().size() > 0 && ListUtil.isNotEmpty((Collection)qlist.getList())) {
                checkMap2 = new HashMap<String, String>();
                checkMap2.put("giftCode", ((GtGiftUserReDomain)list.get(i)).getGiftCode());
                checkMap2.put("orderStr", "giftUserId");
                upList = this.gtGiftUserServiceRepository.queryGiftUserPage(checkMap2);
                if (upList.getList().size() > 0 && ListUtil.isNotEmpty((Collection)upList.getList())) {
                    upGtGiftUserDomain = (GtGiftUserDomain)upList.getList().get(upList.getList().size() - 1);
                    upGtGiftUserDomain.setGiftCnum(((GtGiftUserReDomain)list.get(i)).getGiftCnum());
                    upGtGiftUserDomain.setAppmanageIcode(((GtGiftUserReDomain)list.get(i)).getAppmanageIcode());
                    upGtGiftUserDomain.setGiftUserWeight(((GtGiftUserReDomain)list.get(i)).getGiftUserWeight());
                    checkMap3 = new HashMap<String, String>();
                    checkMap3.put("companyCode", ((GtGiftUserReDomain)list.get(i)).getCompanyCode());
                    userInfoList = this.userServiceRepository.queryUserinfoPage(checkMap3);
                    this.logger.error("userInfoList1******************************************", (Object)userInfoList.getList());
                    umUserinfoReDomainBean = null;
                    if (userInfoList.getList().size() <= 0 || !ListUtil.isNotEmpty((Collection)userInfoList.getList())) {
                        this.logger.error("\u66f4\u65b01******************************************", (Object)upGtGiftUserDomain);
                        returnStr[i] = "\u7b2c" + count + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25";
                        flag = false;
                        continue;
                    }
                    umUserinfoReDomainBean = (UmUserinfoReDomainBean)userInfoList.getList().get(0);
                    upGtGiftUserDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoCompname());
                    upGtGiftUserDomain.setGiftUserPhone(umUserinfoReDomainBean.getUserinfoPhone());
                    upGtGiftUserDomain.setDepartCode(((GtGiftUserReDomain)list.get(i)).getDepartCode());
                    upGtGiftUserDomain.setMemberCcode(((GtGiftUserReDomain)list.get(i)).getMemberCcode());
                    upGtGiftUserDomain.setMemberCname(((GtGiftUserReDomain)list.get(i)).getMemberCname());
                    upGtGiftUserDomain.setGiftName(((GtGiftUserReDomain)list.get(i)).getGiftName());
                    upGtGiftUserDomain.setGiftUserOcode1(((GtGiftUserReDomain)list.get(i)).getGiftUserOcode1());
                    this.logger.error("\u66f4\u65b02******************************************", (Object)upGtGiftUserDomain);
                    htmlJsonReBean1 = this.gtGiftUserServiceRepository.updateGiftUser((GtGiftUserDomain)upGtGiftUserDomain);
                    if (null == htmlJsonReBean1 || htmlJsonReBean1.isSuccess()) continue;
                    returnStr[i] = "\u7b2c" + count + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25";
                    flag = false;
                    continue;
                }
                upGtGiftUserDomain = new GtGiftUserReDomain();
                userSession = this.getUserSession(request);
                upGtGiftUserDomain.setGiftName(((GtGiftReDomain)qlist.getList().get(0)).getGiftName());
                upGtGiftUserDomain.setMemberName(((GtGiftReDomain)qlist.getList().get(0)).getMemberName());
                upGtGiftUserDomain.setMemberCode(((GtGiftReDomain)qlist.getList().get(0)).getMemberCode());
                upGtGiftUserDomain.setDepartCode(((GtGiftReDomain)qlist.getList().get(0)).getClasstreeCode());
                upGtGiftUserDomain.setGiftUserStart(((GtGiftReDomain)qlist.getList().get(0)).getGiftStart());
                upGtGiftUserDomain.setGiftUserEnd(((GtGiftReDomain)qlist.getList().get(0)).getGiftEnd());
                upGtGiftUserDomain.setGiftCnum(((GtGiftUserReDomain)list.get(i)).getGiftCnum());
                upGtGiftUserDomain.setAppmanageIcode(((GtGiftUserReDomain)list.get(i)).getAppmanageIcode());
                BigDecimal divide = new BigDecimal(100);
                upGtGiftUserDomain.setGiftUserWeight(((GtGiftUserReDomain)list.get(i)).getGiftUserWeight().divide(divide, 2, RoundingMode.HALF_UP));
                HashMap<String, String> checkMap32 = new HashMap<String, String>();
                checkMap32.put("companyCode", ((GtGiftUserReDomain)list.get(i)).getCompanyCode());
                upGtGiftUserDomain.setTenantCode(userSession.getTenantCode());
                SupQueryResult userInfoList2 = this.userServiceRepository.queryUserinfoPage(checkMap32);
                UmUserinfoReDomainBean umUserinfoReDomainBean2 = null;
                this.logger.error("userInfoList2******************************************", (Object)userInfoList2);
                if (userInfoList2.getList().size() <= 0 || !ListUtil.isNotEmpty((Collection)userInfoList2.getList())) {
                    this.logger.error("\u5bfc\u51651******************************************", (Object)upGtGiftUserDomain);
                    returnStr[i] = "\u7b2c" + count + "\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25";
                    flag = false;
                    continue;
                }
                umUserinfoReDomainBean2 = (UmUserinfoReDomainBean)userInfoList2.getList().get(0);
                upGtGiftUserDomain.setMemberBcode(umUserinfoReDomainBean2.getUserinfoCode());
                upGtGiftUserDomain.setMemberBname(umUserinfoReDomainBean2.getUserinfoCompname());
                upGtGiftUserDomain.setGiftUserType(umUserinfoReDomainBean2.getUserinfoType().toString());
                upGtGiftUserDomain.setGiftCode(((GtGiftUserReDomain)list.get(i)).getGiftCode());
                upGtGiftUserDomain.setEmployeeName(umUserinfoReDomainBean2.getUserinfoCompname());
                upGtGiftUserDomain.setGiftUserPhone(umUserinfoReDomainBean2.getUserinfoPhone());
                upGtGiftUserDomain.setDepartCode(((GtGiftUserReDomain)list.get(i)).getDepartCode());
                upGtGiftUserDomain.setMemberCcode(((GtGiftUserReDomain)list.get(i)).getMemberCcode());
                upGtGiftUserDomain.setMemberCname(((GtGiftUserReDomain)list.get(i)).getMemberCname());
                upGtGiftUserDomain.setAppmanageIcode(((GtGiftUserReDomain)list.get(i)).getAppmanageIcode());
                upGtGiftUserDomain.setGiftUserOcode1(((GtGiftUserReDomain)list.get(i)).getGiftUserOcode1());
                this.logger.error("\u5bfc\u51652******************************************", (Object)upGtGiftUserDomain);
                HtmlJsonReBean htmlJsonReBean12 = this.gtGiftUserServiceRepository.saveGiftUser((GtGiftUserDomain)upGtGiftUserDomain);
                if (null == htmlJsonReBean12 || htmlJsonReBean12.isSuccess()) continue;
                returnStr[i] = "\u7b2c" + count + "\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25";
                flag = false;
                continue;
            }
            if (qlist2.getList().size() > 0 && ListUtil.isNotEmpty((Collection)qlist2.getList())) {
                checkMap2 = new HashMap();
                checkMap2.put("giftCode", ((GtGiftUserReDomain)list.get(i)).getGiftCode());
                checkMap2.put("orderStr", "giftUserId");
                upList = this.gtGiftUserServiceRepository.queryGiftUserPage(checkMap2);
                if (upList.getList().size() > 0 && ListUtil.isNotEmpty((Collection)upList.getList())) {
                    upGtGiftUserDomain = (GtGiftUserDomain)upList.getList().get(upList.getList().size() - 1);
                    upGtGiftUserDomain.setGiftCnum(((GtGiftUserReDomain)list.get(i)).getGiftCnum());
                    upGtGiftUserDomain.setAppmanageIcode(((GtGiftUserReDomain)list.get(i)).getAppmanageIcode());
                    upGtGiftUserDomain.setGiftUserWeight(((GtGiftUserReDomain)list.get(i)).getGiftUserWeight());
                    checkMap3 = new HashMap();
                    checkMap3.put("companyCode", ((GtGiftUserReDomain)list.get(i)).getCompanyCode());
                    userInfoList = this.userServiceRepository.queryUserinfoPage(checkMap3);
                    this.logger.error("userInfoList3******************************************", (Object)userInfoList);
                    umUserinfoReDomainBean = null;
                    if (userInfoList.getList().size() <= 0 || !ListUtil.isNotEmpty((Collection)userInfoList.getList())) {
                        this.logger.error("\u66f4\u65b03******************************************", (Object)upGtGiftUserDomain);
                        returnStr[i] = "\u7b2c" + count + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25";
                        flag = false;
                        continue;
                    }
                    umUserinfoReDomainBean = (UmUserinfoReDomainBean)userInfoList.getList().get(0);
                    upGtGiftUserDomain.setEmployeeName(umUserinfoReDomainBean.getUserinfoCompname());
                    upGtGiftUserDomain.setGiftUserPhone(umUserinfoReDomainBean.getUserinfoPhone());
                    upGtGiftUserDomain.setDepartCode(((GtGiftUserReDomain)list.get(i)).getDepartCode());
                    upGtGiftUserDomain.setMemberCcode(((GtGiftUserReDomain)list.get(i)).getMemberCcode());
                    upGtGiftUserDomain.setMemberCname(((GtGiftUserReDomain)list.get(i)).getMemberCname());
                    upGtGiftUserDomain.setGiftName(((GtGiftUserReDomain)list.get(i)).getGiftName());
                    upGtGiftUserDomain.setGiftUserOcode1(((GtGiftUserReDomain)list.get(i)).getGiftUserOcode1());
                    this.logger.error("\u66f4\u65b04******************************************", (Object)upGtGiftUserDomain);
                    htmlJsonReBean1 = this.gtGiftUserServiceRepository.updateGiftUser((GtGiftUserDomain)upGtGiftUserDomain);
                    if (null == htmlJsonReBean1 || htmlJsonReBean1.isSuccess()) continue;
                    returnStr[i] = "\u7b2c" + count + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25";
                    flag = false;
                    continue;
                }
                upGtGiftUserDomain = new GtGiftUserReDomain();
                userSession = this.getUserSession(request);
                upGtGiftUserDomain.setGiftName(((SpScontractReDomain)qlist2.getList().get(0)).getScontractName());
                upGtGiftUserDomain.setMemberName(((SpScontractReDomain)qlist2.getList().get(0)).getMemberName());
                upGtGiftUserDomain.setMemberCode(((SpScontractReDomain)qlist2.getList().get(0)).getMemberCode());
                upGtGiftUserDomain.setDepartCode(((SpScontractReDomain)qlist2.getList().get(0)).getMemberGcode());
                String MemberGcode = ((SpScontractReDomain)qlist2.getList().get(0)).getMemberGcode().substring(0, 1);
                if (MemberGcode.equals("2")) {
                    upGtGiftUserDomain.setGiftUserOcode("2");
                }
                upGtGiftUserDomain.setGiftUserStart(((SpScontractReDomain)qlist2.getList().get(0)).getContractEffectivedate());
                upGtGiftUserDomain.setGiftUserEnd(((SpScontractReDomain)qlist2.getList().get(0)).getContractDepositdate());
                upGtGiftUserDomain.setGiftCnum(((GtGiftUserReDomain)list.get(i)).getGiftCnum());
                upGtGiftUserDomain.setAppmanageIcode(((GtGiftUserReDomain)list.get(i)).getAppmanageIcode());
                BigDecimal divide = new BigDecimal(100);
                upGtGiftUserDomain.setGiftUserWeight(((GtGiftUserReDomain)list.get(i)).getGiftUserWeight().divide(divide, 2, RoundingMode.HALF_UP));
                HashMap<String, String> checkMap33 = new HashMap<String, String>();
                checkMap33.put("companyCode", ((GtGiftUserReDomain)list.get(i)).getCompanyCode());
                upGtGiftUserDomain.setTenantCode(userSession.getTenantCode());
                SupQueryResult userInfoList3 = this.userServiceRepository.queryUserinfoPage(checkMap33);
                UmUserinfoReDomainBean umUserinfoReDomainBean3 = null;
                this.logger.error("userInfoList2******************************************", (Object)userInfoList3);
                if (userInfoList3.getList().size() <= 0 || !ListUtil.isNotEmpty((Collection)userInfoList3.getList())) {
                    this.logger.error("\u5bfc\u51653******************************************", (Object)upGtGiftUserDomain);
                    returnStr[i] = "\u7b2c" + count + "\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25";
                    flag = false;
                    continue;
                }
                umUserinfoReDomainBean3 = (UmUserinfoReDomainBean)userInfoList3.getList().get(0);
                upGtGiftUserDomain.setMemberBcode(umUserinfoReDomainBean3.getUserinfoCode());
                upGtGiftUserDomain.setMemberBname(umUserinfoReDomainBean3.getUserinfoCompname());
                upGtGiftUserDomain.setGiftUserType(umUserinfoReDomainBean3.getUserinfoType().toString());
                upGtGiftUserDomain.setGiftCode(((GtGiftUserReDomain)list.get(i)).getGiftCode());
                upGtGiftUserDomain.setEmployeeName(umUserinfoReDomainBean3.getUserinfoCompname());
                upGtGiftUserDomain.setGiftUserPhone(umUserinfoReDomainBean3.getUserinfoPhone());
                upGtGiftUserDomain.setDepartCode(((GtGiftUserReDomain)list.get(i)).getDepartCode());
                upGtGiftUserDomain.setMemberCcode(((GtGiftUserReDomain)list.get(i)).getMemberCcode());
                upGtGiftUserDomain.setMemberCname(((GtGiftUserReDomain)list.get(i)).getMemberCname());
                upGtGiftUserDomain.setAppmanageIcode(((GtGiftUserReDomain)list.get(i)).getAppmanageIcode());
                upGtGiftUserDomain.setGiftUserOcode1(((GtGiftUserReDomain)list.get(i)).getGiftUserOcode1());
                this.logger.error("\u5bfc\u51654******************************************", (Object)upGtGiftUserDomain);
                HtmlJsonReBean htmlJsonReBean13 = this.gtGiftUserServiceRepository.saveGiftUser((GtGiftUserDomain)upGtGiftUserDomain);
                if (null == htmlJsonReBean13 || htmlJsonReBean13.isSuccess()) continue;
                returnStr[i] = "\u7b2c" + count + "\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25";
                flag = false;
                continue;
            }
            returnStr[i] = "\u7b2c" + count + "\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25";
            flag = false;
        }
        this.logger.error("\u5bfc\u5165\u7ed3\u675f******************************************");
        StringBuilder sb = new StringBuilder();
        if (returnStr != null && returnStr.length > 0) {
            for (int i = 0; i < returnStr.length; ++i) {
                if (i < returnStr.length - 1) {
                    sb.append(returnStr[i] + ",");
                    continue;
                }
                sb.append(returnStr[i]);
            }
        }
        String lytype1 = sb.toString();
        if (flag) {
            return new HtmlJsonReBean((Object)"\u5bfc\u5165\u6210\u529f");
        }
        return new HtmlJsonReBean("error", lytype1);
    }

    @RequestMapping(value={"queryGift.json"}, name="\u5bfc\u51fa\u4e70\u5bb6\u5408\u540c")
    @ResponseBody
    public SupQueryResult<GtGiftUserReDomain> querySgcontractForPaasPlatformHy(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (null == param.get("excelTemplate")) {
                param.put("excelTemplate", "sg");
            }
        }
        return this.queryContractPageCom(request, "\u4e70\u5bb6\u5408\u540c\u5217\u8868", param);
    }

    protected SupQueryResult<GtGiftUserReDomain> queryContractPageCom(HttpServletRequest request, String fileName, Map<String, Object> param) {
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u4e70\u5bb6\u5408\u540c\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((String)excelTemplate) && "sg".equals(excelTemplate)) {
                infoMap.put("headMap", this.covertBuyerScontractOutExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            this.logger.error(CODE + ".queryContractPageCom.1111", (Object)(param + "=:=" + infoMap));
            try {
                this.exportComExcel(request, param, infoMap, "gt.gtgiftuser.queryGiftUserPage", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryContractPageCom.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.gtGiftUserServiceRepository.queryGiftUserPage(param);
    }

    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
        List spScontractReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), GtGiftUserReDomain.class);
        if (ListUtil.isEmpty((Collection)spScontractReDomainList)) {
            return null;
        }
        if ("sg".equals(excelTemplate)) {
            for (GtGiftUserReDomain sp : spScontractReDomainList) {
                if (!ListUtil.isNotEmpty((Collection)spScontractReDomainList)) continue;
                Map<String, Object> objectDetailToMap = this.covertOrderMap(sp);
                mapList.add(objectDetailToMap);
            }
        }
        return mapList;
    }

    public List<Map<String, Object>> covertBuyerScontractOutExcelParam() {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("showName", "\u5408\u540c\u7f16\u53f7(\u7535\u5546)");
        paramMap.put("dataName", "giftUserCode");
        mapList.add(paramMap);
        paramMap = new HashMap();
        paramMap.put("showName", "\u5408\u540c\u7f16\u53f7");
        paramMap.put("dataName", "giftCode");
        mapList.add(paramMap);
        paramMap = new HashMap();
        paramMap.put("showName", "\u4e70\u5bb6\u4f01\u4e1a\u7f16\u7801");
        paramMap.put("dataName", "channelCode");
        mapList.add(paramMap);
        paramMap = new HashMap();
        paramMap.put("showName", "\u4e70\u5bb6\u4f01\u4e1a\u540d\u79f0");
        paramMap.put("dataName", "scontractBcode");
        mapList.add(paramMap);
        paramMap = new HashMap();
        paramMap.put("showName", "\u9879\u76ee\u91d1\u989d");
        paramMap.put("dataName", "giftCnum");
        mapList.add(paramMap);
        paramMap = new HashMap();
        paramMap.put("showName", "\u7b7e\u7ea6\u65f6\u95f4");
        paramMap.put("dataName", "memberCcode");
        mapList.add(paramMap);
        paramMap = new HashMap();
        paramMap.put("showName", "\u5408\u540c\u5931\u6548\u65f6\u95f4");
        paramMap.put("dataName", "memberCname");
        mapList.add(paramMap);
        paramMap = new HashMap();
        paramMap.put("showName", "\u5408\u540c\u72b6\u6001");
        paramMap.put("dataName", "dataState");
        mapList.add(paramMap);
        return mapList;
    }

    protected Map<String, Object> covertOrderMap(GtGiftUserReDomain sp) {
        HashMap<String, Object> orderDetaiMap = new HashMap<String, Object>();
        orderDetaiMap.put("giftUserCode", sp.getGiftUserCode());
        orderDetaiMap.put("giftCode", sp.getGiftCode());
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put("userinfoPhone", sp.getGiftUserPhone());
        orderDetaiMap.put("channelCode", sp.getCompanyCode());
        orderDetaiMap.put("scontractBcode", sp.getCompanyShortname());
        orderDetaiMap.put("giftCnum", sp.getGiftCnum());
        orderDetaiMap.put("memberCcode", sp.getMemberCcode());
        orderDetaiMap.put("memberCname", sp.getMemberBname());
        switch (sp.getDataState()) {
            case 0: {
                orderDetaiMap.put("dataState", "\u672a\u5f00\u59cb");
                break;
            }
            case 1: {
                orderDetaiMap.put("dataState", "\u6267\u884c\u4e2d");
                break;
            }
            case 2: {
                orderDetaiMap.put("dataState", "\u5df2\u6682\u505c");
                break;
            }
            case 3: {
                orderDetaiMap.put("dataState", "\u5df2\u7981\u7528");
                break;
            }
            case 4: {
                orderDetaiMap.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            case 5: {
                orderDetaiMap.put("dataState", "\u5df2\u5173\u95ed");
            }
        }
        return orderDetaiMap;
    }

    @RequestMapping(value={"queryRelToD.json"}, name="\u5408\u540c\u62a5\u4ef7\u54a8\u8be2\u5355")
    @ResponseBody
    public GtGiftReDomain queryRelToD(HttpServletRequest request, String giftUserCode) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == giftUserCode) {
            this.logger.error(CODE + ".queryRelToC", (Object)"giftUserCode is null");
            return new GtGiftReDomain();
        }
        GtGiftUserReDomain gtGiftUserReDomain = this.gtGiftUserServiceRepository.getGiftUserByCode(userSession.getTenantCode(), giftUserCode);
        GtGiftReDomain gtGiftReDomain = this.gtGiftServiceRepository.getGiftByCode(gtGiftUserReDomain.getTenantCode(), gtGiftUserReDomain.getGiftCode());
        Map amap = this.getQueryMapParam("giftCode,tenantCode", new Object[]{gtGiftReDomain.getGiftCode(), gtGiftReDomain.getTenantCode()});
        amap.put("goodsName", param.get("goodsName"));
        amap.put("skuNo", param.get("skuNo"));
        amap.put("orderStr", param.get("orderStr"));
        amap.put("fuzzy", true);
        amap.put("order", true);
        Map map = this.assemMapParam(request);
        if (map.containsKey("goodsCode")) {
            amap.put("fuzzy", true);
            amap.put("goodsCode", map.get("goodsCode"));
        }
        if (null == param.get("orderStr")) {
            amap.put("order", true);
        }
        gtGiftReDomain.setGtGiftRelDomainList(this.gtGiftRelServiceRepository.queryGiftRelPage(amap).getList());
        this.makeUserRelNum(gtGiftReDomain, (GtGiftUserDomain)gtGiftUserReDomain);
        return gtGiftReDomain;
    }
}

