/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.ia.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ia.domain.IaInsuranceDomain;
import com.qjsoft.laser.controller.facade.ia.domain.IaInsuranceReDomain;
import com.qjsoft.laser.controller.facade.ia.repository.IaInsuranceServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/ia/insurance"}, name="\u4fdd\u9669\u670d\u52a1")
public class InsuranceCon
extends SpringmvcController {
    private static String CODE = "ia.Insurance.con";
    @Autowired
    private IaInsuranceServiceRepository iaInsuranceServiceRepository;

    protected String getContext() {
        return "Insurance";
    }

    @RequestMapping(value={"saveInsurance.json"}, name="\u589e\u52a0\u4fdd\u9669\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveInsurance(HttpServletRequest request, IaInsuranceDomain iaInsuranceDomain) {
        if (null == iaInsuranceDomain) {
            this.logger.error(CODE + ".saveInsurance", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        iaInsuranceDomain.setTenantCode(this.getTenantCode(request));
        return this.iaInsuranceServiceRepository.saveInsurance(iaInsuranceDomain);
    }

    @RequestMapping(value={"getInsurance.json"}, name="\u83b7\u53d6\u4fdd\u9669\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public IaInsuranceReDomain getInsurance(Integer insuranceId) {
        if (StringUtils.isBlank((Integer)insuranceId)) {
            this.logger.error(CODE + ".getInsurance", (Object)"param is null");
            return null;
        }
        return this.iaInsuranceServiceRepository.getInsurance(insuranceId);
    }

    @RequestMapping(value={"updateInsurance.json"}, name="\u66f4\u65b0\u4fdd\u9669\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateInsurance(HttpServletRequest request, IaInsuranceDomain iaInsuranceDomain) {
        if (null == iaInsuranceDomain) {
            this.logger.error(CODE + ".updateInsurance", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        iaInsuranceDomain.setTenantCode(this.getTenantCode(request));
        return this.iaInsuranceServiceRepository.updateInsurance(iaInsuranceDomain);
    }

    @RequestMapping(value={"deleteInsurance.json"}, name="\u5220\u9664\u4fdd\u9669\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteInsurance(Integer insuranceId) {
        if (StringUtils.isBlank((Integer)insuranceId)) {
            this.logger.error(CODE + ".deleteInsurance", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.iaInsuranceServiceRepository.deleteInsurance(insuranceId);
    }

    @RequestMapping(value={"queryInsurancePage.json"}, name="\u67e5\u8be2\u4fdd\u9669\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<IaInsuranceReDomain> queryInsurancePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.iaInsuranceServiceRepository.queryInsurancePage(param);
    }

    @RequestMapping(value={"updateInsuranceState.json"}, name="\u66f4\u65b0\u4fdd\u9669\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateInsuranceState(String insuranceId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)insuranceId)) {
            this.logger.error(CODE + ".updateInsuranceState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.iaInsuranceServiceRepository.updateInsuranceState(Integer.valueOf(insuranceId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"getInsurancePageByOpcode.json"}, name="\u66f4\u5177\u6765\u6e90\u67e5\u8be2\u4fdd\u9669\u4fe1\u606f")
    @ResponseBody
    public IaInsuranceReDomain getInsurancePageByOpcode(HttpServletRequest request, String insuranceOpcode) {
        if (StringUtils.isEmpty((String)insuranceOpcode)) {
            this.logger.error(CODE + ".getInsurancePageByOpcode", (Object)"insuranceOpcode is null");
            return null;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("insuranceOpcode", insuranceOpcode);
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult iaInsuranceReDomainSupQueryResult = this.iaInsuranceServiceRepository.queryInsurancePage(param);
        if (null == iaInsuranceReDomainSupQueryResult || ListUtil.isEmpty((Collection)iaInsuranceReDomainSupQueryResult.getList())) {
            return null;
        }
        return (IaInsuranceReDomain)iaInsuranceReDomainSupQueryResult.getList().get(0);
    }
}

