/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.poi.controller;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Poicon {
    public static void main(String[] args) {
        Workbook wb = null;
        Sheet sheet = null;
        Row row = null;
        ArrayList list = null;
        String cellData = null;
        String filePath = "D:\\test.xlsx";
        String[] columns = new String[]{"name", "age", "score"};
        wb = Poicon.readExcel(filePath);
        if (wb != null) {
            list = new ArrayList();
            sheet = wb.getSheetAt(0);
            int rownum = sheet.getPhysicalNumberOfRows();
            row = sheet.getRow(0);
            int n = row.getPhysicalNumberOfCells();
            for (int i = 1; i < rownum; ++i) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                row = sheet.getRow(i);
                if (row == null) break;
                for (int j = 0; j < n; ++j) {
                    cellData = (String)Poicon.getCellFormatValue(row.getCell(j));
                    map.put(columns[j], cellData);
                }
                list.add(map);
            }
        }
        for (Map map : list) {
            for (Map.Entry entry : map.entrySet()) {
                System.out.print((String)entry.getKey() + ":" + (String)entry.getValue() + ",");
            }
            System.out.println();
        }
    }

    public static Workbook readExcel(String filePath) {
        HSSFWorkbook wb = null;
        if (filePath == null) {
            return null;
        }
        String extString = filePath.substring(filePath.lastIndexOf("."));
        FileInputStream is = null;
        try {
            is = new FileInputStream(filePath);
            if (".xls".equals(extString)) {
                wb = new HSSFWorkbook((InputStream)is);
                return wb;
            }
            if (".xlsx".equals(extString)) {
                wb = new XSSFWorkbook((InputStream)is);
                return wb;
            }
            wb = null;
            return null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return wb;
    }

    public static Object getCellFormatValue(Cell cell) {
        Object cellValue = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 0: {
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case 2: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        cellValue = cell.getDateCellValue();
                        break;
                    }
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case 1: {
                    cellValue = cell.getRichStringCellValue().getString();
                    break;
                }
                default: {
                    cellValue = "";
                    break;
                }
            }
        } else {
            cellValue = "";
        }
        return cellValue;
    }
}

