/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.interceptor.service;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.interceptor.bean.InterBean;
import com.qjsoft.laser.controller.interceptor.bean.OsOAuthConfigDomain;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BaseInterUtil {
    public static String TenantCode = "saas-tenantcode";
    public static String CookieToken = "saas-token";
    public static String ProappCode = "saas-proappcode";
    public static String ResparamTokenkey = "tokenkey";
    public static String SESSION_KEY = "laser_usersession";
    public static String UP_URL = "laser_upurl";
    private static ThreadLocal<Map<String, String>> HEADMAP = new ThreadLocal();
    private static Object lock = new Object();

    public static void setHeadMap(Map<String, String> map) {
        HEADMAP.set(map);
    }

    public static void setHeadMap(String key, String value) {
        Map<String, String> map = BaseInterUtil.getHeadMap();
        map.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getHeadMap() {
        Object object = lock;
        synchronized (object) {
            Map<String, String> map = HEADMAP.get();
            if (null == map) {
                map = new ConcurrentHashMap<String, String>();
                BaseInterUtil.setHeadMap(map);
            }
            return map;
        }
    }

    public static String getHeadMap(String key) {
        Map<String, String> map = BaseInterUtil.getHeadMap();
        return map.get(key);
    }

    public static void removeHeadMap() {
        HEADMAP.remove();
    }

    public static void putTokenHeader(HttpServletRequest request, HttpServletResponse response, String token) {
        if (null == request || null == response) {
            return;
        }
        response.setHeader(CookieToken, token);
        BaseInterUtil.setHeadMap(CookieToken, token);
    }

    public static void putTenantHeader(HttpServletRequest request, HttpServletResponse response, String tenantCode) {
        if (null == request || null == response) {
            return;
        }
        response.setHeader(TenantCode, tenantCode);
        BaseInterUtil.setHeadMap(TenantCode, tenantCode);
    }

    public static void putProappHeader(HttpServletRequest request, HttpServletResponse response, String proappCode) {
        if (null == request || null == response) {
            return;
        }
        response.setHeader(ProappCode, proappCode);
        BaseInterUtil.setHeadMap(ProappCode, proappCode);
    }

    public static Boolean isJsonRequest(HttpServletRequest request) {
        String url = request.getServletPath();
        return url.endsWith(".json") || StringUtils.isNotBlank((String)request.getHeader("X-Requested-With"));
    }

    public static String getUrl(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String queryString = request.getQueryString();
        String url = !StringUtils.isEmpty((String)queryString) && queryString.indexOf("=") > 0 ? request.getServletPath() + "?" + queryString : request.getServletPath();
        return url;
    }

    public static String getRedurl(HttpServletRequest request, String url) {
        if (null == request || StringUtils.isBlank((String)url)) {
            return null;
        }
        try {
            String redurl = URLEncoder.encode(request.getContextPath() + url, "UTF-8");
            return redurl;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getTokenGroup(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request || null == cookieMap) {
            return null;
        }
        String proappCode = BaseInterUtil.getProappCode(request, cookieMap);
        if (StringUtils.isBlank((String)proappCode)) {
            return null;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request, cookieMap);
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        return BaseInterUtil.getTokenGroup(proappCode, tenantCode);
    }

    public static String getTokenGroup(String proappCode, String tenantCode) {
        if (StringUtils.isBlank((String)proappCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String key = proappCode + "-" + tenantCode;
        String group = SupDisUtil.getMap((String)"osconfig_key", (String)key);
        if (StringUtils.isBlank((String)group)) {
            key = proappCode + "-" + "00000000";
            group = SupDisUtil.getMap((String)"osconfig_key", (String)key);
        }
        return group;
    }

    public static String getToKen(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String token = request.getHeader(CookieToken);
        if (StringUtils.isBlank((String)token)) {
            token = BaseInterUtil.getHeadMap(CookieToken);
        }
        if (StringUtils.isBlank((String)token)) {
            Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
            String group = BaseInterUtil.getTokenGroup(request, cookieMap);
            token = BaseInterUtil.getToKen(request, group, cookieMap);
        }
        return token;
    }

    public static String getToKen(HttpServletRequest request, String group) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getToKen(request, group, cookieMap);
    }

    public static void putTokenCookie(HttpServletRequest request, HttpServletResponse response, String token) {
        if (null == response) {
            return;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        String proappCode = BaseInterUtil.getProappCode(request, cookieMap);
        if (StringUtils.isBlank((String)proappCode)) {
            return;
        }
        String tenantCode = BaseInterUtil.getTenantCode(request, cookieMap);
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        BaseInterUtil.putTokenCookie(response, proappCode, token, tenantCode);
    }

    public static void putTokenCookie(HttpServletResponse response, String proappCode, String token, String tenantCode) {
        if (null == response) {
            return;
        }
        if (StringUtils.isBlank((String)proappCode)) {
            return;
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        OsOAuthConfigDomain osOAuthConfigReDomain = BaseInterUtil.getOsOAuthConfigDomain(proappCode, tenantCode);
        if (null == osOAuthConfigReDomain || StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookie())) {
            return;
        }
        Cookie _cookie = new Cookie(CookieToken + "-" + osOAuthConfigReDomain.getAppmanageGroup(), token);
        _cookie.setDomain(osOAuthConfigReDomain.getOauthConfigCookie());
        if (StringUtils.isBlank((String)osOAuthConfigReDomain.getOauthConfigCookiep())) {
            osOAuthConfigReDomain.setOauthConfigCookiep("/");
        }
        _cookie.setPath(osOAuthConfigReDomain.getOauthConfigCookiep());
        _cookie.setHttpOnly(true);
        if (StringUtils.isBlank((String)token)) {
            _cookie.setMaxAge(0);
        }
        response.addCookie(_cookie);
    }

    public static void putTokenCookie(HttpServletResponse response, InterBean interBean) {
        if (null == interBean || StringUtils.isBlank((String)interBean.getProappCode()) || StringUtils.isBlank((String)interBean.getTenantCode())) {
            return;
        }
        BaseInterUtil.putTokenCookie(response, interBean.getProappCode(), interBean.getToken(), interBean.getTenantCode());
    }

    public static OsOAuthConfigDomain getOsOAuthConfigDomain(String proappCode, String tenantCode) {
        if (StringUtils.isBlank((String)proappCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String json = SupDisUtil.getMap((String)"OsOAuthConfig_Key", (String)(proappCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            json = SupDisUtil.getMap((String)"OsOAuthConfig_Key", (String)(proappCode + "-" + "00000000"));
        }
        OsOAuthConfigDomain osOAuthConfigReDomain = (OsOAuthConfigDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OsOAuthConfigDomain.class);
        return osOAuthConfigReDomain;
    }

    public static String getToKen(HttpServletRequest request, String group, Map<String, String> cookieMap) {
        if (null == cookieMap) {
            return null;
        }
        String token = cookieMap.get(CookieToken + "-" + group);
        if (StringUtils.isBlank((String)token) && null != request) {
            token = request.getParameter(ResparamTokenkey);
        }
        return token;
    }

    public static void putSession(HttpServletRequest request, HttpServletResponse response, UserSession userSession) {
        if (null == request || null == request.getSession()) {
            return;
        }
        request.getSession().setAttribute(SESSION_KEY, (Object)userSession);
        if (null != userSession) {
            BaseInterUtil.putTenantHeader(request, response, userSession.getTenantCode());
        } else {
            BaseInterUtil.putTokenCookie(request, response, null);
        }
    }

    public static UserSession getSession(HttpServletRequest request) {
        if (null == request || null == request.getSession()) {
            return null;
        }
        return (UserSession)request.getSession().getAttribute(SESSION_KEY);
    }

    public static String getRequestservice(HttpServletRequest request, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = "00000000";
        }
        String schemeStr = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-scheme-scheme"));
        String ddserverName = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-serverName-serverName"));
        String serverName = request.getServerName();
        if (StringUtils.isNotBlank((String)ddserverName) && serverName.contains(ddserverName)) {
            schemeStr = "https";
        }
        schemeStr = StringUtils.isBlank((String)schemeStr) ? "http" : schemeStr;
        String str = schemeStr + "://" + request.getServerName();
        if (request.getServerPort() != 80) {
            str = str + ":" + request.getServerPort();
        }
        return str;
    }

    public static String getTenantCode(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        String tenantCode = request.getHeader(TenantCode);
        if (StringUtils.isBlank((String)tenantCode) && null != cookieMap) {
            tenantCode = cookieMap.get(TenantCode);
        }
        if (StringUtils.isBlank((String)tenantCode)) {
            tenantCode = BaseInterUtil.getHeadMap(TenantCode);
        }
        return tenantCode;
    }

    public static String getTenantCode(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getTenantCode(request, cookieMap);
    }

    public static String getProappCode(HttpServletRequest request, Map<String, String> cookieMap) {
        if (null == request) {
            return null;
        }
        String proappCode = request.getHeader(ProappCode);
        if (StringUtils.isBlank((String)proappCode) && null != cookieMap) {
            proappCode = cookieMap.get(ProappCode);
        }
        if (StringUtils.isBlank((String)proappCode)) {
            proappCode = BaseInterUtil.getHeadMap(ProappCode);
        }
        return proappCode;
    }

    public static String getProappCode(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Map<String, String> cookieMap = BaseInterUtil.getSaaSCookies(request);
        return BaseInterUtil.getProappCode(request, cookieMap);
    }

    public static Map<String, String> getSaaSCookies(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (null == cookies || cookies.length == 0) {
            return null;
        }
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        for (Cookie cookie : cookies) {
            if (!cookie.getName().contains("saas-")) continue;
            map.put(cookie.getName(), cookie.getValue());
        }
        return map;
    }
}

