/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.job.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.job.domain.JobScheduleDomainBean;
import com.qjsoft.laser.controller.facade.job.domain.JobScheduleReDomainBean;
import com.qjsoft.laser.controller.facade.job.repository.ScheduleServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/job/jobschedule"}, name="\u8c03\u5ea6\u6ce8\u518c\u7ba1\u7406\u4fe1\u606f")
public class JobscheduleCon
extends SpringmvcController {
    private static String CODE = "job.jobschedule.con";
    @Autowired
    private ScheduleServiceRepository scheduleServiceRepository;

    protected String getContext() {
        return "jobschedule";
    }

    @RequestMapping(value={"saveJobschedule.json"}, name="\u589e\u52a0\u8c03\u5ea6\u6ce8\u518c\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean saveJobschedule(HttpServletRequest request, JobScheduleDomainBean jobscheduleDomain) {
        if (null == jobscheduleDomain) {
            this.logger.error(CODE + ".saveJobschedule", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        jobscheduleDomain.setTenantCode(this.getTenantCode(request));
        return this.scheduleServiceRepository.saveSchedule(jobscheduleDomain);
    }

    @RequestMapping(value={"getJobschedule.json"}, name="\u83b7\u53d6\u8c03\u5ea6\u6ce8\u518c\u7ba1\u7406\u4fe1\u606f\u4fe1\u606f")
    @ResponseBody
    public JobScheduleReDomainBean getJobschedule(String scheduleId) {
        if (StringUtils.isBlank((String)scheduleId)) {
            this.logger.error(CODE + ".getJobschedule", (Object)"param is null");
            return null;
        }
        return this.scheduleServiceRepository.getSchedule(Integer.valueOf(scheduleId));
    }

    @RequestMapping(value={"updateJobschedule.json"}, name="\u66f4\u65b0\u8c03\u5ea6\u6ce8\u518c\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateJobschedule(HttpServletRequest request, JobScheduleDomainBean jobscheduleDomain) {
        if (null == jobscheduleDomain) {
            this.logger.error(CODE + ".updateJobschedule", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        jobscheduleDomain.setTenantCode(this.getTenantCode(request));
        return this.scheduleServiceRepository.updateSchedule(jobscheduleDomain);
    }

    @RequestMapping(value={"deleteJobschedule.json"}, name="\u5220\u9664\u8c03\u5ea6\u6ce8\u518c\u7ba1\u7406\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean deleteJobschedule(String scheduleId) {
        if (StringUtils.isBlank((String)scheduleId)) {
            this.logger.error(CODE + ".deleteJobschedule", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.scheduleServiceRepository.deleteSchedule(Integer.valueOf(scheduleId));
    }

    @RequestMapping(value={"queryJobschedulePage.json"}, name="\u67e5\u8be2\u8c03\u5ea6\u6ce8\u518c\u7ba1\u7406\u4fe1\u606f\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<JobScheduleReDomainBean> queryJobschedulePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.scheduleServiceRepository.querySchedulePage(param);
    }

    @RequestMapping(value={"updateJobscheduleState.json"}, name="\u66f4\u65b0\u8c03\u5ea6\u6ce8\u518c\u7ba1\u7406\u4fe1\u606f\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateJobscheduleState(String scheduleId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)scheduleId)) {
            this.logger.error(CODE + ".updateJobscheduleState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.scheduleServiceRepository.updateScheduleState(Integer.valueOf(scheduleId), dataState, oldDataState);
    }
}

