/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.mindex.controller;

import com.qjsoft.laser.controller.core.auth.AuthService;
import com.qjsoft.laser.controller.core.auth.MenuInfoBean;
import com.qjsoft.laser.controller.core.auth.UserInfo;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.mindex.bean.IndexBean;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/mi/mindex"})
public class MindexCon
extends SpringmvcController {
    @Autowired
    private AuthService authService;

    protected String getContext() {
        return "mindex";
    }

    @RequestMapping(value={"getTopMenuList.json"})
    @ResponseBody
    public List<MenuInfoBean> getTopMenuList(HttpServletRequest request) {
        List<MenuInfoBean> menuList = this.getMenu(request);
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        if (null != menuList && !menuList.isEmpty()) {
            List<MenuInfoBean> childList = null;
            for (MenuInfoBean menuBean : menuList) {
                childList = this.makeMenu(menuBean.getProappMenuCode(), proappCode, tenantCode);
                if (null != childList && !childList.isEmpty()) {
                    this.order(childList);
                }
                menuBean.setChildren(childList);
            }
        }
        return menuList;
    }

    @RequestMapping(value={"getTopPerMenuList.json"})
    @ResponseBody
    public List<MenuInfoBean> getTopPerMenuList(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        UserSession userSession = this.getUserSession(request);
        List<MenuInfoBean> menulist = null == userSession || StringUtils.isBlank((String)userSession.getTicketTokenid()) ? this.getTopMenuList(request) : this.getMenuPer(request, tenantCode, proappCode);
        return menulist;
    }

    @RequestMapping(value={"menuPerQuery.json"})
    @ResponseBody
    public List<MenuInfoBean> menuPerQuery(HttpServletRequest request, String appPath, String menuParentCode) {
        String proappCode;
        String tenantCode = this.getTenantCode(request);
        List<MenuInfoBean> menulist = this.getMenuPer(request, tenantCode, proappCode = this.getProappCode(request));
        if (null == menulist || menulist.isEmpty()) {
            return null;
        }
        for (MenuInfoBean menuInfoBean : menulist) {
            if (StringUtils.isNotBlank((String)menuParentCode) && menuInfoBean.getProappMenuCode().equals(menuParentCode)) {
                return menuInfoBean.getChildren();
            }
            if (!StringUtils.isNotBlank((String)appPath) || !appPath.equals(menuInfoBean.getMenuJspath())) continue;
            return menuInfoBean.getChildren();
        }
        return null;
    }

    private List<MenuInfoBean> getMenu(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        String oauthEnvCode = this.getOauthEnvCode(request);
        List<MenuInfoBean> menuList = this.navQuery(proappCode, tenantCode);
        this.makeMenu(menuList, tenantCode, proappCode, oauthEnvCode);
        return menuList;
    }

    @RequestMapping(value={"index.json"})
    @ResponseBody
    public IndexBean index(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        IndexBean indexBean = new IndexBean();
        UserInfo userInfo = this.getUserInfo(request);
        indexBean.setUserInfo(userInfo);
        List<MenuInfoBean> menuList = this.getMenuPer(request, tenantCode, proappCode);
        indexBean.setTopMenuList(menuList);
        return indexBean;
    }

    private void makeMenu(List<MenuInfoBean> menuList, String tenantCode, String proappCode, String oauthEnvCode) {
        if (null == menuList || menuList.isEmpty()) {
            return;
        }
        this.order(menuList);
        for (MenuInfoBean menuInfoBean : menuList) {
            if (StringUtils.isNotBlank((String)menuInfoBean.getMenuAction())) {
                menuInfoBean.setMenuAction(menuInfoBean.getMenuAction().replace("${tenantCode}", tenantCode));
                menuInfoBean.setMenuAction(menuInfoBean.getMenuAction().replace("${proappCode}", proappCode));
                menuInfoBean.setMenuAction(menuInfoBean.getMenuAction().replace("${oauthEnvCode}", oauthEnvCode));
            }
            if (!StringUtils.isNotBlank((String)menuInfoBean.getMenuJspath())) continue;
            menuInfoBean.setMenuJspath(menuInfoBean.getMenuJspath().replace("${tenantCode}", tenantCode));
            menuInfoBean.setMenuJspath(menuInfoBean.getMenuJspath().replace("${proappCode}", proappCode));
            menuInfoBean.setMenuJspath(menuInfoBean.getMenuJspath().replace("${oauthEnvCode}", oauthEnvCode));
        }
    }

    private List<MenuInfoBean> getMenuPer(HttpServletRequest request, String tenantCode, String proappCode) {
        UserSession userSession = this.getUserSession(request);
        ArrayList<MenuInfoBean> menuList = new ArrayList();
        Object extensions = userSession.getExtensions();
        if (null == extensions) {
            return null;
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        menuList = this.authService.getUserPerMenuTree(userSession.getMap(), proappCode, tenantCode);
        this.makeMenu(menuList, tenantCode, proappCode, oauthEnvCode);
        return menuList;
    }

    private void order(List<MenuInfoBean> menuList) {
        Collections.sort(menuList, new Comparator<MenuInfoBean>(){

            @Override
            public int compare(MenuInfoBean menuInfoBean1, MenuInfoBean menuInfoBean2) {
                if (null == menuInfoBean1.getProappMenuOrder()) {
                    menuInfoBean1.setProappMenuOrder(Integer.valueOf(0));
                }
                if (null == menuInfoBean2.getProappMenuOrder()) {
                    menuInfoBean2.setProappMenuOrder(Integer.valueOf(0));
                }
                int order1 = menuInfoBean1.getProappMenuOrder();
                int order2 = menuInfoBean2.getProappMenuOrder();
                return Integer.compare(order1, order2);
            }
        });
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public List<MenuInfoBean> listQuery(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        return this.navQuery(proappCode, tenantCode);
    }

    @RequestMapping(value={"menuQuery.json"})
    @ResponseBody
    public List<MenuInfoBean> menuQuery(HttpServletRequest request, String menuParentCode) {
        String tenantCode = this.getTenantCode(request);
        String proappCode = this.getProappCode(request);
        return this.makeMenu(menuParentCode, proappCode, tenantCode);
    }

    private List<MenuInfoBean> navQuery(String proappCode, String tenantCode) {
        return this.authService.navQuery(proappCode, tenantCode);
    }

    private List<MenuInfoBean> makeMenu(String menuParentCode, String proappCode, String tenantCode) {
        return this.authService.makeMenu(menuParentCode, proappCode, tenantCode);
    }

    @RequestMapping(value={"defaultAccess.json"}, name="\u9ed8\u8ba4\u8bbf\u95ee")
    @ResponseBody
    public HtmlJsonReBean defaultAccess(HttpServletRequest request) {
        return new HtmlJsonReBean();
    }
}

