/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.oc.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcRefundServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/ocrefundgoods"}, name="\u9000\u6b3e")
public class OcrefundgoodsCon
extends SpringmvcController {
    private static String CODE = "oc.ocrefundgoods.con";
    @Autowired
    private OcRefundServiceRepository ocRefundServiceRepository;

    protected String getContext() {
        return "ocrefundgoods";
    }

    @RequestMapping(value={"saveOcRefundGoods.json"}, name="\u589e\u52a0\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean saveOcRefundGoods(HttpServletRequest request, OcRefundGoodsDomain ocrefundgoodsDomain) {
        if (null == ocrefundgoodsDomain) {
            this.logger.error(CODE + ".saveOcRefundGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocrefundgoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocRefundServiceRepository.saveRefundGoods(ocrefundgoodsDomain);
    }

    @RequestMapping(value={"getOcRefundGoods.json"}, name="\u83b7\u53d6\u9000\u6b3e\u4fe1\u606f")
    @ResponseBody
    public OcRefundGoodsReDomain getOcRefundGoods(Integer refundGoodsId) {
        if (StringUtils.isBlank((Integer)refundGoodsId)) {
            this.logger.error(CODE + ".getOcRefundGoods", (Object)"param is null");
            return null;
        }
        return this.ocRefundServiceRepository.getRefundGoods(refundGoodsId);
    }

    @RequestMapping(value={"updateOcRefundGoods.json"}, name="\u66f4\u65b0\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean updateOcRefundGoods(HttpServletRequest request, OcRefundGoodsDomain ocrefundgoodsDomain) {
        if (null == ocrefundgoodsDomain) {
            this.logger.error(CODE + ".updateOcRefundGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocrefundgoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocRefundServiceRepository.updateRefundGoods(ocrefundgoodsDomain);
    }

    @RequestMapping(value={"deleteOcRefundGoods.json"}, name="\u5220\u9664\u9000\u6b3e")
    @ResponseBody
    public HtmlJsonReBean deleteOcRefundGoods(Integer refundGoodsId) {
        if (StringUtils.isBlank((Integer)refundGoodsId)) {
            this.logger.error(CODE + ".deleteOcRefundGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefundServiceRepository.deleteRefundGoods(refundGoodsId);
    }

    @RequestMapping(value={"queryOcRefundGoodsPage.json"}, name="\u67e5\u8be2\u9000\u6b3e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundGoodsReDomain> queryOcRefundGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundServiceRepository.queryRefundGoodsPage(param);
    }

    @RequestMapping(value={"updateOcRefundGoodsState.json"}, name="\u66f4\u65b0\u9000\u6b3e\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOcRefundGoodsState(String refundGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)refundGoodsId)) {
            this.logger.error(CODE + ".updateOcRefundGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefundServiceRepository.updateRefundGoodsState(Integer.valueOf(refundGoodsId), dataState, oldDataState);
    }
}

