/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.oc.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcSettlListDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcSettlListReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcSettlServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/ocsettllist"}, name="\u73b0\u91d1\u7ed3\u7b97\u660e\u7ec6")
public class OcsettllistCon
extends SpringmvcController {
    private static String CODE = "oc.ocsettllist.con";
    @Autowired
    private OcSettlServiceRepository ocSettlServiceRepository;

    protected String getContext() {
        return "ocsettllist";
    }

    @RequestMapping(value={"saveOcSettlList.json"}, name="\u589e\u52a0\u73b0\u91d1\u7ed3\u7b97")
    @ResponseBody
    public HtmlJsonReBean saveOcSettlList(HttpServletRequest request, OcSettlListDomain ocsettllistDomain) {
        if (null == ocsettllistDomain) {
            this.logger.error(CODE + ".saveOcSettlList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocsettllistDomain.setTenantCode(this.getTenantCode(request));
        return this.ocSettlServiceRepository.saveSettlList(ocsettllistDomain);
    }

    @RequestMapping(value={"getOcSettlList.json"}, name="\u83b7\u53d6\u73b0\u91d1\u7ed3\u7b97\u4fe1\u606f")
    @ResponseBody
    public OcSettlListReDomain getOcSettlList(Integer settlListId) {
        if (StringUtils.isBlank((Integer)settlListId)) {
            this.logger.error(CODE + ".getOcSettlList", (Object)"param is null");
            return null;
        }
        return this.ocSettlServiceRepository.getSettlList(settlListId);
    }

    @RequestMapping(value={"updateOcSettlList.json"}, name="\u66f4\u65b0\u73b0\u91d1\u7ed3\u7b97")
    @ResponseBody
    public HtmlJsonReBean updateOcSettlList(HttpServletRequest request, OcSettlListDomain ocsettllistDomain) {
        if (null == ocsettllistDomain) {
            this.logger.error(CODE + ".updateOcSettlList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocsettllistDomain.setTenantCode(this.getTenantCode(request));
        return this.ocSettlServiceRepository.updateSettlList(ocsettllistDomain);
    }

    @RequestMapping(value={"deleteOcSettlList.json"}, name="\u5220\u9664\u73b0\u91d1\u7ed3\u7b97")
    @ResponseBody
    public HtmlJsonReBean deleteOcSettlList(Integer settlListId) {
        if (StringUtils.isBlank((Integer)settlListId)) {
            this.logger.error(CODE + ".deleteOcSettlList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocSettlServiceRepository.deleteSettlList(settlListId);
    }

    @RequestMapping(value={"queryOcSettlListPage.json"}, name="\u67e5\u8be2\u73b0\u91d1\u7ed3\u7b97\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcSettlListReDomain> queryOcSettlListPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocSettlServiceRepository.querySettlListPage(param);
    }

    @RequestMapping(value={"updateOcSettlListState.json"}, name="\u66f4\u65b0\u73b0\u91d1\u7ed3\u7b97\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOcSettlListState(String settlListId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)settlListId)) {
            this.logger.error(CODE + ".updateOcSettlListState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocSettlServiceRepository.updateSettlListState(Integer.valueOf(settlListId), dataState, oldDataState);
    }
}

