/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.oc.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/ocshopping"}, name="\u8d2d\u7269\u8f66")
public class OcshoppingCon
extends SpringmvcController {
    private static String CODE = "oc.ocshopping.con";
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;

    protected String getContext() {
        return "ocshopping";
    }

    @RequestMapping(value={"saveOcShopping.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66")
    @ResponseBody
    public HtmlJsonReBean saveOcShopping(HttpServletRequest request, OcShoppingDomain ocshoppingDomain) {
        if (null == ocshoppingDomain) {
            this.logger.error(CODE + ".saveOcShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocshoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.saveShopping(ocshoppingDomain);
    }

    @RequestMapping(value={"getOcShopping.json"}, name="\u83b7\u53d6\u8d2d\u7269\u8f66\u4fe1\u606f")
    @ResponseBody
    public OcShoppingReDomain getOcShopping(Integer shoppingId) {
        if (StringUtils.isBlank((Integer)shoppingId)) {
            this.logger.error(CODE + ".getOcShopping", (Object)"param is null");
            return null;
        }
        return this.ocShoppingServiceRepository.getShopping(shoppingId);
    }

    @RequestMapping(value={"updateOcShopping.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66")
    @ResponseBody
    public HtmlJsonReBean updateOcShopping(HttpServletRequest request, OcShoppingDomain ocshoppingDomain) {
        if (null == ocshoppingDomain) {
            this.logger.error(CODE + ".updateOcShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocshoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.updateShopping(ocshoppingDomain);
    }

    @RequestMapping(value={"deleteOcShopping.json"}, name="\u5220\u9664\u8d2d\u7269\u8f66")
    @ResponseBody
    public HtmlJsonReBean deleteOcShopping(Integer shoppingId) {
        if (StringUtils.isBlank((Integer)shoppingId)) {
            this.logger.error(CODE + ".deleteOcShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingServiceRepository.deleteShopping(shoppingId);
    }

    @RequestMapping(value={"queryOcShoppingPage.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShoppingReDomain> queryOcShoppingPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocShoppingServiceRepository.queryShoppingPage(param);
    }

    @RequestMapping(value={"updateOcShoppingState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOcShoppingState(String shoppingId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".updateOcShoppingState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingServiceRepository.updateShoppingState(Integer.valueOf(shoppingId), dataState, oldDataState);
    }
}

