/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.oc.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractEngineServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcRefundEngineServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/oc/occontract"}, name="\u8ba2\u5355")
public class OccontractCon
extends SpringmvcController {
    private static String CODE = "oc.occontract.con";
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcContractEngineServiceRepository ocContractEngineServiceRepository;
    @Autowired
    private OcRefundEngineServiceRepository ocRefundEngineServiceRepository;

    protected String getContext() {
        return "occontract";
    }

    @RequestMapping(value={"saveOcContract.json"}, name="\u589e\u52a0\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveOcContract(HttpServletRequest request, OcContractDomain occontractDomain) {
        if (null == occontractDomain) {
            this.logger.error(CODE + ".saveOcContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        occontractDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.saveContract(occontractDomain);
    }

    @RequestMapping(value={"getOcContract.json"}, name="\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f")
    @ResponseBody
    public OcContractReDomain getOcContract(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".getOcContract", (Object)"param is null");
            return null;
        }
        return this.ocContractServiceRepository.getContract(contractId);
    }

    @RequestMapping(value={"updateOcContract.json"}, name="\u66f4\u65b0\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updateOcContract(HttpServletRequest request, OcContractDomain occontractDomain) {
        if (null == occontractDomain) {
            this.logger.error(CODE + ".updateOcContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        occontractDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.updateContract(occontractDomain);
    }

    @RequestMapping(value={"deleteOcContract.json"}, name="\u5220\u9664\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteOcContract(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".deleteOcContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.deleteContract(contractId);
    }

    @RequestMapping(value={"queryOcContractPage.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryOcContractPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractPage(param);
    }

    @RequestMapping(value={"updateOcContractState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOcContractState(String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".updateOcContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractState(Integer.valueOf(contractId), dataState, oldDataState);
    }

    @RequestMapping(value={"sendSavePayBack.json"}, name="\u652f\u4ed8\u65f6\u95f4\u8d85\u65f6")
    @ResponseBody
    public HtmlJsonReBean sendSavePayBack(Object dataState) {
        return this.ocContractEngineServiceRepository.sendSavePayBack(dataState);
    }

    @RequestMapping(value={"queryPprocessLoadDb.json"}, name="\u9000\u6b3e\u8fdb\u7a0b")
    @ResponseBody
    public HtmlJsonReBean queryPprocessLoadDb(Object dataState) {
        return this.ocRefundEngineServiceRepository.queryPprocessLoadDb();
    }

    @RequestMapping(value={"queryContractPageReDomain.json"}, name="\u67e5\u8be2\u5408\u540c\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageReDomain(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"contractUploads.json"}, name="\u4e0a\u4f20\u5408\u7ea6   \u4e0a\u4f20\u6210\u529f\u5e76\u66f4\u65b0\u6570\u636e\u5e93   0\u5df2\u7b7e\u7ea6  1\u672a\u7b7e\u7ea6  3\u5df2\u5931\u6548 ")
    @ResponseBody
    public HtmlJsonReBean contractUploads(HttpServletRequest request, MultipartFile multipartFile) {
        this.logger.info("\u8fdb\u5165controller===========");
        this.logger.info("file.getName================" + multipartFile.getName());
        this.logger.info("multipartFile================" + multipartFile);
        System.out.println("file.getName" + multipartFile.getName());
        Map param = this.assemMapParam(request);
        if (null == multipartFile) {
            this.logger.error(CODE + ".contractUploads", (Object)"param is null");
            return null;
        }
        return this.ocContractServiceRepository.contractUpload(multipartFile, param);
    }

    @RequestMapping(value={"downLoadContract.json"}, name="\u4e0b\u8f7d\u5408\u7ea6 ")
    @ResponseBody
    public ResponseEntity<byte[]> downLoadContract(HttpServletRequest request, String fileName) throws IOException {
        this.logger.error("\u8fdb\u5165controller");
        if (null == fileName) {
            this.logger.error(CODE + ".fileName", (Object)"param is null");
            return null;
        }
        return this.ocContractServiceRepository.downLoadContract(fileName);
    }
}

