/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.oc.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/occontractgoods"}, name="\u8ba2\u5355")
public class OccontractgoodsCon
extends SpringmvcController {
    private static String CODE = "oc.occontractgoods.con";
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;

    protected String getContext() {
        return "occontractgoods";
    }

    @RequestMapping(value={"saveOcContractGoods.json"}, name="\u589e\u52a0\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean saveOcContractGoods(HttpServletRequest request, OcContractGoodsDomain occontractgoodsDomain) {
        if (null == occontractgoodsDomain) {
            this.logger.error(CODE + ".saveOcContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        occontractgoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.saveContractGoods(occontractgoodsDomain);
    }

    @RequestMapping(value={"getOcContractGoods.json"}, name="\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f")
    @ResponseBody
    public OcContractGoodsReDomain getOcContractGoods(Integer contractGoodsId) {
        if (StringUtils.isBlank((Integer)contractGoodsId)) {
            this.logger.error(CODE + ".getOcContractGoods", (Object)"param is null");
            return null;
        }
        return this.ocContractServiceRepository.getContractGoods(contractGoodsId);
    }

    @RequestMapping(value={"updateOcContractGoods.json"}, name="\u66f4\u65b0\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updateOcContractGoods(HttpServletRequest request, OcContractGoodsDomain occontractgoodsDomain) {
        if (null == occontractgoodsDomain) {
            this.logger.error(CODE + ".updateOcContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        occontractgoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.updateContractGoods(occontractgoodsDomain);
    }

    @RequestMapping(value={"deleteOcContractGoods.json"}, name="\u5220\u9664\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteOcContractGoods(Integer contractGoodsId) {
        if (StringUtils.isBlank((Integer)contractGoodsId)) {
            this.logger.error(CODE + ".deleteOcContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.deleteContractGoods(contractGoodsId);
    }

    @RequestMapping(value={"queryOcContractGoodsPage.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryOcContractGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractGoodsPage(param);
    }

    @RequestMapping(value={"updateOcContractGoodsState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateOcContractGoodsState(String contractGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractGoodsId)) {
            this.logger.error(CODE + ".updateOcContractGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractGoodsState(Integer.valueOf(contractGoodsId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryOcContractGoodsPages.json"}, name="\u67e5\u8be2\u8ba2\u5355\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryOcContractGoodsPages(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractGoodsPage(param);
    }
}

