/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.oc.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcShopsetDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShopsetReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcShopsetServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/shopset"}, name="\u8d2d\u7269\u8f66\u663e\u793a\u670d\u52a1")
public class ShopsetCon
extends SpringmvcController {
    private static String CODE = "oc.shopset.con";
    @Autowired
    private OcShopsetServiceRepository ocShopsetServiceRepository;

    protected String getContext() {
        return "shopset";
    }

    @RequestMapping(value={"saveShopset.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66\u663e\u793a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveShopset(HttpServletRequest request, OcShopsetDomain ocShopsetDomain) {
        if (null == ocShopsetDomain) {
            this.logger.error(CODE + ".saveShopset", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShopsetDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShopsetServiceRepository.saveshopset(ocShopsetDomain);
    }

    @RequestMapping(value={"getShopset.json"}, name="\u83b7\u53d6\u8d2d\u7269\u8f66\u663e\u793a\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcShopsetReDomain getShopset(Integer shopsetID) {
        if (StringUtils.isBlank((Integer)shopsetID)) {
            this.logger.error(CODE + ".getShopset", (Object)"param is null");
            return null;
        }
        return this.ocShopsetServiceRepository.getshopset(shopsetID);
    }

    @RequestMapping(value={"updateShopset.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u663e\u793a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateShopset(HttpServletRequest request, OcShopsetDomain ocShopsetDomain) {
        if (null == ocShopsetDomain) {
            this.logger.error(CODE + ".updateShopset", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShopsetDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShopsetServiceRepository.updateshopset(ocShopsetDomain);
    }

    @RequestMapping(value={"deleteShopset.json"}, name="\u5220\u9664\u8d2d\u7269\u8f66\u663e\u793a\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShopset(Integer shopsetID) {
        if (StringUtils.isBlank((Integer)shopsetID)) {
            this.logger.error(CODE + ".deleteShopset", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShopsetServiceRepository.deleteshopset(shopsetID);
    }

    @RequestMapping(value={"queryShopsetPage.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u663e\u793a\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShopsetReDomain> queryShopsetPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocShopsetServiceRepository.queryshopsetPage(param);
    }

    @RequestMapping(value={"updateShopsetState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u663e\u793a\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShopsetState(String shopsetID, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        if (StringUtils.isBlank((String)shopsetID)) {
            this.logger.error(CODE + ".updateShopsetState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShopsetServiceRepository.updateshopsetState(Integer.valueOf(shopsetID), dataState, oldDataState, map);
    }

    @RequestMapping(value={"queryShopsetByTypemap.json"}, name="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u8d2d\u7269\u8f66\u670d\u52a1\u663e\u793a")
    @ResponseBody
    public List<OcShopsetReDomain> queryShopsetByTypemap(HttpServletRequest request, String shopsetType) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("channelCode", this.getTginfoChannel(request));
        this.logger.error(CODE + ".queryShopsetByTypemap", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)param));
        return this.ocShopsetServiceRepository.queryShopsetByTypemap(param);
    }
}

