/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.GoodsNumDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcPackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsPmList;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PromotionForOcReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionCalcDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.SkuInfoDomain;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/shopping"}, name="\u8d2d\u7269\u8f66\u670d\u52a1")
public class ShoppingCon
extends SpringmvcController {
    private static String CODE = "oc.shopping.con";
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;

    protected String getContext() {
        return "shopping";
    }

    @RequestMapping(value={"saveShopping.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.saveShopping(ocShoppingDomain);
    }

    @RequestMapping(value={"getShopping.json"}, name="\u83b7\u53d6\u8d2d\u7269\u8f66\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcShoppingReDomain getShopping(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".getShopping", (Object)"param is null");
            return null;
        }
        return this.ocShoppingServiceRepository.getShopping(Integer.valueOf(shoppingId));
    }

    @RequestMapping(value={"updateShopping.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".updateShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.updateShopping(ocShoppingDomain);
    }

    @RequestMapping(value={"deleteShopping.json"}, name="\u5220\u9664\u8d2d\u7269\u8f66\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShopping(String shoppingId) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".deleteShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] shoppingIdS = shoppingId.split(",");
        if (null == shoppingIdS || shoppingIdS.length <= 0) {
            this.logger.error(CODE + ".deleteShopping1", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (int i = 0; i < shoppingIdS.length; ++i) {
            htmlJsonReBean = this.ocShoppingServiceRepository.deleteShopping(Integer.valueOf(shoppingIdS[i]));
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"queryShoppingPage.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShoppingReDomain> queryShoppingPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String memberCode = this.getMerchantCode(request);
        if (StringUtils.isBlank((String)memberCode)) {
            this.logger.error(CODE + ".queryShoppingPage", (Object)"memberCode");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        param.put("memberBcode", memberCode);
        param.put("tenantCode", tenantCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult ocShoppingReDomainSupQueryResult = this.ocShoppingServiceRepository.queryShoppingPage(param);
        HashMap ocPmMap = new HashMap();
        HashMap<String, ArrayList<OcShoppingGoodsDomain>> pmGoodsMap = new HashMap<String, ArrayList<OcShoppingGoodsDomain>>();
        HashMap<String, PmPromotionReDomain> pmMap = new HashMap<String, PmPromotionReDomain>();
        HashMap<String, ArrayList<OcShoppingGoodsDomain>> noPmGoodsMap = new HashMap<String, ArrayList<OcShoppingGoodsDomain>>();
        List ocShoppingReDomainList = ocShoppingReDomainSupQueryResult.getRows();
        if (null != ocShoppingReDomainList && ocShoppingReDomainList.size() > 0) {
            for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
                List ocShoppingGoodsDomainList = ocShoppingReDomain.getList();
                String shoppingCode = ocShoppingReDomain.getShoppingCode();
                if (null == ocShoppingGoodsDomainList || ocShoppingGoodsDomainList.size() <= 0) continue;
                for (OcShoppingGoodsDomain ocShoppingGoodsDomain : ocShoppingGoodsDomainList) {
                    ArrayList<OcShoppingGoodsDomain> ocShoppingGoodsDomainList1;
                    String goodsCode = ocShoppingGoodsDomain.getGoodsCode();
                    SupQueryResult pmPromotionReDomainSupQueryResult = this.pmPromotionServiceRepository.checkPromotionListByGoodsCode(tenantCode, goodsCode, this.getUserInfo(request).getUserCode(), this.getOauthEnvCode(request));
                    List pmPromotionReDomainList = pmPromotionReDomainSupQueryResult.getRows();
                    String shoppingGoodsPmCode = ocShoppingGoodsDomain.getShoppingGoodsPm();
                    String defaultPmCode = "";
                    ArrayList<PromotionForOcReDomain> promotionForOcReDomainList = new ArrayList<PromotionForOcReDomain>();
                    if (null != pmPromotionReDomainList && pmPromotionReDomainList.size() > 0) {
                        defaultPmCode = ((PmPromotionReDomain)pmPromotionReDomainList.get(0)).getPromotionCode();
                        for (PmPromotionReDomain pmPromotionReDomain : pmPromotionReDomainList) {
                            pmMap.put(pmPromotionReDomain.getPromotionCode(), pmPromotionReDomain);
                            PromotionForOcReDomain promotionForOcReDomain = new PromotionForOcReDomain();
                            promotionForOcReDomain.setPbCode(pmPromotionReDomain.getPbCode());
                            promotionForOcReDomain.setPromotionId(pmPromotionReDomain.getPromotionId());
                            promotionForOcReDomain.setPromotionCode(pmPromotionReDomain.getPromotionCode());
                            promotionForOcReDomain.setPromotionName(pmPromotionReDomain.getPromotionName());
                            promotionForOcReDomainList.add(promotionForOcReDomain);
                        }
                    }
                    ocShoppingGoodsDomain.setPmPromotionList(promotionForOcReDomainList);
                    if (StringUtils.isEmpty((String)defaultPmCode)) {
                        ocShoppingGoodsDomain.setShoppingGoodsPm("");
                        this.updateShoppingGoods(request, ocShoppingGoodsDomain);
                        ArrayList<OcShoppingGoodsDomain> noPmGoodsList = (ArrayList<OcShoppingGoodsDomain>)noPmGoodsMap.get(shoppingCode);
                        if (null != noPmGoodsList && noPmGoodsList.size() > 0) {
                            noPmGoodsList.add(ocShoppingGoodsDomain);
                        } else {
                            noPmGoodsList = new ArrayList<OcShoppingGoodsDomain>();
                            noPmGoodsList.add(ocShoppingGoodsDomain);
                        }
                        noPmGoodsMap.put(shoppingCode, noPmGoodsList);
                        continue;
                    }
                    if (!StringUtils.isEmpty((String)shoppingGoodsPmCode)) {
                        if (!pmMap.keySet().contains(shoppingGoodsPmCode)) {
                            shoppingGoodsPmCode = defaultPmCode;
                            ocShoppingGoodsDomain.setShoppingGoodsPm(shoppingGoodsPmCode);
                            this.updateShoppingGoods(request, ocShoppingGoodsDomain);
                        }
                    } else {
                        shoppingGoodsPmCode = defaultPmCode;
                        ocShoppingGoodsDomain.setShoppingGoodsPm(defaultPmCode);
                        this.updateShoppingGoods(request, ocShoppingGoodsDomain);
                    }
                    if (null != (ocShoppingGoodsDomainList1 = (ArrayList<OcShoppingGoodsDomain>)pmGoodsMap.get(shoppingGoodsPmCode)) && ocShoppingGoodsDomainList1.size() > 0) {
                        ocShoppingGoodsDomainList1.add(ocShoppingGoodsDomain);
                    } else {
                        ocShoppingGoodsDomainList1 = new ArrayList<OcShoppingGoodsDomain>();
                        ocShoppingGoodsDomainList1.add(ocShoppingGoodsDomain);
                    }
                    pmGoodsMap.put(shoppingGoodsPmCode, ocShoppingGoodsDomainList1);
                    ArrayList<String> pmPromotionCodeList = (ArrayList<String>)ocPmMap.get(shoppingCode);
                    if (null != pmPromotionCodeList && pmPromotionCodeList.size() > 0) {
                        if (!pmPromotionCodeList.contains(shoppingGoodsPmCode)) {
                            pmPromotionCodeList.add(shoppingGoodsPmCode);
                        }
                    } else {
                        pmPromotionCodeList = new ArrayList<String>();
                        pmPromotionCodeList.add(shoppingGoodsPmCode);
                    }
                    ocPmMap.put(shoppingCode, pmPromotionCodeList);
                }
            }
        }
        if (null != ocShoppingReDomainList && ocShoppingReDomainList.size() > 0) {
            for (OcShoppingReDomain ocShoppingReDomain : ocShoppingReDomainList) {
                List pmPromotionCodeList;
                ocShoppingReDomain.setList(null);
                String shoppingCode = ocShoppingReDomain.getShoppingCode();
                List noPmGoodsList = (List)noPmGoodsMap.get(shoppingCode);
                if (null != noPmGoodsList && noPmGoodsList.size() > 0) {
                    ocShoppingReDomain.setNoPmList(noPmGoodsList);
                }
                if (null == (pmPromotionCodeList = (List)ocPmMap.get(shoppingCode)) || pmPromotionCodeList.size() <= 0) continue;
                ArrayList<PmPromotionCalcDomain> calcDomainList = new ArrayList<PmPromotionCalcDomain>();
                ArrayList<PmPromotionReDomain> pmPromotionReDomainList = new ArrayList<PmPromotionReDomain>();
                for (String pmPromotionCode : pmPromotionCodeList) {
                    PmPromotionReDomain pmPromotionReDomain = (PmPromotionReDomain)pmMap.get(pmPromotionCode);
                    PmPromotionCalcDomain pmPromotionCalcDomain = new PmPromotionCalcDomain();
                    pmPromotionCalcDomain.setPromotionId(pmPromotionReDomain.getPromotionId().intValue());
                    List ocShoppingGoodsDomainList1 = (List)pmGoodsMap.get(pmPromotionReDomain.getPromotionCode());
                    if (null != ocShoppingGoodsDomainList1 && ocShoppingGoodsDomainList1.size() > 0) {
                        pmPromotionReDomain.setOcShoppingGoodsList(ocShoppingGoodsDomainList1);
                        ArrayList<SkuInfoDomain> skuList = new ArrayList<SkuInfoDomain>();
                        for (OcShoppingGoodsDomain ocShoppingGoodsDomain : ocShoppingGoodsDomainList1) {
                            SkuInfoDomain skuInfoDomain = new SkuInfoDomain();
                            skuInfoDomain.setGoodsCamount(ocShoppingGoodsDomain.getGoodsCamount());
                            skuInfoDomain.setSkuCode(ocShoppingGoodsDomain.getSkuCode());
                            skuInfoDomain.setShoppingGoodsCheck(ocShoppingGoodsDomain.getShoppingGoodsCheck());
                            skuList.add(skuInfoDomain);
                        }
                        pmPromotionCalcDomain.setSkuList(skuList);
                    }
                    pmPromotionReDomainList.add(pmPromotionReDomain);
                    calcDomainList.add(pmPromotionCalcDomain);
                }
                HtmlJsonReBean calcResult = this.pmPromotionServiceRepository.calcPromotionForShoppingGoods(calcDomainList, "", tenantCode, memberCode, this.getOauthEnvCode(request));
                ocShoppingReDomain.setCalcResult(calcResult.getDataObj());
                ocShoppingReDomain.setPmPromotionList(pmPromotionReDomainList);
            }
        }
        return ocShoppingReDomainSupQueryResult;
    }

    @RequestMapping(value={"updateShoppingGoodsPmInfo.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u7684\u8425\u9500\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsPmInfo(HttpServletRequest request, String shoppingGoodsId, String promotionCode) {
        if (StringUtils.isBlank((String)shoppingGoodsId) || StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".updateShoppingGoodsPmInfo", (Object)" param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.ocShoppingServiceRepository.updateShoppingGoodsPmInfo(Integer.valueOf(shoppingGoodsId), promotionCode);
    }

    @RequestMapping(value={"updateShoppingGoodsCheckState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u7684\u9009\u4e2d\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsCheckState(HttpServletRequest request, Integer shoppingGoodsId, String shoppingCode, Integer checkState) {
        String memberCode = this.getMerchantCode(request);
        return this.ocShoppingServiceRepository.updateShoppingGoodsCheckState(memberCode, shoppingCode, shoppingGoodsId, checkState);
    }

    @RequestMapping(value={"updateShoppingGoodsNum.json"}, name="\u4fee\u6539\u8d2d\u7269\u8f66\u6570\u91cf")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsNum(HttpServletRequest request, Integer shoppingGoodsId, BigDecimal amount, BigDecimal goodWeight) {
        if (StringUtils.isBlank((Integer)shoppingGoodsId) || null == amount && null == goodWeight) {
            this.logger.error(CODE + ".updateShoppingGoodsNum", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.ocShoppingServiceRepository.getShoppingGoods(shoppingGoodsId);
        if (null == ocShoppingGoodsReDomain) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (null == ocShoppingGoodsReDomain.getGoodsSupplynum() || ocShoppingGoodsReDomain.getGoodsSupplynum().subtract(ocShoppingGoodsReDomain.getGoodsCamount()).intValue() < 0) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8d2d\u7269\u8f66\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
        }
        this.ocShoppingServiceRepository.updateShoppingGoodsNum(shoppingGoodsId, amount, goodWeight);
        return this.updateShoppingGoodsCheckState(request, shoppingGoodsId, "", 0);
    }

    @RequestMapping(value={"updateShoppingState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingState(String shoppingId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingId)) {
            this.logger.error(CODE + ".updateShoppingState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingServiceRepository.updateShoppingState(Integer.valueOf(shoppingId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveContractByOcShopping.json"}, name="\u4ece\u8d2d\u7269\u8f66\u4e2d\u4e0b\u5355")
    @ResponseBody
    public HtmlJsonReBean saveContractByOcShopping(HttpServletRequest request, OcShoppingDomain ocShoppingDomain, String contractTypepro) {
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".saveContractByOcShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.saveContractByOcShopping(ocShoppingDomain, contractTypepro);
    }

    @RequestMapping(value={"insertShoppingGoods.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean insertShoppingGoods(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".insertShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".insertShoppingGoods", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingGoodsDomain.setMemberBcode(userSession.getUserPcode());
        ocShoppingGoodsDomain.setMemberBname(userSession.getMerberCompname());
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.insertShoppingGoods(ocShoppingGoodsDomain);
    }

    @RequestMapping(value={"addShoppingGoodsBySpec.json"}, name="\u901a\u8fc7\u89c4\u683c\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public RsSkuReDomain addShoppingGoodsBySpec(HttpServletRequest request, String goodsCode, String specStr) {
        if (StringUtils.isBlank((String)specStr) || StringUtils.isBlank((String)goodsCode)) {
            this.logger.error(CODE + ".addShoppingGoodsBySpec", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        List spcList = (List)JsonUtil.buildNormalBinder().getJsonToList(specStr, String.class);
        RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSkuBySpec(spcList, goodsCode, tenantCode);
        if (null == rsSkuReDomain) {
            this.logger.error(CODE + ".addShoppingGoodsBySpec", (Object)(specStr.toString() + "-" + goodsCode + "-" + tenantCode));
            return null;
        }
        if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().subtract(new BigDecimal(1)).intValue() < 0) {
            this.logger.error(CODE + ".addShoppingGoodsBySpec1", (Object)(specStr.toString() + "-" + goodsCode + "-" + tenantCode));
            return null;
        }
        return rsSkuReDomain;
    }

    private HtmlJsonReBean saveShopping(HttpServletRequest request, Integer skuId, BigDecimal goodsNum, BigDecimal goodsWeght) {
        if (null == skuId) {
            this.logger.error(CODE + ".saveShopping", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
        }
        OcShoppingDomain ocShoppingDomain = this.makeOcShoppingDomain(request, skuId, goodsNum, goodsWeght);
        if (null == ocShoppingDomain || null == ocShoppingDomain.getPackageList() || ocShoppingDomain.getPackageList().isEmpty()) {
            this.logger.error(CODE + ".saveShopping", (Object)"ocShoppingDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5df2\u4e0b\u67b6\u6216\u5e93\u5b58\u4e0d\u8db3");
        }
        OcShoppingGoodsDomain ocShoppingGoodsDomain = (OcShoppingGoodsDomain)((OcPackageDomain)ocShoppingDomain.getPackageList().get(0)).getShoppingGoodsList().get(0);
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".saveShopping", (Object)"ocShoppingGoodsDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveShopping", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        ocShoppingGoodsDomain.setMemberBcode(userSession.getUserPcode());
        ocShoppingGoodsDomain.setMemberBname(userSession.showUserName());
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.insertShoppingGoods(ocShoppingGoodsDomain);
    }

    @RequestMapping(value={"addShoppingGoods.json"}, name="\u589e\u52a0\u8d2d\u7269\u8f66SKU\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean addShoppingGoods(HttpServletRequest request, Integer skuId, BigDecimal goodsNum, BigDecimal goodsWeght) {
        return this.saveShopping(request, skuId, goodsNum, goodsWeght);
    }

    @RequestMapping(value={"getShoppingGoods.json"}, name="\u83b7\u53d6\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcShoppingGoodsReDomain getShoppingGoods(String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".getShoppingGoods", (Object)"param is null");
            return null;
        }
        return this.ocShoppingServiceRepository.getShoppingGoods(Integer.valueOf(shoppingGoodsId));
    }

    @RequestMapping(value={"updateShoppingGoods.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoods(HttpServletRequest request, OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            this.logger.error(CODE + ".updateShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocShoppingGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocShoppingServiceRepository.updateShoppingGoods(ocShoppingGoodsDomain);
    }

    @RequestMapping(value={"deleteShoppingGoods.json"}, name="\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShoppingGoods(String shoppingGoodsId) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".deleteShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String[] shoppingGoodsIdS = shoppingGoodsId.split(",");
        if (null == shoppingGoodsIdS || shoppingGoodsIdS.length <= 0) {
            this.logger.error(CODE + ".deleteShoppingGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        for (int i = 0; i < shoppingGoodsIdS.length; ++i) {
            htmlJsonReBean = this.ocShoppingServiceRepository.deleteShoppingGoods(Integer.valueOf(shoppingGoodsIdS[i]));
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"deleteShoppingGoodsBatch.json"}, name="\u6279\u91cf\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteShoppingGoodsBatch(String shoppingGoodsIdStr) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".deleteShoppingGoodsBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List shoppingGoodsIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        return this.ocShoppingServiceRepository.deleteShoppingGoodsBatch(shoppingGoodsIdList);
    }

    @RequestMapping(value={"updateShoppingGoodsNumBatch.json"}, name="\u6279\u91cf\u4fee\u6539")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsNumBatch(String goodsListStr) {
        if (StringUtils.isBlank((String)goodsListStr)) {
            this.logger.error(CODE + ".updateShoppingGoodsNumBatch", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List goodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(goodsListStr, GoodsNumDomain.class);
        return this.ocShoppingServiceRepository.updateShoppingGoodsNumBatch(goodsList);
    }

    @RequestMapping(value={"queryShoppingGoodsPage.json"}, name="\u67e5\u8be2\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcShoppingGoodsReDomain> queryShoppingGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocShoppingServiceRepository.queryShoppingGoodsPage(param);
    }

    @RequestMapping(value={"updateShoppingGoodsState.json"}, name="\u66f4\u65b0\u8d2d\u7269\u8f66\u5546\u54c1\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateShoppingGoodsState(String shoppingGoodsId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)shoppingGoodsId)) {
            this.logger.error(CODE + ".updateShoppingGoodsState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingServiceRepository.updateShoppingGoodsState(Integer.valueOf(shoppingGoodsId), dataState, oldDataState);
    }

    @RequestMapping(value={"queryShoppingToContract.json"}, name="\u8d2d\u7269\u8f66\u7ed3\u7b97\u9875\u9762")
    @ResponseBody
    public List<OcShoppingReDomain> queryShoppingToContract(String shoppingGoodsIdStr) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr)) {
            this.logger.error(CODE + ".queryShoppingToContract", (Object)"param is null");
            return null;
        }
        List shoppingGoodsIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        return this.ocShoppingServiceRepository.queryShoppingToContract(shoppingGoodsIdList);
    }

    @RequestMapping(value={"queryShoppingPmToContract.json"}, name="\u8d2d\u7269\u8f66\u7ed3\u7b97\u9875\u9762\u542b\u8425\u9500\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean queryShoppingPmToContract(HttpServletRequest request, Integer terminalType, String shoppingGoodsPmListsStr) {
        if (StringUtils.isBlank((String)shoppingGoodsPmListsStr)) {
            this.logger.error(CODE + ".queryShoppingPmToContract", (Object)"param is null");
            return null;
        }
        List shoppingGoodsPmLists = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsPmListsStr, OcShoppingGoodsPmList.class);
        return this.ocShoppingServiceRepository.calcShoppingPmToContract(this.getMerchantCode(request), this.getTenantCode(request), terminalType, shoppingGoodsPmLists);
    }

    @RequestMapping(value={"queryToContract.json"}, name="\u76f4\u63a5\u7ed3\u7b97\u9875\u9762")
    @ResponseBody
    public List<OcShoppingDomain> queryToContract(HttpServletRequest request, Integer skuId, BigDecimal goodsNum, BigDecimal goodsWeght) {
        if (null == skuId) {
            this.logger.error(CODE + ".queryToContract", (Object)"skuId is null");
            return null;
        }
        OcShoppingDomain ocShoppingDomain = this.makeOcShoppingDomain(request, skuId, goodsNum, goodsWeght);
        if (null == ocShoppingDomain) {
            this.logger.error(CODE + ".queryToContract", (Object)"OcShoppingDomain is null");
            return null;
        }
        ArrayList<OcShoppingDomain> list = new ArrayList<OcShoppingDomain>();
        list.add(ocShoppingDomain);
        return list;
    }

    private OcShoppingDomain makeOcShoppingDomain(HttpServletRequest request, Integer skuId, BigDecimal goodsNum, BigDecimal goodsWeght) {
        RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuId);
        if (null == rsSkuReDomain) {
            return null;
        }
        if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
            this.logger.error(CODE + ".makeOcShoppingDomain.rsSkuReDomain", (Object)"GoodsSupplynum is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("goodsCode", rsSkuReDomain.getGoodsCode());
        map.put("tenantCode", rsSkuReDomain.getTenantCode());
        RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
        if (null == rsResourceGoodsReDomain) {
            return null;
        }
        if (1 != rsResourceGoodsReDomain.getDataOpbillstate()) {
            return null;
        }
        OcShoppingDomain ocShoppingDomain = new OcShoppingDomain();
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".makeOcShoppingDomain.UserSession", (Object)"UserSession is null");
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingDomain, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)ocShoppingDomain, (Object)rsSkuReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".makeOcShoppingDomain.e", (Throwable)e);
            return null;
        }
        if (userSession.getUserPcode().equals(ocShoppingDomain.getMemberCode())) {
            this.logger.error(CODE + ".makeOcShoppingDomain.memberCode", (Object)"\u81ea\u5df1\u4e70\u81ea\u5df1");
            return null;
        }
        ocShoppingDomain.setMemberBcode(userSession.getUserPcode());
        ocShoppingDomain.setMemberBname(userSession.getMerberCompname());
        ocShoppingDomain.setTenantCode(this.getTenantCode(request));
        OcShoppingGoodsDomain ocShoppingGoodsDomain = new OcShoppingGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)rsResourceGoodsReDomain);
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)rsSkuReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".makeOcShoppingDomain.e1", (Throwable)e);
            return null;
        }
        if (null == goodsNum) {
            goodsNum = new BigDecimal(1);
        }
        if (null == goodsWeght) {
            goodsWeght = new BigDecimal(1);
        }
        ocShoppingDomain.setShoppingCamount(goodsNum);
        ocShoppingDomain.setShoppingCweight(goodsWeght);
        ocShoppingDomain.setGoodsMoney(ocShoppingDomain.getShoppingCamount().multiply(rsSkuReDomain.getPricesetNprice()));
        ocShoppingGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
        ocShoppingGoodsDomain.setGoodsCamount(goodsNum);
        ocShoppingGoodsDomain.setGoodsCweight(goodsWeght);
        ocShoppingGoodsDomain.setShoppingGoodsAmount(rsSkuReDomain.getGoodsHangnum());
        ocShoppingGoodsDomain.setShoppingGoodsWeight(rsSkuReDomain.getGoodsHangweight());
        ocShoppingGoodsDomain.setMemberBcode(ocShoppingDomain.getMemberBcode());
        ocShoppingGoodsDomain.setMemberBname(ocShoppingDomain.getMemberBname());
        ocShoppingGoodsDomain.setTenantCode(ocShoppingDomain.getTenantCode());
        ArrayList<OcShoppingGoodsDomain> goodslist = new ArrayList<OcShoppingGoodsDomain>();
        goodslist.add(ocShoppingGoodsDomain);
        ArrayList<OcPackageDomain> pageList = new ArrayList<OcPackageDomain>();
        OcPackageDomain ocPackage = new OcPackageDomain();
        ocPackage.setShoppingGoodsList(goodslist);
        pageList.add(ocPackage);
        ocShoppingDomain.setPackageList(pageList);
        return ocShoppingDomain;
    }
}

