/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSettlDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcPackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcShoppingGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.SkuDomain;
import com.qjsoft.laser.controller.facade.oc.domain.pojo.PackageExpressDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractEngineServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.facade.pm.domain.DiscountDataDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmUserOrderReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.facade.wl.repository.WlFreightTemServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contract"}, name="\u8ba2\u5355\u670d\u52a1")
public class ContractCon
extends SpringmvcController {
    private static String CODE = "oc.contract.con";
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;
    @Autowired
    private WlFreightTemServiceRepository wlFreightTemServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;
    @Autowired
    private OcContractEngineServiceRepository ocContractEngineServiceRepository;

    protected String getContext() {
        return "contract";
    }

    @RequestMapping(value={"saveContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContract(HttpServletRequest request, String orderDomainStr) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".saveContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".saveContract", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveContract", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ArrayList<OcContractDomain> ocContractDomainList = new ArrayList<OcContractDomain>();
        ArrayList<Integer> shoppingGoodsIdList = new ArrayList<Integer>();
        for (OrderDomain orderDomain : orderDomainList) {
            OcContractDomain contractDomain;
            try {
                contractDomain = this.makeContractDomain(orderDomain);
                contractDomain.setMemberBcode(userSession.getUserPcode());
                contractDomain.setMemberBname(userSession.showUserName());
                contractDomain.setTenantCode(userSession.getTenantCode());
                contractDomain.setPackageList(this.makePackageDomainList(orderDomain.getPackageList(), contractDomain, shoppingGoodsIdList));
            }
            catch (Exception e) {
                this.logger.error(CODE + ".saveContract.ex", (Throwable)e);
                return new HtmlJsonReBean(CODE + ".saveContract.ex", e.getMessage());
            }
            this.calculateContract(contractDomain);
            ocContractDomainList.add(contractDomain);
        }
        if (request.getParameter("cdebug") != null) {
            this.logger.info(CODE + ".saveContract.debug", (Object)"\u4e0b\u5355\u8c03\u8bd5\u6a21\u5f0f");
            shoppingGoodsIdList = null;
        }
        return this.ocShoppingServiceRepository.sendBatchContractByDel(ocContractDomainList, shoppingGoodsIdList);
    }

    public OcContractDomain makeContractDomain(OrderDomain orderDomain) throws Exception {
        OcContractDomain contractDomain = new OcContractDomain();
        try {
            BeanUtils.copyAllPropertys((Object)contractDomain, (Object)orderDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".makeContractDomain.ex", (Throwable)e);
            return null;
        }
        contractDomain.setContractType("01");
        this.createPackageDomainListOnOrder_temp(orderDomain);
        return contractDomain;
    }

    private List<PackageDomain> createPackageDomainListOnOrder_temp(OrderDomain orderDomain) {
        PackageDomain packageDomain;
        ArrayList<PackageDomain> packageDomainList = orderDomain.getPackageList();
        if (packageDomainList == null) {
            packageDomainList = new ArrayList<PackageDomain>();
        }
        if (packageDomainList.isEmpty()) {
            packageDomain = new PackageDomain();
            packageDomainList.add(packageDomain);
            orderDomain.setPackageList(packageDomainList);
        } else {
            packageDomain = (PackageDomain)packageDomainList.get(0);
        }
        packageDomain.setPackageMode("0");
        packageDomain.setShoppingGoodsIdList(orderDomain.getShoppingGoodsIdList());
        packageDomain.setSkuIdList(orderDomain.getSkuIdList());
        return packageDomainList;
    }

    public List<OcPackageDomain> makePackageDomainList(List<PackageDomain> packageList, OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) throws Exception {
        if (ListUtil.isEmpty(packageList)) {
            throw new Exception("\u5305\u88f9\u4fe1\u606f\u4e3a\u7a7a");
        }
        ArrayList<OcPackageDomain> packageDomainList = new ArrayList<OcPackageDomain>();
        for (PackageDomain packageDomain : packageList) {
            OcPackageDomain ocPackageDomain = this.makePackageDomain(packageDomain, ocContractDomain);
            packageDomainList.add(ocPackageDomain);
            if (null == shoppingGoodsIdList || null == packageDomain.getShoppingGoodsIdList()) continue;
            shoppingGoodsIdList.addAll(packageDomain.getShoppingGoodsIdList());
        }
        return packageDomainList;
    }

    private OcPackageDomain makePackageDomain(PackageDomain packageDomain, OcContractDomain ocContractDomain) throws Exception {
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)packageDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".makePackageDomain.ex", (Throwable)e);
            return null;
        }
        BigDecimal goodsPmoney = BigDecimal.ZERO;
        String goodsPmbillno = "";
        String pmInfo = SupDisUtil.get((String)("pm-userorder" + ocContractDomain.getMemberBcode()));
        List pmUserOrderReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(pmInfo, PmUserOrderReDomain.class);
        ArrayList<DiscountDataDomain> discountDataDomains = new ArrayList<DiscountDataDomain>();
        if (null != pmUserOrderReDomainList && pmUserOrderReDomainList.size() > 0) {
            for (PmUserOrderReDomain pmUserOrderReDomain : pmUserOrderReDomainList) {
                List discountDataDomainList;
                goodsPmoney = goodsPmoney.add(pmUserOrderReDomain.getDiscountAmount());
                goodsPmbillno = goodsPmbillno + ";" + pmUserOrderReDomain.getPromotionCode();
                String discountData = pmUserOrderReDomain.getDiscountData();
                if (!StringUtils.isNotBlank((String)discountData) || null == (discountDataDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(discountData, DiscountDataDomain.class))) continue;
                discountDataDomains.addAll(discountDataDomainList);
            }
        }
        ocPackageDomain.setContractGoodsList(this.makeContractGoodsDomainList(packageDomain.getShoppingGoodsIdList(), packageDomain.getSkuIdList(), ocContractDomain, discountDataDomains));
        BigDecimal goodsMoney = BigDecimal.ZERO;
        BigDecimal packageGoodsWeight = BigDecimal.ZERO;
        BigDecimal packageGoodsNum = BigDecimal.ZERO;
        for (OcContractGoodsDomain ocContractGoodsDomain : ocPackageDomain.getContractGoodsList()) {
            if (null == ocContractGoodsDomain.getGoodsNum()) {
                ocContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            packageGoodsNum = packageGoodsNum.add(ocContractGoodsDomain.getGoodsNum());
            if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
                ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            goodsMoney = goodsMoney.add(ocContractGoodsDomain.getContractGoodsInmoney());
            if (null == ocContractGoodsDomain.getGoodsWeight()) {
                ocContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            packageGoodsWeight = packageGoodsWeight.add(ocContractGoodsDomain.getGoodsWeight());
        }
        ocPackageDomain.setGoodsWeight(packageGoodsWeight);
        ocPackageDomain.setGoodsNum(packageGoodsNum);
        ocPackageDomain.setWarehouseName(ocContractDomain.getWarehouseName());
        ocPackageDomain.setMemberBcode(ocContractDomain.getMemberBcode());
        ocPackageDomain.setMemberBname(ocContractDomain.getMemberBname());
        BigDecimal freightFare = this.getFreightFare(ocPackageDomain.getContractGoodsList(), ocContractDomain.getAreaCode());
        ocPackageDomain.setPackageFare(freightFare.toString());
        ocPackageDomain.setGoodsMoney(goodsMoney.add(freightFare));
        ocPackageDomain.setGoodsPmoney(goodsPmoney);
        if (StringUtils.isNotBlank((String)goodsPmbillno)) {
            goodsPmbillno = goodsPmbillno.substring(1);
        }
        ocPackageDomain.setGoodsPmbillno(goodsPmbillno);
        return ocPackageDomain;
    }

    private List<OcContractGoodsDomain> makeContractGoodsDomainList(List<Integer> shoppingGoodsIdList, List<SkuDomain> skuIdList, OcContractDomain ocContractDomain, List<DiscountDataDomain> discountDataDomains) throws Exception {
        BigDecimal inmoney;
        if (ListUtil.isEmpty(shoppingGoodsIdList) && ListUtil.isEmpty(skuIdList)) {
            this.logger.info(CODE + ".makeContractGoodsDomainList.shoppingGoodsIdList.empty", (Object)"\u8d2d\u7269\u8f66\u53c2\u6570\u4e3a\u7a7a");
            throw new Exception("\u8d2d\u7269\u8f66\u6570\u636e\u4e3a\u7a7a");
        }
        boolean shop = true;
        shop = !ListUtil.isEmpty(shoppingGoodsIdList);
        ArrayList<OcContractGoodsDomain> contractGoodsDomainList = new ArrayList<OcContractGoodsDomain>();
        HashMap<String, BigDecimal> skuCodeDiscountMap = new HashMap<String, BigDecimal>();
        if (null != discountDataDomains && discountDataDomains.size() > 0) {
            for (DiscountDataDomain discountDataDomain : discountDataDomains) {
                skuCodeDiscountMap.put(discountDataDomain.getSkuCode(), discountDataDomain.getDiscountAmount());
            }
        }
        if (shop) {
            for (Integer id : shoppingGoodsIdList) {
                OcContractGoodsDomain contractGoodsDomain = new OcContractGoodsDomain();
                OcShoppingGoodsReDomain ocShoppingGoodsReDomain = this.ocShoppingServiceRepository.getShoppingGoods(id);
                if (ocShoppingGoodsReDomain == null) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.shoppingGoodsId", (Object)("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  " + id));
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (!ocShoppingGoodsReDomain.getMemberBcode().equals(ocContractDomain.getMemberBcode())) {
                    this.logger.error(CODE, (Object)String.format("\u8d2d\u7269\u8f66\u8d2d\u4e70\u4eba\u4e0e\u767b\u5f55\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0cshoppingGoodsId=%s,\u6240\u6709\u8005\u8d26\u53f7=%s,\u767b\u5f55\u8d26\u53f7=%s", id, ocShoppingGoodsReDomain.getMemberBcode(), ocContractDomain.getMemberBcode()));
                    throw new Exception("\u8d2d\u7269\u8f66\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(ocShoppingGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(ocShoppingGoodsReDomain.getMemberName());
                }
                if (null == ocShoppingGoodsReDomain.getGoodsSupplynum() || ocShoppingGoodsReDomain.getGoodsSupplynum().subtract(ocShoppingGoodsReDomain.getGoodsCamount()).intValue() < 0) {
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3");
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)ocShoppingGoodsReDomain);
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsCamount(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsCweight(ocShoppingGoodsReDomain.getGoodsCweight());
                contractGoodsDomain.setGoodsNum(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsCamount(ocShoppingGoodsReDomain.getGoodsCamount());
                contractGoodsDomain.setGoodsWeight(ocShoppingGoodsReDomain.getGoodsCweight());
                inmoney = ocShoppingGoodsReDomain.getPricesetNprice().multiply(contractGoodsDomain.getGoodsNum());
                contractGoodsDomain.setContractGoodsInmoney(inmoney);
                BigDecimal discountAmount = (BigDecimal)skuCodeDiscountMap.get(ocShoppingGoodsReDomain.getSkuCode());
                if (null == discountAmount) {
                    discountAmount = BigDecimal.ZERO;
                }
                BigDecimal contractGoodsMoney = inmoney.subtract(discountAmount);
                contractGoodsDomain.setContractGoodsPrice(contractGoodsMoney.divide(contractGoodsDomain.getGoodsNum()));
                contractGoodsDomain.setContractGoodsMoney(contractGoodsMoney);
                contractGoodsDomain.setContractGoodsAppraise(Integer.valueOf(0));
                contractGoodsDomain.setRefundFlag(Integer.valueOf(0));
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        } else {
            for (SkuDomain skuDomain : skuIdList) {
                OcContractGoodsDomain contractGoodsDomain = new OcContractGoodsDomain();
                RsSkuReDomain rsSkuReDomain = this.rsSkuServiceRepository.getSku(skuDomain.getSkuId());
                if (rsSkuReDomain == null) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (1 != rsSkuReDomain.getDataOpbillstate() || null == rsSkuReDomain.getGoodsSupplynum() || rsSkuReDomain.getGoodsSupplynum().longValue() <= 0L) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.rsSkuReDomain", (Object)"GoodsSupplynum is null");
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u5e93\u5b58\u4e0d\u8db3");
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("goodsCode", rsSkuReDomain.getGoodsCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                RsResourceGoodsReDomain rsResourceGoodsReDomain = this.rsResourceGoodsServiceRepository.getResourceGoodsByCode(map);
                if (null == rsResourceGoodsReDomain) {
                    this.logger.error(CODE + ".makeContractGoodsDomainList.skuId", (Object)("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728  " + skuDomain.getSkuId()));
                    throw new Exception("\u8d2d\u7269\u8f66\u5546\u54c1\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                    ocContractDomain.setMemberCode(rsResourceGoodsReDomain.getMemberCode());
                    ocContractDomain.setMemberName(rsResourceGoodsReDomain.getMemberName());
                }
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsResourceGoodsReDomain);
                BeanUtils.copyAllPropertys((Object)contractGoodsDomain, (Object)rsSkuReDomain);
                contractGoodsDomain.setMemberBcode(ocContractDomain.getMemberBcode());
                contractGoodsDomain.setMemberBname(ocContractDomain.getMemberBname());
                contractGoodsDomain.setGoodsName(rsResourceGoodsReDomain.getGoodsName());
                contractGoodsDomain.setGoodsCamount(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsCweight(null == skuDomain.getGoodsWeght() ? BigDecimal.ZERO : skuDomain.getGoodsWeght());
                contractGoodsDomain.setGoodsNum(skuDomain.getGoodsNum());
                contractGoodsDomain.setGoodsWeight(skuDomain.getGoodsWeght());
                if (null == skuDomain.getGiftFlag()) {
                    skuDomain.setGiftFlag(Integer.valueOf(0));
                }
                if (skuDomain.getGiftFlag() == 0) {
                    inmoney = rsSkuReDomain.getPricesetNprice().multiply(contractGoodsDomain.getGoodsNum());
                    contractGoodsDomain.setContractGoodsInmoney(inmoney);
                    BigDecimal discountAmount = (BigDecimal)skuCodeDiscountMap.get(contractGoodsDomain.getSkuCode());
                    if (null == discountAmount) {
                        discountAmount = BigDecimal.ZERO;
                    }
                    BigDecimal contractGoodsMoney = inmoney.subtract(discountAmount);
                    contractGoodsDomain.setContractGoodsMoney(contractGoodsMoney);
                    contractGoodsDomain.setContractGoodsPrice(contractGoodsMoney.divide(contractGoodsDomain.getGoodsNum()));
                } else if (skuDomain.getGiftFlag() == 1) {
                    contractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
                    contractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
                    contractGoodsDomain.setContractGoodsPrice(BigDecimal.ZERO);
                }
                contractGoodsDomain.setContractGoodsAppraise(Integer.valueOf(0));
                contractGoodsDomain.setRefundFlag(Integer.valueOf(0));
                contractGoodsDomainList.add(contractGoodsDomain);
            }
        }
        if (ListUtil.isEmpty(contractGoodsDomainList)) {
            this.logger.info(CODE + ".makeContractGoodsDomainList.contractGoodsDomainList.empty", (Object)"\u8d2d\u7269\u8f66\u4e3a\u7a7a");
            throw new Exception("\u8d2d\u7269\u8f66\u4e3a\u7a7a");
        }
        return contractGoodsDomainList;
    }

    private void calculateContract(OcContractDomain contractDomain) {
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal goodsWeight = BigDecimal.ZERO;
        BigDecimal contractInmoney = BigDecimal.ZERO;
        BigDecimal contractMoney = BigDecimal.ZERO;
        BigDecimal dataBnum = BigDecimal.ZERO;
        BigDecimal dataBweight = BigDecimal.ZERO;
        BigDecimal dataBmoney = BigDecimal.ZERO;
        BigDecimal goodsLogmoney = BigDecimal.ZERO;
        BigDecimal goodsPmoney = BigDecimal.ZERO;
        String goodsPmbillno = "";
        for (OcPackageDomain ocPackageDomain : contractDomain.getPackageList()) {
            goodsNum = goodsNum.add(ocPackageDomain.getGoodsNum());
            goodsWeight = goodsWeight.add(ocPackageDomain.getGoodsWeight());
            contractInmoney = contractInmoney.add(ocPackageDomain.getGoodsMoney());
            goodsLogmoney = goodsLogmoney.add(new BigDecimal(ocPackageDomain.getPackageFare()));
            goodsPmoney = goodsPmoney.add(ocPackageDomain.getGoodsPmoney());
            if (!StringUtils.isNotBlank((String)ocPackageDomain.getGoodsPmbillno())) continue;
            goodsPmbillno = goodsPmbillno + ";" + ocPackageDomain.getGoodsPmbillno();
        }
        if (StringUtils.isNotBlank((String)goodsPmbillno)) {
            goodsPmbillno = goodsPmbillno.substring(1);
        }
        dataBnum = goodsNum;
        dataBweight = goodsWeight;
        dataBmoney = contractInmoney.subtract(goodsPmoney);
        contractMoney = contractInmoney.subtract(goodsPmoney);
        ArrayList<OcContractSettlDomain> ocContractSettlDomainList = new ArrayList<OcContractSettlDomain>();
        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
        ocContractSettlDomain.setContractSettlOpno(goodsPmbillno);
        ocContractSettlDomain.setContractSettlBlance("PM");
        ocContractSettlDomain.setContractSettlType("0");
        ocContractSettlDomain.setContractSettlGmoney(goodsPmoney);
        ocContractSettlDomain.setContractSettlPmoney(goodsPmoney);
        ocContractSettlDomain.setContractPmode("0");
        ocContractSettlDomainList.add(ocContractSettlDomain);
        HtmlJsonReBean htmlJsonReBean = this.upmUpointsServiceRepository.deductible(contractMoney, contractDomain.getTenantCode(), contractDomain.getMemberBcode(), "0");
        if (null != htmlJsonReBean && null != htmlJsonReBean.getDataObj()) {
            Map upmMap = (Map)htmlJsonReBean.getDataObj();
            BigDecimal disamount = (BigDecimal)upmMap.get("disamount");
            Integer integral = (Integer)upmMap.get("integral");
            contractInmoney = contractInmoney.subtract(disamount);
            contractMoney = contractMoney.subtract(disamount);
            OcContractSettlDomain ocContractSettlDomain1 = new OcContractSettlDomain();
            ocContractSettlDomain1.setContractSettlOpno("");
            ocContractSettlDomain1.setContractSettlBlance("INT");
            ocContractSettlDomain1.setContractSettlType("0");
            ocContractSettlDomain1.setContractSettlGmoney(BigDecimal.valueOf(integral.intValue()));
            ocContractSettlDomain1.setContractSettlPmoney(disamount);
            ocContractSettlDomain1.setContractPmode("0");
            ocContractSettlDomainList.add(ocContractSettlDomain1);
        }
        contractDomain.setOcContractSettlList(ocContractSettlDomainList);
        contractDomain.setGoodsNum(goodsNum);
        contractDomain.setGoodsWeight(goodsWeight);
        contractDomain.setContractInmoney(contractInmoney);
        contractDomain.setContractMoney(contractMoney);
        contractDomain.setDataBnum(dataBnum);
        contractDomain.setDataBweight(dataBweight);
        contractDomain.setDataBmoney(dataBmoney);
        contractDomain.setGoodsLogmoney(goodsLogmoney);
        contractDomain.setGoodsPmoney(goodsPmoney);
        contractDomain.setGoodsPmbillno(goodsPmbillno);
    }

    private BigDecimal getFreightFare(List<OcContractGoodsDomain> ocContractGoodsDomainList, String areaCode) throws Exception {
        String freightExpCode;
        if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
            throw new Exception("\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
        }
        HashMap<String, String> skuParamMap = new HashMap<String, String>();
        HashMap<String, String> expParamMap = new HashMap<String, String>();
        HashMap<String, BigDecimal> quantityMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> weightMap = new HashMap<String, BigDecimal>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            RsSkuReDomain rsSkuReDomain;
            skuParamMap.clear();
            skuParamMap.put("skuCode", ocContractGoodsDomain.getSkuCode());
            if (StringUtils.isNotBlank((String)ocContractGoodsDomain.getTenantCode())) {
                skuParamMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            }
            if ((rsSkuReDomain = this.rsSkuServiceRepository.getSkuByCode(skuParamMap)) == null) {
                throw new Exception("\u5546\u54c1sku\u4fe1\u606f\u6709\u8bef");
            }
            freightExpCode = rsSkuReDomain.getFreightTemCode();
            BigDecimal cquantity = (BigDecimal)quantityMap.get(freightExpCode);
            if (cquantity == null) {
                cquantity = BigDecimal.ZERO;
            }
            cquantity = cquantity.add(ocContractGoodsDomain.getGoodsNum());
            quantityMap.put(freightExpCode, cquantity);
            BigDecimal cweight = (BigDecimal)weightMap.get(freightExpCode);
            if (cweight == null) {
                cweight = BigDecimal.ZERO;
            }
            if (ocContractGoodsDomain.getGoodsWeight() != null) {
                cweight = cweight.add(ocContractGoodsDomain.getGoodsWeight());
            }
            weightMap.put(freightExpCode, cweight);
        }
        BigDecimal freightFare = BigDecimal.ZERO;
        for (Map.Entry entry : quantityMap.entrySet()) {
            freightExpCode = (String)entry.getKey();
            expParamMap.clear();
            expParamMap.put("freightExpCode", freightExpCode);
            expParamMap.put("areaCode", areaCode);
            expParamMap.put("quantity", (String)entry.getValue());
            expParamMap.put("weight", (String)weightMap.get(freightExpCode));
            BigDecimal fare = this.wlFreightTemServiceRepository.getFreightFare(expParamMap);
            if (fare != null) {
                freightFare = freightFare.add(fare);
                continue;
            }
            this.logger.info(CODE + ".setPackageFreightFare.getFreightFare.null", (Object)("param=" + expParamMap));
        }
        return freightFare;
    }

    @RequestMapping(value={"getContract.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcContractReDomain getContract(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.ocContractServiceRepository.getContract(Integer.valueOf(contractId));
    }

    @RequestMapping(value={"updateContract.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateContract(HttpServletRequest request, OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error(CODE + ".updateContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.updateContract(ocContractDomain);
    }

    @RequestMapping(value={"deleteContract.json"}, name="\u5220\u9664\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteContract(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".deleteContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.deleteContract(Integer.valueOf(contractId));
    }

    @RequestMapping(value={"queryContractGoodsPage.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractGoodsPage(param);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u67e5\u8be2\u5546\u5bb6\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"queryContractPagePlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPagePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"queryContractPageC.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageC(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"updateContractState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractState(String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId) || dataState == null) {
            this.logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractState(Integer.valueOf(contractId), dataState, oldDataState);
    }

    @RequestMapping(value={"offlinePayContractState.json"}, name="\u7ebf\u4e0b\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean offlinePayContractState(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".offlinePayContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractStateExtend(contractId, Integer.valueOf(2), Integer.valueOf(1));
    }

    @RequestMapping(value={"cancelContractC.json"}, name="\u53d6\u6d88\u8ba2\u5355  C\u7aef")
    @ResponseBody
    public HtmlJsonReBean cancelContractC(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractStateExtend(contractId, Integer.valueOf(-1), Integer.valueOf(1));
    }

    @RequestMapping(value={"getContractByCode.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractByCode(HttpServletRequest request) {
        Map param = this.getMemberBcodeQueryMapParams(request);
        return this.ocContractServiceRepository.getContractByCode(param);
    }

    @RequestMapping(value={"updateContractSubMoney.json"}, name="\u4fee\u6539\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean updateContractSubMoney(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error(CODE + ".saveContracNext", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractSubMoney(contractId, subMoney, remark);
    }

    @RequestMapping(value={"syncContractState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractState(HttpServletRequest request, String contractBillcode) {
        return this.getContrant(request, contractBillcode, -1, 1);
    }

    @RequestMapping(value={"syncContractBatchState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ocContractServiceRepository.queryContractPage(map);
        if (null == qlist || null == qlist.getRows()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u6570\u636e\u4e3a\u7a7a");
        }
        Integer errDataState = -1;
        Integer newDataState = 1;
        boolean flag = true;
        for (OcContractReDomain OcContractReDomain2 : qlist.getRows()) {
            HtmlJsonReBean htmlJsonReBean = this.getContrant(request, OcContractReDomain2.getContractBillcode(), errDataState, newDataState);
            if (null == htmlJsonReBean || htmlJsonReBean.isSuccess()) continue;
            flag = false;
        }
        if (flag) {
            return new HtmlJsonReBean((Object)"ok");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5931\u8d25");
    }

    @RequestMapping(value={"syncContractPayState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractPayState(HttpServletRequest request, String contractBillcode) {
        return this.getContrant(request, contractBillcode, -1, 2);
    }

    @RequestMapping(value={"syncContractBatchPayState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchPayState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ocContractServiceRepository.queryContractPage(map);
        if (null == qlist || null == qlist.getRows()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u6570\u636e\u4e3a\u7a7a");
        }
        Integer errDataState = -1;
        Integer newDataState = 2;
        boolean flag = true;
        for (OcContractReDomain OcContractReDomain2 : qlist.getRows()) {
            HtmlJsonReBean htmlJsonReBean = this.getContrant(request, OcContractReDomain2.getContractBillcode(), errDataState, newDataState);
            if (null == htmlJsonReBean || htmlJsonReBean.isSuccess()) continue;
            flag = false;
        }
        if (flag) {
            return new HtmlJsonReBean((Object)"ok");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5931\u8d25");
    }

    private HtmlJsonReBean getContrant(HttpServletRequest request, String contractBillcode, Integer errDataState, Integer newDataState) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        long currentTime = System.currentTimeMillis();
        long expireMillis = 10000L;
        String DisKey = "ocContract-state-" + contractBillcode + tenantCode;
        Integer dataState = null;
        HtmlJsonReBean htmlJsonReBean = this.checkDataState(errDataState, newDataState, DisKey);
        if (null != htmlJsonReBean) {
            return htmlJsonReBean;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        while (dataState == null || dataState.intValue() != newDataState.intValue() && dataState.intValue() != errDataState.intValue()) {
            block11: {
                if (System.currentTimeMillis() - currentTime > 10000L) {
                    OcContractReDomain contractReDomain = this.ocContractServiceRepository.getContractByCode(map);
                    if (contractReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                        break;
                    }
                    dataState = contractReDomain.getDataState();
                    this.logger.debug(CODE + ".syncContractState.expire", (Object)("\u4e0b\u5355\u5904\u7406\u8d85\u65f6\uff1a" + contractBillcode + ",\u6570\u636e\u5e93\u72b6\u6001\uff1a" + dataState));
                    if (dataState != null && dataState.intValue() == newDataState.intValue()) {
                        return new HtmlJsonReBean((Object)"ok");
                    }
                    if (dataState == null || dataState.intValue() != errDataState.intValue()) break;
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    this.logger.error(CODE + ".syncContractState.sleep.ex", (Throwable)e);
                }
                try {
                    String str = SupDisUtil.getRemot((String)DisKey);
                    if (!StringUtils.isNotBlank((String)str)) break block11;
                    dataState = Integer.valueOf(str);
                }
                catch (NumberFormatException e) {
                    this.logger.error(CODE, (Object)("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + contractBillcode));
                    continue;
                }
            }
            if (dataState != null && dataState.intValue() == newDataState.intValue()) {
                return new HtmlJsonReBean((Object)"ok");
            }
            if (dataState == null || dataState.intValue() != errDataState.intValue()) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u51fa\u9519\u4e86\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
    }

    private HtmlJsonReBean checkDataState(Integer errDataState, Integer newDataState, String DisKey) {
        String str = SupDisUtil.getRemot((String)DisKey);
        Integer dataState = null;
        if (StringUtils.isNotBlank((String)str)) {
            dataState = Integer.valueOf(str);
        }
        if (dataState != null && dataState.intValue() == newDataState.intValue()) {
            return new HtmlJsonReBean((Object)"ok");
        }
        if (dataState != null && dataState.intValue() == errDataState.intValue()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        return null;
    }

    @RequestMapping(value={"checkContractPay.json"}, name="\u786e\u5b9a\u662f\u5426\u652f\u51fa\u6210\u529f")
    @ResponseBody
    public HtmlJsonReBean checkContractPay(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".checkContractPay", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        if (null == ocContractReDomain || 2 != ocContractReDomain.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateShippedPackageExpress.json"}, name="\u4fee\u6539\u5df2\u53d1\u8d27\u7269\u6d41\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateShippedPackageExpress(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            this.logger.error(CODE + ".updatePackageExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)packageExpress);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".updateShippedPackageExpress.ex", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5904\u7406\u5f02\u5e38");
        }
        ocPackageDomain.setPackageId(packageId);
        ocPackageDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.updatePackage(ocPackageDomain);
    }

    @RequestMapping(value={"confirmReceive.json"}, name="\u786e\u8ba4\u7b7e\u6536")
    @ResponseBody
    public HtmlJsonReBean confirmReceive(HttpServletRequest request, String contractBillcode, Integer packageId) {
        String tenantCode;
        Map getContractMap;
        OcContractReDomain contract;
        if (contractBillcode == null) {
            this.logger.error(CODE + ".confirmReceive", (Object)"param is null");
        }
        if ((contract = this.ocContractServiceRepository.getContractByCode(getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode = this.getTenantCode(request)}))) == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (ListUtil.isEmpty((Collection)contract.getPackageList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5305\u88f9\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        if (3 != contract.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        HtmlJsonReBean contractResult = this.sendContractNext(request, contractBillcode);
        if (null == contractResult || !contractResult.isSuccess()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7b7e\u6536\u5931\u8d25");
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @ResponseBody
    @RequestMapping(value={"calculateFreightFare.json"}, name="\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public HtmlJsonReBean calculateFreightFare(HttpServletRequest request, String shoppingGoodsIdStr, String skuIdStr, String areaCode) {
        BigDecimal fare;
        if (StringUtils.isBlank((String)shoppingGoodsIdStr) && StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".calculateFreightFare", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List shoppingGoodsIdList = null;
        List skuIdList = null;
        if (StringUtils.isNotBlank((String)shoppingGoodsIdStr)) {
            shoppingGoodsIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        } else {
            skuIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(skuIdStr, SkuDomain.class);
            if (null == skuIdList || skuIdList.isEmpty()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
            }
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setMemberBcode(userSession.getUserPcode());
        try {
            fare = this.getFreightFare(this.makeContractGoodsDomainList(shoppingGoodsIdList, skuIdList, ocContractDomain, null), areaCode);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".calculateFreightFare.ex", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
        }
        return new HtmlJsonReBean((Object)fare);
    }

    private HtmlJsonReBean sendContractNext(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }
}

