/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingDomain;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingReDomain;
import com.qjsoft.laser.controller.facade.dd.repository.DdFalgSettingServiceRepository;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundGoodsBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcRefundServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/oc/refund"}, name="\u9000\u6b3e\u670d\u52a1")
public class RefundCon
extends SpringmvcController {
    private static String CODE = "oc.refund.con";
    @Autowired
    private OcRefundServiceRepository ocRefundServiceRepository;
    @Autowired
    private DdFalgSettingServiceRepository ddFalgSettingServiceRepository;
    @Autowired
    private FileServiceRepository fileServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;

    protected String getContext() {
        return "refund";
    }

    @RequestMapping(value={"saveRefund.json"}, name="\u589e\u52a0\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRefund(HttpServletRequest request, String params) {
        if (null == params) {
            this.logger.error(CODE + ".params", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundBean ocRefundBean = (OcRefundBean)JsonUtil.buildNormalBinder().getJsonToObject(params, OcRefundBean.class);
        if (null == ocRefundBean || null == ocRefundBean.getOcRefundGoodsBeanList() || ocRefundBean.getOcRefundGoodsBeanList().isEmpty()) {
            this.logger.error(CODE + ".saveRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", ocRefundBean.getContractBillcode());
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractReDomain);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".ocContractDomain.ex", (Throwable)e);
            return new HtmlJsonReBean(CODE + ".ocContractDomain.ex", e.getMessage());
        }
        try {
            ocRefundDomain.setRefundCode(ocRefundBean.getRefundCode());
            ocRefundDomain.setRefundType(ocRefundBean.getRefundType());
            ocRefundDomain.setRefundMoney(ocRefundBean.getRefundMoney());
            ocRefundDomain.setRefundEx(ocRefundBean.getRefundEx());
            ocRefundDomain.setRefundMeo(ocRefundBean.getRefundMeo());
            ocRefundDomain.setAddressCode(ocRefundBean.getAddressCode());
            ocRefundDomain.setContractState(ocContractReDomain.getDataState());
            ocRefundDomain.setOcRefundFileDomainList(ocRefundBean.getOcRefundFileDomainList());
            ocRefundDomain.setOcRefundGoodsDomainList(this.makeRefundGoodsList(ocRefundBean.getOcRefundGoodsBeanList(), (OcContractDomain)ocContractReDomain));
            ocRefundDomain.setGoodsReceiptMem("");
            ocRefundDomain.setGoodsReceiptPhone("");
            ocRefundDomain.setGoodsReceiptArrdess("");
        }
        catch (Exception e) {
            this.logger.error(CODE + ".saveRefund.ex", (Throwable)e);
            return new HtmlJsonReBean(CODE + ".saveRefund.ex", e.getMessage());
        }
        return this.ocRefundServiceRepository.saveRefund(ocRefundDomain);
    }

    private List<OcRefundGoodsDomain> makeRefundGoodsList(List<OcRefundGoodsBean> ocRefundGoodsList, OcContractDomain ocContractDomain) throws Exception {
        if (null == ocRefundGoodsList) {
            this.logger.error(CODE + ".makeRefundGoodsList.ocRefundGoodsList", (Object)"param is null");
            return null;
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        Map<String, OcContractGoodsDomain> contractGoodsMap = this.contractGoodsMap(ocContractDomain.getGoodsList());
        for (OcRefundGoodsBean refundGoodsList : ocRefundGoodsList) {
            OcContractGoodsDomain ocContractGoods = contractGoodsMap.get(refundGoodsList.getContractGoodsCode());
            if (null == ocContractGoods) {
                throw new Exception("\u5546\u54c1\u4e3a\u7a7a");
            }
            if (refundGoodsList.getGoodsCamount().compareTo(ocContractGoods.getGoodsCamount().subtract(ocContractGoods.getContractGoodsRefnum())) > 0) {
                throw new Exception("\u5546\u54c1\u6570\u91cf\u4e0d\u8db3");
            }
            OcRefundGoodsDomain refundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)refundGoodsDomain, (Object)ocContractGoods);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".refundGoodsList.ex", (Throwable)e);
                return null;
            }
            refundGoodsDomain.setGoodsCamount(refundGoodsList.getGoodsCamount());
            refundGoodsDomain.setGoodsCweight(refundGoodsList.getGoodsCweight());
            refundGoodsDomain.setGoodsCode(refundGoodsList.getContractGoodsCode());
            refundGoodsDomain.setContractBillcode(refundGoodsList.getContractBillcode());
            refundGoodsDomain.setRefundCode(refundGoodsList.getRefundCode());
            ocRefundGoodsDomainList.add(refundGoodsDomain);
        }
        return ocRefundGoodsDomainList;
    }

    public Map<String, OcContractGoodsDomain> contractGoodsMap(List<OcContractGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error(CODE + ".contractGoodsMap.goodsList", (Object)"param is null");
            return null;
        }
        HashMap<String, OcContractGoodsDomain> map = new HashMap<String, OcContractGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            if (null == ocContractGoodsDomain.getContractGoodsRefnum()) {
                ocContractGoodsDomain.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsCamount()) {
                ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
            }
            map.put(ocContractGoodsDomain.getContractGoodsCode(), ocContractGoodsDomain);
        }
        return map;
    }

    @RequestMapping(value={"getRefund.json"}, name="\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain getRefund(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error(CODE + ".getRefund", (Object)"param is null");
            return null;
        }
        return this.ocRefundServiceRepository.getRefund(refundId);
    }

    @RequestMapping(value={"getRefundByCode.json"}, name="\u6839\u636eCODE\u83b7\u53d6\u9000\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcRefundReDomain getRefundByCode(HttpServletRequest request, String refundCode) {
        if (null == refundCode) {
            this.logger.error(CODE + ".getRefundByCode.refundCode", (Object)"param is null");
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refundCode", refundCode);
        map.put("tenantCode", this.getTenantCode(request));
        return this.ocRefundServiceRepository.getRefundByCode(map);
    }

    @RequestMapping(value={"updateRefund.json"}, name="\u66f4\u65b0\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRefund(HttpServletRequest request, OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error(CODE + ".updateRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocRefundDomain.setTenantCode(this.getTenantCode(request));
        return this.ocRefundServiceRepository.updateRefund(ocRefundDomain);
    }

    @RequestMapping(value={"deleteRefund.json"}, name="\u5220\u9664\u9000\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRefund(Integer refundId) {
        if (StringUtils.isBlank((Integer)refundId)) {
            this.logger.error(CODE + ".deleteRefund", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefundServiceRepository.deleteRefund(refundId);
    }

    @RequestMapping(value={"queryRefundPage.json"}, name="\u5546\u5bb6\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryRefundPageBuy.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundPageBuy(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"queryRefundPagePlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u9000\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRefundReDomain> queryRefundPagePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRefundServiceRepository.queryRefundReDomainPage(param);
    }

    @RequestMapping(value={"updateRefundState.json"}, name="\u66f4\u65b0\u9000\u6b3e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRefundState(String refundId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)refundId)) {
            this.logger.error(CODE + ".updateRefundState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRefundServiceRepository.updateRefundState(Integer.valueOf(refundId), dataState, oldDataState);
    }

    @RequestMapping(value={"uploadRefFile.json"}, name="\u4e0a\u4f20\u9000\u8d27\u6587\u4ef6")
    @ResponseBody
    public FmFileReDomainBean uploadRefFile(MultipartFile file, HttpServletRequest request) {
        if (null == file) {
            this.logger.error(CODE + ".uploadRefFile", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        String fileSort = "FILE_02";
        return this.fileServiceRepository.saveFile(file, tenantCode, fileSort);
    }

    @RequestMapping(value={"arrGoods.json"}, name="\u5230\u8d27")
    @ResponseBody
    public HtmlJsonReBean arrGoods(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".arrGoods", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".arrGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundServiceRepository.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"sendGoods.json"}, name="\u53d1\u8d27\uff08\u586b\u5199\u7269\u6d41\u4fe1\u606f\uff09")
    @ResponseBody
    public HtmlJsonReBean sendGoods(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".sendGoods", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".sendGoods", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        return this.ocRefundServiceRepository.sendRefundRes(refundCode, tenantCode, map);
    }

    @RequestMapping(value={"audit.json"}, name="\u5ba1\u6838\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean audit(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".audit", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".audit", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundServiceRepository.getRefundByCode(codeMap);
        if (refundReDomain.getDataState() == 0) {
            return this.ocRefundServiceRepository.sendRefundRes(refundCode, tenantCode, map);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5df2\u5ba1\u6838");
    }

    @RequestMapping(value={"res.json"}, name="\u5ba1\u6838\u4e0d\u901a\u8fc7")
    @ResponseBody
    public HtmlJsonReBean res(HttpServletRequest request, @RequestParam Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            this.logger.error(CODE + ".audit", (Object)"map is null");
            return null;
        }
        String refundCode = (String)map.get("refundCode");
        if (StringUtils.isBlank((String)refundCode)) {
            this.logger.error(CODE + ".res", (Object)"param is null");
            return null;
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("refundCode", refundCode);
        codeMap.put("tenantCode", tenantCode);
        OcRefundReDomain refundReDomain = this.ocRefundServiceRepository.getRefundByCode(codeMap);
        if (refundReDomain.getDataState() == 0) {
            return this.ocRefundServiceRepository.updateRefundRes(refundCode, tenantCode, map);
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5df2\u5ba1\u6838");
    }

    @RequestMapping(value={"queryRefCause.json"}, name="\u83b7\u53d6\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public List<DdFalgSettingReDomain> queryRefCause(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        return this.queryRefCause(tenantCode);
    }

    @RequestMapping(value={"saveFalgSetting.json"}, name="\u589e\u52a0\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public HtmlJsonReBean saveFalgSetting(HttpServletRequest request, DdFalgSettingDomain ddFalgSettingDomain) {
        if (null == ddFalgSettingDomain) {
            this.logger.error(CODE + ".saveFalgSetting", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ddFalgSettingDomain.setFlagSettingScope("flagSettingScope");
        ddFalgSettingDomain.setFlagSettingType("refCause");
        ddFalgSettingDomain.setTenantCode(this.getTenantCode(request));
        return this.ddFalgSettingServiceRepository.saveFalgSetting(ddFalgSettingDomain);
    }

    @RequestMapping(value={"deleteFalgSetting.json"}, name="\u5220\u9664\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public HtmlJsonReBean deleteFalgSetting(String flagSettingId) {
        if (StringUtils.isBlank((String)flagSettingId)) {
            this.logger.error(CODE + ".deleteFalgSetting", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ddFalgSettingServiceRepository.deleteFalgSetting(Integer.valueOf(flagSettingId));
    }

    @RequestMapping(value={"updateFalgSetting.json"}, name="\u4fee\u6539\u9000\u8d27\u7406\u7531")
    @ResponseBody
    public HtmlJsonReBean updateFalgSetting(HttpServletRequest request, DdFalgSettingDomain ddFalgSettingDomain) {
        if (null == ddFalgSettingDomain) {
            this.logger.error(CODE + ".saveFalgSetting", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ddFalgSettingDomain.setFlagSettingScope("flagSettingScope");
        ddFalgSettingDomain.setFlagSettingType("refCause");
        ddFalgSettingDomain.setTenantCode(this.getTenantCode(request));
        return this.ddFalgSettingServiceRepository.updateFalgSetting(ddFalgSettingDomain);
    }

    private List<DdFalgSettingReDomain> queryRefCause(String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flagSettingScope", "refundEx");
        map.put("flagSettingType", "refundEx");
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ddFalgSettingServiceRepository.queryFalgSettingPage(map);
        if (qlist == null) {
            return null;
        }
        return qlist.getRows();
    }
}

