/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.common.send.PostParamMap;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcPackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.SkuDomain;
import com.qjsoft.laser.controller.facade.oc.domain.pojo.PackageExpressDomain;
import com.qjsoft.laser.controller.facade.oc.enumc.ContractType;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractEngineServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractSubServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.facade.pro.domain.ProProjectCskuDomain;
import com.qjsoft.laser.controller.facade.pro.repository.ProProjectCskuServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.upm.repository.UpmUpointsServiceRepository;
import com.qjsoft.laser.controller.facade.wl.repository.WlFreightTemServiceRepository;
import com.qjsoft.laser.controller.order.domain.FareBean;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contract"}, name="\u8ba2\u5355\u670d\u52a1")
public class ContractCon
extends SpringmvcController {
    private static String CODE = "oc.contract.con";
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;
    @Autowired
    private WlFreightTemServiceRepository wlFreightTemServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;
    @Autowired
    private UpmUpointsServiceRepository upmUpointsServiceRepository;
    @Autowired
    private OcContractEngineServiceRepository ocContractEngineServiceRepository;
    @Autowired
    private ProProjectCskuServiceRepository proProjectCskuServiceRepository;
    @Autowired
    private OcContractSubServiceRepository ocContractSubServiceRepository;

    protected String getContext() {
        return "contract";
    }

    @RequestMapping(value={"saveContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContract(HttpServletRequest request, String orderDomainStr) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.CON.getCode());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveEaseContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1(\u7b80\u6613)")
    @ResponseBody
    public HtmlJsonReBean saveEaseContract(HttpServletRequest request, String orderDomainStr) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.PROJECT.getCode());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveGiftContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1(\u793c\u5305\u5151\u6362)")
    @ResponseBody
    public HtmlJsonReBean saveGiftContract(HttpServletRequest request, String orderDomainStr) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.GIFTEX.getCode());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveGiftExchangeContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1(\u793c\u5305\u8d2d\u4e70)")
    @ResponseBody
    public HtmlJsonReBean saveGiftExchangeContract(HttpServletRequest request, String orderDomainStr) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.GIFT.getCode());
        return htmlJsonReBean;
    }

    private HtmlJsonReBean createOrder(HttpServletRequest request, String orderDomainStr, String contractType) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".saveContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".saveContract", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveContract", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocShoppingServiceRepository.createOcOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request));
    }

    @RequestMapping(value={"getContract.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcContractReDomain getContract(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.ocContractServiceRepository.getContract(Integer.valueOf(contractId));
    }

    @RequestMapping(value={"updateContract.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateContract(HttpServletRequest request, OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error(CODE + ".updateContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.updateContract(ocContractDomain);
    }

    @RequestMapping(value={"deleteContract.json"}, name="\u5220\u9664\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteContract(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".deleteContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.deleteContract(Integer.valueOf(contractId));
    }

    @RequestMapping(value={"queryContractGoodsPage.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractGoodsPage(param);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u67e5\u8be2\u5546\u5bb6\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPage(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"queryContractPagePlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPagePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"queryContractPageC.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageC(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    @RequestMapping(value={"updateContractState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractState(String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId) || dataState == null) {
            this.logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractState(Integer.valueOf(contractId), dataState, oldDataState);
    }

    @RequestMapping(value={"offlinePayContractState.json"}, name="\u7ebf\u4e0b\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean offlinePayContractState(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".offlinePayContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractStateExtend(contractId, Integer.valueOf(2), Integer.valueOf(1));
    }

    @RequestMapping(value={"cancelContractC.json"}, name="\u53d6\u6d88\u8ba2\u5355  C\u7aef")
    @ResponseBody
    public HtmlJsonReBean cancelContractC(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractStateExtend(contractId, Integer.valueOf(-1), Integer.valueOf(1));
    }

    @RequestMapping(value={"getContractByCode.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractByCode(HttpServletRequest request) {
        Map param = this.getMemberBcodeQueryMapParams(request);
        return this.ocContractServiceRepository.getContractByCode(param);
    }

    @RequestMapping(value={"updateContractSubMoney.json"}, name="\u4fee\u6539\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean updateContractSubMoney(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error(CODE + ".saveContracNext", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractSubMoney(contractId, subMoney, remark);
    }

    @RequestMapping(value={"syncContractState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractState(HttpServletRequest request, String contractBillcode) {
        return this.getContrant(request, contractBillcode, -1, 1);
    }

    @RequestMapping(value={"syncContractBatchState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ocContractServiceRepository.queryContractPage(map);
        if (null == qlist || null == qlist.getRows()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u6570\u636e\u4e3a\u7a7a");
        }
        Integer errDataState = -1;
        Integer newDataState = 1;
        boolean flag = true;
        for (OcContractReDomain OcContractReDomain2 : qlist.getRows()) {
            HtmlJsonReBean htmlJsonReBean = this.getContrant(request, OcContractReDomain2.getContractBillcode(), errDataState, newDataState);
            if (null == htmlJsonReBean || htmlJsonReBean.isSuccess()) continue;
            flag = false;
        }
        if (flag) {
            return new HtmlJsonReBean((Object)"ok");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5931\u8d25");
    }

    @RequestMapping(value={"syncContractPayState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractPayState(HttpServletRequest request, String contractBillcode, String contractSubCode) {
        if (StringUtils.isNotBlank((String)contractSubCode)) {
            return this.getContrantSub(request, contractBillcode, contractSubCode, -1, 1);
        }
        return this.getContrant(request, contractBillcode, -1, 2);
    }

    @RequestMapping(value={"syncContractBatchPayState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchPayState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ocContractServiceRepository.queryContractPage(map);
        if (null == qlist || null == qlist.getRows()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u6570\u636e\u4e3a\u7a7a");
        }
        Integer errDataState = -1;
        Integer newDataState = 2;
        boolean flag = true;
        for (OcContractReDomain OcContractReDomain2 : qlist.getRows()) {
            HtmlJsonReBean htmlJsonReBean = this.getContrant(request, OcContractReDomain2.getContractBillcode(), errDataState, newDataState);
            if (null == htmlJsonReBean || htmlJsonReBean.isSuccess()) continue;
            flag = false;
        }
        if (flag) {
            return new HtmlJsonReBean((Object)"ok");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5931\u8d25");
    }

    private HtmlJsonReBean getContrantSub(HttpServletRequest request, String contractBillcode, String contractSubCode, Integer errDataState, Integer newDataState) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractSubCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        long currentTime = System.currentTimeMillis();
        long expireMillis = 10000L;
        String DisKey = "ocContractSub-state-" + contractSubCode + tenantCode;
        Integer dataState = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.checkDataState(errDataState, newDataState, DisKey, map);
        if (null != htmlJsonReBean) {
            return htmlJsonReBean;
        }
        while (dataState == null || dataState.intValue() != newDataState.intValue() && dataState.intValue() != errDataState.intValue()) {
            block13: {
                if (System.currentTimeMillis() - currentTime > 10000L) {
                    OcContractSubReDomain ocContractSubReDomain = this.ocContractSubServiceRepository.getContractSubByCode(tenantCode, contractSubCode);
                    if (ocContractSubReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractSubCode));
                        break;
                    }
                    dataState = ocContractSubReDomain.getDataState();
                    this.logger.debug(CODE + ".syncContractState.expire", (Object)("\u4e0b\u5355\u5904\u7406\u8d85\u65f6\uff1a" + contractBillcode + ",\u6570\u636e\u5e93\u72b6\u6001\uff1a" + dataState));
                    if (dataState != null && dataState.intValue() == newDataState.intValue()) {
                        OcContractReDomain contractReDomain = this.ocContractServiceRepository.getContractByCode(map);
                        if (contractReDomain == null) {
                            this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                            break;
                        }
                        this.sendOrderBigData(contractReDomain);
                        return new HtmlJsonReBean(this.getContract(contractReDomain));
                    }
                    if (dataState == null || dataState.intValue() != errDataState.intValue()) break;
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    this.logger.error(CODE + ".syncContractState.sleep.ex", (Throwable)e);
                }
                try {
                    String str = SupDisUtil.getRemot((String)DisKey);
                    if (!StringUtils.isNotBlank((String)str)) break block13;
                    dataState = Integer.valueOf(str);
                }
                catch (NumberFormatException e) {
                    this.logger.error(CODE, (Object)("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + contractBillcode));
                    continue;
                }
            }
            if (dataState != null && dataState.intValue() == newDataState.intValue()) {
                OcContractReDomain contractReDomain = this.ocContractServiceRepository.getContractByCode(map);
                if (contractReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                    break;
                }
                this.sendOrderBigData(contractReDomain);
                return new HtmlJsonReBean(this.getContract(contractReDomain));
            }
            if (dataState == null || dataState.intValue() != errDataState.intValue()) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u51fa\u9519\u4e86\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
    }

    private HtmlJsonReBean getContrant(HttpServletRequest request, String contractBillcode, Integer errDataState, Integer newDataState) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        long currentTime = System.currentTimeMillis();
        long expireMillis = 10000L;
        String DisKey = "ocContract-state-" + contractBillcode + tenantCode;
        Integer dataState = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.checkDataState(errDataState, newDataState, DisKey, map);
        if (null != htmlJsonReBean) {
            return htmlJsonReBean;
        }
        while (dataState == null || dataState.intValue() != newDataState.intValue() && dataState.intValue() != errDataState.intValue()) {
            OcContractReDomain contractReDomain;
            block12: {
                if (System.currentTimeMillis() - currentTime > 10000L) {
                    contractReDomain = this.ocContractServiceRepository.getContractByCode(map);
                    if (contractReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                        break;
                    }
                    dataState = contractReDomain.getDataState();
                    this.logger.debug(CODE + ".syncContractState.expire", (Object)("\u4e0b\u5355\u5904\u7406\u8d85\u65f6\uff1a" + contractBillcode + ",\u6570\u636e\u5e93\u72b6\u6001\uff1a" + dataState));
                    if (dataState != null && dataState.intValue() == newDataState.intValue()) {
                        this.sendOrderBigData(contractReDomain);
                        return new HtmlJsonReBean(this.getContract(contractReDomain));
                    }
                    if (dataState == null || dataState.intValue() != errDataState.intValue()) break;
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    this.logger.error(CODE + ".syncContractState.sleep.ex", (Throwable)e);
                }
                try {
                    String str = SupDisUtil.getRemot((String)DisKey);
                    if (!StringUtils.isNotBlank((String)str)) break block12;
                    dataState = Integer.valueOf(str);
                }
                catch (NumberFormatException e) {
                    this.logger.error(CODE, (Object)("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + contractBillcode));
                    continue;
                }
            }
            if (dataState != null && dataState.intValue() == newDataState.intValue()) {
                contractReDomain = this.ocContractServiceRepository.getContractByCode(map);
                if (contractReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                    break;
                }
                this.sendOrderBigData(contractReDomain);
                return new HtmlJsonReBean(this.getContract(contractReDomain));
            }
            if (dataState == null || dataState.intValue() != errDataState.intValue()) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u51fa\u9519\u4e86\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355");
    }

    private Map<String, Object> getContract(OcContractReDomain contractReDomain) {
        if (null == contractReDomain) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractReDomain.getContractBillcode());
        map.put("contractBbillcode", contractReDomain.getContractBbillcode());
        map.put("contractType", contractReDomain.getContractType());
        map.put("contractBlance", contractReDomain.getContractBlance());
        map.put("contractPmode", contractReDomain.getContractPmode());
        map.put("contractPaygmoney", contractReDomain.getContractPayamoney());
        map.put("dataBmoney", contractReDomain.getDataBmoney());
        return map;
    }

    public void sendOrderBigData(OcContractReDomain contractReDomain) {
        if (null == contractReDomain) {
            return;
        }
        String bigdataFlag = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(contractReDomain.getTenantCode() + "-bigdata-bigdataflag"));
        if (StringUtils.isBlank((String)bigdataFlag) || !"true".equals(bigdataFlag)) {
            return;
        }
        contractReDomain.setPackageList(null);
        contractReDomain.setOcContractSettlList(null);
        String value = "{\"paasLabel\":\"orderPayment\",\"message\":" + JsonUtil.buildNormalBinder().toJson((Object)contractReDomain) + "}";
        PostParamMap pmap = new PostParamMap("kafka.adapter.sendProducerInfo");
        pmap.putParam("topic", (Object)"paas_business");
        pmap.putParam("value", (Object)value);
        this.htmlIBaseService.sendMesReBeanInAsync(pmap);
    }

    private HtmlJsonReBean checkDataState(Integer errDataState, Integer newDataState, String DisKey, Map<String, Object> map) {
        String str = SupDisUtil.getRemot((String)DisKey);
        Integer dataState = null;
        if (StringUtils.isNotBlank((String)str)) {
            dataState = Integer.valueOf(str);
        }
        if (dataState != null && dataState.intValue() == newDataState.intValue()) {
            OcContractReDomain contractReDomain = this.ocContractServiceRepository.getContractByCode(map);
            if (contractReDomain == null) {
                this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + map.toString()));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
            }
            return new HtmlJsonReBean(this.getContract(contractReDomain));
        }
        if (dataState != null && dataState.intValue() == errDataState.intValue()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        return null;
    }

    @RequestMapping(value={"checkContractPay.json"}, name="\u786e\u5b9a\u662f\u5426\u652f\u51fa\u6210\u529f")
    @ResponseBody
    public HtmlJsonReBean checkContractPay(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".checkContractPay", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        if (null == ocContractReDomain || 2 != ocContractReDomain.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"updateShippedPackageExpress.json"}, name="\u4fee\u6539\u5df2\u53d1\u8d27\u7269\u6d41\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateShippedPackageExpress(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            this.logger.error(CODE + ".updatePackageExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)packageExpress);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".updateShippedPackageExpress.ex", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5904\u7406\u5f02\u5e38");
        }
        ocPackageDomain.setPackageId(packageId);
        ocPackageDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.updatePackage(ocPackageDomain);
    }

    @RequestMapping(value={"confirmReceive.json"}, name="\u786e\u8ba4\u7b7e\u6536")
    @ResponseBody
    public HtmlJsonReBean confirmReceive(HttpServletRequest request, String contractBillcode, Integer packageId) {
        String tenantCode;
        Map getContractMap;
        OcContractReDomain contract;
        if (contractBillcode == null) {
            this.logger.error(CODE + ".confirmReceive", (Object)"param is null");
        }
        if ((contract = this.ocContractServiceRepository.getContractByCode(getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode = this.getTenantCode(request)}))) == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (ListUtil.isEmpty((Collection)contract.getPackageList())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5305\u88f9\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        if (3 != contract.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        HtmlJsonReBean contractResult = this.sendContractNext(request, contractBillcode);
        if (null == contractResult || !contractResult.isSuccess()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7b7e\u6536\u5931\u8d25");
        }
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"confirmReceivable.json"}, name="\u786e\u8ba4\u6536\u6b3e")
    @ResponseBody
    public HtmlJsonReBean confirmReceivable(HttpServletRequest request, String contractBillcode) {
        String tenantCode;
        Map getContractMap;
        OcContractReDomain contract;
        if (contractBillcode == null) {
            this.logger.error(CODE + ".confirmReceive", (Object)"param is null");
        }
        if ((contract = this.ocContractServiceRepository.getContractByCode(getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode = this.getTenantCode(request)}))) == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        HtmlJsonReBean contractResult = this.sendContractNext(request, contractBillcode);
        if (null == contractResult || !contractResult.isSuccess()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7b7e\u6536\u5931\u8d25");
        }
        List ocContractGoodsDomainList = contract.getGoodsList();
        if (ocContractGoodsDomainList == null) {
            this.logger.error("\u53c2\u6570\u4e3a\u7a7a");
        }
        ArrayList<ProProjectCskuDomain> proProjectCskuDomainList = new ArrayList<ProProjectCskuDomain>();
        ProProjectCskuDomain proProjectCskuDomain = new ProProjectCskuDomain();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)proProjectCskuDomain, (Object)ocContractGoodsDomain);
                proProjectCskuDomain.setProjectCskuOpcode(ocContractGoodsDomain.getContractGoodsCode());
                proProjectCskuDomainList.add(proProjectCskuDomain);
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
            }
        }
        this.proProjectCskuServiceRepository.saveProjectCskuBatch(proProjectCskuDomainList);
        return new HtmlJsonReBean((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @ResponseBody
    @RequestMapping(value={"calculateFreightFareBatch.json"}, name="\u6279\u91cf\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public HtmlJsonReBean calculateFreightFareBatch(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List fareBeanList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, FareBean.class);
        if (ListUtil.isEmpty((Collection)fareBeanList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        String areaCode = null;
        String shoppingGoodsIdStr = null;
        String skuIdStr = null;
        BigDecimal fare = new BigDecimal(0);
        BigDecimal fare_temp = new BigDecimal(0);
        HtmlJsonReBean htmlJsonReBean = null;
        for (FareBean fareBean : fareBeanList) {
            areaCode = fareBean.getAreaCode();
            if (StringUtils.isNotBlank((String)fareBean.getShoppingGoodsIdStr())) {
                shoppingGoodsIdStr = fareBean.getShoppingGoodsIdStr();
            } else {
                skuIdStr = fareBean.getSkuIdStr();
            }
            htmlJsonReBean = this.calculateFreightFare(request, shoppingGoodsIdStr, skuIdStr, areaCode);
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                this.logger.error(CODE + ".calculateFreightFareBatch", (Object)"param is null");
                return htmlJsonReBean;
            }
            fare_temp = (BigDecimal)htmlJsonReBean.getDataObj();
            fare = fare.add(fare_temp);
        }
        return new HtmlJsonReBean((Object)fare);
    }

    @ResponseBody
    @RequestMapping(value={"calculateFreightFare.json"}, name="\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public HtmlJsonReBean calculateFreightFare(HttpServletRequest request, String shoppingGoodsIdStr, String skuIdStr, String areaCode) {
        BigDecimal fare;
        if (StringUtils.isBlank((String)shoppingGoodsIdStr) && StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".calculateFreightFare", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List shoppingGoodsIdList = null;
        List skuIdList = null;
        if (StringUtils.isNotBlank((String)shoppingGoodsIdStr)) {
            shoppingGoodsIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        } else {
            skuIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(skuIdStr, SkuDomain.class);
            if (null == skuIdList || skuIdList.isEmpty()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
            }
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setMemberBcode(userSession.getUserPcode());
        try {
            fare = this.ocContractServiceRepository.getFreightFare(this.ocContractServiceRepository.makeContractGoodsDomainList(shoppingGoodsIdList, skuIdList, ocContractDomain, null), areaCode);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".calculateFreightFare.ex", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
        }
        return new HtmlJsonReBean((Object)fare);
    }

    private HtmlJsonReBean sendContractNext(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }
}

