/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;

public class Util {
    public static String makeSign(String md5Key, Map<String, String> params) {
        String preStr = Util.buildSignString(params);
        String text = preStr + md5Key;
        System.out.println("\u4ee3\u7b7e\u5b57\u7b26\u4e32\uff1a" + text);
        return DigestUtils.sha256Hex((byte[])Util.getContentBytes(text)).toUpperCase();
    }

    public static String genMerOrderId(String msgId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        sdf.format(new Date());
        String date = sdf.format(new Date());
        Random random = new Random();
        String rand = random.nextInt(7) + "";
        return msgId + date + rand;
    }

    public static String buildUrlParametersStr(Map<String, String> paramMap) {
        StringBuffer buffer = new StringBuffer();
        Iterator<Map.Entry<String, String>> iterator = paramMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            buffer.append(entry.getKey().toString()).append("=");
            try {
                if (entry.getValue() != null && !entry.getValue().toString().equals("")) {
                    buffer.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            buffer.append(iterator.hasNext() ? "&" : "");
        }
        return buffer.toString();
    }

    private static String buildSignString(Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return "";
        }
        ArrayList<String> keys = new ArrayList<String>(params.size());
        for (String key : params.keySet()) {
            if ("sign".equals(key)) continue;
            keys.add(key);
        }
        Collections.sort(keys);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                buf.append(key + "=" + value);
                continue;
            }
            buf.append(key + "=" + value + "&");
        }
        return buf.toString();
    }

    private static byte[] getContentBytes(String content) {
        try {
            return content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef");
        }
    }

    public static String requestTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = sdf.format(new Date());
        return date;
    }
}

