/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcConsumeBigData;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.pojo.PackageExpressDomain;
import com.qjsoft.laser.controller.facade.oc.enumc.ContractType;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.pm.domain.PmUserCouponReDomain;
import com.qjsoft.laser.controller.order.controller.ContractComCon;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contract"}, name="\u7528\u6237\u7aef\u8ba2\u5355\u670d\u52a1")
public class ContractCon
extends ContractComCon {
    private static String CODE = "oc.contract.con";

    @Override
    protected String getContext() {
        return "contract";
    }

    @RequestMapping(value={"saveExContractGoods.json"}, name="\u8ba2\u5355\u6362\u8d27\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveExContractGoods(HttpServletRequest request, String orderGoodsDomainStr) {
        if (StringUtils.isBlank((String)orderGoodsDomainStr)) {
            this.logger.error(CODE + ".saveExContractGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.saveExContractGoodsCom(request, orderGoodsDomainStr);
    }

    @RequestMapping(value={"saveContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContract(HttpServletRequest request, String orderDomainStr) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.CON.getCode());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveEaseContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1(\u7b80\u6613)")
    @ResponseBody
    public HtmlJsonReBean saveEaseContract(HttpServletRequest request, String orderDomainStr) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.PROJECT.getCode());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveGiftContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1(\u793c\u5305\u5151\u6362)")
    @ResponseBody
    public HtmlJsonReBean saveGiftContract(HttpServletRequest request, String orderDomainStr) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.GIFTEX.getCode());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"saveGiftExchangeContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1(\u793c\u5305\u8d2d\u4e70)")
    @ResponseBody
    public HtmlJsonReBean saveGiftExchangeContract(HttpServletRequest request, String orderDomainStr) {
        HtmlJsonReBean htmlJsonReBean = this.createOrder(request, orderDomainStr, ContractType.GIFT.getCode());
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getContract.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcContractReDomain getContract(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"updateContract.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateContract(HttpServletRequest request, OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error(CODE + ".updateContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractCom(request, ocContractDomain);
    }

    @RequestMapping(value={"deleteContract.json"}, name="\u5220\u9664\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteContract(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".deleteContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.deleteContractCom(contractId);
    }

    @RequestMapping(value={"queryContractGoodsPage.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractGoodsPageCom(request, param);
    }

    @RequestMapping(value={"queryContractForMem.json"}, name="\u5546\u5bb6\u8ba2\u5355\u5217\u8868-\u5546\u5bb6\u8ba2\u5355\u5217\u8868\u9875")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForMem(HttpServletRequest request) {
        return this.queryContractPageS(request);
    }

    @RequestMapping(value={"queryContractPage.json"}, name="\u67e5\u8be2\u5546\u5bb6\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPage(HttpServletRequest request) {
        return this.queryContractPageS(request);
    }

    @RequestMapping(value={"queryContractPageForPlat.json"}, name="\u67e5\u8be2\u5546\u5bb6\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageForPlat(HttpServletRequest request) {
        return this.queryContractPageS(request);
    }

    private SupQueryResult<OcContractReDomain> queryContractPageS(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPagePlat.json"}, name="\u5e73\u53f0\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPagePlat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageC.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageC(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageCchannelCode.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868\u52a0\u5165\u6e20\u9053\u8fc7\u6ee4")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageCchannelCode(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("channelCode", this.getNowChannel(request));
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateContractState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractState(String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId) || dataState == null) {
            this.logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(Integer.valueOf(contractId), dataState, oldDataState);
    }

    @RequestMapping(value={"offlinePayContractState.json"}, name="\u7ebf\u4e0b\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean offlinePayContractState(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".offlinePayContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, OcContractServiceRepository.dataState_2, OcContractServiceRepository.dataState_1);
    }

    @RequestMapping(value={"cancelContractC.json"}, name="\u53d6\u6d88\u8ba2\u5355  C\u7aef")
    @ResponseBody
    public HtmlJsonReBean cancelContractC(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, OcContractServiceRepository.dataState_no, OcContractServiceRepository.dataState_1);
    }

    @RequestMapping(value={"getContractByCode.json"}, name="\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractByCode(HttpServletRequest request) {
        Map param = this.getMemberBcodeQueryMapParams(request);
        return this.getContractByCodeCom(request, param);
    }

    @RequestMapping(value={"getContractByCodeForGroup.json"}, name="\u56e2\u957f\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractByCodeForGroup(HttpServletRequest request) {
        Map param = this.getQueryMapParams(request);
        return this.getContractByCodeCom(request, param);
    }

    @RequestMapping(value={"getContractByCodeForService.json"}, name="\u670d\u52a1\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractByCodeForService(HttpServletRequest request) {
        Map param = this.getQueryMapParams(request);
        return this.getContractByCodeCom(request, param);
    }

    @RequestMapping(value={"updateContractSubMoney.json"}, name="\u4fee\u6539\u4ef7\u683c")
    @ResponseBody
    public HtmlJsonReBean updateContractSubMoney(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error(CODE + ".saveContracNext", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractSubMoneyCom(contractId, subMoney, remark);
    }

    @RequestMapping(value={"syncContractState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractState(HttpServletRequest request, String contractBillcode) {
        return this.getContrant(request, contractBillcode, -1, 1);
    }

    @RequestMapping(value={"syncContractBatchState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        return this.syncContractBatchStateCom(request, contractBbillcode);
    }

    @RequestMapping(value={"syncContractPayState.json"}, name="\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractPayState(HttpServletRequest request, String contractBillcode, String contractSubCode) {
        return this.syncContractPayStateCom(request, contractBillcode, contractSubCode);
    }

    @RequestMapping(value={"syncContractBatchPayState.json"}, name="\u6279\u6b21\u53f7\u540c\u6b65\u7b49\u5f85\u8ba2\u5355\u652f\u4ed8\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean syncContractBatchPayState(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        return this.syncContractBatchPayStateCom(request, contractBbillcode);
    }

    @RequestMapping(value={"checkContractPay.json"}, name="\u786e\u5b9a\u662f\u5426\u652f\u51fa\u6210\u529f")
    @ResponseBody
    public HtmlJsonReBean checkContractPay(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".checkContractPay", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.checkContractPayCom(request, contractBillcode);
    }

    @RequestMapping(value={"updateShippedPackageExpress.json"}, name="\u4fee\u6539\u5df2\u53d1\u8d27\u7269\u6d41\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateShippedPackageExpress(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            this.logger.error(CODE + ".updatePackageExpress", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShippedPackageExpressCom(request, packageId, packageExpress);
    }

    @RequestMapping(value={"confirmReceive.json"}, name="\u786e\u8ba4\u7b7e\u6536")
    @ResponseBody
    public HtmlJsonReBean confirmReceive(HttpServletRequest request, String contractBillcode, Integer packageId) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".confirmReceive", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractServiceRepository.dataState_3);
    }

    @RequestMapping(value={"confirmReceivable.json"}, name="\u786e\u8ba4\u6536\u6b3e")
    @ResponseBody
    public HtmlJsonReBean confirmReceivable(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".confirmReceive.contractBillcode", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractServiceRepository.dataState_1);
    }

    @ResponseBody
    @RequestMapping(value={"calculateFreightFareBatch.json"}, name="\u6279\u91cf\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public HtmlJsonReBean calculateFreightFareBatch(HttpServletRequest request, String paramStr) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.calculateFreightFareBatchCom(request, paramStr, null);
    }

    @ResponseBody
    @RequestMapping(value={"calculateFreightFare.json"}, name="\u8ba1\u7b97\u7269\u6d41\u8d39\u7528")
    public HtmlJsonReBean calculateFreightFare(HttpServletRequest request, String shoppingGoodsIdStr, String skuIdStr, String areaCode) {
        if (StringUtils.isBlank((String)shoppingGoodsIdStr) && StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".calculateFreightFare", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.calculateFreightFareCom(request, shoppingGoodsIdStr, skuIdStr, areaCode, null);
    }

    @RequestMapping(value={"CaExistence.json"}, name="CA\u5b58\u5728\u65f6")
    @ResponseBody
    public HtmlJsonReBean CaExistence(HttpServletRequest request, String contractBillcode, String CallbackURL) throws Exception {
        if (StringUtils.isBlank((String)CallbackURL)) {
            this.logger.error(CODE + ".CaExistence", (Object)("CallbackURL is===-===" + contractBillcode));
        }
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".CaExistence", (Object)("contractBillcode is==-===" + contractBillcode));
        }
        return this.caExistenceCom(request, contractBillcode, CallbackURL);
    }

    @RequestMapping(value={"queryContractPagePlatBuild.json"}, name="\u67e5\u8be2\u5e73\u53f0\u623f\u5c4b\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPagePlatBuild(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateContractStatePlatBuild.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001(\u5e73\u53f0\u623f\u5c4b)")
    @ResponseBody
    public HtmlJsonReBean updateContractStatePlatBuild(HttpServletRequest request, String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId) || dataState == null) {
            this.logger.error(CODE + ".updateContractStatePlatBuild", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.sendContractNextCom(request, Integer.valueOf(contractId), oldDataState);
    }

    @RequestMapping(value={"confirmReceivablePlatBuild.json"}, name="\u786e\u8ba4\u6536\u6b3e\uff08\u5e73\u53f0\u623f\u5c4b\uff09")
    @ResponseBody
    public HtmlJsonReBean confirmReceivablePlatBuild(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".confirmReceivablePlatBuild.contractBillcode", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractServiceRepository.dataState_1);
    }

    @RequestMapping(value={"queryContractPageBuiMat.json"}, name="\u5168\u6e20\u9053\u5efa\u6750\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBuiMat(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageBuiMats.json"}, name="\u5168\u6e20\u9053\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBuiMats(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageBuiMatsBymem.json"}, name="\u5168\u6e20\u9053\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868\u8fc7\u6ee4\u5f53\u524d\u767b\u5f55\u8005")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBuiMatsBymem(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractStorePage.json"}, name="\u95e8\u5e97\u67e5\u770b\u5168\u6e20\u9053\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractStorePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("memberCcode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractStoreForBalance.json"}, name="\u95e8\u5e97\u67e5\u770b\u5168\u6e20\u9053\u8ba2\u5355\u5bf9\u8d26\u5217\u8868")
    @ResponseBody
    public List<OcContractReDomain> queryContractStoreForBalance(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        return this.queryContractPlatForBalanceCom(request, userSession.getUserPcode());
    }

    @RequestMapping(value={"queryContractPlatForBalance.json"}, name="\u4e2d\u53f0\u67e5\u770b\u5168\u6e20\u9053\u8ba2\u5355\u5bf9\u8d26\u5217\u8868")
    @ResponseBody
    public List<OcContractReDomain> queryContractPlatForBalance(HttpServletRequest request, String memberCcode) {
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        return this.queryContractPlatForBalanceCom(request, memberCcode);
    }

    @RequestMapping(value={"queryContractMyPage.json"}, name="\u67e5\u770b\u81ea\u5df1\u5168\u6e20\u9053\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractMyPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null != param) {
            param.put("memberCode", userSession.getUserPcode());
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateShippedPackageExpressBuiMat.json"}, name="\u4fee\u6539\u5df2\u53d1\u8d27\u7269\u6d41\u4fe1\u606f(\u5168\u6e20\u9053\u5efa\u6750)")
    @ResponseBody
    public HtmlJsonReBean updateShippedPackageExpressBuiMat(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            this.logger.error(CODE + ".updateShippedPackageExpressBuiMat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShippedPackageExpressCom(request, packageId, packageExpress);
    }

    @RequestMapping(value={"updateContractSubMoneyBuiMat.json"}, name="\u4fee\u6539\u4ef7\u683c(\u5168\u6e20\u9053\u5efa\u6750)")
    @ResponseBody
    public HtmlJsonReBean updateContractSubMoneyBuiMat(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error(CODE + ".updateContractSubMoneyBuiMat", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractSubMoneyCom(contractId, subMoney, remark);
    }

    @RequestMapping(value={"updateContractStateBuiMat.json"}, name="\u8fd0\u8425\u7aef\u53d6\u6d88\u5f85\u652f\u4ed8\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean updateContractStateBuiMat(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".updateContractStateBuiMat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, OcContractServiceRepository.dataState_no, OcContractServiceRepository.dataState_1);
    }

    @RequestMapping(value={"offlinePayContractStateBuiMat.json"}, name="\u7ebf\u4e0b\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001(\u5168\u6e20\u9053\u5efa\u6750)")
    @ResponseBody
    public HtmlJsonReBean offlinePayContractStateBuiMat(Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".offlinePayContractStateBuiMat", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, OcContractServiceRepository.dataState_2, OcContractServiceRepository.dataState_1);
    }

    @RequestMapping(value={"queryContractPageBuild.json"}, name="\u5168\u6e20\u9053\u623f\u5c4b\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBuild(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateContractStateBuild.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001(\u5168\u6e20\u9053\u623f\u5c4b)")
    @ResponseBody
    public HtmlJsonReBean updateContractStateBuild(String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId) || dataState == null) {
            this.logger.error(CODE + ".updateContractStateBuild", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(Integer.valueOf(contractId), dataState, oldDataState);
    }

    @RequestMapping(value={"confirmReceivableBuild.json"}, name="\u786e\u8ba4\u6536\u6b3e\uff08\u5168\u6e20\u9053\u623f\u5c4b\uff09")
    @ResponseBody
    public HtmlJsonReBean confirmReceivableBuild(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".confirmReceivableBuild.contractBillcode", (Object)"param is null");
        }
        return this.sendContractNextCom(request, contractBillcode, OcContractServiceRepository.dataState_1);
    }

    @RequestMapping(value={"queryContractPageBySg.json"}, name="\u67e5\u8be2\u5546\u5bb6\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBySg(HttpServletRequest request) {
        Map param = this.assemMapMemberParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateContractSubMoneyBySg.json"}, name="\u4fee\u6539\u4ef7\u683c(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean updateContractSubMoneyBySg(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error(CODE + ".updateContractSubMoneyBySg", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractSubMoneyCom(contractId, subMoney, remark);
    }

    @RequestMapping(value={"updateContractStateBySg.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1\u72b6\u6001(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean updateContractStateBySg(HttpServletRequest request, String contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractId) || dataState == null) {
            this.logger.error(CODE + ".updateContractStateBySg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.sendContractNextCom(request, Integer.valueOf(contractId), oldDataState);
    }

    @RequestMapping(value={"offlinePayContractStateBySg.json"}, name="\u7ebf\u4e0b\u652f\u4ed8\uff0c\u4fee\u6539\u8ba2\u5355\u72b6\u6001(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean offlinePayContractStateBySg(HttpServletRequest request, Integer contractId) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".offlinePayContractStateBySg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.sendContractNextCom(request, (int)contractId, (Integer)1);
    }

    @RequestMapping(value={"updateShippedPackageExpressBySg.json"}, name="\u4fee\u6539\u5df2\u53d1\u8d27\u7269\u6d41\u4fe1\u606f(\u4e00\u952e\u53d1\u8d27)")
    @ResponseBody
    public HtmlJsonReBean updateShippedPackageExpressBySg(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            this.logger.error(CODE + ".updateShippedPackageExpressBySg", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateShippedPackageExpressCom(request, packageId, packageExpress);
    }

    @RequestMapping(value={"queryUserConByGoods.json"}, name="\u6839\u636e\u5546\u54c1\u83b7\u53d6\u5bf9\u5e94\u7684\u4f18\u60e0\u5377")
    @ResponseBody
    public List<PmUserCouponReDomain> queryUserConByGoods(HttpServletRequest request, String pmContractGoodsDomainListStr) {
        if (StringUtils.isBlank((String)pmContractGoodsDomainListStr)) {
            this.logger.error(CODE + ".queryUserConByGoods", (Object)"param is null");
            return null;
        }
        return this.queryUserConByGoodsCom(request, pmContractGoodsDomainListStr);
    }

    @RequestMapping(value={"queryContractForAt.json"}, name="\u67e5\u8be2\u7ade\u62cd\u8ba2\u5355--\u4e2a\u4eba")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        param.put("memberCcode", userSession.getUserPcode());
        param.put("tenantCode", this.getTenantCode(request));
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractForPaasAt.json"}, name="\u67e5\u8be2\u7ade\u62cd\u8ba2\u5355--\u6240\u6709")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForPaasAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractForPaasPlatformAt.json"}, name="\u67e5\u8be2\u7ade\u62cd\u8ba2\u5355--\u5e73\u53f0\u6240\u6709")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForPaasPlatformAt(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"getContractForPaasPlatformAt.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f--\u5e73\u53f0\u6240\u6709")
    @ResponseBody
    public OcContractReDomain getContractForPaasPlatformAt(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"getContractForAt.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f--\u4e2a\u4eba")
    @ResponseBody
    public OcContractReDomain getContractForAt(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"getContractForPaasAt.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f--\u6240\u6709")
    @ResponseBody
    public OcContractReDomain getContractForPaasAt(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"queryContractPageCForAt.json"}, name="\u4e70\u5bb6\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868--\u7ade\u4ef7")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageCForAt(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"getContractCForAt.json"}, name="\u83b7\u53d6\u8ba2\u5355\u670d\u52a1\u4fe1\u606f--\u7ade\u4ef7")
    @ResponseBody
    public OcContractReDomain getContractCForAt(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"updateContractForAt.json"}, name="\u66f4\u65b0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateContractForAt(HttpServletRequest request, OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error(CODE + ".updateContract", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractCom(request, ocContractDomain);
    }

    @RequestMapping(value={"queryContractByUser.json"}, name="\u67e5\u770b\u7528\u6237\u8ba2\u5355")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractByUser(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"getContractCForUser.json"}, name="\u67e5\u770b\u8ba2\u5355\u8be6\u60c5")
    @ResponseBody
    public OcContractReDomain getContractCForUser(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"queryContractGoodsByUser.json"}, name="\u67e5\u770b\u7528\u6237\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractForUser(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractGoodsPageCom(request, param);
    }

    @RequestMapping(value={"queryContractForUser.json"}, name="\u67e5\u770b\u7528\u6237\u8ba2\u5355")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractForUser(HttpServletRequest request, String userinfoCode) {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("memberBcode", userinfoCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractGoodsForUser.json"}, name="\u67e5\u770b\u7528\u6237\u5546\u54c1")
    @ResponseBody
    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsForUser(HttpServletRequest request, String userinfoCode) {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        param.put("memberBcode", userinfoCode);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.queryContractGoodsPageCom(request, param);
    }

    @RequestMapping(value={"queryContractPageBuiMatsBymemForStore.json"}, name="\u95e8\u5e97\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868\u8fc7\u6ee4\u5f53\u524d\u767b\u5f55\u8005")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBuiMatsBymemForStore(HttpServletRequest request) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", userSession.getUserPcode());
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryAllUserOcConsumeBigDataPage.json"}, name="\u5ba2\u6237\u8ba2\u5355\u6d88\u8d39\u6570\u636e\u7edf\u8ba1")
    @ResponseBody
    public SupQueryResult<OcConsumeBigData> queryAllUserOcConsumeBigDataPage(HttpServletRequest request) {
        return this.queryAllUserOcConsumeBigDataPageCom(request);
    }

    @RequestMapping(value={"queryAllOcConsumeBigDataByDay.json"}, name="\u5e73\u53f0\u603b\u9500\u552e\u6570\u636e\u7edf\u8ba1")
    @ResponseBody
    public List<OcConsumeBigData> queryAllOcConsumeBigDataByDay(HttpServletRequest request) {
        return this.queryAllOcConsumeBigDataByDayCom(request);
    }

    @RequestMapping(value={"queryAllOcConsumeBigDataForSellerPage.json"}, name="\u5356\u65b9\u9500\u552e\u6570\u636e\u7edf\u8ba1")
    @ResponseBody
    public SupQueryResult<OcConsumeBigData> queryAllOcConsumeBigDataForSellerPage(HttpServletRequest request) {
        return this.queryAllOcConsumeBigDataForSellerPageCom(request);
    }

    @RequestMapping(value={"getOrderInvUrl.json"}, name="\u83b7\u53d6\u5f00\u7968\u5730\u5740")
    @ResponseBody
    public HtmlJsonReBean getOrderInvUrl(HttpServletRequest request) {
        return this.getOrderInvUrlCom(request);
    }

    @RequestMapping(value={"getOrderInvUrlForPlat.json"}, name="\u5e73\u53f0\u83b7\u53d6\u5f00\u7968\u5730\u5740")
    @ResponseBody
    public HtmlJsonReBean getOrderInvUrlForPlat(HttpServletRequest request) {
        return this.getOrderInvUrlForPlatCom(request);
    }

    @RequestMapping(value={"queryContractPageByABulk.json"}, name="\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868-\u56e2\u8d2d")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageByAbulk(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("contractType", OcContractServiceRepository.contractType_Abulk);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageBySpellGroup.json"}, name="\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868-\u62fc\u56e2")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBySpellGroup(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("contractType", OcContractServiceRepository.contractType_SpellGroup);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageBySecKill.json"}, name="\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868-\u79d2\u6740")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageBySecKill(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("contractType", OcContractServiceRepository.contractType_SecKill);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageForPm.json"}, name="\u67e5\u8be2\u8ba2\u5355\u670d\u52a1\u5206\u9875\u5217\u8868-\u62fc\u56e2")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageForPm(HttpServletRequest request, String promotionCode) {
        if (StringUtils.isBlank((String)promotionCode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("contractType", OcContractServiceRepository.contractType_SpellGroup);
            param.put("goodsPmbillno", promotionCode);
        }
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractNumPageForGroup.json"}, name="\u67e5\u8be2\u56e2\u957f\u4e1a\u7ee9")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractNumPageForGroup(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", this.getMerchantCode(request));
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageForGroup.json"}, name="\u67e5\u8be2\u56e2\u957f\u8ba2\u5355")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageForGroup(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("memberCcode", this.getMerchantCode(request));
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"queryContractPageForService.json"}, name="\u67e5\u8be2\u670d\u52a1")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageForService(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("goodsSupplierCode", this.getMerchantCode(request));
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateContractDelcode.json"}, name="\u6838\u63d0\u8d27\u7801")
    @ResponseBody
    public HtmlJsonReBean updateContractDelcode(HttpServletRequest request, String contractBillcode, String contractDelcode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractDelcode)) {
            this.logger.error(CODE + ".updateContractDelcode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractDelcodeCom(request, contractBillcode, contractDelcode);
    }

    @RequestMapping(value={"cancelContractForAt.json"}, name="\u53d6\u6d88\u8ba2\u5355")
    @ResponseBody
    public HtmlJsonReBean cancelContractForAt(Integer contractId, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)contractId)) {
            this.logger.error(CODE + ".updateContractState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updateContractStateExtendCom(contractId, -1, oldDataState);
    }
}

