/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcRegularGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRegularGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcRegularGoodsServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/regular"}, name="\u5e38\u8d2d\u6e05\u5355")
public class RegularCon
extends SpringmvcController {
    private static String CODE = "oc.regular.con";
    @Autowired
    private OcRegularGoodsServiceRepository ocRegularGoodsServiceRepository;

    protected String getContext() {
        return "regular";
    }

    @RequestMapping(value={"saveRegularGoods.json"}, name="\u589e\u52a0\u5e38\u8d2d\u6e05\u5355")
    @ResponseBody
    public HtmlJsonReBean saveRegular(HttpServletRequest request, OcRegularGoodsDomain regularGoodsDomain) {
        if (null == regularGoodsDomain) {
            this.logger.error(CODE + ".saveRegularGoods", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        regularGoodsDomain.setTenantCode(this.getTenantCode(request));
        return this.ocRegularGoodsServiceRepository.saveregularGoods(regularGoodsDomain);
    }

    @RequestMapping(value={"getRegularByRule.json"}, name="\u6309\u89c4\u5219\u83b7\u53d6\u5e38\u8d2d\u6e05\u5355\u4fe1\u606f")
    @ResponseBody
    public List<OcRegularGoodsReDomain> getReguzlarByRule(HttpServletRequest request, @RequestParam(defaultValue="ModifiedTime", required=false) String rule, @RequestParam(defaultValue="10", required=false) Integer num) {
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        this.logger.info(CODE + "userCode=", (Object)userCode);
        if (StringUtils.isBlank((String)rule) || StringUtils.isBlank((Integer)num)) {
            this.logger.error(CODE + ".getRegularByRule", (Object)"param is null");
            return null;
        }
        return this.ocRegularGoodsServiceRepository.getRegularByRule(userCode, rule, num);
    }

    @RequestMapping(value={"deleteRegularByMemberCodeAndSkuCode.json"}, name="\u5220\u9664\u5e38\u8d2d\u6e05\u5355")
    @ResponseBody
    public HtmlJsonReBean deleteRegularByMemberCodeAndSkuCode(HttpServletRequest request, String skuCode) {
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error(CODE + ".deleteRegularByMemberCodeAndSkuCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRegularGoodsServiceRepository.deleteRegularByMemberCodeAndSkuCode(userCode, skuCode);
    }
}

