/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcRegularDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRegularGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRegularReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcRegularServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/regular"}, name="\u5e38\u8d2d\u6e05\u5355\u8868")
public class RegularCon
extends SpringmvcController {
    private static String CODE = "oc.regular.con";
    @Autowired
    private OcRegularServiceRepository ocRegularServiceRepository;

    protected String getContext() {
        return "regular";
    }

    @RequestMapping(value={"getRegular.json"}, name="\u83b7\u53d6\u5e38\u8d2d\u6e05\u5355\u8868\u4fe1\u606f")
    @ResponseBody
    public OcRegularReDomain getRegular(Integer regularId) {
        if (StringUtils.isBlank((Integer)regularId)) {
            this.logger.error(CODE + ".getRegular", (Object)"param is null");
            return null;
        }
        return this.ocRegularServiceRepository.getRegular(regularId);
    }

    @RequestMapping(value={"updateRegular.json"}, name="\u66f4\u65b0\u5e38\u8d2d\u6e05\u5355\u8868")
    @ResponseBody
    public HtmlJsonReBean updateRegular(HttpServletRequest request, OcRegularDomain ocRegularDomain) {
        if (null == ocRegularDomain) {
            this.logger.error(CODE + ".updateRegular", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocRegularDomain.setTenantCode(this.getTenantCode(request));
        return this.ocRegularServiceRepository.updateRegular(ocRegularDomain);
    }

    @RequestMapping(value={"deleteRegular.json"}, name="\u5220\u9664\u5e38\u8d2d\u6e05\u5355\u8868")
    @ResponseBody
    public HtmlJsonReBean deleteRegular(Integer regularId) {
        if (StringUtils.isBlank((Integer)regularId)) {
            this.logger.error(CODE + ".deleteRegular", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRegularServiceRepository.deleteRegular(regularId);
    }

    @RequestMapping(value={"queryRegularPage.json"}, name="\u67e5\u8be2\u5e38\u8d2d\u6e05\u5355\u8868\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRegularReDomain> queryRegularPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocRegularServiceRepository.queryRegularPage(param);
    }

    @RequestMapping(value={"updateRegularState.json"}, name="\u66f4\u65b0\u5e38\u8d2d\u6e05\u5355\u8868\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRegularState(String regularId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)regularId)) {
            this.logger.error(CODE + ".updateRegularState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocRegularServiceRepository.updateRegularState(Integer.valueOf(regularId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryRegularGoodsPage.json"}, name="\u67e5\u8be2\u5e38\u8d2d\u6e05\u5355\u5546\u54c1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcRegularGoodsReDomain> queryRegularGoodsPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        String userinfoOcode = userSession.getUserinfoOcode();
        String userPcode = userSession.getUserPcode();
        this.logger.error(CODE, (Object)("userCode=" + userCode));
        this.logger.error(CODE, (Object)("UserinfoOcode=" + userinfoOcode));
        this.logger.error(CODE, (Object)("userPcode=" + userPcode));
        param.put("memberCode", userPcode);
        return this.ocRegularServiceRepository.queryRegularGoodsPage(param);
    }

    @RequestMapping(value={"deleteRegularGoodsByMemberCodeAndSkuCode.json"}, name="\u901a\u8fc7\u767b\u5f55\u540d\u548c\u5546\u54c1id\u5220\u9664\u6307\u5b9a\u5e38\u8d2d\u5546\u54c1")
    @ResponseBody
    public HtmlJsonReBean deleteRegularGoodsByMemberCodeAndSkuCode(HttpServletRequest request, String skuCode) {
        if (StringUtils.isBlank((String)skuCode)) {
            this.logger.error(CODE + ".deleteRegularGoodsByMemberCodeAndSkuCode", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        String userPcode = userSession.getUserPcode();
        return this.ocRegularServiceRepository.deleteRegularGoodsByMemberCodeAndSkuCode(userPcode, skuCode);
    }

    @RequestMapping(value={"saveRegular.json"}, name="\u589e\u52a0\u5e38\u8d2d\u6e05\u5355\u8868")
    @ResponseBody
    public HtmlJsonReBean saveRegular(HttpServletRequest request, OcRegularDomain ocRegularDomain) {
        if (null == ocRegularDomain) {
            this.logger.error(CODE + ".saveRegular", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocRegularDomain.setTenantCode(this.getTenantCode(request));
        UserSession userSession = this.getUserSession(request);
        String userPcode = userSession.getUserPcode();
        ocRegularDomain.setMemberCode(userPcode);
        return this.ocRegularServiceRepository.saveRegular(ocRegularDomain);
    }
}

