/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustrelReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustrelServiceRepository;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingReDomain;
import com.qjsoft.laser.controller.facade.dd.repository.DdFalgSettingServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcBusinessDimensionDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcCflowPprocessReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcClinckDataDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcClinicRankingDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcClinicReportDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcClorstDataStatisticsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcCommissionStatisticsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcConsumeBigData;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSettlDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcDentalReportDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcDistributorEmployeeReportDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcPackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcRefundReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.SkuDomain;
import com.qjsoft.laser.controller.facade.oc.domain.pojo.PackageExpressDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcCflowPprocessServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractEngineServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractSubServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcRefundServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.facade.org.domain.OrgEmployeeReDomain;
import com.qjsoft.laser.controller.facade.org.domain.OrgUserBean;
import com.qjsoft.laser.controller.facade.org.repository.OrgCompanyServiceRepository;
import com.qjsoft.laser.controller.facade.org.repository.OrgEmployeeServiceRepository;
import com.qjsoft.laser.controller.facade.pm.domain.PmContractGoodsDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDiscountDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDiscountlistDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmUserCouponReDomain;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.pte.domain.PteBalanceamtReDomain;
import com.qjsoft.laser.controller.facade.pte.repository.PteBalanceamtServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmGroupListReDomain;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UmGroupServiceRepository;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.facade.vd.domain.VdFaccountInfo;
import com.qjsoft.laser.controller.facade.vd.repository.VdFaccountOuterServiceRepository;
import com.qjsoft.laser.controller.facade.vd.repository.VdFaccountServiceRepository;
import com.qjsoft.laser.controller.order.domain.FareBean;
import com.qjsoft.laser.controller.order.orderexceltemplate.ExcelExportTemplate;
import com.qjsoft.laser.controller.order.utils.MatrixToImageWriter;
import com.qjsoft.laser.controller.springmvc.SpringmvnNewController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class ContractComCon
extends SpringmvnNewController {
    private static String CODE = "oc.contractcom.con";
    @Autowired
    protected OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;
    @Autowired
    protected OcContractEngineServiceRepository ocContractEngineServiceRepository;
    @Autowired
    private OcContractSubServiceRepository ocContractSubServiceRepository;
    @Autowired
    private CtCustrelServiceRepository ctCustrelServiceRepository;
    @Autowired
    private OrgEmployeeServiceRepository orgEmployeeServiceRepository;
    @Autowired
    private OrgCompanyServiceRepository orgCompanyServiceRepository;
    @Autowired
    private OcCflowPprocessServiceRepository ocCflowPprocessServiceRepository;
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;
    @Autowired
    private OcRefundServiceRepository ocRefundServiceRepository;
    @Autowired
    private VdFaccountOuterServiceRepository vdFaccountOuterServiceRepository;
    @Autowired
    private VdFaccountServiceRepository vdFaccountServiceRepository;
    @Autowired
    private PteBalanceamtServiceRepository pteBalanceamtServiceRepository;
    @Autowired
    private DdFalgSettingServiceRepository ddFalgSettingServiceRepository;
    UmGroupServiceRepository umGroupServiceRepository;

    protected String getContext() {
        return "contractcom";
    }

    public String getEmp(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        String employeeCode = userSession.getEmployeeCode();
        if (StringUtils.isNotBlank((String)employeeCode)) {
            return employeeCode;
        }
        SupQueryResult qemp = this.orgEmployeeServiceRepository.queryEmployeePage(this.getQueryMapParam("userCode,userinfoCode,tenantCode", new Object[]{userSession.getUserCode(), userSession.getUserPcode(), userSession.getTenantCode()}));
        if (null == qemp || ListUtil.isEmpty((Collection)qemp.getList())) {
            return null;
        }
        return ((OrgEmployeeReDomain)qemp.getList().get(0)).getEmployeeCode();
    }

    public String getDep(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        OrgUserBean orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userSession.getUserCode(), userSession.getCompanyCode(), userSession.getTenantCode());
        if (null == orgUserBean) {
            return null;
        }
        return orgUserBean.getDepartCode();
    }

    public String getCom(UserSession userSession) {
        if (null == userSession) {
            return null;
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode())) {
            return userSession.getCompanyCode();
        }
        OrgUserBean orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userSession.getUserCode(), userSession.getCompanyCode(), userSession.getTenantCode());
        if (null == orgUserBean) {
            return null;
        }
        return orgUserBean.getCompanyCode();
    }

    public HtmlJsonReBean saveExContractGoodsCom(HttpServletRequest request, String orderGoodsDomainStr) {
        if (StringUtils.isBlank((String)orderGoodsDomainStr)) {
            this.logger.error(CODE + ".saveExContractGoodsCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List ocContractGoodsDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderGoodsDomainStr, OcContractGoodsDomain.class);
        if (ListUtil.isEmpty((Collection)ocContractGoodsDomainList)) {
            this.logger.error(CODE + ".saveExContractGoodsCom.ocContractGoodsDomainList", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomainList) {
            ocContractGoodsDomain.setTenantCode(this.getTenantCode(request));
        }
        HtmlJsonReBean htmlJsonReBean = this.ocContractServiceRepository.saveExContractGoods(ocContractGoodsDomainList);
        return htmlJsonReBean;
    }

    protected HtmlJsonReBean createOrder(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".createOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        orgUserBean = StringUtils.isNotBlank((String)memberBcode) ? this.getOrgUserBean(memberBcode, userSession, this.getCompanyCode(request), userSession.getTenantCode()) : this.getOrgUserBean(userSession.getUserPcode(), userSession, null, userSession.getTenantCode());
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getEmployeeCode())) {
            orgUserBean.setEmployeeCode(((OrderDomain)orderDomainList.get(0)).getEmployeeCode());
            orgUserBean.setEmployeeName(((OrderDomain)orderDomainList.get(0)).getEmployeeName());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartCode())) {
            orgUserBean.setDepartCode(((OrderDomain)orderDomainList.get(0)).getDepartCode());
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartShortname())) {
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getCompanyCode())) {
            orgUserBean.setCompanyCode(((OrderDomain)orderDomainList.get(0)).getCompanyCode());
            orgUserBean.setCompanyShortname(((OrderDomain)orderDomainList.get(0)).getCompanyShortname());
        }
        this.makeChannel(orderDomainList, request);
        return this.ocShoppingServiceRepository.createOcOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, contractProperty);
    }

    public OrgUserBean getOrgUserBean(String memberBcode, UserSession userSession, String companyCode, String tenantCode) {
        SupQueryResult qcust;
        if (null == userSession || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = null;
        String userCode = userSession.getUserCode();
        if (StringUtils.isNotBlank((String)companyCode)) {
            orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        }
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode) && null != (qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
            CtCustrelReDomain ctustrelReDomain = (CtCustrelReDomain)qcust.getList().get(0);
            orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
            orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            orgUserBean.setCompanyCode(ctustrelReDomain.getCompanyCode());
            orgUserBean.setEmployeeCode(ctustrelReDomain.getEmployeeCode());
            orgUserBean.setEmployeeName(ctustrelReDomain.getEmployeeName());
            orgUserBean.setDepartCode(ctustrelReDomain.getDepartCode());
            orgUserBean.setDepartShortname(ctustrelReDomain.getDepartName());
            orgUserBean.setCompanyShortname(ctustrelReDomain.getCompanyShortname());
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode()) && !userSession.getCompanyCode().equals(orgUserBean.getCompanyCode())) {
            orgUserBean.setCompanyCode(userSession.getCompanyCode());
            orgUserBean.setCompanyShortname(userSession.getCompanyShortname());
        }
        return orgUserBean;
    }

    protected HtmlJsonReBean createOrder(HttpServletRequest request, String orderDomainStr, String contractType) {
        return this.createOrder(request, orderDomainStr, contractType, null, "0");
    }

    protected HtmlJsonReBean createOrderpc(HttpServletRequest request, String orderDomainStr, String contractType) {
        return this.createOrderpc(request, orderDomainStr, contractType, null, "0");
    }

    private void makeChannel(List<OrderDomain> orderDomainList, HttpServletRequest request) {
        if (ListUtil.isEmpty(orderDomainList) || null == request) {
            return;
        }
        for (OrderDomain orderDomain : orderDomainList) {
            orderDomain.setChannelCode(this.getNowChannel(request));
            orderDomain.setChannelName(this.getChannelName(orderDomain.getChannelCode(), request));
        }
    }

    public OcContractReDomain getContractCom(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContractCom", (Object)"param is null");
            return null;
        }
        return this.ocContractServiceRepository.getContract(Integer.valueOf(contractId));
    }

    public HtmlJsonReBean updateContractCom(HttpServletRequest request, OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error(CODE + ".updateContractCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.updateContract(ocContractDomain);
    }

    public HtmlJsonReBean deleteContractCom(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".deleteContractCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.deleteContract(Integer.valueOf(contractId));
    }

    public SupQueryResult<OcContractGoodsReDomain> queryContractGoodsPageCom(HttpServletRequest request, Map<String, Object> param) {
        return this.ocContractServiceRepository.queryContractGoodsPage(param);
    }

    public OcContractReDomain getContractByCodeCom(HttpServletRequest request, Map<String, Object> param) {
        return this.ocContractServiceRepository.getContractByCode(param);
    }

    public HtmlJsonReBean updateContractSubMoneyCom(Integer contractId, String subMoney, String remark) {
        if (contractId == null || StringUtils.hasBlank((String[])new String[]{subMoney, remark})) {
            this.logger.error(CODE + ".updateContractSubMoneyCom", (Object)"params is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractServiceRepository.updateContractSubMoney(contractId, subMoney, remark);
    }

    public HtmlJsonReBean syncContractStateCom(HttpServletRequest request, String contractBillcode) {
        return this.getContrant(request, contractBillcode, OcContractServiceRepository.dataState_no, OcContractServiceRepository.dataState_1);
    }

    public HtmlJsonReBean syncContractBatchStateCom(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ocContractServiceRepository.queryContractPage(map);
        if (null == qlist || null == qlist.getRows()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u6570\u636e\u4e3a\u7a7a");
        }
        Integer errDataState = OcContractServiceRepository.dataState_no;
        Integer newDataState = OcContractServiceRepository.dataState_1;
        boolean flag = true;
        for (OcContractReDomain OcContractReDomain2 : qlist.getRows()) {
            HtmlJsonReBean htmlJsonReBean = this.getContrant(request, OcContractReDomain2.getContractBillcode(), errDataState, newDataState);
            if (null == htmlJsonReBean || htmlJsonReBean.isSuccess()) continue;
            flag = false;
        }
        if (flag) {
            return new HtmlJsonReBean((Object)"ok");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5931\u8d25");
    }

    public HtmlJsonReBean syncContractPayStateCom(HttpServletRequest request, String contractBillcode, String contractSubCode) {
        if (StringUtils.isNotBlank((String)contractSubCode)) {
            return this.getContrantSub(request, contractBillcode, contractSubCode, OcContractServiceRepository.dataState_no, OcContractServiceRepository.dataState_1);
        }
        return this.getContrant(request, contractBillcode, OcContractServiceRepository.dataState_no, OcContractServiceRepository.dataState_2);
    }

    public HtmlJsonReBean syncContractBatchPayStateCom(HttpServletRequest request, String contractBbillcode) {
        if (StringUtils.isBlank((String)contractBbillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBbillcode", contractBbillcode);
        map.put("tenantCode", tenantCode);
        SupQueryResult qlist = this.ocContractServiceRepository.queryContractPage(map);
        if (null == qlist || null == qlist.getRows()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6279\u53f7\u6570\u636e\u4e3a\u7a7a");
        }
        Integer errDataState = OcContractServiceRepository.dataState_no;
        Integer newDataState = OcContractServiceRepository.dataState_2;
        boolean flag = true;
        for (OcContractReDomain OcContractReDomain2 : qlist.getRows()) {
            HtmlJsonReBean htmlJsonReBean = this.getContrant(request, OcContractReDomain2.getContractBillcode(), errDataState, newDataState);
            if (null == htmlJsonReBean || htmlJsonReBean.isSuccess()) continue;
            flag = false;
        }
        if (flag) {
            return new HtmlJsonReBean((Object)"ok");
        }
        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5931\u8d25");
    }

    public HtmlJsonReBean getContrantSub(HttpServletRequest request, String contractBillcode, String contractSubCode, Integer errDataState, Integer newDataState) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractSubCode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        long currentTime = System.currentTimeMillis();
        long expireMillis = 10000L;
        String DisKey = "ocContractSub-state-" + contractSubCode + tenantCode;
        Integer dataState = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.checkDataState(errDataState, newDataState, DisKey, map);
        if (null != htmlJsonReBean) {
            return htmlJsonReBean;
        }
        while (!this.checkErrorDataState(dataState, errDataState, newDataState) && !this.checkOkDataState(dataState, errDataState, newDataState)) {
            if (System.currentTimeMillis() - currentTime > 10000L) {
                OcContractSubReDomain ocContractSubReDomain = this.ocContractSubServiceRepository.getContractSubByCode(tenantCode, contractSubCode);
                if (ocContractSubReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractSubCode));
                    break;
                }
                dataState = ocContractSubReDomain.getDataState();
                this.logger.debug(CODE + ".syncContractState.expire", (Object)("\u4e0b\u5355\u5904\u7406\u8d85\u65f6\uff1a" + contractBillcode + ",\u6570\u636e\u5e93\u72b6\u6001\uff1a" + dataState));
                if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                    OcContractReDomain contractReDomain = this.ocContractServiceRepository.getContractModelByCodes(map);
                    if (contractReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                        break;
                    }
                    if (!this.checkOkDataState(contractReDomain.getDataState(), errDataState, newDataState)) break;
                    return new HtmlJsonReBean(this.getContract(contractReDomain));
                }
                if (dataState == null || dataState.intValue() != errDataState.intValue()) break;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.logger.error(CODE + ".syncContractState.sleep.ex", (Throwable)e);
            }
            try {
                String str = SupDisUtil.getRemot((String)DisKey);
                if (StringUtils.isNotBlank((String)str)) {
                    dataState = Integer.valueOf(str);
                } else {
                    OcContractSubReDomain ocContractSubReDomain = this.ocContractSubServiceRepository.getContractSubByCode(tenantCode, contractSubCode);
                    if (ocContractSubReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractSubCode));
                        break;
                    }
                    dataState = ocContractSubReDomain.getDataState();
                }
            }
            catch (NumberFormatException e) {
                this.logger.error(CODE, (Object)("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + contractBillcode));
                continue;
            }
            if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                OcContractReDomain contractReDomain = this.ocContractServiceRepository.getContractOneByCode(map);
                if (contractReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                    break;
                }
                this.sendOrderBigData(contractReDomain);
                dataState = contractReDomain.getDataState();
                if (!this.checkOkDataState(dataState, errDataState, newDataState)) continue;
                return new HtmlJsonReBean(this.getContract(contractReDomain));
            }
            if (!this.checkErrorDataState(dataState, errDataState, newDataState)) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        return new HtmlJsonReBean("-2", "\u8ba2\u5355\u72b6\u6001\u672a\u53d8\u5316", (Object)"no");
    }

    public HtmlJsonReBean getContrant(HttpServletRequest request, String contractBillcode, Integer errDataState, Integer newDataState) {
        for (int i = 0; i < 10; ++i) {
            this.logger.error(CODE + ".getContrant", (Object)"==========================================================================");
        }
        this.logger.error(CODE + ".getContrant", (Object)("contractBillcode->" + contractBillcode));
        if (StringUtils.isBlank((String)contractBillcode)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        long currentTime = System.currentTimeMillis();
        long expireMillis = 30000L;
        String DisKey = "ocContract-state-" + contractBillcode + tenantCode;
        Integer dataState = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        HtmlJsonReBean htmlJsonReBean = this.checkDataState(errDataState, newDataState, DisKey, map);
        if (null != htmlJsonReBean) {
            return htmlJsonReBean;
        }
        OcContractReDomain contractReDomain = null;
        while (!this.checkErrorDataState(dataState, errDataState, newDataState) && !this.checkOkDataState(dataState, errDataState, newDataState)) {
            contractReDomain = null;
            if (System.currentTimeMillis() - currentTime > 30000L) {
                contractReDomain = this.ocContractServiceRepository.getContractModelByCodes(map);
                if (contractReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                    break;
                }
                dataState = contractReDomain.getDataState();
                this.logger.debug(CODE + ".syncContractState.expire", (Object)("\u4e0b\u5355\u5904\u7406\u8d85\u65f6\uff1a" + contractBillcode + ",\u6570\u636e\u5e93\u72b6\u6001\uff1a" + dataState));
                if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                    this.logger.error(CODE, (Object)("\u627e\u5230\u8ba2\u5355\u72b6\u60011\uff1a" + dataState + "=" + newDataState));
                    return new HtmlJsonReBean(this.getContract(contractReDomain));
                }
                if (!this.checkErrorDataState(dataState, errDataState, newDataState)) break;
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                this.logger.error(CODE + ".syncContractState.sleep.ex", (Throwable)e);
            }
            try {
                String str = SupDisUtil.getRemot((String)DisKey);
                if (StringUtils.isNotBlank((String)str) && !"null".equals(str)) {
                    dataState = Integer.valueOf(str);
                } else {
                    contractReDomain = this.ocContractServiceRepository.getContractModelByCodes(map);
                    if (contractReDomain == null) {
                        this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                        break;
                    }
                    dataState = contractReDomain.getDataState();
                }
            }
            catch (NumberFormatException e) {
                this.logger.error(CODE, (Object)("\u7f13\u5b58\u4e2d\u672a\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + contractBillcode));
                continue;
            }
            if (this.checkOkDataState(dataState, errDataState, newDataState)) {
                if (null == contractReDomain) {
                    contractReDomain = this.ocContractServiceRepository.getContractOneByCode(map);
                }
                if (contractReDomain == null) {
                    this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + contractBillcode));
                    break;
                }
                this.logger.error(CODE, (Object)("\u627e\u5230\u8ba2\u5355\u72b6\u6001\uff1a" + dataState + "=" + newDataState));
                dataState = contractReDomain.getDataState();
                if (!this.checkOkDataState(dataState, errDataState, newDataState)) continue;
                return new HtmlJsonReBean(this.getContract(contractReDomain));
            }
            if (!this.checkErrorDataState(dataState, errDataState, newDataState)) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        this.logger.error(CODE, (Object)("\u627e\u5230\u8ba2\u5355\u72b6\u60011\uff1a" + dataState + "=" + errDataState + "=" + newDataState));
        if (this.checkOkDataState(dataState, errDataState, newDataState)) {
            return new HtmlJsonReBean(this.getContract(contractReDomain));
        }
        return new HtmlJsonReBean("-2", "\u8ba2\u5355\u72b6\u6001\u672a\u53d8\u5316", (Object)"no");
    }

    public Map<String, Object> getContract(OcContractReDomain contractReDomain) {
        if (null == contractReDomain) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractReDomain.getContractBillcode());
        map.put("contractBbillcode", contractReDomain.getContractBbillcode());
        map.put("contractType", contractReDomain.getContractType());
        map.put("contractBlance", contractReDomain.getContractBlance());
        map.put("contractPmode", contractReDomain.getContractPmode());
        map.put("contractPaygmoney", contractReDomain.getContractPayamoney());
        map.put("dataBmoney", contractReDomain.getDataBmoney());
        return map;
    }

    public void sendOrderBigData(OcContractReDomain contractReDomain) {
    }

    public HtmlJsonReBean checkDataState(Integer errDataState, Integer newDataState, String DisKey, Map<String, Object> map) {
        String str = SupDisUtil.getRemot((String)DisKey);
        Integer dataState = null;
        OcContractReDomain contractReDomain = null;
        if (StringUtils.isNotBlank((String)str)) {
            dataState = Integer.valueOf(str);
        } else {
            contractReDomain = this.ocContractServiceRepository.getContractModelByCodes(map);
            if (contractReDomain == null) {
                return null;
            }
            dataState = contractReDomain.getDataState();
        }
        if (this.checkErrorDataState(dataState, errDataState, newDataState)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
        }
        if (this.checkOkDataState(dataState, errDataState, newDataState)) {
            if (null == contractReDomain) {
                contractReDomain = this.ocContractServiceRepository.getContractModelByCodes(map);
            }
            if (contractReDomain == null) {
                this.logger.error(CODE + ".syncContractState.con", (Object)("\u8ba2\u5355\u4e0d\u5b58\u5728" + map.toString()));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u5904\u7406\u5931\u8d25");
            }
            if (this.checkOkDataState(contractReDomain.getDataState(), errDataState, newDataState)) {
                return new HtmlJsonReBean(this.getContract(contractReDomain));
            }
        }
        return null;
    }

    public boolean checkErrorDataState(Integer dataState, Integer errDataState, Integer newDataState) {
        this.logger.error(CODE + ".checkErrorDataState", (Object)"=============================");
        this.logger.error(CODE + ".checkErrorDataState", (Object)("dataState=>" + dataState));
        this.logger.error(CODE + ".checkErrorDataState", (Object)("errDataState=>" + errDataState));
        return dataState != null && dataState.intValue() == errDataState.intValue();
    }

    public boolean checkOkDataState(Integer dataState, Integer errDataState, Integer newDataState) {
        if (OcContractServiceRepository.dataState_2.intValue() == newDataState.intValue() && dataState != null && (dataState.intValue() == newDataState.intValue() || dataState == newDataState + 1 || dataState == newDataState + 2 || dataState.intValue() == OcContractServiceRepository.dataState_30.intValue())) {
            return true;
        }
        return dataState != null && (dataState.intValue() == newDataState.intValue() || dataState == newDataState + 1);
    }

    public HtmlJsonReBean checkContractPayCom(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".checkContractPay", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractOneByCode(map);
        if (null == ocContractReDomain || OcContractServiceRepository.dataState_2.intValue() != ocContractReDomain.getDataState().intValue() && OcContractServiceRepository.dataState_30.intValue() != ocContractReDomain.getDataState().intValue()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return new HtmlJsonReBean();
    }

    public HtmlJsonReBean updateShippedPackageExpressCom(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        if (packageExpress == null || StringUtils.hasBlank((String[])new String[]{packageExpress.getPackageBillno(), packageExpress.getExpressCode()}) || packageId == null) {
            this.logger.error(CODE + ".updateShippedPackageExpressCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.updatePackage(request, packageId, packageExpress);
    }

    public HtmlJsonReBean updatePackage(HttpServletRequest request, Integer packageId, PackageExpressDomain packageExpress) {
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)packageExpress);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".updatePackage.ex", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5904\u7406\u5f02\u5e38");
        }
        ocPackageDomain.setPackageId(packageId);
        ocPackageDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractServiceRepository.updatePackage(ocPackageDomain);
    }

    public HtmlJsonReBean sendContractNextCom(HttpServletRequest request, Integer contractId, Integer dateState, boolean buy) {
        if (null == contractId || null == dateState) {
            this.logger.error(CODE + ".sendContractNextCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null);
        }
        OcContractReDomain contract = this.ocContractServiceRepository.getContract(contractId);
        if (contract == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (buy && !this.getUserSession(request).getUserPcode().equals(contract.getMemberBcode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "user");
        }
        if (dateState != contract.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        return this.sendContractNext(request, contract.getContractBillcode());
    }

    public HtmlJsonReBean sendContractPay(HttpServletRequest request, Integer dateState, OcContractSettlDomain ocContractSettlDomain) {
        if (null == ocContractSettlDomain) {
            this.logger.error(CODE + ".sendContractPay", null);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null);
        }
        OcContractReDomain contract = this.ocContractServiceRepository.getContractOneByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{ocContractSettlDomain.getContractBillcode(), ocContractSettlDomain.getTenantCode()}));
        if (contract == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (dateState != contract.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        return this.ocContractEngineServiceRepository.sendSaveOffPayOk(ocContractSettlDomain);
    }

    public HtmlJsonReBean sendContractPayBatch(HttpServletRequest request, Integer dateState, List<OcContractSettlDomain> ocContractSettlDomainList) {
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            this.logger.error(CODE + ".sendContractPayBatch", null);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, null);
        }
        return this.ocContractEngineServiceRepository.sendSaveOffPayOkBatch(ocContractSettlDomainList);
    }

    public HtmlJsonReBean sendContractNextCom(HttpServletRequest request, String contractBillcode, Integer dateState, boolean buy) {
        String tenantCode;
        Map getContractMap;
        OcContractReDomain contract;
        if (StringUtils.isBlank((String)contractBillcode) || null == dateState) {
            this.logger.error(CODE + ".sendContractNextCom", (Object)"param is null");
        }
        if ((contract = this.ocContractServiceRepository.getContractOneByCode(getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode = this.getTenantCode(request)}))) == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (buy && !this.getUserSession(request).getUserPcode().equals(contract.getMemberBcode())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "user");
        }
        if (dateState != contract.getDataState()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
        }
        return this.sendContractNext(request, contractBillcode);
    }

    public HtmlJsonReBean calculateFreightFareBatchCom(HttpServletRequest request, String paramStr, String memberBcode) {
        if (StringUtils.isBlank((String)paramStr)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List fareBeanList = (List)JsonUtil.buildNormalBinder().getJsonToList(paramStr, FareBean.class);
        if (ListUtil.isEmpty((Collection)fareBeanList)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u4e3a\u7a7a");
        }
        String areaCode = null;
        String shoppingGoodsIdStr = null;
        String skuIdStr = null;
        BigDecimal fare = new BigDecimal(0);
        BigDecimal fare_temp = new BigDecimal(0);
        HtmlJsonReBean htmlJsonReBean = null;
        for (FareBean fareBean : fareBeanList) {
            areaCode = fareBean.getAreaCode();
            if (StringUtils.isNotBlank((String)fareBean.getShoppingGoodsIdStr())) {
                shoppingGoodsIdStr = fareBean.getShoppingGoodsIdStr();
            } else {
                skuIdStr = fareBean.getSkuIdStr();
            }
            htmlJsonReBean = this.calculateFreightFareCom(request, shoppingGoodsIdStr, skuIdStr, areaCode, memberBcode);
            if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
                this.logger.error(CODE + ".calculateFreightFareBatch", (Object)"param is null");
                return htmlJsonReBean;
            }
            fare_temp = (BigDecimal)htmlJsonReBean.getDataObj();
            fare = fare.add(fare_temp);
        }
        return new HtmlJsonReBean((Object)fare);
    }

    public HtmlJsonReBean calculateFreightFareCom(HttpServletRequest request, String shoppingGoodsIdStr, String skuIdStr, String areaCode, String memberBcode) {
        BigDecimal fare;
        if (StringUtils.isBlank((String)shoppingGoodsIdStr) && StringUtils.isBlank((String)skuIdStr)) {
            this.logger.error(CODE + ".calculateFreightFare", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        List shoppingGoodsIdList = null;
        List skuIdList = null;
        if (StringUtils.isNotBlank((String)shoppingGoodsIdStr)) {
            shoppingGoodsIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(shoppingGoodsIdStr, Integer.class);
        } else {
            skuIdList = (List)JsonUtil.buildNormalBinder().getJsonToList(skuIdStr, SkuDomain.class);
            if (null == skuIdList || skuIdList.isEmpty()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u5f02\u5e38");
            }
        }
        UserSession userSession = this.getUserSession(request);
        if (userSession == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u672a\u767b\u5f55");
        }
        OcContractDomain ocContractDomain = new OcContractDomain();
        ocContractDomain.setMemberBcode(StringUtils.isBlank((String)memberBcode) ? userSession.getUserPcode() : memberBcode);
        ocContractDomain.setTenantCode(this.getTenantCode(request));
        try {
            fare = this.ocContractServiceRepository.getFreightFare(this.ocContractServiceRepository.makeContractGoodsDomainList("", shoppingGoodsIdList, skuIdList, ocContractDomain, null), areaCode);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".calculateFreightFare.ex", (Throwable)e);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, e.getMessage());
        }
        this.logger.error(CODE + ".calculateFreightFare.json" + fare);
        return new HtmlJsonReBean((Object)fare);
    }

    protected HtmlJsonReBean sendContractNext(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }

    public HtmlJsonReBean caExistenceCom(HttpServletRequest request, String contractBillcode, String CallbackURL) throws Exception {
        if (StringUtils.isBlank((String)CallbackURL)) {
            this.logger.error(CODE + ".CaExistenceCom", (Object)("CallbackURL is===-===" + contractBillcode));
        }
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".CaExistenceCom", (Object)("contractBillcode is==-===" + contractBillcode));
        }
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        String tenanrCode = this.getTenantCode(request);
        return this.ocContractServiceRepository.CaFollowupoperation(contractBillcode, userCode, CallbackURL, tenanrCode);
    }

    protected SupQueryResult<OcContractReDomain> queryContractPageCom(HttpServletRequest request, String fileName, Map<String, Object> param) {
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u8ba2\u5355\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((String)excelTemplate) && "ag".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderNewHeadExcelParam());
            } else if ("ms".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderMsHeadExcelParam());
            } else if ("retailer".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxHeadExcelParam());
            } else if ("retailerDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxDetaiHeadExcelParam());
            } else if ("pg".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgHeadExcelParam());
            } else if ("pgDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgDetailHeadExcelParam());
            } else if ("retailerPackets".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderRetailerPacketsExcelParam());
            } else if ("retailerPacketsDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertRetailerPacketsDetailExcelParam());
            } else if ("pt".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertScantlingOrderHeadExcelParam());
            } else if ("ptD".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertScantlingOrderHeadExcelParam());
            } else {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderHeadExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            this.logger.error(CODE + ".queryContractPageCom.1111", (Object)(param + "=:=" + infoMap));
            try {
                this.exportComExcel(request, param, infoMap, "oc.contract.queryContractPageReDomain", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryContractPageCom.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    protected List<Map<String, Object>> makeExcelData(String json, String apiRouter, String excelTemplate) {
        ArrayList<Map<String, Object>> mapList;
        block54: {
            List ocContractReDomainList;
            block58: {
                block57: {
                    block56: {
                        block55: {
                            block53: {
                                SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, SupQueryResult.class);
                                ocContractReDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), OcContractReDomain.class);
                                if (ListUtil.isEmpty((Collection)ocContractReDomainList)) {
                                    return null;
                                }
                                mapList = new ArrayList<Map<String, Object>>();
                                if (!StringUtils.isBlank((String)excelTemplate)) break block53;
                                for (OcContractReDomain oc : ocContractReDomainList) {
                                    List goodsList = oc.getGoodsList();
                                    boolean flag = false;
                                    if (ListUtil.isNotEmpty((Collection)goodsList)) {
                                        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                                            Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomain);
                                            if (!flag) {
                                                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                                Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                                                objectDetailToMap.putAll(stringObjectMap);
                                                flag = true;
                                            }
                                            mapList.add(objectDetailToMap);
                                        }
                                        continue;
                                    }
                                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                    Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                                    mapList.add(stringObjectMap);
                                }
                                break block54;
                            }
                            if (!"ag".equals(excelTemplate)) break block55;
                            for (OcContractReDomain oc : ocContractReDomainList) {
                                List goodsList = oc.getGoodsList();
                                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                Map<String, Object> stringObjectMap = this.coverOrderStateStr(objectToMap);
                                Map<String, Object> stringObjectMapStr = this.coverOrderUser(oc.getMemberBcode(), oc.getTenantCode());
                                Map<String, Object> stringObjectMapStr1 = this.covercontractPayamoneyStr(stringObjectMap);
                                objectToMap.putAll(stringObjectMap);
                                objectToMap.putAll(stringObjectMapStr);
                                objectToMap.putAll(stringObjectMapStr1);
                                if (ListUtil.isNotEmpty((Collection)goodsList)) {
                                    for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                                        Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomain);
                                        objectDetailToMap.putAll(objectToMap);
                                        mapList.add(objectDetailToMap);
                                    }
                                    continue;
                                }
                                mapList.add(objectToMap);
                            }
                            break block54;
                        }
                        if (!"sc".equals(excelTemplate)) break block56;
                        for (OcContractReDomain oc : ocContractReDomainList) {
                            List goodsList = oc.getGoodsList();
                            Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                            Map<String, Object> stringObjectMap = this.coverOrderStateStr(objectToMap);
                            objectToMap.putAll(stringObjectMap);
                            if (ListUtil.isNotEmpty((Collection)goodsList)) {
                                HashMap<String, String> param = new HashMap<String, String>();
                                for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                                    PmPromotionReDomain pmPromotionReDomain;
                                    List pmPromotionDiscountList;
                                    HashMap<String, BigDecimal> paramStr = new HashMap<String, BigDecimal>();
                                    Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomain);
                                    param.put("promotionName", ocContractGoodsDomain.getGoodsProperty2());
                                    param.put("tenantCode", ocContractGoodsDomain.getTenantCode());
                                    SupQueryResult pmPromotionReDomainSupQueryResult = this.pmPromotionServiceRepository.queryPromotionPage(param);
                                    if (ListUtil.isNotEmpty((Collection)pmPromotionReDomainSupQueryResult.getList()) && ListUtil.isNotEmpty((Collection)(pmPromotionDiscountList = (pmPromotionReDomain = (PmPromotionReDomain)pmPromotionReDomainSupQueryResult.getList().get(0)).getPmPromotionDiscountList()))) {
                                        PmPromotionDiscountDomain pmPromotionDiscountDomain = (PmPromotionDiscountDomain)pmPromotionDiscountList.get(0);
                                        List pmPromotionDiscountlistList = pmPromotionDiscountDomain.getPmPromotionDiscountlistList();
                                        for (PmPromotionDiscountlistDomain mPromotionDiscountlistDomain : pmPromotionDiscountlistList) {
                                            BigDecimal sum = ocContractGoodsDomain.getGoodsNum().multiply(new BigDecimal(mPromotionDiscountlistDomain.getDiscountAmount())).divide(new BigDecimal(100));
                                            paramStr.put(mPromotionDiscountlistDomain.getPpdlOpname(), sum);
                                        }
                                    }
                                    objectDetailToMap.putAll(paramStr);
                                    objectDetailToMap.putAll(objectToMap);
                                    mapList.add(objectDetailToMap);
                                }
                                continue;
                            }
                            mapList.add(objectToMap);
                        }
                        break block54;
                    }
                    if (!"xs".equals(excelTemplate)) break block57;
                    HashMap<String, ArrayList<OcContractGoodsDomain>> NameMap = new HashMap<String, ArrayList<OcContractGoodsDomain>>();
                    HashMap<String, Map<String, Object>> ocMap = new HashMap<String, Map<String, Object>>();
                    for (Object oc : ocContractReDomainList) {
                        Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson(oc), String.class, Object.class);
                        Map<String, Object> stringObjectMap = this.coverOrderStateStr(objectToMap);
                        objectToMap.putAll(stringObjectMap);
                        ocMap.put(oc.getContractBillcode(), stringObjectMap);
                        List goodsList = oc.getGoodsList();
                        if (!ListUtil.isNotEmpty((Collection)goodsList)) continue;
                        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                            List<Object> ocContractGoodsDomainNameList = (List)NameMap.get(ocContractGoodsDomain.getGoodsName());
                            if (null == ocContractGoodsDomainNameList) {
                                ocContractGoodsDomainNameList = new ArrayList<OcContractGoodsDomain>();
                                NameMap.put(ocContractGoodsDomain.getGoodsName(), (ArrayList<OcContractGoodsDomain>)ocContractGoodsDomainNameList);
                            }
                            ocContractGoodsDomainNameList.add(ocContractGoodsDomain);
                        }
                    }
                    HashMap<String, BigDecimal> paramSum = new HashMap<String, BigDecimal>();
                    if (null == NameMap || NameMap.isEmpty()) break block54;
                    for (String name : NameMap.keySet()) {
                        List ocContractGoodsDomainList = (List)NameMap.get(name);
                        if (!ListUtil.isNotEmpty((Collection)ocContractGoodsDomainList)) continue;
                        BigDecimal sum = BigDecimal.ZERO;
                        for (OcContractGoodsDomain ocContractGoodsDomains : ocContractGoodsDomainList) {
                            Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomains);
                            Map objectToMap = (Map)ocMap.get(ocContractGoodsDomains.getContractBillcode());
                            objectDetailToMap.putAll(objectToMap);
                            mapList.add(objectDetailToMap);
                            BigDecimal goodsCamountSum = ocContractGoodsDomains.getGoodsCamount();
                            if (null == goodsCamountSum) {
                                goodsCamountSum = BigDecimal.ZERO;
                            }
                            sum = sum.add(goodsCamountSum);
                            paramSum.put(name, sum);
                        }
                        OcContractGoodsDomain ocContractGoodsDomains = new OcContractGoodsDomain();
                        ocContractGoodsDomains.setGoodsName("\u54c1\u9879\u5408\u8ba1:");
                        BigDecimal bigDecimal = (BigDecimal)paramSum.get(name);
                        if (null == bigDecimal) {
                            bigDecimal = BigDecimal.ZERO;
                        }
                        ocContractGoodsDomains.setGoodsCamount(bigDecimal);
                        Map<String, Object> objectDetailToMap1 = this.covertMap(ocContractGoodsDomains);
                        mapList.add(objectDetailToMap1);
                    }
                    break block54;
                }
                if (!"ms".equals(excelTemplate)) break block58;
                HashMap<String, ArrayList<OcContractGoodsDomain>> NameMap = new HashMap<String, ArrayList<OcContractGoodsDomain>>();
                HashMap<String, Map<String, Object>> ocMap = new HashMap<String, Map<String, Object>>();
                for (Object oc : ocContractReDomainList) {
                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson(oc), String.class, Object.class);
                    Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                    objectToMap.putAll(stringObjectMap);
                    ocMap.put(oc.getContractBillcode(), stringObjectMap);
                    List goodsList = oc.getGoodsList();
                    if (!ListUtil.isNotEmpty((Collection)goodsList)) continue;
                    for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                        List<Object> ocContractGoodsDomainNameList = (List)NameMap.get(ocContractGoodsDomain.getGoodsName());
                        if (null == ocContractGoodsDomainNameList) {
                            ocContractGoodsDomainNameList = new ArrayList<OcContractGoodsDomain>();
                            NameMap.put(ocContractGoodsDomain.getGoodsName(), (ArrayList<OcContractGoodsDomain>)ocContractGoodsDomainNameList);
                        }
                        ocContractGoodsDomainNameList.add(ocContractGoodsDomain);
                    }
                }
                HashMap paramSum = new HashMap();
                if (null == NameMap || NameMap.isEmpty()) break block54;
                for (String name : NameMap.keySet()) {
                    List ocContractGoodsDomainList = (List)NameMap.get(name);
                    if (!ListUtil.isNotEmpty((Collection)ocContractGoodsDomainList)) continue;
                    BigDecimal sum = BigDecimal.ZERO;
                    for (OcContractGoodsDomain ocContractGoodsDomains : ocContractGoodsDomainList) {
                        Map<String, Object> objectDetailToMap = this.covertMap(ocContractGoodsDomains);
                        Map objectToMap = (Map)ocMap.get(ocContractGoodsDomains.getContractBillcode());
                        objectDetailToMap.putAll(objectToMap);
                        mapList.add(objectDetailToMap);
                        BigDecimal goodsCamountSum = ocContractGoodsDomains.getGoodsCamount();
                        if (null == goodsCamountSum) {
                            goodsCamountSum = BigDecimal.ZERO;
                        }
                        sum = sum.add(goodsCamountSum);
                        paramSum.put(name, sum);
                    }
                    OcContractGoodsDomain ocContractGoodsDomains = new OcContractGoodsDomain();
                    ocContractGoodsDomains.setGoodsName("\u54c1\u9879\u5408\u8ba1:");
                    Object bigDecimal = (BigDecimal)paramSum.get(name);
                    if (null == bigDecimal) {
                        bigDecimal = BigDecimal.ZERO;
                    }
                    ocContractGoodsDomains.setGoodsCamount((BigDecimal)bigDecimal);
                }
                break block54;
            }
            if ("pg".equals(excelTemplate)) {
                for (OcContractReDomain oc : ocContractReDomainList) {
                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                    Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                    mapList.add(stringObjectMap);
                }
            } else if ("pgDetail".equals(excelTemplate) || "retailerDetail".equals(excelTemplate) || "retailer".equals(excelTemplate)) {
                for (OcContractReDomain oc : ocContractReDomainList) {
                    List goodsList = oc.getGoodsList();
                    boolean flag = false;
                    if (ListUtil.isNotEmpty((Collection)goodsList)) {
                        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                            Map<String, Object> objectDetailToMap = this.covertMapWtite(ocContractGoodsDomain);
                            if (!flag) {
                                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                Map<String, Object> stringObjectMap = this.coverOrderStatePg(objectToMap);
                                objectDetailToMap.putAll(stringObjectMap);
                                flag = true;
                            }
                            mapList.add(objectDetailToMap);
                        }
                        continue;
                    }
                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                    Map<String, Object> stringObjectMap = this.coverOrderStatePg(objectToMap);
                    mapList.add(stringObjectMap);
                }
            } else if ("retailerPackets".equals(excelTemplate) || "retailerPacketsDetail".equals(excelTemplate)) {
                for (OcContractReDomain occ : ocContractReDomainList) {
                    List occList = occ.getGoodsList();
                    boolean flags = false;
                    if (ListUtil.isNotEmpty((Collection)occList)) {
                        for (OcContractGoodsDomain ocContractGoodsDomain : occList) {
                            Map<String, Object> objectDetailToMap = this.covertMapWtite(ocContractGoodsDomain);
                            if (!flags) {
                                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)occ), String.class, Object.class);
                                Map<String, Object> stringObjectMap = this.coverOrderStatePg(objectToMap);
                                objectDetailToMap.putAll(stringObjectMap);
                                flags = true;
                            }
                            mapList.add(objectDetailToMap);
                        }
                        continue;
                    }
                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)occ), String.class, Object.class);
                    Map<String, Object> stringObjectMap = this.coverOrderState(objectToMap);
                    mapList.add(stringObjectMap);
                }
            } else if ("pt".equals(excelTemplate)) {
                for (OcContractReDomain oc : ocContractReDomainList) {
                    List goodsList = oc.getGoodsList();
                    boolean flag = false;
                    if (ListUtil.isNotEmpty((Collection)goodsList)) {
                        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                            Map<String, Object> objectDetailToMap = this.covertMapWtite(ocContractGoodsDomain);
                            if (!flag) {
                                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                Map<String, Object> stringObjectMap = this.coverOrderStatePt(objectToMap);
                                objectDetailToMap.putAll(stringObjectMap);
                                flag = true;
                            }
                            mapList.add(objectDetailToMap);
                        }
                        continue;
                    }
                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                    Map<String, Object> stringObjectMap = this.coverOrderStatePt(objectToMap);
                    mapList.add(stringObjectMap);
                }
            } else if ("ptD".equals(excelTemplate)) {
                for (OcContractReDomain oc : ocContractReDomainList) {
                    List goodsList = oc.getGoodsList();
                    boolean flag = false;
                    if (ListUtil.isNotEmpty((Collection)goodsList)) {
                        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                            Map<String, Object> objectDetailToMap = this.covertMapWtite(ocContractGoodsDomain);
                            if (!flag) {
                                Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                                Map<String, Object> stringObjectMap = this.coverOrderStatePtD(objectToMap);
                                objectDetailToMap.putAll(stringObjectMap);
                                flag = true;
                            }
                            mapList.add(objectDetailToMap);
                        }
                        continue;
                    }
                    Map objectToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(JsonUtil.buildNonDefaultBinder().toJson((Object)oc), String.class, Object.class);
                    Map<String, Object> stringObjectMap = this.coverOrderStatePtD(objectToMap);
                    mapList.add(stringObjectMap);
                }
            }
        }
        return mapList;
    }

    protected Map<String, Object> coverOrderStatePtD(Map<String, Object> map) {
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 3: {
                map.put("dataState", "\u5df2\u53d1\u8d27");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 4: {
                map.put("dataState", "\u4ea4\u6613\u6210\u529f");
                break;
            }
            case 0: {
                map.put("dataState", "\u5ba1\u6838");
                break;
            }
            case 5: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderStatePt(Map<String, Object> map) {
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case 30: {
                map.put("dataState", "\u5f85\u6210\u56e2");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u53d1\u8d27");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderStatePg(Map<String, Object> map) {
        String contractType;
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        String mj = "\u7528\u6237\u540d" + (String)map.get("goodsReceiptMem") + "\u624b\u673a\u53f7" + (String)map.get("goodsReceiptPhone");
        map.put("mj", mj);
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 0: {
                map.put("dataState", "\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u53d1\u8d27");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            case 5: {
                map.put("dataState", "\u4ea4\u6613\u6210\u529f");
                break;
            }
            case 9: {
                map.put("dataState", "\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u4ea4\u6613");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        Integer contractPmode = null == map.get("contractPmode") ? 8888 : Integer.valueOf(map.get("contractPmode").toString());
        switch (contractPmode) {
            case 0: {
                map.put("contractPmode", "\u7ebf\u4e0a");
                break;
            }
            case 1: {
                map.put("contractPmode", "\u7ebf\u4e0b");
                break;
            }
            case 3: {
                map.put("contractPmode", "\u8d27\u5230\u4ed8\u6b3e");
                break;
            }
            default: {
                map.put("contractPmode", "\u672a\u77e5\u72b6\u6001:" + map.get("contractPmode"));
            }
        }
        switch (contractType = String.valueOf(null == map.get("contractType") ? Integer.valueOf(8888) : map.get("contractType").toString())) {
            case "00": {
                map.put("contractType", "\u5b9e\u7269\u8ba2\u5355");
                break;
            }
            case "06": {
                map.put("contractType", "\u79ef\u5206\u8ba2\u5355");
                break;
            }
            case "30": {
                map.put("contractType", "\u9884\u552e\u8ba2\u5355");
                break;
            }
            case "28": {
                map.put("contractType", "\u865a\u62df\u8ba2\u5355");
                break;
            }
            case "26": {
                map.put("contractType", "\u79d2\u6740\u8ba2\u5355");
                break;
            }
            default: {
                map.put("contractType", "\u672a\u77e5\u72b6\u6001:" + map.get("contractType"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderStateStr(Map<String, Object> map) {
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u5ba1\u6838");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u8f6c\u5355");
                break;
            }
            case 5: {
                map.put("dataState", "\u751f\u4ea7\u4e2d");
                break;
            }
            case 0: {
                map.put("dataState", "\u5904\u7406\u4e2d");
                break;
            }
            case 7: {
                map.put("dataState", "\u5f85\u5206\u5382");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u51fa\u5e93");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> coverOrderUser(String userinfoCode, String tenantCode) {
        UmUserinfoReDomainBean userinfoByCode = this.userServiceRepository.getUserinfoByCode(userinfoCode, tenantCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != userinfoByCode) {
            map.put("userinfoOcode", userinfoByCode.getUserinfoOcode());
            map.put("cityName", userinfoByCode.getCityName());
        }
        return map;
    }

    protected Map<String, Object> coverOrderState(Map<String, Object> map) {
        String contractType;
        if (null == map.get("contractDepositdate")) {
            map.put("contractDepositdate", map.get("gmtModified"));
        }
        map.put("contractValidate", map.get("gmtCreate"));
        String mj = "\u7528\u6237\u540d" + (String)map.get("goodsReceiptMem") + "\u624b\u673a\u53f7" + (String)map.get("goodsReceiptPhone");
        map.put("mj", mj);
        String lTime = (String)map.get("promotionBegintime") + (String)map.get("promotionEndtime");
        String YTime = (String)map.get("receiveStart") + (String)map.get("receiveEnd");
        map.put("lTime", lTime);
        map.put("YTime", YTime);
        Integer contractPmode = null == map.get("contractPmode") ? 8888 : Integer.valueOf(map.get("contractPmode").toString());
        switch (contractPmode) {
            case 0: {
                map.put("contractPmode", "\u7ebf\u4e0a");
                break;
            }
            case 1: {
                map.put("contractPmode", "\u7ebf\u4e0b");
                break;
            }
            case 3: {
                map.put("contractPmode", "\u8d27\u5230\u4ed8\u6b3e");
                break;
            }
            default: {
                map.put("contractPmode", "\u672a\u77e5\u72b6\u6001:" + map.get("contractPmode"));
            }
        }
        switch (contractType = String.valueOf(null == map.get("contractType") ? Integer.valueOf(8888) : map.get("contractType").toString())) {
            case "00": {
                map.put("contractType", "\u5b9e\u7269\u8ba2\u5355");
                break;
            }
            case "06": {
                map.put("contractType", "\u79ef\u5206\u8ba2\u5355");
                break;
            }
            case "30": {
                map.put("contractType", "\u9884\u552e\u8ba2\u5355");
                break;
            }
            case "26": {
                map.put("contractType", "\u79d2\u6740\u8ba2\u5355");
                break;
            }
            default: {
                map.put("contractType", "\u672a\u77e5\u72b6\u6001:" + map.get("contractType"));
            }
        }
        Integer dataState = null == map.get("dataState") ? 8888 : Integer.valueOf(map.get("dataState").toString());
        switch (dataState) {
            case -1: {
                map.put("dataState", "\u5df2\u53d6\u6d88");
                break;
            }
            case 0: {
                map.put("dataState", "\u5ba1\u6838");
                break;
            }
            case 1: {
                map.put("dataState", "\u5f85\u4ed8\u6b3e");
                break;
            }
            case 2: {
                map.put("dataState", "\u5f85\u53d1\u8d27");
                break;
            }
            case 3: {
                map.put("dataState", "\u5df2\u53d1\u8d27");
                break;
            }
            case 9: {
                map.put("dataState", "\u5e93\u5b58\u4e0d\u8db3,\u65e0\u6cd5\u4ea4\u6613");
                break;
            }
            case 4: {
                map.put("dataState", "\u5df2\u5b8c\u6210");
                break;
            }
            case 5: {
                map.put("dataState", "\u4ea4\u6613\u6210\u529f");
                break;
            }
            default: {
                map.put("dataState", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map;
    }

    protected Map<String, Object> covercontractPayamoneyStr(Map<String, Object> map) {
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        Integer dataState = 0;
        String str = null;
        if (null != map.get("contractPayamoney") && map.get("tenantCode").equals("2019110100000001")) {
            str = map.get("contractPayamoney").toString().trim();
            Double v = Double.parseDouble(str);
            int b = v.intValue();
            dataState = b;
        }
        switch (dataState) {
            case 0: {
                map1.put("contractPayamoneyStr", "\u65e0");
                break;
            }
            case 1: {
                map1.put("contractPayamoneyStr", "\u6309\u6bd4\u4f8b");
                break;
            }
            case 2: {
                map1.put("contractPayamoneyStr", "\u56fa\u5b9a\u989d\u5ea6");
                break;
            }
            default: {
                map1.put("contractPayamoneyStr", "\u672a\u77e5\u72b6\u6001:" + map.get("dataState"));
            }
        }
        return map1;
    }

    protected Map<String, Object> covertMap(OcContractGoodsDomain ocContractGoodsDomain) {
        HashMap<String, Object> orderDetaiMap = new HashMap<String, Object>();
        orderDetaiMap.put("classtreeName", ocContractGoodsDomain.getClasstreeName());
        orderDetaiMap.put("warehouseName", ocContractGoodsDomain.getWarehouseName());
        orderDetaiMap.put("goodsProperty5", ocContractGoodsDomain.getGoodsProperty5());
        orderDetaiMap.put("goodsSupplyweight", ocContractGoodsDomain.getGoodsSupplyweight());
        orderDetaiMap.put("partsnameWeightunitStr", ocContractGoodsDomain.getPartsnameWeightunit());
        orderDetaiMap.put("partsnameWeightunit", ocContractGoodsDomain.getPartsnameWeightunit());
        orderDetaiMap.put("goodsNo", ocContractGoodsDomain.getGoodsNo());
        orderDetaiMap.put("goodsName", ocContractGoodsDomain.getGoodsName());
        orderDetaiMap.put("goodsCamount", ocContractGoodsDomain.getGoodsCamount());
        orderDetaiMap.put("contractGoodsInmoney", ocContractGoodsDomain.getContractGoodsInmoney());
        orderDetaiMap.put("contractGoodsMoney", ocContractGoodsDomain.getContractGoodsMoney());
        orderDetaiMap.put("pricesetNprice", ocContractGoodsDomain.getPricesetNprice());
        orderDetaiMap.put("contractGoodsPrice", ocContractGoodsDomain.getContractGoodsPrice());
        orderDetaiMap.put("skuNo", ocContractGoodsDomain.getSkuNo());
        orderDetaiMap.put("skuName", ocContractGoodsDomain.getSkuName());
        orderDetaiMap.put("goodsProperty2", ocContractGoodsDomain.getGoodsProperty2());
        orderDetaiMap.put("goodsProperty3", ocContractGoodsDomain.getGoodsProperty3());
        orderDetaiMap.put("contractGoodsRemark", ocContractGoodsDomain.getContractGoodsRemark());
        orderDetaiMap.put("contractGoodsGtype", ocContractGoodsDomain.getContractGoodsGtype());
        orderDetaiMap.put("memo", ocContractGoodsDomain.getMemo());
        orderDetaiMap.put("goodsRemark", ocContractGoodsDomain.getGoodsRemark());
        orderDetaiMap.put("contractGoodsId", ocContractGoodsDomain.getContractGoodsId());
        orderDetaiMap.put("goodsOrdnum", ocContractGoodsDomain.getGoodsOrdnum());
        orderDetaiMap.put("skuName", ocContractGoodsDomain.getSkuName());
        if (null == ocContractGoodsDomain.getGoodsCamount()) {
            ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getGoodsOneweight()) {
            ocContractGoodsDomain.setGoodsOneweight(BigDecimal.ZERO);
        }
        BigDecimal qty = ocContractGoodsDomain.getGoodsCamount().multiply(ocContractGoodsDomain.getGoodsOneweight());
        orderDetaiMap.put("partsnameWeightunit", qty);
        orderDetaiMap.put("goodsSpec5", ocContractGoodsDomain.getGoodsSpec5());
        if (null == ocContractGoodsDomain.getGoodsOrdnum()) {
            ocContractGoodsDomain.setGoodsOrdnum(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getGoodsCamount()) {
            ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
        }
        orderDetaiMap.put("goodsOrdnumSimple", ocContractGoodsDomain.getGoodsOrdnum().subtract(ocContractGoodsDomain.getGoodsCamount()));
        if (null != ocContractGoodsDomain.getDataState()) {
            String contractGoodsDataState = "";
            contractGoodsDataState = -1 == ocContractGoodsDomain.getDataState() ? "\u53d6\u6d88" : "\u6b63\u5e38";
            orderDetaiMap.put("contractGoodsDataState", contractGoodsDataState);
        }
        return orderDetaiMap;
    }

    protected Map<String, Object> covertMapWtite(OcContractGoodsDomain ocContractGoodsDomain) {
        HashMap<String, Object> orderMaps = new HashMap<String, Object>();
        orderMaps.put("goodsNo", ocContractGoodsDomain.getGoodsNo());
        orderMaps.put("skuBarcode", ocContractGoodsDomain.getSkuBarcode());
        orderMaps.put("skuName", ocContractGoodsDomain.getSkuName());
        orderMaps.put("goodsName", ocContractGoodsDomain.getGoodsName());
        orderMaps.put("pntreeName", ocContractGoodsDomain.getPntreeName());
        orderMaps.put("classtreeName", ocContractGoodsDomain.getClasstreeName());
        orderMaps.put("classtreeCode", ocContractGoodsDomain.getClasstreeCode());
        orderMaps.put("partsnameNumunit", ocContractGoodsDomain.getPartsnameNumunit());
        orderMaps.put("goodsName", ocContractGoodsDomain.getGoodsName());
        orderMaps.put("goodsOneweight", ocContractGoodsDomain.getGoodsOneweight());
        orderMaps.put("pricesetNprice", ocContractGoodsDomain.getPricesetNprice());
        orderMaps.put("goodsInmoney", ocContractGoodsDomain.getContractGoodsInmoney());
        orderMaps.put("goodsNum", ocContractGoodsDomain.getGoodsNum());
        orderMaps.put("goodsNum", ocContractGoodsDomain.getGoodsNum());
        orderMaps.put("contractGoodsInmoney", ocContractGoodsDomain.getContractGoodsInmoney());
        orderMaps.put("contractGoodsMoney", ocContractGoodsDomain.getContractGoodsMoney());
        orderMaps.put("goodsCamount", ocContractGoodsDomain.getGoodsCamount());
        orderMaps.put("goodsOrdnum", ocContractGoodsDomain.getGoodsOrdnum());
        return orderMaps;
    }

    public List<OcContractReDomain> queryContractPlatForBalanceCom(HttpServletRequest request, String memberCcode) {
        SupQueryResult qlist;
        if (StringUtils.isBlank((String)memberCcode)) {
            return null;
        }
        Map param = this.assemMapParam(request);
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (null == param) {
            return null;
        }
        param.put("memberCcode", memberCcode);
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("dataState", OcContractServiceRepository.dataState_4);
        String erpFlag = (String)param.get("erpFlag");
        if (StringUtils.isBlank((String)erpFlag)) {
            erpFlag = "0";
        }
        if (null == (qlist = this.ocContractServiceRepository.queryContractPageReDomain(param)) || ListUtil.isEmpty((Collection)qlist.getList())) {
            return null;
        }
        List<OcContractReDomain> ocContractReDomainList = this.create(qlist.getList(), erpFlag);
        for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
            String erpCode = ocContractReDomain.getErpCode();
            if (StringUtils.isNotBlank((String)erpCode)) continue;
            String erpMsg = this.ocContractServiceRepository.queryOrderIsMsg(ocContractReDomain.getContractBillcode());
            if (StringUtils.isNotBlank((String)erpMsg)) {
                ocContractReDomain.setMemo(erpMsg);
                continue;
            }
            List ocCflowPprocessReDomainList = this.ocCflowPprocessServiceRepository.queryCflowPprocessPage(this.getQueryMapParam("contractBillcode,cflowPserviceCode,tenantCode", new Object[]{ocContractReDomain.getContractBillcode(), "P39", ocContractReDomain.getTenantCode()})).getList();
            if (ListUtil.isEmpty((Collection)ocCflowPprocessReDomainList)) {
                erpMsg = "\u672a\u63a8\u9001\u4ea7\u751f\u63a8\u9001\u6570\u636e,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u6838\u67e5\uff01";
                ocContractReDomain.setMemo(erpMsg);
                continue;
            }
            if (ocCflowPprocessReDomainList.size() == 1) {
                OcCflowPprocessReDomain ocCflowPprocessReDomain = (OcCflowPprocessReDomain)ocCflowPprocessReDomainList.get(0);
                Integer dataState = ocCflowPprocessReDomain.getDataState();
                if (dataState == 2) {
                    erpMsg = "\u5df2\u63a8\u9001\u5bcc\u57fa\u672a\u5165\u673a,\u5bcc\u57fa\u5165\u673a\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e\u67e5\u770b\uff01";
                    ocContractReDomain.setMemo(erpMsg);
                }
                if (dataState != 3 && dataState != 0) continue;
                erpMsg = "\u63a8\u9001\u5f02\u5e38,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff01";
                ocContractReDomain.setMemo(erpMsg);
                continue;
            }
            boolean successflag = false;
            for (OcCflowPprocessReDomain ocCflowPprocessReDomain : ocCflowPprocessReDomainList) {
                Integer dataState = ocCflowPprocessReDomain.getDataState();
                if (dataState != 2) continue;
                successflag = true;
            }
            if (successflag) {
                erpMsg = "\u5df2\u63a8\u9001\u5bcc\u57fa\u672a\u5165\u673a,\u5bcc\u57fa\u5165\u673a\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e\u67e5\u770b\uff01";
                ocContractReDomain.setMemo(erpMsg);
                continue;
            }
            erpMsg = "\u63a8\u9001\u5f02\u5e38,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff01";
            ocContractReDomain.setMemo(erpMsg);
        }
        return ocContractReDomainList;
    }

    protected List<OcContractReDomain> create(List<OcContractReDomain> list, String erpFlag) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String nostr = this.getListToString(list);
        Map<String, Map<String, Object>> erpMap = this.queryErp(nostr);
        ArrayList<OcContractReDomain> relist = new ArrayList<OcContractReDomain>();
        for (OcContractReDomain ocContractReDomain : list) {
            if (MapUtil.isNotEmpty(erpMap)) {
                Map<String, Object> valueMap = erpMap.get(ocContractReDomain.getContractBillcode());
                if (MapUtil.isNotEmpty(valueMap)) {
                    Object erpAmt = valueMap.get("erpAmt");
                    if (null == erpAmt) {
                        erpAmt = "0";
                    }
                    ocContractReDomain.setErpAmt(new BigDecimal(erpAmt.toString()));
                    ocContractReDomain.setErpCode((String)valueMap.get("erpCode"));
                    ocContractReDomain.setErpDate((String)valueMap.get("erpDate"));
                    if ("2".equals(erpFlag)) continue;
                    relist.add(ocContractReDomain);
                    continue;
                }
                this.logger.info(CODE + ".queryErp.valueMap.null", (Object)("valueMap:" + valueMap));
                if ("1".equals(erpFlag)) continue;
                relist.add(ocContractReDomain);
                continue;
            }
            this.logger.info(CODE + ".queryErp.null", (Object)("erpMap:" + erpMap));
            if ("1".equals(erpFlag)) continue;
            relist.add(ocContractReDomain);
        }
        return relist;
    }

    private Map<String, Map<String, Object>> queryErp(String nostr) {
        if (StringUtils.isBlank((String)nostr)) {
            return null;
        }
        return this.ocContractServiceRepository.queryOrderErpFlag(nostr);
    }

    private String getListToString(List<OcContractReDomain> list) {
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        String noStr = "";
        for (OcContractReDomain ocContractReDomain : list) {
            if (StringUtils.isNotBlank((String)noStr)) {
                noStr = noStr + ",";
            }
            noStr = noStr + ocContractReDomain.getContractBillcode();
        }
        return noStr;
    }

    private UserSession getUserSession(String memberBcode, UserSession userSession) {
        if (StringUtils.isBlank((String)memberBcode) || null == userSession) {
            return null;
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = this.userServiceRepository.getUserinfoByCode(memberBcode, userSession.getTenantCode());
        if (null == umUserinfoReDomainBean) {
            return null;
        }
        UserSession reuserSession = new UserSession();
        try {
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)userSession);
            BeanUtils.copyAllPropertys((Object)reuserSession, (Object)umUserinfoReDomainBean);
            reuserSession.setUserCode(userSession.getUserCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        reuserSession.setMerberCompname(umUserinfoReDomainBean.getUserinfoCompname());
        SupQueryResult qmem = this.umGroupServiceRepository.queryGroupListPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{umUserinfoReDomainBean.getUserinfoCode(), umUserinfoReDomainBean.getTenantCode()}));
        if (null != qmem && ListUtil.isNotEmpty((Collection)qmem.getList())) {
            reuserSession.setGroupCode(((UmGroupListReDomain)qmem.getList().get(0)).getGroupCode());
            reuserSession.setGroupName(((UmGroupListReDomain)qmem.getList().get(0)).getGroupName());
        }
        return reuserSession;
    }

    public List<PmUserCouponReDomain> queryUserConByGoodsCom(HttpServletRequest request, String pmContractGoodsDomainListStr, String memberBcode, String contractPmode) {
        if (StringUtils.isBlank((String)pmContractGoodsDomainListStr)) {
            this.logger.error(CODE + ".queryUserConByGoodsCom", (Object)"param is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        if (StringUtils.isNotBlank((String)memberBcode)) {
            userSession = this.getUserSession(memberBcode, userSession);
        }
        List pmContractGoodsDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(pmContractGoodsDomainListStr, PmContractGoodsDomain.class);
        return this.ocContractServiceRepository.queryUserCon(pmContractGoodsDomainList, this.ocContractServiceRepository.getPmCheckBean(this.getNowChannel(request), this.getProappCode(request), this.getTenantCode(request), userSession.getUserPcode(), userSession.getMerberCompname(), userSession.getUserName(), contractPmode));
    }

    public SupQueryResult<OcConsumeBigData> queryAllUserOcConsumeBigDataPageCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.ocContractServiceRepository.queryAllUserOcConsumeBigDataPage(param);
    }

    public List<OcConsumeBigData> queryAllOcConsumeBigDataByDayCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.ocContractServiceRepository.queryAllOcConsumeBigDataByDay(param);
    }

    public SupQueryResult<OcConsumeBigData> queryAllOcConsumeBigDataForSellerPageCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.ocContractServiceRepository.queryAllOcConsumeBigDataForSellerPage(param);
    }

    public HtmlJsonReBean getOrderInvUrlCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (MapUtil.isEmpty((Map)param)) {
            this.logger.error(CODE + ".getOrderInvUrl.param.null", (Object)"param is null");
            return new HtmlJsonReBean("error", "param is null");
        }
        HashMap queryUserinfoMap = new HashMap();
        queryUserinfoMap.put("userinfoCode", param.get("memberCcode"));
        SupQueryResult umUserinfoReResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoMap);
        if (ListUtil.isEmpty((Collection)umUserinfoReResult.getList())) {
            this.logger.error(CODE + ".getOrderInvUrl.queryUserinfoPage.null", (Object)"shop is null");
            return new HtmlJsonReBean("error", "shop is null");
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUserinfoReResult.getList().get(0);
        String shopId = umUserinfoReDomainBean.getUserinfoOcode();
        String requestUrl = "";
        String requestKey = "";
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isNotBlank((String)tenantCode)) {
            requestKey = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestOrderInvUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)requestKey);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error(CODE + ".getOrderInvUrl.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + requestKey + ",tenantCode:" + tenantCode));
            return new HtmlJsonReBean("error", "requestUrl is null");
        }
        String orderInvSecretKey = tenantCode.concat("-").concat("SS_SECRET").concat("-").concat(shopId);
        String shopScreact = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)orderInvSecretKey);
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.SupDisUtil.null", (Object)"shopScreact is null");
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.null", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String[] split = shopScreact.split("-");
        if (null == split || split.length != 2) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.split", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String key = split[0];
        String secret = split[1];
        String ddh = shopId + param.get("contractBillcode").toString();
        String je = param.get("dataBmoney").toString();
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.key or secret.null", (Object)(key + "-" + secret));
            return new HtmlJsonReBean("error", "key or secret is null");
        }
        if (StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.secretMap.null", (Object)(shopId + ":shopScreact is null"));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String md5_2 = MD5Util.MD5((String)(key + ddh + MD5Util.MD5((String)(secret + ddh)) + je));
        String url = requestUrl + "?k=" + key + "," + ddh + "," + je + "," + md5_2 + ",$";
        return new HtmlJsonReBean((Object)url);
    }

    public HtmlJsonReBean getOrderInvUrlForPlatCom(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (MapUtil.isEmpty((Map)param)) {
            this.logger.error(CODE + ".getOrderInvUrl.param.null", (Object)"param is null");
            return new HtmlJsonReBean("error", "param is null");
        }
        if (StringUtils.isBlank((String)((String)param.get("memberCcode")))) {
            this.logger.error(CODE + ".getOrderInvUrl.memberCcode.null", (Object)"param is null");
            return new HtmlJsonReBean("error", "memberCcode is null");
        }
        HashMap queryUserinfoMap = new HashMap();
        queryUserinfoMap.put("userinfoCode", param.get("memberCcode"));
        SupQueryResult umUserinfoReResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoMap);
        if (ListUtil.isEmpty((Collection)umUserinfoReResult.getList())) {
            this.logger.error(CODE + ".getOrderInvUrl.queryUserinfoPage.null", (Object)"shop is null");
            return new HtmlJsonReBean("error", "shop is null");
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUserinfoReResult.getList().get(0);
        String shopId = umUserinfoReDomainBean.getUserinfoOcode();
        if (StringUtils.isBlank((String)shopId)) {
            this.logger.error(CODE + ".getOrderInvUrl.shopId.null", param.get("memberCcode"));
            return new HtmlJsonReBean("error", "shopId is null");
        }
        String requestUrl = "";
        String requestKey = "";
        String tenantCode = this.getTenantCode(request);
        if (StringUtils.isNotBlank((String)tenantCode)) {
            requestKey = tenantCode.concat("-").concat("SSURL").concat("-").concat("requestOrderInvUrl");
            requestUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)requestKey);
        }
        if (StringUtils.isBlank((String)requestUrl)) {
            this.logger.error(CODE + ".getOrderInvUrl.getRequestUrl", (Object)("\u83b7\u53d6\u5730\u5740\u4e3a\u7a7a\uff01\uff01\uff01key\uff1a" + requestKey + ",tenantCode:" + tenantCode));
            return new HtmlJsonReBean("error", "requestUrl is null");
        }
        String orderInvSecretKey = tenantCode.concat("-").concat("SS_SECRET").concat("-").concat(shopId);
        String shopScreact = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)orderInvSecretKey);
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.SupDisUtil.null", (Object)"shopScreact is null");
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        if (StringUtils.isBlank((String)shopScreact)) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.null", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String[] split = shopScreact.split("-");
        if (null == split || split.length != 2) {
            this.logger.error(CODE + ".getOrderInvUrl.shopScreact.split", (Object)("shopScreact is null,key:" + orderInvSecretKey));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String key = split[0];
        String secret = split[1];
        String ddh = shopId + param.get("contractBillcode").toString();
        String je = param.get("dataBmoney").toString();
        if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.key or secret.null", (Object)(key + "-" + secret));
            return new HtmlJsonReBean("error", "key or secret is null");
        }
        if (StringUtils.isBlank((String)secret)) {
            this.logger.error(CODE + ".getOrderInvUrl.secretMap.null", (Object)(shopId + ":shopScreact is null"));
            return new HtmlJsonReBean("error", "shopScreact is null");
        }
        String md5_2 = MD5Util.MD5((String)(key + ddh + MD5Util.MD5((String)(secret + ddh)) + je));
        String url = requestUrl + "?k=" + key + "," + ddh + "," + je + "," + md5_2 + ",$";
        this.logger.error(CODE + ".getOrderInvUrlForPlatCom.url", (Object)url);
        String text = "";
        try {
            int width = 120;
            String widthStr = (String)param.get("width");
            if (StringUtils.isNotBlank((String)widthStr)) {
                width = Integer.valueOf(widthStr);
            }
            int height = 120;
            String heightStr = (String)param.get("height");
            if (StringUtils.isNotBlank((String)heightStr)) {
                height = Integer.valueOf(heightStr);
            }
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.MARGIN, 0);
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            BitMatrix bitMatrix = qrCodeWriter.encode(url, BarcodeFormat.QR_CODE, width, height, hints);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream(bitMatrix, "PNG", outputStream);
            text = Base64.encodeBase64String((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.error(CODE + ".getOrderInvUrlForPlatCom.text", (Object)text);
        return new HtmlJsonReBean((Object)text);
    }

    public HtmlJsonReBean updateContractDelcodeCom(HttpServletRequest request, String contractBillcode, String contractDelcode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)contractDelcode)) {
            this.logger.error(CODE + ".updateContractDelcodeCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("contractBillcode", contractBillcode);
        param.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractOneByCode(param);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".updateContractDelcodeCom.ocContractReDomain", (Object)((Object)param).toString());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63d0\u8d27\u7801\u6709\u8bef");
        }
        if (!contractDelcode.equals(ocContractReDomain.getContractDelcode())) {
            UmUserinfoReDomainBean umUserinfoReDomainBean = this.userServiceRepository.getUserinfoByCode(ocContractReDomain.getMemberBcode(), this.getTenantCode(request));
            if (null == umUserinfoReDomainBean) {
                this.logger.error(CODE + ".updateContractDelcodeCom.umUserinfoReDomainBean", (Object)contractDelcode);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63d0\u8d27\u7801\u6709\u8bef");
            }
            if (!contractDelcode.equals(umUserinfoReDomainBean.getUserinfoUcode())) {
                this.logger.error(CODE + ".updateContractDelcodeCom.userinfoUcode", (Object)contractDelcode);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63d0\u8d27\u7801\u6709\u8bef");
            }
        }
        if (3 != ocContractReDomain.getDataState()) {
            this.logger.error(CODE + ".updateContractDelcodeCom.dataState", (Object)ocContractReDomain.getDataState());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
        }
        return this.ocContractServiceRepository.sendContractNext(contractBillcode, this.getTenantCode(request), null);
    }

    public HtmlJsonReBean updateContractUserinfoCodeCom(HttpServletRequest request, String contractBillcodes, String userinfoCode) {
        if (StringUtils.isBlank((String)contractBillcodes) || StringUtils.isBlank((String)userinfoCode)) {
            this.logger.error(CODE + ".updateContractUserinfoCodeCom", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".queryContractForUserBySupplierCode.userSession", (Object)"userSession is null");
            return null;
        }
        for (String contractBillcode : this.getcodeStrList(contractBillcodes)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("contractBillcode", contractBillcode);
            param.put("tenantCode", this.getTenantCode(request));
            param.put("userinfoCode", userinfoCode);
            OcContractReDomain contractByCode = this.ocContractServiceRepository.getContractByCode(param);
            if (null == contractByCode) {
                this.logger.error(CODE + ".updateContractUserinfoCodeCom.contractByCode", (Object)contractByCode);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u53f7\u6709\u8bef");
            }
            if (3 != contractByCode.getDataState()) {
                this.logger.error(CODE + ".updateContractUserinfoCodeCom.dataState", (Object)contractByCode.getDataState());
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u72b6\u6001\u6709\u8bef");
            }
            if (userSession.getUserPcode().equals(contractByCode.getGoodsSupplierCode())) continue;
            this.logger.error(CODE + ".updateContractUserinfoCodeCom.goodsSupplierCode", (Object)contractByCode.getGoodsSupplierCode());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u914d\u9001\u5546\u6709\u8bef");
        }
        for (String contractBillcode : this.getcodeStrList(contractBillcodes)) {
            this.ocContractServiceRepository.sendContractNext(contractBillcode, this.getTenantCode(request), null);
        }
        return new HtmlJsonReBean();
    }

    protected List<String> getcodeStrList(String codesStr) {
        String[] codeStr = codesStr.split(",");
        ArrayList<String> codeList = new ArrayList<String>();
        for (String code : codeStr) {
            codeList.add(code);
        }
        return codeList;
    }

    public HtmlJsonReBean updateContractStateExtendCom(Integer contractId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((Integer)contractId) || null == dataState) {
            this.logger.error(CODE + ".cancelContractForAll", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null != oldDataState) {
            OcContractReDomain contract = this.ocContractServiceRepository.getContract(contractId);
            if (null == contract) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "contract is null");
            }
            if (contract.getDataState().intValue() != oldDataState.intValue()) {
                return new HtmlJsonReBean("error", "\u72b6\u6001\u5df2\u53d8\u5316");
            }
        }
        return this.ocContractServiceRepository.updateContractStateExtend(contractId, dataState, oldDataState);
    }

    public String sendUpdateContracbal(String contractBillcode, String fundType, String feeName, String tenantCode, Map<String, Object> map) {
        return this.ocContractServiceRepository.sendUpdateContracbal(contractBillcode, fundType, feeName, tenantCode, map);
    }

    protected SupQueryResult<OcClinicRankingDomain> queryClinicRankingCom(HttpServletRequest request, Map<String, Object> map) {
        String METHOD_NAME = ".queryClinicRankingCom";
        this.logger.error(CODE + ".queryClinicRankingCom", (Object)JsonUtil.buildNonEmptyBinder().toJson(map));
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        if (map.get("startDate") == null) {
            map.put("startDate", sf.format(new Date()));
        }
        if (map.get("endDate") == null) {
            map.put("endDate", sf.format(new Date()));
        }
        HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
        queryUserinfoPageMap.put("userinfoQuality", "service");
        queryUserinfoPageMap.put("tenantCode", map.get("tenantCode"));
        queryUserinfoPageMap.put("userinfoCode", map.get("departCode"));
        queryUserinfoPageMap.put("userinfoParentCode", map.get("companyCode"));
        queryUserinfoPageMap.put("rows", map.get("rows"));
        queryUserinfoPageMap.put("page", map.get("page"));
        queryUserinfoPageMap.put("startRow", map.get("startRow"));
        queryUserinfoPageMap.put("endRow", map.get("endRow"));
        if (map.get("cityCode") == null) {
            queryUserinfoPageMap.put("provinceCode", map.get("provinceCode"));
        } else {
            queryUserinfoPageMap.put("cityCode", map.get("cityCode"));
        }
        queryUserinfoPageMap.put("fuzzy", true);
        SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoPageMap);
        List umUserinfoReDomainBeanList = new ArrayList();
        if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
            umUserinfoReDomainBeanList = umUserinfoReDomainBeanSupQueryResult.getList();
        }
        HashMap<String, Object> queryUserinfoPageAllMap = new HashMap<String, Object>();
        queryUserinfoPageAllMap.put("tenantCode", map.get("tenantCode"));
        SupQueryResult umUserinfoReDomainBeanAllSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoPageAllMap);
        List userinfoAllList = umUserinfoReDomainBeanAllSupQueryResult.getList();
        ArrayList<OcClinicRankingDomain> list = new ArrayList<OcClinicRankingDomain>();
        for (int i = 0; i < umUserinfoReDomainBeanList.size(); ++i) {
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            this.logger.error(CODE + ".queryClinicRankingCom", (Object)("===================getUserinfoParentCode->" + ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode() + "===getUserinfoCode->" + ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode()));
            queryContractPageMap.put("companyCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode());
            queryContractPageMap.put("departCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            queryContractPageMap.put("tenantCode", map.get("tenantCode"));
            queryContractPageMap.put("gmtCreateQstart", map.get("startDate") + " 00:00:00");
            queryContractPageMap.put("gmtCreateQend", map.get("endDate") + " 23:59:59");
            SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractPageMap);
            List ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
            List<String> everyDayList = this.getBetweenDates(map.get("startDate").toString(), map.get("endDate").toString());
            ArrayList<OcClinckDataDomain> ocClinckDataDomainList = new ArrayList<OcClinckDataDomain>();
            for (int j = 0; j < everyDayList.size(); ++j) {
                queryContractPageMap.put("gmtCreateQstart", everyDayList.get(j) + " 00:00:00");
                queryContractPageMap.put("gmtCreateQend", everyDayList.get(j) + " 23:59:59");
                SupQueryResult everyDayDataQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractPageMap);
                List everyDayDataList = everyDayDataQueryResult.getList();
                BigDecimal price = new BigDecimal(0);
                for (int k = 0; k < everyDayDataList.size(); ++k) {
                    price = price.add(((OcContractReDomain)everyDayDataList.get(k)).getDataBmoney());
                }
                OcClinckDataDomain ocClinckDataDomain = new OcClinckDataDomain();
                ocClinckDataDomain.setDate(everyDayList.get(j));
                ocClinckDataDomain.setTotal(Integer.valueOf(everyDayDataList.size()));
                ocClinckDataDomain.setPrice(price);
                ocClinckDataDomainList.add(ocClinckDataDomain);
            }
            BigDecimal price = new BigDecimal(0);
            for (int j = 0; j < ocContractReDomainList.size(); ++j) {
                price = price.add(((OcContractReDomain)ocContractReDomainList.get(j)).getDataBmoney());
            }
            OcClinicRankingDomain ocClinicRankingDomain = new OcClinicRankingDomain();
            ocClinicRankingDomain.setSalesAmount(price);
            ocClinicRankingDomain.setProvince(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getProvinceName());
            ocClinicRankingDomain.setCity(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getCityName());
            ocClinicRankingDomain.setClinic(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCompname());
            ocClinicRankingDomain.setOrderTotal(Integer.valueOf(ocContractReDomainList.size()));
            ocClinicRankingDomain.setChartData(ocClinckDataDomainList);
            for (int j = 0; j < userinfoAllList.size(); ++j) {
                if (!((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCode().equals(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode())) continue;
                if (((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoType() == 1) {
                    ocClinicRankingDomain.setStaff(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCompname());
                    break;
                }
                if (((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoType() == 2) {
                    ocClinicRankingDomain.setDistributor(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCompname());
                    break;
                }
                this.logger.error(CODE + ".queryClinicRankingCom", (Object)"\u672a\u77e5\u7c7b\u578b\uff01");
                break;
            }
            list.add(ocClinicRankingDomain);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, (Object)umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcClinicRankingDomain> queryCityClinicRankingCom(HttpServletRequest request, Map<String, Object> map, UserSession userSession) {
        this.logger.error(CODE + ".queryCityClinicRankingCom", (Object)"======================================\u524d\u5341\u57ce\u5e02\u8bca\u6240\u6392\u540d======================================");
        UmUserinfoReDomainBean umUserinfoReDomainBean = this.userServiceRepository.getUserInfoByUserinfoCode("20000210394750", map.get("tenantCode") + "");
        List<OcClinicRankingDomain> list = new ArrayList();
        this.logger.error(CODE + ".queryCityClinicRankingCom", (Object)("\u67e5\u51fa\u6765\u7684umUserinfoReDomainBean\u4e3a" + JsonUtil.buildNonEmptyBinder().toJson((Object)umUserinfoReDomainBean)));
        SupQueryResult umUserinfoReDomainBeanSupQueryResult = null;
        if (umUserinfoReDomainBean != null && umUserinfoReDomainBean.getCityName() != null && "".equals(umUserinfoReDomainBean.getCityName())) {
            this.logger.error(CODE + ".queryCityClinicRankingCom", (Object)("\u67e5\u51fa\u6765\u7684\u57ce\u5e02\u4e3a" + umUserinfoReDomainBean.getCityName()));
            HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
            queryUserinfoPageMap.put("userinfoQuality", "service");
            queryUserinfoPageMap.put("tenantCode", map.get("tenantCode"));
            queryUserinfoPageMap.put("fuzzy", true);
            umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoPageMap);
            List umUserinfoReDomainBeanList = new ArrayList();
            if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
                umUserinfoReDomainBeanList = umUserinfoReDomainBeanSupQueryResult.getList();
            }
            for (UmUserinfoReDomainBean userinfoReDomainBean : umUserinfoReDomainBeanList) {
                HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
                queryContractPageMap.put("departCode", userinfoReDomainBean.getUserinfoCode());
                queryContractPageMap.put("tenantCode", map.get("tenantCode"));
                queryContractPageMap.put("areaName", umUserinfoReDomainBean.getCityName());
                queryUserinfoPageMap.put("fuzzy", true);
                SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractPageMap);
                List ocContractReDomainList = new ArrayList();
                if (ocContractReDomainSupQueryResult != null && ocContractReDomainSupQueryResult.getList() != null) {
                    ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
                }
                BigDecimal price = new BigDecimal(0);
                for (int j = 0; j < ocContractReDomainList.size(); ++j) {
                    price = price.add(((OcContractReDomain)ocContractReDomainList.get(j)).getDataBmoney());
                }
                OcClinicRankingDomain ocClinicRankingDomain = new OcClinicRankingDomain();
                ocClinicRankingDomain.setSalesAmount(price);
                ocClinicRankingDomain.setClinic(userinfoReDomainBean.getUserinfoCompname());
                ocClinicRankingDomain.setOrderTotal(Integer.valueOf(ocContractReDomainList.size()));
                list.add(ocClinicRankingDomain);
            }
        } else {
            this.logger.error(CODE + ".queryCityClinicRankingCom", (Object)"\u672a\u67e5\u5230\u5f53\u524d\u767b\u5f55\u8005\u4fe1\u606f\u6216\u8005\u8bca\u6240\u57ce\u5e02\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Collections.sort(list, new Comparator<OcClinicRankingDomain>(){

            @Override
            public int compare(OcClinicRankingDomain o1, OcClinicRankingDomain o2) {
                return o2.getSalesAmount().compareTo(o1.getSalesAmount());
            }
        });
        if (list.size() > 10) {
            list = list.subList(0, 10);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    private List<String> getBetweenDates(String date1, String date2) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        Date start = null;
        Date end = null;
        try {
            start = sf.parse(date1);
            end = sf.parse(date2);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        tempStart.add(5, -1);
        tempStart.add(6, 1);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        tempEnd.add(5, 1);
        while (tempStart.before(tempEnd)) {
            result.add(sf.format(tempStart.getTime()));
            tempStart.add(6, 1);
        }
        return result;
    }

    protected SupQueryResult<OcBusinessDimensionDomain> queryBusinessDimensionCom(HttpServletRequest request, Map<String, Object> map) {
        String METHOD_NAME = ".queryBusinessDimensionCom";
        this.logger.error(CODE + ".queryBusinessDimensionCom", (Object)JsonUtil.buildNonEmptyBinder().toJson(map));
        HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
        queryUserinfoPageMap.put("userinfoQuality", "group");
        queryUserinfoPageMap.put("tenantCode", map.get("tenantCode"));
        queryUserinfoPageMap.put("userinfoCode", map.get("dentistCode"));
        queryUserinfoPageMap.put("userinfoParentCode", map.get("clinicCode"));
        queryUserinfoPageMap.put("gmtCreateQstart", map.get("startDate"));
        queryUserinfoPageMap.put("gmtCreateQend", map.get("endDate"));
        queryUserinfoPageMap.put("rows", map.get("rows"));
        queryUserinfoPageMap.put("page", map.get("page"));
        queryUserinfoPageMap.put("startRow", map.get("startRow"));
        queryUserinfoPageMap.put("endRow", map.get("endRow"));
        if (map.get("cityCode") == null) {
            queryUserinfoPageMap.put("provinceCode", map.get("provinceCode"));
        } else {
            queryUserinfoPageMap.put("cityCode", map.get("cityCode"));
        }
        queryUserinfoPageMap.put("fuzzy", true);
        SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoPageMap);
        List umUserinfoReDomainBeanList = new ArrayList();
        if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
            umUserinfoReDomainBeanList = umUserinfoReDomainBeanSupQueryResult.getList();
        }
        HashMap<String, Object> queryUserinfoPageAllMap = new HashMap<String, Object>();
        queryUserinfoPageAllMap.put("tenantCode", map.get("tenantCode"));
        SupQueryResult umUserinfoReDomainBeanAllSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoPageAllMap);
        List userinfoAllList = umUserinfoReDomainBeanAllSupQueryResult.getList();
        this.logger.error(CODE + ".queryBusinessDimensionCom", (Object)("========================\u6839\u636e\u4f9b\u5e94\u5546/\u5458\u5de5\u6392\u9664\u524d->" + umUserinfoReDomainBeanList.size()));
        if (map.get("companyCode") != null) {
            Iterator iterator = umUserinfoReDomainBeanList.iterator();
            while (iterator.hasNext()) {
                UmUserinfoReDomainBean next = (UmUserinfoReDomainBean)iterator.next();
                for (int i = 0; i < userinfoAllList.size(); ++i) {
                    if (!next.getUserinfoParentCode().equals(((UmUserinfoReDomainBean)userinfoAllList.get(i)).getUserinfoCode())) continue;
                    Boolean flag = true;
                    for (int j = 0; j < userinfoAllList.size(); ++j) {
                        if (!((UmUserinfoReDomainBean)userinfoAllList.get(i)).getUserinfoParentCode().equals(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCode()) || !((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCode().equals(map.get("companyCode"))) continue;
                        flag = false;
                        break;
                    }
                    if (!flag.booleanValue()) continue;
                    iterator.remove();
                }
            }
        }
        this.logger.error(CODE + ".queryBusinessDimensionCom", (Object)("========================\u6839\u636e\u4f9b\u5e94\u5546/\u5458\u5de5\u6392\u9664\u540e->" + umUserinfoReDomainBeanList.size()));
        if (map.get("startDate") == null && map.get("endDate") == null) {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            if (map.get("firstSaleStartDate") == null) {
                map.put("firstSaleStartDate", sf.format(new Date()) + " 00:00:00");
            }
            if (map.get("firstSaleEndDate") == null) {
                map.put("firstSaleEndDate", sf.format(new Date()) + " 23:59:59");
            }
            Iterator iterator = umUserinfoReDomainBeanList.iterator();
            while (iterator.hasNext()) {
                UmUserinfoReDomainBean next = (UmUserinfoReDomainBean)iterator.next();
                HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
                UmUserinfoReDomainBean umUserinfoReDomainBean = this.getParentUmUserinfoReDomainBean(next, userinfoAllList);
                if (umUserinfoReDomainBean != null) {
                    queryContractPageMap.put("companyCode", umUserinfoReDomainBean.getUserinfoCode());
                }
                queryContractPageMap.put("departCode", next.getUserinfoParentCode());
                queryContractPageMap.put("employeeCode", next.getUserinfoCode());
                queryContractPageMap.put("tenantCode", map.get("tenantCode"));
                SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractPageMap);
                List ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
                OcContractReDomain firstSaleOrder = this.getFirstSaleOrder(ocContractReDomainList);
                if (firstSaleOrder == null) {
                    this.logger.error(CODE + ".queryBusinessDimensionCom", (Object)"========================firstSaleOrder->null");
                    iterator.remove();
                    continue;
                }
                try {
                    this.logger.error(CODE + ".queryBusinessDimensionCom", (Object)("========================\u65f6\u95f4->" + firstSaleOrder.getGmtCreate()));
                    if (firstSaleOrder.getGmtCreate().compareTo(sf.parse(map.get("firstSaleStartDate").toString())) != -1 && firstSaleOrder.getGmtCreate().compareTo(sf.parse(map.get("firstSaleEndDate").toString())) != 1) continue;
                    iterator.remove();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
        this.logger.error(CODE + ".queryBusinessDimensionCom", (Object)("========================\u6839\u636e\u9996\u6b21\u9500\u552e\u65f6\u95f4\u6392\u9664\u540e->" + umUserinfoReDomainBeanList.size()));
        ArrayList<OcBusinessDimensionDomain> list = new ArrayList<OcBusinessDimensionDomain>();
        for (int i = 0; i < umUserinfoReDomainBeanList.size(); ++i) {
            this.logger.error(CODE + ".queryBusinessDimensionCom", (Object)("===================getUserinfoParentCode->" + ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode() + "===getUserinfoCode->" + ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode()));
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            UmUserinfoReDomainBean umUserinfoReDomainBean = this.getParentUmUserinfoReDomainBean((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i), userinfoAllList);
            if (umUserinfoReDomainBean != null) {
                queryContractPageMap.put("companyCode", umUserinfoReDomainBean.getUserinfoCode());
            }
            queryContractPageMap.put("departCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode());
            queryContractPageMap.put("employeeCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            queryContractPageMap.put("tenantCode", map.get("tenantCode"));
            this.logger.error(CODE + ".queryBusinessDimensionCom", (Object)"========================\u6309\u7167\u6ce8\u518c\u65f6\u95f4\u6bb5\u67e5\u8be2");
            if (map.get("startDate") == null && map.get("endDate") == null) {
                this.logger.error(CODE + ".queryBusinessDimensionCom", (Object)"========================\u6309\u7167\u9996\u6b21\u9500\u552e\u65f6\u95f4\u6bb5\u67e5\u8be2");
                queryContractPageMap.put("gmtCreateQstart", map.get("firstSaleStartDate"));
                queryContractPageMap.put("gmtCreateQend", map.get("firstSaleEndDate"));
            }
            SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractPageMap);
            List ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
            BigDecimal price = new BigDecimal(0);
            for (int j = 0; j < ocContractReDomainList.size(); ++j) {
                price = price.add(((OcContractReDomain)ocContractReDomainList.get(j)).getDataBmoney());
            }
            if (map.get("salesAmountStrat") != null && map.get("salesAmountEnd") != null ? price.compareTo(new BigDecimal(map.get("salesAmountStrat").toString())) == -1 || price.compareTo(new BigDecimal(map.get("salesAmountEnd").toString())) == 1 : (map.get("salesAmountStrat") != null && map.get("salesAmountEnd") == null ? price.compareTo(new BigDecimal(map.get("salesAmountStrat").toString())) == -1 : map.get("salesAmountStrat") == null && map.get("salesAmountEnd") != null && price.compareTo(new BigDecimal(map.get("salesAmountEnd").toString())) == 1)) continue;
            List<String> everyDayList = null;
            everyDayList = map.get("startDate") == null && map.get("endDate") == null ? this.getBetweenDates(map.get("firstSaleStartDate").toString(), map.get("firstSaleEndDate").toString()) : this.getBetweenDates(map.get("startDate").toString(), map.get("endDate").toString());
            ArrayList<OcClinckDataDomain> ocClinckDataDomainList = new ArrayList<OcClinckDataDomain>();
            for (int j = 0; j < everyDayList.size(); ++j) {
                queryContractPageMap.put("gmtCreateQstart", everyDayList.get(j) + " 00:00:00");
                queryContractPageMap.put("gmtCreateQend", everyDayList.get(j) + " 23:59:59");
                SupQueryResult everyDayDataQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractPageMap);
                List everyDayDataList = everyDayDataQueryResult.getList();
                BigDecimal priceToday = new BigDecimal(0);
                for (int k = 0; k < everyDayDataList.size(); ++k) {
                    priceToday = priceToday.add(((OcContractReDomain)everyDayDataList.get(k)).getDataBmoney());
                }
                OcClinckDataDomain ocClinckDataDomain = new OcClinckDataDomain();
                ocClinckDataDomain.setDate(everyDayList.get(j));
                ocClinckDataDomain.setTotal(Integer.valueOf(everyDayDataList.size()));
                ocClinckDataDomain.setPrice(priceToday);
                ocClinckDataDomainList.add(ocClinckDataDomain);
            }
            queryContractPageMap.put("gmtCreateQstart", null);
            queryContractPageMap.put("gmtCreateQend", null);
            SupQueryResult everyDayDataQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractPageMap);
            List nowDataList = everyDayDataQueryResult.getList();
            OcContractReDomain firstSaleOrder = this.getFirstSaleOrder(nowDataList);
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            OcBusinessDimensionDomain ocBusinessDimensionDomain = new OcBusinessDimensionDomain();
            ocBusinessDimensionDomain.setSalesAmount(price);
            ocBusinessDimensionDomain.setRegistrationDate(sf.format(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getGmtCreate()));
            if (firstSaleOrder != null) {
                ocBusinessDimensionDomain.setFirstSaleDate(sf.format(firstSaleOrder.getGmtCreate()));
            }
            ocBusinessDimensionDomain.setProvince(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getProvinceName());
            ocBusinessDimensionDomain.setDentist(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCompname());
            ocBusinessDimensionDomain.setCity(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getCityName());
            ocBusinessDimensionDomain.setOrderTotal(Integer.valueOf(ocContractReDomainList.size()));
            ocBusinessDimensionDomain.setChartData(ocClinckDataDomainList);
            for (int j = 0; j < userinfoAllList.size(); ++j) {
                if (!((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCode().equals(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode())) continue;
                for (int k = 0; k < userinfoAllList.size(); ++k) {
                    if (!((UmUserinfoReDomainBean)userinfoAllList.get(k)).getUserinfoCode().equals(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoParentCode())) continue;
                    if (((UmUserinfoReDomainBean)userinfoAllList.get(k)).getUserinfoType() == 1) {
                        ocBusinessDimensionDomain.setStaff(((UmUserinfoReDomainBean)userinfoAllList.get(k)).getUserinfoCompname());
                        break;
                    }
                    if (((UmUserinfoReDomainBean)userinfoAllList.get(k)).getUserinfoType() == 2) {
                        ocBusinessDimensionDomain.setDistributor(((UmUserinfoReDomainBean)userinfoAllList.get(k)).getUserinfoCompname());
                        break;
                    }
                    this.logger.error(CODE + ".queryBusinessDimensionCom", (Object)"\u672a\u77e5\u7c7b\u578b\uff01");
                    break;
                }
                ocBusinessDimensionDomain.setClinic(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCompname());
                break;
            }
            list.add(ocBusinessDimensionDomain);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, (Object)umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    private UmUserinfoReDomainBean getParentUmUserinfoReDomainBean(UmUserinfoReDomainBean umUserinfoReDomainBean, List<UmUserinfoReDomainBean> userinfoAllList) {
        String METHOD_NAME = "getParentUmUserinfoReDomainBean";
        UmUserinfoReDomainBean ub = null;
        block0: for (int j = 0; j < userinfoAllList.size(); ++j) {
            if (!umUserinfoReDomainBean.getUserinfoParentCode().equals(userinfoAllList.get(j).getUserinfoCode())) continue;
            for (int k = 0; k < userinfoAllList.size(); ++k) {
                if (!userinfoAllList.get(j).getUserinfoParentCode().equals(userinfoAllList.get(k).getUserinfoCode())) continue;
                ub = userinfoAllList.get(k);
                break block0;
            }
            break;
        }
        return ub;
    }

    private OcContractReDomain getFirstSaleOrder(List<OcContractReDomain> ocContractReDomains) {
        if (ocContractReDomains.isEmpty()) {
            return null;
        }
        Collections.sort(ocContractReDomains, new Comparator<OcContractReDomain>(){

            @Override
            public int compare(OcContractReDomain o1, OcContractReDomain o2) {
                return o1.getGmtCreate().compareTo(o2.getGmtCreate());
            }
        });
        return ocContractReDomains.get(0);
    }

    protected SupQueryResult<OcClorstDataStatisticsDomain> queryOcClorstDataStatistics(HttpServletRequest request, Map<String, Object> map) {
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)"================================\u5206\u9500\u5546\u5458\u5de5\u6570\u636e\u7edf\u8ba1================================");
        if (map.get("userinfoCode") == null) {
            this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u5165\u53c2\u4e3a\u7a7a\uff01userinfoCode->" + map.get("userinfoCode")));
            return null;
        }
        HashMap<String, Object> queryClinicMap = new HashMap<String, Object>();
        queryClinicMap.put("userinfoParentCode", map.get("userinfoCode"));
        queryClinicMap.put("userinfoQuality", "service");
        queryClinicMap.put("fuzzy", true);
        SupQueryResult umUserinfoReDomainBeanAllSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryClinicMap);
        List clinicAllList = new ArrayList();
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================umUserinfoReDomainBeanAllSupQueryResult===->" + umUserinfoReDomainBeanAllSupQueryResult));
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================umUserinfoReDomainBeanAllSupQueryResult.getList()===->" + umUserinfoReDomainBeanAllSupQueryResult.getList()));
        if (umUserinfoReDomainBeanAllSupQueryResult != null && umUserinfoReDomainBeanAllSupQueryResult.getList() != null) {
            clinicAllList = umUserinfoReDomainBeanAllSupQueryResult.getList();
        }
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8bca\u6240===clinicAllList.size()->" + clinicAllList.size()));
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8bca\u6240===clinicAllList->" + JsonUtil.buildNonEmptyBinder().toJson(clinicAllList)));
        Integer orderClinicTotal = 0;
        Integer dentistsTotal = 0;
        Integer orderDentistsTotal = 0;
        for (int i = 0; i < clinicAllList.size(); ++i) {
            HashMap<String, String> queryContractPageMap = new HashMap<String, String>();
            queryContractPageMap.put("departCode", ((UmUserinfoReDomainBean)clinicAllList.get(i)).getUserinfoCode());
            SupQueryResult everyDayDataQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractPageMap);
            List contractReList = everyDayDataQueryResult.getList();
            if (!contractReList.isEmpty()) {
                orderClinicTotal = orderClinicTotal + 1;
            }
            HashMap<String, Object> queryDentistsMap = new HashMap<String, Object>();
            queryDentistsMap.put("userinfoParentCode", ((UmUserinfoReDomainBean)clinicAllList.get(i)).getUserinfoCode());
            queryDentistsMap.put("userinfoQuality", "group");
            queryDentistsMap.put("fuzzy", true);
            SupQueryResult dentistsSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryDentistsMap);
            this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================dentistsSupQueryResult->" + dentistsSupQueryResult));
            List dentistsAllList = new ArrayList();
            if (dentistsSupQueryResult != null && dentistsSupQueryResult.getList() != null) {
                dentistsAllList = dentistsSupQueryResult.getList();
            }
            this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================dentistsAllList->" + dentistsAllList));
            this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u7259\u533b===dentistsAllList.size()->" + dentistsAllList.size()));
            this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u7259\u533b===dentistsAllList->" + JsonUtil.buildNonEmptyBinder().toJson(dentistsAllList)));
            dentistsTotal = dentistsTotal + dentistsAllList.size();
            for (int j = 0; j < dentistsAllList.size(); ++j) {
                HashMap<String, String> queryContractDentistsMap = new HashMap<String, String>();
                queryContractDentistsMap.put("employeeCode", ((UmUserinfoReDomainBean)dentistsAllList.get(j)).getUserinfoCode());
                SupQueryResult dentistsQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractDentistsMap);
                List dsList = dentistsQueryResult.getList();
                if (dsList.isEmpty()) continue;
                orderDentistsTotal = orderDentistsTotal + 1;
            }
        }
        HashMap<String, Object> queryContractTotalMap = new HashMap<String, Object>();
        queryContractTotalMap.put("companyCode", map.get("userinfoCode"));
        SupQueryResult totalQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractTotalMap);
        List contractTotalList = totalQueryResult.getList();
        BigDecimal orderPriceTotal = new BigDecimal(0);
        BigDecimal receivedAmountTotal = new BigDecimal(0);
        for (int i = 0; i < contractTotalList.size(); ++i) {
            orderPriceTotal = orderPriceTotal.add(((OcContractReDomain)contractTotalList.get(i)).getContractInmoney());
            if (((OcContractReDomain)contractTotalList.get(i)).getDataState() != 4) continue;
            receivedAmountTotal = receivedAmountTotal.add(((OcContractReDomain)contractTotalList.get(i)).getDataBmoney());
        }
        OcClorstDataStatisticsDomain ocClorstDataStatisticsDomain = new OcClorstDataStatisticsDomain();
        ocClorstDataStatisticsDomain.setClinicTotal(Integer.valueOf(clinicAllList.size()));
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8bca\u6240\u603b\u6570->" + clinicAllList.size()));
        ocClorstDataStatisticsDomain.setOrderClinicTotal(orderClinicTotal);
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u4e0b\u5355\u8bca\u6240\u6570->" + orderClinicTotal));
        ocClorstDataStatisticsDomain.setDentistsTotal(dentistsTotal);
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u603b\u7259\u533b\u6570->" + dentistsTotal));
        ocClorstDataStatisticsDomain.setOrderDentistsTotal(orderDentistsTotal);
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u4e0b\u5355\u7259\u533b\u6570->" + orderDentistsTotal));
        ocClorstDataStatisticsDomain.setOrderTotal(Integer.valueOf(contractTotalList.size()));
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8ba2\u5355\u603b\u6570->" + contractTotalList.size()));
        ocClorstDataStatisticsDomain.setOrderPriceTotal(orderPriceTotal);
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8ba2\u5355\u603b\u6570->" + orderPriceTotal));
        ocClorstDataStatisticsDomain.setReceivedAmountTotal(receivedAmountTotal);
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u5b9e\u6536\u603b\u91d1\u989d->" + receivedAmountTotal));
        ArrayList<OcClorstDataStatisticsDomain> list = new ArrayList<OcClorstDataStatisticsDomain>();
        list.add(ocClorstDataStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, (Object)umUserinfoReDomainBeanAllSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcClorstDataStatisticsDomain> queryOcClinicStatisticsData(HttpServletRequest request, Map<String, Object> map) {
        this.logger.error(CODE + ".queryOcClinicStatisticsData", (Object)"================================\u8bca\u6240\u6570\u636e\u7edf\u8ba1================================");
        if (map.get("userinfoCode") == null) {
            this.logger.error(CODE + ".queryOcClinicStatisticsData", (Object)("================================\u5165\u53c2\u4e3a\u7a7a\uff01userinfoCode->" + map.get("userinfoCode")));
            return null;
        }
        Integer dentistsTotal = 0;
        Integer orderDentistsTotal = 0;
        HashMap<String, Object> queryDentistsMap = new HashMap<String, Object>();
        queryDentistsMap.put("userinfoParentCode", map.get("userinfoCode"));
        queryDentistsMap.put("userinfoQuality", "group");
        queryDentistsMap.put("fuzzy", true);
        SupQueryResult dentistsSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryDentistsMap);
        List dentistsAllList = new ArrayList();
        if (dentistsSupQueryResult != null && dentistsSupQueryResult.getList() != null) {
            dentistsAllList = dentistsSupQueryResult.getList();
        }
        this.logger.error(CODE + ".queryOcClinicStatisticsData", (Object)("================================\u7259\u533b===dentistsAllList.size()->" + dentistsAllList.size()));
        this.logger.error(CODE + ".queryOcClinicStatisticsData", (Object)("================================\u7259\u533b===dentistsAllList->" + JsonUtil.buildNonEmptyBinder().toJson(dentistsAllList)));
        dentistsTotal = dentistsTotal + dentistsAllList.size();
        for (int j = 0; j < dentistsAllList.size(); ++j) {
            HashMap<String, String> queryContractDentistsMap = new HashMap<String, String>();
            queryContractDentistsMap.put("employeeCode", ((UmUserinfoReDomainBean)dentistsAllList.get(j)).getUserinfoCode());
            SupQueryResult dentistsQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractDentistsMap);
            List dsList = dentistsQueryResult.getList();
            if (dsList.isEmpty()) continue;
            orderDentistsTotal = orderDentistsTotal + 1;
        }
        HashMap<String, Object> queryContractTotalMap = new HashMap<String, Object>();
        queryContractTotalMap.put("employeeCode", map.get("userinfoCode"));
        SupQueryResult totalQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractTotalMap);
        List contractTotalList = totalQueryResult.getList();
        BigDecimal orderPriceTotal = new BigDecimal(0);
        BigDecimal receivedAmountTotal = new BigDecimal(0);
        for (int i = 0; i < contractTotalList.size(); ++i) {
            orderPriceTotal = orderPriceTotal.add(((OcContractReDomain)contractTotalList.get(i)).getContractInmoney());
            if (((OcContractReDomain)contractTotalList.get(i)).getDataState() != 4) continue;
            receivedAmountTotal = receivedAmountTotal.add(((OcContractReDomain)contractTotalList.get(i)).getDataBmoney());
        }
        OcClorstDataStatisticsDomain ocClorstDataStatisticsDomain = new OcClorstDataStatisticsDomain();
        ocClorstDataStatisticsDomain.setDentistsTotal(dentistsTotal);
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u603b\u7259\u533b\u6570->" + dentistsTotal));
        ocClorstDataStatisticsDomain.setOrderDentistsTotal(orderDentistsTotal);
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u4e0b\u5355\u7259\u533b\u6570->" + orderDentistsTotal));
        ocClorstDataStatisticsDomain.setOrderTotal(Integer.valueOf(contractTotalList.size()));
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8ba2\u5355\u603b\u6570->" + contractTotalList.size()));
        ocClorstDataStatisticsDomain.setOrderPriceTotal(orderPriceTotal);
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8ba2\u5355\u603b\u6570->" + orderPriceTotal));
        ocClorstDataStatisticsDomain.setReceivedAmountTotal(receivedAmountTotal);
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u5b9e\u6536\u603b\u91d1\u989d->" + receivedAmountTotal));
        ArrayList<OcClorstDataStatisticsDomain> list = new ArrayList<OcClorstDataStatisticsDomain>();
        list.add(ocClorstDataStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, (Object)dentistsSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcClorstDataStatisticsDomain> queryOcDentistStatisticsData(HttpServletRequest request, Map<String, Object> map) {
        this.logger.error(CODE + ".queryOcDentistStatisticsData", (Object)"================================\u7259\u533b\u6570\u636e\u7edf\u8ba1================================");
        if (map.get("userinfoCode") == null) {
            this.logger.error(CODE + ".queryOcDentistStatisticsData", (Object)("================================\u5165\u53c2\u4e3a\u7a7a\uff01userinfoCode->" + map.get("userinfoCode")));
            return null;
        }
        HashMap<String, Object> queryContractTotalMap = new HashMap<String, Object>();
        queryContractTotalMap.put("employeeCode", map.get("userinfoCode"));
        SupQueryResult totalQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractTotalMap);
        List contractTotalList = totalQueryResult.getList();
        BigDecimal orderPriceTotal = new BigDecimal(0);
        BigDecimal receivedAmountTotal = new BigDecimal(0);
        for (int i = 0; i < contractTotalList.size(); ++i) {
            if (((OcContractReDomain)contractTotalList.get(i)).getContractInmoney() == null) continue;
            orderPriceTotal = orderPriceTotal.add(((OcContractReDomain)contractTotalList.get(i)).getContractInmoney());
            if (((OcContractReDomain)contractTotalList.get(i)).getDataState() != 4 || ((OcContractReDomain)contractTotalList.get(i)).getDataBmoney() == null) continue;
            receivedAmountTotal = receivedAmountTotal.add(((OcContractReDomain)contractTotalList.get(i)).getDataBmoney());
        }
        OcClorstDataStatisticsDomain ocClorstDataStatisticsDomain = new OcClorstDataStatisticsDomain();
        ocClorstDataStatisticsDomain.setOrderTotal(Integer.valueOf(contractTotalList.size()));
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8ba2\u5355\u603b\u6570->" + contractTotalList.size()));
        ocClorstDataStatisticsDomain.setOrderPriceTotal(orderPriceTotal);
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u8ba2\u5355\u603b\u6570->" + orderPriceTotal));
        ocClorstDataStatisticsDomain.setReceivedAmountTotal(receivedAmountTotal);
        this.logger.error(CODE + ".queryOcClorstDataStatistics", (Object)("================================\u5b9e\u6536\u603b\u91d1\u989d->" + receivedAmountTotal));
        ArrayList<OcClorstDataStatisticsDomain> list = new ArrayList<OcClorstDataStatisticsDomain>();
        list.add(ocClorstDataStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, (Object)totalQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcContractReDomain> queryContractPageRate(HttpServletRequest request, String fileName, Map<String, Object> param) {
        String exportFlag = null == param || null == param.get("exportFlag") ? "false" : (String)param.get("exportFlag");
        String excelTemplate = null == param || null == param.get("excelTemplate") ? "" : (String)param.get("excelTemplate");
        Boolean flag = Boolean.valueOf(exportFlag);
        if (flag.booleanValue()) {
            UserSession userSession;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = "\u8ba2\u5355\u5217\u8868";
            }
            String userCode = null == (userSession = this.getUserSession(request)) ? "" : userSession.getUserCode();
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((String)excelTemplate) && "ag".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderNewHeadExcelParam());
            } else if ("ms".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderMsHeadExcelParam());
            } else if ("retailer".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxHeadExcelParam());
            } else if ("retailerDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderFxDetaiHeadExcelParam());
            } else if ("pg".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgHeadExcelParam());
            } else if ("pgDetail".equals(excelTemplate)) {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderPgDetailHeadExcelParam());
            } else {
                infoMap.put("headMap", ExcelExportTemplate.covertOrderHeadExcelParam());
            }
            infoMap.put("userCode", userCode);
            infoMap.put("fileName", fileName);
            this.logger.error(CODE + ".queryContractPageCom.1111", (Object)(param + "=:=" + infoMap));
            try {
                this.exportComExcel(request, param, infoMap, "oc.contract.queryContractPageReDomain", excelTemplate);
            }
            catch (Exception e) {
                this.logger.error(CODE + ".queryContractPageCom.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
                return null;
            }
            return null;
        }
        return this.ocContractServiceRepository.queryContractPageReDomain(param);
    }

    protected SupQueryResult<OcClinicReportDomain> queryOcClinicReport(HttpServletRequest request, Map<String, Object> map) {
        this.logger.error(CODE + ".queryOcClinicReport", (Object)"================================\u8bca\u6240\u62a5\u8868================================");
        this.logger.error(CODE + ".queryOcClinicReport", (Object)("================================map->" + JsonUtil.buildNonEmptyBinder().toJson(map) + "================================"));
        HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
        queryUserinfoPageMap.put("userinfoQuality", "service");
        queryUserinfoPageMap.put("tenantCode", map.get("tenantCode"));
        queryUserinfoPageMap.put("userinfoCode", map.get("departCode"));
        queryUserinfoPageMap.put("rows", map.get("rows"));
        queryUserinfoPageMap.put("page", map.get("page"));
        queryUserinfoPageMap.put("startRow", map.get("startRow"));
        queryUserinfoPageMap.put("endRow", map.get("endRow"));
        if (map.get("cityCode") == null) {
            queryUserinfoPageMap.put("provinceCode", map.get("provinceCode"));
        } else {
            queryUserinfoPageMap.put("cityCode", map.get("cityCode"));
        }
        queryUserinfoPageMap.put("fuzzy", true);
        SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoPageMap);
        List umUserinfoReDomainBeanList = new ArrayList();
        if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
            umUserinfoReDomainBeanList = umUserinfoReDomainBeanSupQueryResult.getList();
        }
        ArrayList<OcClinicReportDomain> list = new ArrayList<OcClinicReportDomain>();
        for (int i = 0; i < umUserinfoReDomainBeanList.size(); ++i) {
            OcClinicReportDomain ocClinicReportDomain = new OcClinicReportDomain();
            ocClinicReportDomain.setClinic(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCompname());
            HashMap<String, Object> umusrMap = new HashMap<String, Object>();
            umusrMap.put("userinfoQuality", "group");
            umusrMap.put("userinfoParentCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            umusrMap.put("tenantCode", map.get("tenantCode"));
            umusrMap.put("fuzzy", true);
            SupQueryResult umusr = this.userServiceRepository.queryUserinfoPage(umusrMap);
            List umusrList = new ArrayList();
            if (umusr != null && umusr.getList() != null) {
                umusrList = umusr.getList();
            }
            ocClinicReportDomain.setDentistsTotal(Integer.valueOf(umusrList.size()));
            ocClinicReportDomain.setCity(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getCityName());
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            queryContractPageMap.put("departCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            queryContractPageMap.put("tenantCode", map.get("tenantCode"));
            SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractPageMap);
            List ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
            ocClinicReportDomain.setOrderTotal(Integer.valueOf(ocContractReDomainList.size()));
            ocClinicReportDomain.setOrderPriceTotal(this.getPriceTotal(ocContractReDomainList));
            ocClinicReportDomain.setRefundPriceTotal(this.getRefundPriceTotal(ocContractReDomainList, map.get("tenantCode").toString()));
            ocClinicReportDomain.setEffectivePriceTotal(ocClinicReportDomain.getOrderPriceTotal().subtract(ocClinicReportDomain.getRefundPriceTotal()));
            ocClinicReportDomain.setReturningServantPriceTotal(this.getPteBalanceamtPriceTotal(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode(), map.get("tenantCode").toString()));
            list.add(ocClinicReportDomain);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, (Object)umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcDistributorEmployeeReportDomain> queryOcDistributorEmployeeReport(HttpServletRequest request, Map<String, Object> map) {
        this.logger.error(CODE + ".queryOcDistributorEmployeeReport", (Object)"================================\u5206\u9500\u5546/\u5458\u5de5\u62a5\u8868================================");
        this.logger.error(CODE + ".queryOcDistributorEmployeeReport", (Object)("================================map->" + JsonUtil.buildNonEmptyBinder().toJson(map) + "================================"));
        HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
        queryUserinfoPageMap.put("userinfoQuality", "retailer");
        queryUserinfoPageMap.put("tenantCode", map.get("tenantCode"));
        queryUserinfoPageMap.put("userinfoCode", map.get("companyCode"));
        queryUserinfoPageMap.put("rows", map.get("rows"));
        queryUserinfoPageMap.put("page", map.get("page"));
        queryUserinfoPageMap.put("startRow", map.get("startRow"));
        queryUserinfoPageMap.put("endRow", map.get("endRow"));
        if (map.get("cityCode") == null) {
            queryUserinfoPageMap.put("provinceCode", map.get("provinceCode"));
        } else {
            queryUserinfoPageMap.put("cityCode", map.get("cityCode"));
        }
        queryUserinfoPageMap.put("fuzzy", true);
        SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoPageMap);
        List umUserinfoReDomainBeanList = new ArrayList();
        if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
            umUserinfoReDomainBeanList = umUserinfoReDomainBeanSupQueryResult.getList();
        }
        ArrayList<OcDistributorEmployeeReportDomain> list = new ArrayList<OcDistributorEmployeeReportDomain>();
        for (int i = 0; i < umUserinfoReDomainBeanList.size(); ++i) {
            OcDistributorEmployeeReportDomain ocDistributorEmployeeReportDomain = new OcDistributorEmployeeReportDomain();
            ocDistributorEmployeeReportDomain.setDistributorName(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCompname());
            HashMap<String, Object> clinicMap = new HashMap<String, Object>();
            clinicMap.put("userinfoQuality", "service");
            clinicMap.put("tenantCode", map.get("tenantCode"));
            clinicMap.put("userinfoParentCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            clinicMap.put("fuzzy", true);
            SupQueryResult umClinicSupQueryResult = this.userServiceRepository.queryUserinfoPage(clinicMap);
            List umClinicBeanList = new ArrayList();
            if (umClinicSupQueryResult != null && umClinicSupQueryResult.getList() != null) {
                umClinicBeanList = umClinicSupQueryResult.getList();
            }
            ocDistributorEmployeeReportDomain.setClinicTotal(Integer.valueOf(umClinicBeanList.size()));
            if (umClinicBeanList.isEmpty()) {
                ocDistributorEmployeeReportDomain.setDentistTotal(Integer.valueOf(0));
            }
            for (int j = 0; j < umClinicBeanList.size(); ++j) {
                HashMap<String, Object> dentistMap = new HashMap<String, Object>();
                dentistMap.put("userinfoQuality", "group");
                dentistMap.put("tenantCode", map.get("tenantCode"));
                dentistMap.put("userinfoParentCode", ((UmUserinfoReDomainBean)umClinicBeanList.get(j)).getUserinfoCode());
                dentistMap.put("fuzzy", true);
                SupQueryResult umDentistSupQueryResult = this.userServiceRepository.queryUserinfoPage(dentistMap);
                List umDentistBeanList = new ArrayList();
                if (umDentistSupQueryResult != null && umDentistSupQueryResult.getList() != null) {
                    umDentistBeanList = umDentistSupQueryResult.getList();
                }
                ocDistributorEmployeeReportDomain.setDentistTotal(Integer.valueOf(umDentistBeanList.size()));
            }
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            queryContractPageMap.put("companyCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            queryContractPageMap.put("tenantCode", map.get("tenantCode"));
            SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractPageMap);
            List ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
            ocDistributorEmployeeReportDomain.setOrderTotal(Integer.valueOf(ocContractReDomainList.size()));
            ocDistributorEmployeeReportDomain.setOrderPriceTotal(this.getPriceTotal(ocContractReDomainList));
            ocDistributorEmployeeReportDomain.setRefundPriceTotal(this.getRefundPriceTotal(ocContractReDomainList, map.get("tenantCode").toString()));
            ocDistributorEmployeeReportDomain.setEffectivePriceTotal(ocDistributorEmployeeReportDomain.getOrderPriceTotal().subtract(ocDistributorEmployeeReportDomain.getRefundPriceTotal()));
            ocDistributorEmployeeReportDomain.setReturningServantPriceTotal(this.getPteBalanceamtPriceTotal(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode(), map.get("tenantCode").toString()));
            list.add(ocDistributorEmployeeReportDomain);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, (Object)umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    protected SupQueryResult<OcDentalReportDomain> queryOcDentalReport(HttpServletRequest request, Map<String, Object> map) {
        this.logger.error(CODE + ".queryOcDentalReport", (Object)"================================\u7259\u533b\u62a5\u8868================================");
        this.logger.error(CODE + ".queryOcDentalReport", (Object)("================================map->" + JsonUtil.buildNonEmptyBinder().toJson(map) + "================================"));
        HashMap<String, Object> queryUserinfoPageMap = new HashMap<String, Object>();
        queryUserinfoPageMap.put("userinfoQuality", "group");
        queryUserinfoPageMap.put("tenantCode", map.get("tenantCode"));
        queryUserinfoPageMap.put("userinfoSort", map.get("userinfoSort"));
        queryUserinfoPageMap.put("rows", map.get("rows"));
        queryUserinfoPageMap.put("page", map.get("page"));
        queryUserinfoPageMap.put("startRow", map.get("startRow"));
        queryUserinfoPageMap.put("endRow", map.get("endRow"));
        if (map.get("cityCode") == null) {
            queryUserinfoPageMap.put("provinceCode", map.get("provinceCode"));
        } else {
            queryUserinfoPageMap.put("cityCode", map.get("cityCode"));
        }
        queryUserinfoPageMap.put("fuzzy", true);
        SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoPageMap);
        List umUserinfoReDomainBeanList = new ArrayList();
        if (umUserinfoReDomainBeanSupQueryResult != null && umUserinfoReDomainBeanSupQueryResult.getList() != null) {
            umUserinfoReDomainBeanList = umUserinfoReDomainBeanSupQueryResult.getList();
        }
        HashMap<String, Object> queryUserinfoPageAllMap = new HashMap<String, Object>();
        queryUserinfoPageAllMap.put("tenantCode", map.get("tenantCode"));
        SupQueryResult umUserinfoReDomainBeanAllSupQueryResult = this.userServiceRepository.queryUserinfoPage(queryUserinfoPageAllMap);
        List userinfoAllList = umUserinfoReDomainBeanAllSupQueryResult.getList();
        if (map.get("departCode") != null) {
            Iterator iterator = umUserinfoReDomainBeanList.iterator();
            while (iterator.hasNext()) {
                UmUserinfoReDomainBean next = (UmUserinfoReDomainBean)iterator.next();
                Boolean flag = true;
                for (int i = 0; i < userinfoAllList.size(); ++i) {
                    if (!next.getUserinfoParentCode().equals(((UmUserinfoReDomainBean)userinfoAllList.get(i)).getUserinfoCode()) || !((UmUserinfoReDomainBean)userinfoAllList.get(i)).getUserinfoCode().equals(map.get("departCode"))) continue;
                    flag = false;
                    break;
                }
                if (!flag.booleanValue()) continue;
                iterator.remove();
            }
        }
        ArrayList<OcDentalReportDomain> list = new ArrayList<OcDentalReportDomain>();
        for (int i = 0; i < umUserinfoReDomainBeanList.size(); ++i) {
            OcDentalReportDomain ocDentalReportDomain = new OcDentalReportDomain();
            ocDentalReportDomain.setType(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getQualityQtypeName());
            ocDentalReportDomain.setName(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCompname());
            for (int j = 0; j < userinfoAllList.size(); ++j) {
                if (!((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCode().equals(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoParentCode())) continue;
                ocDentalReportDomain.setClinic(((UmUserinfoReDomainBean)userinfoAllList.get(j)).getUserinfoCompname());
                break;
            }
            HashMap<String, Object> queryContractPageMap = new HashMap<String, Object>();
            queryContractPageMap.put("employeeCode", ((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode());
            queryContractPageMap.put("tenantCode", map.get("tenantCode"));
            SupQueryResult ocContractReDomainSupQueryResult = this.ocContractServiceRepository.queryContractPage(queryContractPageMap);
            List ocContractReDomainList = ocContractReDomainSupQueryResult.getList();
            ocDentalReportDomain.setOrderTotal(Integer.valueOf(ocContractReDomainList.size()));
            ocDentalReportDomain.setOrderPriceTotal(this.getPriceTotal(ocContractReDomainList));
            ocDentalReportDomain.setRefundPriceTotal(this.getRefundPriceTotal(ocContractReDomainList, map.get("tenantCode").toString()));
            ocDentalReportDomain.setEffectivePriceTotal(ocDentalReportDomain.getOrderPriceTotal().subtract(ocDentalReportDomain.getRefundPriceTotal()));
            ocDentalReportDomain.setReturningServantPriceTotal(this.getPteBalanceamtPriceTotal(((UmUserinfoReDomainBean)umUserinfoReDomainBeanList.get(i)).getUserinfoCode(), map.get("tenantCode").toString()));
            list.add(ocDentalReportDomain);
        }
        SupQueryResult supQueryResult = new SupQueryResult();
        try {
            BeanUtils.copyAllPropertys((Object)supQueryResult, (Object)umUserinfoReDomainBeanSupQueryResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    private BigDecimal getRefundPriceTotal(List<OcContractReDomain> ocContractReDomainList, String tenantCode) {
        BigDecimal refundPriceTotal = new BigDecimal(0);
        for (int j = 0; j < ocContractReDomainList.size(); ++j) {
            HashMap<String, String> queryRefundPageMap = new HashMap<String, String>();
            queryRefundPageMap.put("contractBillcode", ocContractReDomainList.get(j).getContractBillcode());
            queryRefundPageMap.put("tenantCode", tenantCode);
            SupQueryResult ocRefundReDomainSupQueryResult = this.ocRefundServiceRepository.queryRefundPage(queryRefundPageMap);
            List ocRefundList = ocRefundReDomainSupQueryResult.getList();
            for (OcRefundReDomain ocRefundReDomain : ocRefundList) {
                refundPriceTotal = refundPriceTotal.add(ocRefundReDomain.getContractMoney());
            }
        }
        return refundPriceTotal;
    }

    private BigDecimal getPteBalanceamtPriceTotal(String memberCode, String tenantCode) {
        HashMap<String, String> pteBalanceamtMap = new HashMap<String, String>();
        pteBalanceamtMap.put("memberCode", memberCode);
        pteBalanceamtMap.put("tenantCode", tenantCode);
        SupQueryResult pteBalanceamtReDomainSupQueryResult = this.pteBalanceamtServiceRepository.queryBalanceamtPage(pteBalanceamtMap);
        List list = pteBalanceamtReDomainSupQueryResult.getList();
        BigDecimal pteBalanceamtPriceTotal = new BigDecimal(0);
        for (PteBalanceamtReDomain pteBalanceamtReDomain : list) {
            pteBalanceamtPriceTotal = pteBalanceamtPriceTotal.add(pteBalanceamtReDomain.getBalanceAllamount());
        }
        return pteBalanceamtPriceTotal;
    }

    private BigDecimal getPriceTotal(List<OcContractReDomain> ocContractReDomainList) {
        BigDecimal priceTotal = new BigDecimal(0);
        for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
            priceTotal = priceTotal.add(ocContractReDomain.getContractInmoney());
        }
        return priceTotal;
    }

    protected HtmlJsonReBean createOrderRule(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".createOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        orgUserBean = StringUtils.isNotBlank((String)memberBcode) ? this.getOrgUserRuleBean(memberBcode, userSession, this.getCompanyCode(request), userSession.getTenantCode()) : this.getOrgUserBean(userSession.getUserPcode(), userSession, null, userSession.getTenantCode());
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getEmployeeCode())) {
            orgUserBean.setEmployeeCode(((OrderDomain)orderDomainList.get(0)).getEmployeeCode());
            orgUserBean.setEmployeeName(((OrderDomain)orderDomainList.get(0)).getEmployeeName());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartCode())) {
            orgUserBean.setDepartCode(((OrderDomain)orderDomainList.get(0)).getDepartCode());
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartShortname())) {
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getCompanyCode())) {
            orgUserBean.setCompanyCode(((OrderDomain)orderDomainList.get(0)).getCompanyCode());
            orgUserBean.setCompanyShortname(((OrderDomain)orderDomainList.get(0)).getCompanyShortname());
        }
        this.makeChannel(orderDomainList, request);
        String appmanageIcode = ((OrderDomain)orderDomainList.get(0)).getAppmanageIcode();
        if (StringUtils.isBlank((String)appmanageIcode)) {
            appmanageIcode = this.getProappCode(request);
        }
        return this.ocShoppingServiceRepository.createOcOrderRule(orderDomainList, contractType, userSession, appmanageIcode, this.getOauthEnvCode(request), orgUserBean, contractProperty, memberBcode);
    }

    public OrgUserBean getOrgUserRuleBean(String memberBcode, UserSession userSession, String companyCode, String tenantCode) {
        if (null == userSession || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = null;
        String userCode = userSession.getUserCode();
        if (StringUtils.isNotBlank((String)companyCode)) {
            orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        }
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode)) {
            UmUserinfoReDomainBean umUserinfoReDomainBean;
            SupQueryResult umUser;
            SupQueryResult qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}));
            this.logger.error(qcust.toString() + "12345");
            if (null != qcust && ListUtil.isNotEmpty((Collection)qcust.getList())) {
                CtCustrelReDomain ctustrelReDomain = (CtCustrelReDomain)qcust.getList().get(0);
                orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
                orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
                orgUserBean.setCompanyCode(ctustrelReDomain.getCompanyCode());
                orgUserBean.setEmployeeCode(ctustrelReDomain.getEmployeeCode());
                orgUserBean.setEmployeeName(ctustrelReDomain.getEmployeeName());
                orgUserBean.setDepartCode(ctustrelReDomain.getDepartCode());
                orgUserBean.setDepartShortname(ctustrelReDomain.getDepartName());
                orgUserBean.setCompanyShortname(ctustrelReDomain.getCompanyShortname());
            }
            if (null != (umUser = this.userServiceRepository.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}))) && ListUtil.isNotEmpty((Collection)umUser.getList()) && "1".equals((umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUser.getList().get(0)).getQualityQtypeCode())) {
                HashMap<String, String> ddmap = new HashMap<String, String>();
                ddmap.put("flagSettingCode", "exchangerate");
                SupQueryResult ddFalgSettingReDomainSupQueryResult = this.ddFalgSettingServiceRepository.queryFalgSettingPage(ddmap);
                DdFalgSettingReDomain ddFalgSettingReDomain = (DdFalgSettingReDomain)ddFalgSettingReDomainSupQueryResult.getList().get(0);
                this.logger.error(ddFalgSettingReDomain.toString() + "111222");
                this.logger.error(orgUserBean.toString() + "1111111");
                orgUserBean.setPricesetCurrency(ddFalgSettingReDomain.getFlagSettingPro());
            }
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode()) && !userSession.getCompanyCode().equals(orgUserBean.getCompanyCode())) {
            orgUserBean.setCompanyCode(userSession.getCompanyCode());
            orgUserBean.setCompanyShortname(userSession.getCompanyShortname());
        }
        return orgUserBean;
    }

    protected SupQueryResult<OcCommissionStatisticsDomain> queryOcCommissionStatisticsDomain(HttpServletRequest request, Map<String, Object> map) {
        this.logger.error(CODE + ".queryOcCommissionStatisticsDomain", (Object)"================================\u8fd4\u4f63\u6570\u636e\u7edf\u8ba1================================");
        this.logger.error(CODE + ".queryOcCommissionStatisticsDomain", (Object)("================================map->" + JsonUtil.buildNonEmptyBinder().toJson(map) + "================================"));
        if (map.get("userinfoCode") == null || map.get("tenantCode") == null || "".equals(map.get("userinfoCode").toString().trim())) {
            this.logger.error(CODE + ".queryOcCommissionStatisticsDomain", (Object)"\u8bf7\u6c42\u53c2\u6570\u4e3anull\u6216\u8005\u4e3a\u7a7a");
            return null;
        }
        OcCommissionStatisticsDomain ocCommissionStatisticsDomain = new OcCommissionStatisticsDomain();
        ocCommissionStatisticsDomain.setReturningServantTotal(this.getPteBalanceamtPriceTotal(map.get("userinfoCode").toString(), map.get("tenantCode").toString()));
        this.logger.error(CODE + ".queryOcCommissionStatisticsDomain", (Object)("================================\u8fd4\u4f63\u603b\u91d1\u989d->" + ocCommissionStatisticsDomain.getReturningServantTotal() + "================================"));
        ocCommissionStatisticsDomain.setRebateBalance(this.getVdFaccountOuterForAmount(map.get("userinfoCode").toString(), map.get("tenantCode").toString()));
        this.logger.error(CODE + ".queryOcCommissionStatisticsDomain", (Object)("================================\u8fd4\u4f63\u4f59\u989d->" + ocCommissionStatisticsDomain.getRebateBalance() + "================================"));
        ocCommissionStatisticsDomain.setWithdrawalTotal(ocCommissionStatisticsDomain.getReturningServantTotal().subtract(ocCommissionStatisticsDomain.getRebateBalance()));
        this.logger.error(CODE + ".queryOcCommissionStatisticsDomain", (Object)("================================\u8fd4\u4f63\u63d0\u73b0\u91d1\u989d->" + ocCommissionStatisticsDomain.getWithdrawalTotal() + "================================"));
        ArrayList<OcCommissionStatisticsDomain> list = new ArrayList<OcCommissionStatisticsDomain>();
        list.add(ocCommissionStatisticsDomain);
        SupQueryResult supQueryResult = new SupQueryResult();
        supQueryResult.setList(list);
        supQueryResult.setRows(list);
        return supQueryResult;
    }

    private BigDecimal getVdFaccountOuterForAmount(String merchantCode, String tenantCode) {
        List vdFaccountInfos1;
        String type = merchantCode.substring(0, 1);
        String faccountType = "101";
        if ("2".equals(type)) {
            faccountType = "201";
        }
        if (ListUtil.isEmpty((Collection)(vdFaccountInfos1 = this.vdFaccountOuterServiceRepository.queryOuterFaccount(merchantCode, faccountType, tenantCode)))) {
            this.logger.error(CODE + ".vdFaccountInfos1.null", (Object)(merchantCode + "====" + faccountType + "====" + tenantCode));
            return new BigDecimal(0);
        }
        return ((VdFaccountInfo)vdFaccountInfos1.get(0)).getFaccountAmount();
    }

    protected HtmlJsonReBean createOrderpc(HttpServletRequest request, String orderDomainStr, String contractType, String memberBcode, String contractProperty) {
        if (StringUtils.isBlank((String)orderDomainStr)) {
            this.logger.error(CODE + ".createOrder", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        List orderDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (null == orderDomainList || orderDomainList.isEmpty()) {
            this.logger.error(CODE + ".createOrder", (Object)"orderDomainStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".createOrder", (Object)"UserSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrgUserBean orgUserBean = null;
        orgUserBean = StringUtils.isNotBlank((String)memberBcode) ? this.getOrgUserBean(memberBcode, userSession, this.getCompanyCode(request), userSession.getTenantCode()) : this.getOrgUserBeanpc(userSession.getUserPcode(), userSession, null, userSession.getTenantCode());
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getEmployeeCode())) {
            orgUserBean.setEmployeeCode(((OrderDomain)orderDomainList.get(0)).getEmployeeCode());
            orgUserBean.setEmployeeName(((OrderDomain)orderDomainList.get(0)).getEmployeeName());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartCode())) {
            orgUserBean.setDepartCode(((OrderDomain)orderDomainList.get(0)).getDepartCode());
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getDepartShortname())) {
            orgUserBean.setDepartShortname(((OrderDomain)orderDomainList.get(0)).getDepartShortname());
        }
        if (StringUtils.isNotBlank((String)((OrderDomain)orderDomainList.get(0)).getCompanyCode())) {
            orgUserBean.setCompanyCode(((OrderDomain)orderDomainList.get(0)).getCompanyCode());
            orgUserBean.setCompanyShortname(((OrderDomain)orderDomainList.get(0)).getCompanyShortname());
        }
        this.makeChannel(orderDomainList, request);
        return this.ocShoppingServiceRepository.createOcOrderRule(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), orgUserBean, contractProperty, memberBcode);
    }

    public OrgUserBean getOrgUserBeanpc(String memberBcode, UserSession userSession, String companyCode, String tenantCode) {
        SupQueryResult qcust;
        if (null == userSession || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        OrgUserBean orgUserBean = null;
        String userCode = userSession.getUserCode();
        if (StringUtils.isNotBlank((String)companyCode)) {
            orgUserBean = this.orgCompanyServiceRepository.getEmpByUserCode(userCode, companyCode, tenantCode);
        }
        if (null == orgUserBean) {
            orgUserBean = new OrgUserBean();
        }
        orgUserBean.setMemberBcode(memberBcode);
        if (StringUtils.isNotBlank((String)memberBcode) && null != (qcust = this.ctCustrelServiceRepository.queryCustrelPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}))) && ListUtil.isNotEmpty((Collection)qcust.getList())) {
            UmUserinfoReDomainBean umUserinfoReDomainBean;
            CtCustrelReDomain ctustrelReDomain = (CtCustrelReDomain)qcust.getList().get(0);
            orgUserBean.setCustrelCode(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelCode());
            orgUserBean.setMemberBname(((CtCustrelReDomain)qcust.getList().get(0)).getCustrelName());
            orgUserBean.setCompanyCode(ctustrelReDomain.getCompanyCode());
            orgUserBean.setEmployeeCode(ctustrelReDomain.getEmployeeCode());
            orgUserBean.setEmployeeName(ctustrelReDomain.getEmployeeName());
            orgUserBean.setDepartCode(ctustrelReDomain.getDepartCode());
            orgUserBean.setDepartShortname(ctustrelReDomain.getDepartName());
            orgUserBean.setCompanyShortname(ctustrelReDomain.getCompanyShortname());
            SupQueryResult umUser = this.userServiceRepository.queryUserinfoPage(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{memberBcode, tenantCode}));
            if (null != umUser && ListUtil.isNotEmpty((Collection)umUser.getList()) && "1".equals((umUserinfoReDomainBean = (UmUserinfoReDomainBean)umUser.getList().get(0)).getQualityQtypeCode())) {
                HashMap<String, String> ddmap = new HashMap<String, String>();
                ddmap.put("flagSettingCode", "exchangerate");
                SupQueryResult ddFalgSettingReDomainSupQueryResult = this.ddFalgSettingServiceRepository.queryFalgSettingPage(ddmap);
                DdFalgSettingReDomain ddFalgSettingReDomain = (DdFalgSettingReDomain)ddFalgSettingReDomainSupQueryResult.getList().get(0);
                this.logger.error(ddFalgSettingReDomain.toString() + "111222");
                this.logger.error(orgUserBean.toString() + "1111111");
                orgUserBean.setPricesetCurrency(ddFalgSettingReDomain.getFlagSettingPro());
            }
        }
        if (StringUtils.isNotBlank((String)userSession.getCompanyCode()) && !userSession.getCompanyCode().equals(orgUserBean.getCompanyCode())) {
            orgUserBean.setCompanyCode(userSession.getCompanyCode());
            orgUserBean.setCompanyShortname(userSession.getCompanyShortname());
        }
        return orgUserBean;
    }
}

