/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.thread;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.order.domain.OrderData;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.util.HashMap;

public class OrderNexThread
implements Runnable {
    private static final String CODE = "OrderNexThread";
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private String tenantCode;
    private OrderData orderData;
    private OcContractServiceRepository ocContractServiceRepository;

    public OrderNexThread(String tenantCode, OrderData orderData, OcContractServiceRepository ocContractServiceRepository) {
        this.tenantCode = tenantCode;
        this.orderData = orderData;
        this.ocContractServiceRepository = ocContractServiceRepository;
    }

    @Override
    public void run() {
        int i;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", this.orderData.getContractBillcode());
        map.put("tenantCode", this.tenantCode);
        OcContractReDomain contractByCode = this.ocContractServiceRepository.getContractByCode(map);
        if (contractByCode == null) {
            this.logger.error("OrderNexThreadrun.getContractByCode is null", map);
            return;
        }
        if (contractByCode.getDataState().equals(8)) {
            contractByCode.setDataState(Integer.valueOf(2));
        }
        if ((i = this.orderData.getDataState() - contractByCode.getDataState()) <= 0) {
            this.logger.error("OrderNexThreadrun.checkOrder.\u72b6\u6001\u9519\u8bef", (Object)(this.orderData.getDataState() + "___" + contractByCode.getDataState()));
            return;
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put(CODE, true);
        pmap.put("dataStateStr1", "sendgoods");
        for (int j = 1; j <= i; ++j) {
            HtmlJsonReBean htmlJsonReBean;
            if ("60".equals(contractByCode.getContractType())) {
                pmap.put("exchange", true);
                htmlJsonReBean = this.ocContractServiceRepository.sendContractNext(this.orderData.getContractBillcode(), this.tenantCode, pmap);
            } else {
                this.logger.error("OrderNexThread.run.sendContractNext.j" + j);
                htmlJsonReBean = this.ocContractServiceRepository.sendContractNext(this.orderData.getContractBillcode(), this.tenantCode, pmap);
            }
            if (j == i) continue;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

