/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.BsAreaReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.VipVopApiServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsResourceGoodsReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsResourceGoodsServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmAddressReDomain;
import com.qjsoft.laser.controller.springmvc.SpringmvnNewController;
import com.vip.cup.supply.vop.AreaVisibleVo;
import com.vip.cup.supply.vop.CupGetMerItemArea;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/vipvop"}, name="\u7528\u6237\u7aef\u8ba2\u5355\u670d\u52a1")
public class VipVopCon
extends SpringmvnNewController {
    private static String CODE = "oc.vipvop.con";
    @Autowired
    private VipVopApiServiceRepository vipVopApiServiceRepository;
    @Autowired
    private RsResourceGoodsServiceRepository rsResourceGoodsServiceRepository;

    protected String getContext() {
        return "vipvop";
    }

    @RequestMapping(value={"checkVipvopGoodsInfo.json"}, name="\u6821\u9a8c\u552f\u54c1\u4f1a\u5546\u54c1\u7684\u53ef\u552e\u548c\u5e93\u5b58\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean checkVipvopGoodsInfo(HttpServletRequest request, String goodsCodeStr, Integer addressId) {
        String[] goodsCodes;
        if (StringUtils.isBlank((String)goodsCodeStr) || addressId == null) {
            this.logger.error(CODE + ".checkGoodsInfo.\u53c2\u6570\u4e3a\u7a7a", (Object)(goodsCodeStr + "-" + addressId));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        UmAddressReDomain address = this.vipVopApiServiceRepository.getAddress(addressId);
        if (address == null) {
            this.logger.error(CODE + ".checkGoodsInfo.\u67e5\u8be2\u5730\u5740\u5931\u8d25", (Object)addressId);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u5730\u5740\u5931\u8d25");
        }
        String cityCode = address.getCityCode();
        String cityName = address.getCityName();
        if (cityCode != null && !"undefined".equals(cityCode)) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("areaCode", cityCode);
            map.put("tenantCode", tenantCode);
            BsAreaReDomain areaByCode = this.vipVopApiServiceRepository.getAreaByCode(map);
            if (areaByCode == null) {
                this.logger.error(CODE + ".checkGoodsInfo.\u57ce\u5e02\u5339\u914d\u5931\u8d25", (Object)JsonUtil.buildNormalBinder().toJson(map));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u57ce\u5e02\u5339\u914d\u5931\u8d25");
            }
            cityName = areaByCode.getAreaRemark();
            if (StringUtils.isBlank((String)cityName)) {
                cityName = areaByCode.getAreaName();
            }
        }
        String areaCode = address.getAreaCode();
        HashMap<String, String> map3 = new HashMap<String, String>(2);
        map3.put("areaCode", areaCode);
        map3.put("tenantCode", tenantCode);
        BsAreaReDomain areaByCode = this.vipVopApiServiceRepository.getAreaByCode(map3);
        if (areaByCode == null) {
            this.logger.error(CODE + ".checkGoodsInfo.\u533a\u57df\u5339\u914d\u5931\u8d25", (Object)JsonUtil.buildNormalBinder().toJson(map3));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u533a\u57df\u5339\u914d\u5931\u8d25");
        }
        String weaterCode = areaByCode.getWeaterCode();
        if (StringUtils.isBlank((String)weaterCode)) {
            this.logger.error(CODE + ".checkGoodsInfo.\u5f53\u524d\u5730\u5740\u4e0d\u53ef\u7528", (Object)JsonUtil.buildNormalBinder().toJson((Object)areaByCode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5f53\u524d\u5730\u5740\u4e0d\u53ef\u7528\uff0c\u8bf7\u5207\u6362\u5730\u5740");
        }
        HashMap<String, String> skuIdMap = new HashMap<String, String>();
        for (String goodsCode : goodsCodes = goodsCodeStr.split(",")) {
            RsResourceGoodsReDomain goods = this.rsResourceGoodsServiceRepository.getResourceGoodsByCodeStr(goodsCode, tenantCode);
            if (goods == null) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            skuIdMap.put(goods.getGoodsNo(), goods.getGoodsEocode());
        }
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        StringBuilder skuIdStrBuilder = new StringBuilder();
        for (String skuId : skuIdMap.keySet()) {
            skuIdStrBuilder.append(",").append(skuId);
        }
        String skuIdStr = skuIdStrBuilder.substring(1);
        this.logger.info(CODE + ".checkGoodsInfo.skuIdStr", (Object)skuIdStr);
        HtmlJsonReBean stockHj = this.vipVopApiServiceRepository.getSkuStock(skuIdStr, weaterCode, tenantCode);
        this.logger.info(CODE + ".checkGoodsInfo.stockHJ", (Object)(skuIdStr + "-" + JsonUtil.buildNormalBinder().toJson((Object)stockHj)));
        if (!stockHj.isSuccess()) {
            return stockHj;
        }
        Map jsonToMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(stockHj.getDataObj().toString(), String.class, Object.class);
        if (MapUtil.isEmpty((Map)jsonToMap)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u5e93\u5b58\u5931\u8d25");
        }
        Map skuStockMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNonNullBinder().toJson(jsonToMap.get("skuStockMap")), String.class, String.class);
        if (MapUtil.isEmpty((Map)skuStockMap)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u89e3\u6790\u6570\u636e\u5931\u8d25");
        }
        for (String skuId : skuIdStr.split(",")) {
            String stock = (String)skuStockMap.get(skuId);
            this.logger.info(CODE + ".checkGoodsInfo.stock", (Object)(skuId + "-" + stock));
            if (Integer.parseInt(stock) <= 0) {
                resultMap.put(skuId, 3);
                continue;
            }
            resultMap.put(skuId, 1);
        }
        StringBuilder spuIdStrBuilder = new StringBuilder();
        for (String spuId : skuIdMap.values()) {
            spuIdStrBuilder.append(",").append(spuId);
        }
        String spuIdStr = spuIdStrBuilder.substring(1);
        this.logger.info(CODE + ".checkGoodsInfo.spuIdStr", (Object)spuIdStr);
        HtmlJsonReBean htmlJsonReBean = this.vipVopApiServiceRepository.getMerItemArea(spuIdStr, tenantCode);
        if (!htmlJsonReBean.isSuccess()) {
            this.logger.error(CODE + ".checkGoodsInfo.\u67e5\u8be2\u5931\u8d25", (Object)(spuIdStr + "-" + JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean)));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u5931\u8d25");
        }
        String resultStr = htmlJsonReBean.getDataObj().toString();
        CupGetMerItemArea cupGetMerItemArea = (CupGetMerItemArea)JsonUtil.buildNormalBinder().getJsonToObject(resultStr, CupGetMerItemArea.class);
        if (cupGetMerItemArea == null) {
            this.logger.error(CODE + ".checkGoodsInfo.cupGetMerItemArea is null", (Object)(spuIdStr + "-" + resultStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u83b7\u53d6\u8fd0\u8d39\u6a21\u677f\u5931\u8d25");
        }
        Map midAreaMap = cupGetMerItemArea.getMidAreaMap();
        if (MapUtil.isEmpty((Map)midAreaMap)) {
            this.logger.error(CODE + ".checkGoodsInfo.\u67e5\u8be2\u6570\u636e\u5931\u8d25", (Object)(spuIdStr + "-" + resultStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u83b7\u53d6\u8fd0\u8d39\u6a21\u677f\u5931\u8d25");
        }
        for (String spuId : spuIdStr.split(",")) {
            AreaVisibleVo areaVisibleVo = (AreaVisibleVo)midAreaMap.get(spuId);
            if (areaVisibleVo == null) {
                this.logger.error(CODE + ".checkGoodsInfo.\u5339\u914d\u6570\u636e\u5931\u8d25", (Object)(spuId + "-" + resultStr));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5339\u914d\u6570\u636e\u5931\u8d25");
            }
            if ("1".equals(areaVisibleVo.getIsAllFlag()) || this.checkSpuAddress(cityName, areaVisibleVo)) continue;
            for (Map.Entry skuEntry : skuIdMap.entrySet()) {
                if (!((String)skuEntry.getValue()).equals(spuId)) continue;
                resultMap.put((String)skuEntry.getKey(), 2);
            }
        }
        HtmlJsonReBean htmlJsonReBean1 = new HtmlJsonReBean();
        htmlJsonReBean1.setDataObj(resultMap);
        return htmlJsonReBean1;
    }

    @RequestMapping(value={"getMerItemArea.json"}, name="\u6821\u9a8c\u552f\u54c1\u4f1a\u5546\u54c1\u662f\u5426\u53ef\u552e")
    @ResponseBody
    public HtmlJsonReBean getMerItemArea(HttpServletRequest request, String spuIdStr, Integer addressId) {
        HtmlJsonReBean htmlJsonReBean;
        if (StringUtils.isBlank((String)spuIdStr) || addressId == null) {
            this.logger.error(CODE + ".getMerItemArea.\u53c2\u6570\u4e3a\u7a7a", (Object)(spuIdStr + "-" + addressId));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        String tenantCode = this.getTenantCode(request);
        UmAddressReDomain address = this.vipVopApiServiceRepository.getAddress(addressId);
        if (address == null) {
            this.logger.error(CODE + ".getMerItemArea.\u67e5\u8be2\u5730\u5740\u5931\u8d25", (Object)addressId);
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u5730\u5740\u5931\u8d25");
        }
        String cityCode = address.getCityCode();
        String cityName = address.getCityName();
        if (cityCode != null && !"undefined".equals(cityCode)) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("areaCode", cityCode);
            map.put("tenantCode", tenantCode);
            BsAreaReDomain areaByCode = this.vipVopApiServiceRepository.getAreaByCode(map);
            if (areaByCode == null) {
                this.logger.error(CODE + ".getMerItemArea.\u57ce\u5e02\u5339\u914d\u5931\u8d25", (Object)JsonUtil.buildNormalBinder().toJson(map));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u57ce\u5e02\u5339\u914d\u5931\u8d25");
            }
            cityName = areaByCode.getAreaRemark();
            if (StringUtils.isBlank((String)cityName)) {
                cityName = areaByCode.getAreaName();
            }
        }
        if (!(htmlJsonReBean = this.vipVopApiServiceRepository.getMerItemArea(spuIdStr, tenantCode)).isSuccess()) {
            this.logger.error(CODE + ".getMerItemArea.\u67e5\u8be2\u5931\u8d25", (Object)(spuIdStr + "-" + JsonUtil.buildNormalBinder().toJson((Object)htmlJsonReBean)));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u5931\u8d25");
        }
        String resultStr = htmlJsonReBean.getDataObj().toString();
        CupGetMerItemArea cupGetMerItemArea = (CupGetMerItemArea)JsonUtil.buildNormalBinder().getJsonToObject(resultStr, CupGetMerItemArea.class);
        if (cupGetMerItemArea == null) {
            this.logger.error(CODE + ".getMerItemArea.cupGetMerItemArea is null", (Object)(spuIdStr + "-" + resultStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u83b7\u53d6\u8fd0\u8d39\u6a21\u677f\u5931\u8d25");
        }
        Map midAreaMap = cupGetMerItemArea.getMidAreaMap();
        if (MapUtil.isEmpty((Map)midAreaMap)) {
            this.logger.error(CODE + ".getMerItemArea.\u67e5\u8be2\u6570\u636e\u5931\u8d25", (Object)(spuIdStr + "-" + resultStr));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u83b7\u53d6\u8fd0\u8d39\u6a21\u677f\u5931\u8d25");
        }
        for (String spuId : spuIdStr.split(",")) {
            AreaVisibleVo areaVisibleVo = (AreaVisibleVo)midAreaMap.get(spuId);
            if (areaVisibleVo == null) {
                this.logger.error(CODE + ".getMerItemArea.\u5339\u914d\u6570\u636e\u5931\u8d25", (Object)(spuId + "-" + resultStr));
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5339\u914d\u6570\u636e\u5931\u8d25");
            }
            if ("1".equals(areaVisibleVo.getIsAllFlag()) || this.checkSpuAddress(cityName, areaVisibleVo)) continue;
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5546\u54c1\u5728\u8be5\u57ce\u5e02\u4e0d\u53ef\u552e");
        }
        return new HtmlJsonReBean();
    }

    private boolean checkSpuAddress(String cityName, AreaVisibleVo areaVisibleVo) {
        boolean flag = false;
        for (String areaVisible : areaVisibleVo.getAreaVisibles()) {
            if (!cityName.equals(areaVisible)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    protected List<Map<String, Object>> makeExcelData(String s, String s1, String s2) {
        return null;
    }
}

