/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.repository.OcServiceRepository;
import com.qjsoft.laser.controller.order.controller.ContractComCon;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contractcule"}, name="\u7ebf\u7d22\u8ba2\u5355")
public class ContractCuleCon
extends ContractComCon {
    private static String CODE = "oc.contractcule.con";
    @Autowired
    private OcServiceRepository ocServiceRepository;
    private static final String CONCUL = "50";

    @Override
    protected String getContext() {
        return "contract";
    }

    @RequestMapping(value={"saveRuleContract.json"}, name="\u589e\u52a0\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRuleContract(HttpServletRequest request, String orderDomainStr) {
        return this.createOrderCule(request, orderDomainStr, CONCUL);
    }

    public HtmlJsonReBean createOrderCule(HttpServletRequest request, String orderDomainStr, String contractType) {
        if (StringUtils.isBlank((String)orderDomainStr) || StringUtils.isBlank((String)contractType)) {
            this.logger.error(CODE + "createOrderCule", (Object)"orderDomainStr or is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + "createOrderCule", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u767b\u5f55\u4fe1\u606f\u4e3a\u7a7a");
        }
        List orderDomainLi = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (ListUtil.isEmpty((Collection)orderDomainLi)) {
            this.logger.error(CODE + "createOrderCule", (Object)"ltLtinfoDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrderDomain orderDo = (OrderDomain)orderDomainLi.get(0);
        List ocContractGoodsDomainList = ((PackageDomain)orderDo.getPackageList().get(0)).getContractGoodsList();
        OrderDomain orderDomain = new OrderDomain();
        HashMap<String, Object> map = new HashMap<String, Object>();
        TypeBean typeBean = this.ocServiceRepository.getOcSetting(contractType, this.getTenantCode(request));
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
            map.put("contractBlance", typeBean.getBlance());
            map.put("contractPmode", typeBean.getPmode());
        }
        orderDomain.setContractRemark(orderDo.getContractRemark());
        orderDomain.setFaccountName(orderDo.getFaccountName());
        orderDomain.setContractType(contractType);
        orderDomain.setContractTypepro("01");
        orderDomain.setGoodsSupplierName(orderDo.getGoodsSupplierName());
        orderDomain.setMemberGname(orderDo.getMemberGname());
        orderDomain.setGoodsReceiptPhone(orderDo.getGoodsReceiptPhone());
        orderDomain.setGoodsReceiptMem(orderDo.getGoodsReceiptMem());
        orderDomain.setEmployeeCode(orderDo.getEmployeeCode());
        orderDomain.setEmployeeName(orderDo.getEmployeeName());
        orderDomain.setContractMoney(orderDomain.getContractMoney());
        orderDomain.setContractInmoney(orderDomain.getContractInmoney());
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        PackageDomain packageDomain = new PackageDomain();
        packageList.add(packageDomain);
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        packageDomain.setContractGoodsList(contractGoodsList);
        for (OcContractGoodsDomain ocContractGoods : ocContractGoodsDomainList) {
            OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
            BeanUtils.copyProperties((Object)ocContractGoodsDomain, (Object)ocContractGoods);
            ocContractGoodsDomain.setAppmanageIcode(this.getProappCode(request));
            ocContractGoodsDomain.setMemberBcode(userSession.getUserPcode());
            ocContractGoodsDomain.setMemberBname(userSession.getMerberCompname());
            contractGoodsList.add(ocContractGoodsDomain);
        }
        ArrayList<OrderDomain> orderDomainList = new ArrayList<OrderDomain>();
        orderDomainList.add(orderDomain);
        map.put("contractType", contractType);
        HtmlJsonReBean htmlJsonReBean = this.ocServiceRepository.createOcOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), null);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        map.put("contractBillcode", htmlJsonReBean.getDataObj());
        htmlJsonReBean.setDataObj(map);
        return htmlJsonReBean;
    }
}

