/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractSubServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcServiceRepository;
import com.qjsoft.laser.controller.order.controller.ContractComCon;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contractcule"}, name="\u5bfc\u8d2d\u5458\u7ebf\u7d22\u8ba2\u5355")
public class ContractCuleCon
extends ContractComCon {
    private static String CODE = "oc.contractcule.con";
    @Autowired
    private OcServiceRepository ocServiceRepository;
    @Autowired
    private OcContractSubServiceRepository ocContractSubServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    private static final String CONCUL = "50";

    @Override
    protected String getContext() {
        return "contract";
    }

    @RequestMapping(value={"saveRuleContract.json"}, name="\u589e\u52a0\u7ebf\u7d22\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRuleContract(HttpServletRequest request, String orderDomainStr) {
        return this.createOrderCule(request, orderDomainStr, CONCUL);
    }

    public HtmlJsonReBean createOrderCule(HttpServletRequest request, String orderDomainStr, String contractType) {
        if (StringUtils.isBlank((String)orderDomainStr) || StringUtils.isBlank((String)contractType)) {
            this.logger.error(CODE + "saveRuleContract", (Object)"orderDomainStr or is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + "saveRuleContract", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u767b\u5f55\u4fe1\u606f\u4e3a\u7a7a");
        }
        List orderDomainLi = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (ListUtil.isEmpty((Collection)orderDomainLi)) {
            this.logger.error(CODE + "createOrderCule", (Object)"ltLtinfoDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrderDomain orderDo = (OrderDomain)orderDomainLi.get(0);
        List ocContractGoodsDomainList = ((PackageDomain)orderDo.getPackageList().get(0)).getContractGoodsList();
        OrderDomain orderDomain = new OrderDomain();
        HashMap<String, Object> map = new HashMap<String, Object>();
        TypeBean typeBean = this.ocServiceRepository.getOcSetting(contractType, this.getTenantCode(request));
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
            map.put("contractBlance", typeBean.getBlance());
            map.put("contractPmode", typeBean.getPmode());
        }
        orderDomain.setContractRemark(orderDo.getContractRemark());
        orderDomain.setFaccountName(orderDo.getFaccountName());
        orderDomain.setContractType(contractType);
        orderDomain.setGoodsSupplierName(orderDo.getGoodsSupplierName());
        orderDomain.setMemberGname(orderDo.getMemberGname());
        orderDomain.setGoodsReceiptPhone(orderDo.getGoodsReceiptPhone());
        orderDomain.setGoodsReceiptMem(orderDo.getGoodsReceiptMem());
        orderDomain.setEmployeeCode(orderDo.getEmployeeCode());
        orderDomain.setEmployeeName(orderDo.getEmployeeName());
        orderDomain.setContractMoney(orderDomain.getContractMoney());
        orderDomain.setContractInmoney(orderDomain.getContractInmoney());
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        PackageDomain packageDomain = new PackageDomain();
        packageList.add(packageDomain);
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        packageDomain.setContractGoodsList(contractGoodsList);
        for (OcContractGoodsDomain ocContractGoods : ocContractGoodsDomainList) {
            this.logger.error("ocContractGoods====---" + JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
            OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
            ocContractGoodsDomain.setAppmanageIcode(this.getProappCode(request));
            this.logger.error("ocContractGoodsDomain====---" + JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoodsDomain));
            ocContractGoodsDomain.setContractGoodsInmoney(ocContractGoods.getContractGoodsInmoney());
            ocContractGoodsDomain.setContractGoodsMoney(ocContractGoods.getContractGoodsMoney());
            ocContractGoodsDomain.setContractGoodsPrice(ocContractGoods.getContractGoodsPrice());
            ocContractGoodsDomain.setGoodsCamount(ocContractGoods.getGoodsCamount());
            ocContractGoodsDomain.setGoodsNum(ocContractGoods.getGoodsNum());
            ocContractGoodsDomain.setPricesetNprice(ocContractGoods.getPricesetNprice());
            ocContractGoodsDomain.setGoodsName(ocContractGoods.getGoodsName());
            ocContractGoodsDomain.setGoodsType(contractType);
            ocContractGoodsDomain.setGoodsNo(ocContractGoods.getGoodsNo());
            ocContractGoodsDomain.setGoodsCode(ocContractGoods.getGoodsCode());
            ocContractGoodsDomain.setSkuCode(ocContractGoods.getSkuCode());
            ocContractGoodsDomain.setSkuName(ocContractGoods.getSkuName());
            ocContractGoodsDomain.setSkuNo(ocContractGoods.getSkuNo());
            ocContractGoodsDomain.setClasstreeCode(ocContractGoods.getClasstreeCode());
            ocContractGoodsDomain.setPntreeCode(ocContractGoods.getPntreeCode());
            ocContractGoodsDomain.setPntreeName(ocContractGoods.getPntreeName());
            ocContractGoodsDomain.setSpuCode(ocContractGoods.getSpuCode());
            ocContractGoodsDomain.setGoodsCamount(ocContractGoods.getGoodsCamount());
            ocContractGoodsDomain.setTenantCode(this.getTenantCode(request));
            ocContractGoodsDomain.setMemberBcode(userSession.getUserPcode());
            ocContractGoodsDomain.setMemberBname(userSession.getMerberCompname());
            contractGoodsList.add(ocContractGoodsDomain);
        }
        ArrayList<OrderDomain> orderDomainList = new ArrayList<OrderDomain>();
        orderDomainList.add(orderDomain);
        map.put("contractType", contractType);
        this.logger.error("orderDomainList====---" + JsonUtil.buildNonDefaultBinder().toJson(orderDomainList));
        HtmlJsonReBean htmlJsonReBean = this.ocServiceRepository.createOcOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), null);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        map.put("contractBillcode", htmlJsonReBean.getDataObj());
        htmlJsonReBean.setDataObj(map);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"getRulContract.json"}, name="\u83b7\u53d6\u7ebf\u7d22\u8ba2\u5355\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcContractReDomain getRulContract(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"queryContractPageC.json"}, name="\u7ebf\u7d22\u8ba2\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageC(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.error(CODE, (Object)("--------------------param is" + param.toString()));
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"addContractSub.json"}, name="\u65b0\u589e\u4ed8\u6b3e\u91d1\u989d")
    @ResponseBody
    public HtmlJsonReBean addContractSub(HttpServletRequest request, String contractBillcode, BigDecimal contractSubGmoney) {
        if (StringUtils.isBlank((String)contractBillcode) || null == contractSubGmoney) {
            this.logger.error(CODE + ".addContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("ocContractReDomain is null : " + ((Object)map).toString()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("userSession: " + ((Object)map).toString()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u672a\u767b\u9646");
        }
        String userPcode = userSession.getUserPcode();
        if (!userPcode.equals(ocContractReDomain.getMemberBcode())) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("userPcode: " + userPcode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u64cd\u4f5c\u6743\u9650");
        }
        OcContractSubDomain ocContractSubDomain = this.make(request, contractSubGmoney, ocContractReDomain);
        if (null == ocContractSubDomain) {
            this.logger.error(CODE + ".addContractSub.ocContractSubDomain", (Object)"ocContractSubDomain is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractSubServiceRepository.saveContractSub(ocContractSubDomain);
    }

    private OcContractSubDomain make(HttpServletRequest request, BigDecimal contractSubGmoney, OcContractReDomain ocContractReDomain) {
        if (null == ocContractReDomain || null == request) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        OcContractSubDomain ocContractSubDomain = new OcContractSubDomain();
        ocContractSubDomain.setContractBillcode(ocContractReDomain.getContractBillcode());
        ocContractSubDomain.setContractSubGmoney(contractSubGmoney);
        ocContractSubDomain.setContractSubPmode("0");
        ocContractSubDomain.setContractSubPmoney(contractSubGmoney);
        ocContractSubDomain.setMemberCode(ocContractReDomain.getMemberCode());
        ocContractSubDomain.setMemberName(ocContractReDomain.getMemberName());
        ocContractSubDomain.setMemberCcode(ocContractReDomain.getMemberCcode());
        ocContractSubDomain.setMemberCname(ocContractReDomain.getMemberCname());
        ocContractSubDomain.setMemberBcode(userSession.getUserPcode());
        ocContractSubDomain.setMemberBname(userSession.getMerberCompname());
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        return ocContractSubDomain;
    }

    @RequestMapping(value={"updateRuleContract.json"}, name="\u4fee\u6539\u7ebf\u7d22\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRuleContract(HttpServletRequest request, String orderDomainStr, String ContractBillCode) {
        HtmlJsonReBean htmlJsonReBean;
        if (StringUtils.isBlank((String)orderDomainStr) || StringUtils.isBlank((String)ContractBillCode)) {
            this.logger.error(CODE + ".updateRuleContract", (Object)"param is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("contractBillcode", ContractBillCode);
        SupQueryResult contractGoodsReDomainSupQueryResult = this.ocContractServiceRepository.queryContractGoodsPage(map);
        if (null != contractGoodsReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)contractGoodsReDomainSupQueryResult.getList())) {
            for (OcContractGoodsReDomain ocContractGoods : contractGoodsReDomainSupQueryResult.getList()) {
                this.ocContractServiceRepository.deleteContractGoods(ocContractGoods.getContractGoodsId());
            }
        }
        if (null == (htmlJsonReBean = this.createOrderCule(request, orderDomainStr, CONCUL)) || "error".equals(htmlJsonReBean.getSysRecode())) {
            this.logger.error(CODE + ".updateRuleContract", (Object)"htmlJsonReBean is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u5546\u54c1\u5931\u8d25");
        }
        Map paramMap = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        paramMap.put("userCode", userSession.getUserCode());
        paramMap.put("userName", userSession.getUserName());
        paramMap.remove("tenantCode");
        paramMap.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(ContractBillCode, this.getTenantCode(request), paramMap);
    }
}

