/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.ct.domain.CtCustclueReDomain;
import com.qjsoft.laser.controller.facade.ct.repository.CtCustclueServiceRepository;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractGoodsReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OrderDomain;
import com.qjsoft.laser.controller.facade.oc.domain.PackageDomain;
import com.qjsoft.laser.controller.facade.oc.domain.TypeBean;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractSubServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcServiceRepository;
import com.qjsoft.laser.controller.order.controller.ContractComCon;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contractculeStore"}, name="\u95e8\u5e97\u7ebf\u7d22\u8ba2\u5355")
public class ContractCuleStoreCon
extends ContractComCon {
    private static String CODE = "oc.contractculeStore.con";
    @Autowired
    private OcServiceRepository ocServiceRepository;
    @Autowired
    private OcContractSubServiceRepository ocContractSubServiceRepository;
    @Autowired
    private CtCustclueServiceRepository ctCustclueServiceRepository;
    private static final String CONCUL = "50";

    @Override
    protected String getContext() {
        return "contract";
    }

    @RequestMapping(value={"getRulContractTo.json"}, name="\u83b7\u53d6\u7ebf\u7d22\u8ba2\u5355\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcContractReDomain getRulContract(String contractId) {
        if (StringUtils.isBlank((String)contractId)) {
            this.logger.error(CODE + ".getContract", (Object)"param is null");
            return null;
        }
        return this.getContractCom(contractId);
    }

    @RequestMapping(value={"queryContractPageTo.json"}, name="\u7ebf\u7d22\u8ba2\u5355\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractReDomain> queryContractPageC(HttpServletRequest request) {
        Map param = this.assemMapBuyParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        this.logger.error(CODE, (Object)("--------------------param is" + param.toString()));
        return this.queryContractPageCom(request, null, param);
    }

    @RequestMapping(value={"updateRulContractToSuccess.json"}, name="\u5ba1\u6838\u6210\u529f")
    @ResponseBody
    public HtmlJsonReBean updateRulContractToSuccess(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.put("dataStatestr", "8");
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"updateCuleContractToFail.json"}, name="\u5ba1\u6838\u5931\u8d25")
    @ResponseBody
    public HtmlJsonReBean updateCuleContractToFail(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".updateCuleContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        map.put("userCode", userSession.getUserCode());
        map.put("userName", userSession.getUserName());
        map.put("dataStatestr", "9");
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"addContractSub.json"}, name="\u65b0\u589e\u4ed8\u6b3e\u91d1\u989d")
    @ResponseBody
    public HtmlJsonReBean addContractSub(HttpServletRequest request, String contractBillcode, BigDecimal contractSubGmoney) {
        if (StringUtils.isBlank((String)contractBillcode) || null == contractSubGmoney) {
            this.logger.error(CODE + ".addContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("ocContractReDomain is null : " + ((Object)map).toString()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("userSession: " + ((Object)map).toString()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u672a\u767b\u9646");
        }
        String userPcode = userSession.getUserPcode();
        if (!userPcode.equals(ocContractReDomain.getMemberBcode())) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("userPcode: " + userPcode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u64cd\u4f5c\u6743\u9650");
        }
        OcContractSubDomain ocContractSubDomain = this.make(request, contractSubGmoney, ocContractReDomain);
        if (null == ocContractSubDomain) {
            this.logger.error(CODE + ".addContractSub.ocContractSubDomain", (Object)"ocContractSubDomain is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractSubServiceRepository.saveContractSub(ocContractSubDomain);
    }

    private OcContractSubDomain make(HttpServletRequest request, BigDecimal contractSubGmoney, OcContractReDomain ocContractReDomain) {
        if (null == ocContractReDomain || null == request) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        OcContractSubDomain ocContractSubDomain = new OcContractSubDomain();
        ocContractSubDomain.setContractBillcode(ocContractReDomain.getContractBillcode());
        ocContractSubDomain.setContractSubGmoney(contractSubGmoney);
        ocContractSubDomain.setContractSubPmode("0");
        ocContractSubDomain.setContractSubPmoney(contractSubGmoney);
        ocContractSubDomain.setMemberCode(ocContractReDomain.getMemberCode());
        ocContractSubDomain.setMemberName(ocContractReDomain.getMemberName());
        ocContractSubDomain.setMemberCcode(ocContractReDomain.getMemberCcode());
        ocContractSubDomain.setMemberCname(ocContractReDomain.getMemberCname());
        ocContractSubDomain.setMemberBcode(userSession.getUserPcode());
        ocContractSubDomain.setMemberBname(userSession.getMerberCompname());
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        return ocContractSubDomain;
    }

    @RequestMapping(value={"saveRuleContract.json"}, name="\u589e\u52a0\u7ebf\u7d22\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRuleContract(HttpServletRequest request, String orderDomainStr) {
        return this.createOrderCule(request, orderDomainStr, CONCUL);
    }

    public HtmlJsonReBean createOrderCule(HttpServletRequest request, String orderDomainStr, String contractType) {
        if (StringUtils.isBlank((String)orderDomainStr) || StringUtils.isBlank((String)contractType)) {
            this.logger.error(CODE + "saveRuleContract", (Object)"orderDomainStr or is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + "saveRuleContract", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u767b\u5f55\u4fe1\u606f\u4e3a\u7a7a");
        }
        List orderDomainLi = (List)JsonUtil.buildNormalBinder().getJsonToList(orderDomainStr, OrderDomain.class);
        if (ListUtil.isEmpty((Collection)orderDomainLi)) {
            this.logger.error(CODE + "createOrderCule", (Object)"ltLtinfoDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        OrderDomain orderDo = (OrderDomain)orderDomainLi.get(0);
        List ocContractGoodsDomainList = ((PackageDomain)orderDo.getPackageList().get(0)).getContractGoodsList();
        OrderDomain orderDomain = new OrderDomain();
        HashMap<String, Object> map = new HashMap<String, Object>();
        TypeBean typeBean = this.ocServiceRepository.getOcSetting(contractType, this.getTenantCode(request));
        if (null != typeBean) {
            orderDomain.setContractBlance(typeBean.getBlance());
            orderDomain.setContractPmode(typeBean.getPmode());
            map.put("contractBlance", typeBean.getBlance());
            map.put("contractPmode", typeBean.getPmode());
        }
        orderDomain.setContractRemark(orderDo.getContractRemark());
        orderDomain.setFaccountName(orderDo.getFaccountName());
        orderDomain.setContractType(contractType);
        orderDomain.setGoodsSupplierName(orderDo.getGoodsSupplierName());
        orderDomain.setMemberGname(orderDo.getMemberGname());
        orderDomain.setGoodsReceiptPhone(orderDo.getGoodsReceiptPhone());
        orderDomain.setGoodsReceiptMem(orderDo.getGoodsReceiptMem());
        orderDomain.setEmployeeCode(orderDo.getEmployeeCode());
        orderDomain.setEmployeeName(orderDo.getEmployeeName());
        orderDomain.setUserCode(userSession.getUserCode());
        orderDomain.setUserName(userSession.getUserName());
        orderDomain.setGoodsSupplierCode(userSession.getUserPcode());
        orderDomain.setContractMoney(orderDomain.getContractMoney());
        orderDomain.setContractInmoney(orderDomain.getContractInmoney());
        ArrayList<PackageDomain> packageList = new ArrayList<PackageDomain>();
        orderDomain.setPackageList(packageList);
        PackageDomain packageDomain = new PackageDomain();
        packageList.add(packageDomain);
        ArrayList<OcContractGoodsDomain> contractGoodsList = new ArrayList<OcContractGoodsDomain>();
        packageDomain.setContractGoodsList(contractGoodsList);
        for (OcContractGoodsDomain ocContractGoods : ocContractGoodsDomainList) {
            this.logger.error("ocContractGoods====---" + JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoods));
            OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
            ocContractGoodsDomain.setAppmanageIcode(this.getProappCode(request));
            this.logger.error("ocContractGoodsDomain====---" + JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractGoodsDomain));
            ocContractGoodsDomain.setContractGoodsInmoney(ocContractGoods.getContractGoodsInmoney());
            ocContractGoodsDomain.setContractGoodsMoney(ocContractGoods.getContractGoodsMoney());
            ocContractGoodsDomain.setContractGoodsPrice(ocContractGoods.getContractGoodsPrice());
            ocContractGoodsDomain.setGoodsCamount(ocContractGoods.getGoodsCamount());
            ocContractGoodsDomain.setGoodsNum(ocContractGoods.getGoodsNum());
            ocContractGoodsDomain.setPricesetNprice(ocContractGoods.getPricesetNprice());
            ocContractGoodsDomain.setGoodsName(ocContractGoods.getGoodsName());
            ocContractGoodsDomain.setGoodsType(contractType);
            ocContractGoodsDomain.setGoodsNo(ocContractGoods.getGoodsNo());
            ocContractGoodsDomain.setGoodsCode(ocContractGoods.getGoodsCode());
            ocContractGoodsDomain.setSkuCode(ocContractGoods.getSkuCode());
            ocContractGoodsDomain.setSkuName(ocContractGoods.getSkuName());
            ocContractGoodsDomain.setSkuNo(ocContractGoods.getSkuNo());
            ocContractGoodsDomain.setClasstreeCode(ocContractGoods.getClasstreeCode());
            ocContractGoodsDomain.setPntreeCode(ocContractGoods.getPntreeCode());
            ocContractGoodsDomain.setPntreeName(ocContractGoods.getPntreeName());
            ocContractGoodsDomain.setSpuCode(ocContractGoods.getSpuCode());
            ocContractGoodsDomain.setGoodsCamount(ocContractGoods.getGoodsCamount());
            ocContractGoodsDomain.setTenantCode(this.getTenantCode(request));
            ocContractGoodsDomain.setMemberBcode(userSession.getUserPcode());
            ocContractGoodsDomain.setMemberBname(userSession.getMerberCompname());
            contractGoodsList.add(ocContractGoodsDomain);
        }
        ArrayList<OrderDomain> orderDomainList = new ArrayList<OrderDomain>();
        orderDomainList.add(orderDomain);
        map.put("contractType", contractType);
        this.logger.error("orderDomainList====---" + JsonUtil.buildNonDefaultBinder().toJson(orderDomainList));
        HtmlJsonReBean htmlJsonReBean = this.ocServiceRepository.createOcOrder(orderDomainList, contractType, userSession, this.getProappCode(request), this.getOauthEnvCode(request), null);
        if (null == htmlJsonReBean || !htmlJsonReBean.isSuccess()) {
            return htmlJsonReBean;
        }
        map.put("contractBillcode", htmlJsonReBean.getDataObj());
        htmlJsonReBean.setDataObj(map);
        return htmlJsonReBean;
    }

    @RequestMapping(value={"updateRuleContract.json"}, name="\u4fee\u6539\u7ebf\u7d22\u8ba2\u5355\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRuleContract(HttpServletRequest request, String contract, String ContractBillCode) {
        OcContractDomain ocContractDomain;
        if (StringUtils.isBlank((String)contract) || StringUtils.isBlank((String)ContractBillCode)) {
            this.logger.error(CODE + ".updateRuleContract", (Object)"param is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("contractBillcode", ContractBillCode);
        SupQueryResult contractReDomainSu = this.ocContractServiceRepository.queryContractPage(map);
        if (null == contractReDomainSu || ListUtil.isEmpty((Collection)contractReDomainSu.getList())) {
            this.logger.error(CODE + ".updateRuleContract", (Object)"contractReDomainSu is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u6b64\u8ba2\u5355");
        }
        OcContractReDomain contractReDomain = (OcContractReDomain)contractReDomainSu.getList().get(0);
        SupQueryResult contractGoodsReDomainSupQueryResult = this.ocContractServiceRepository.queryContractGoodsPage(map);
        if (null != contractGoodsReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)contractGoodsReDomainSupQueryResult.getList())) {
            for (OcContractGoodsReDomain ocContractGoods : contractGoodsReDomainSupQueryResult.getList()) {
                this.ocContractServiceRepository.deleteContractGoods(ocContractGoods.getContractGoodsId());
            }
        }
        if (null == (ocContractDomain = (OcContractDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(contract, OcContractDomain.class))) {
            this.logger.error(CODE + ".updateRuleContract", (Object)"ocContractDomain is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6570\u636e\u7c7b\u578b\u9519\u8bef");
        }
        List ocContractGoodsDomains = ocContractDomain.getGoodsList();
        BigDecimal contractMoney = new BigDecimal("0");
        if (null == ocContractGoodsDomains) {
            ocContractDomain.setContractMoney(new BigDecimal(0));
        } else {
            for (OcContractGoodsDomain ocContractGoodsDomain : ocContractGoodsDomains) {
                ocContractGoodsDomain.setContractBillcode(contractReDomain.getContractBillcode());
                ocContractGoodsDomain.setTenantCode(this.getTenantCode(request));
                ocContractGoodsDomain.setGoodsType(CONCUL);
                contractMoney = contractMoney.add(ocContractGoodsDomain.getContractGoodsMoney());
                this.ocContractServiceRepository.saveContractGoods(ocContractGoodsDomain);
            }
        }
        ocContractDomain.setContractBillcode(contractReDomain.getContractBillcode());
        ocContractDomain.setContractId(contractReDomain.getContractId());
        ocContractDomain.setTenantCode(this.getTenantCode(request));
        ocContractDomain.setContractType(CONCUL);
        HtmlJsonReBean htmlJsonReBean = this.ocContractServiceRepository.updateContract(ocContractDomain);
        if (null == htmlJsonReBean || "error".equals(htmlJsonReBean.getErrorCode())) {
            this.logger.error(CODE + ".updateRuleContract", (Object)"htmlJsonReBean is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4fee\u6539\u8ba2\u5355\u5931\u8d25");
        }
        Map paramMap = this.getQueryMapParams(request);
        UserSession userSession = this.getUserSession(request);
        paramMap.put("userCode", userSession.getUserCode());
        paramMap.put("userName", userSession.getUserName());
        paramMap.remove("tenantCode");
        paramMap.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(ContractBillCode, this.getTenantCode(request), paramMap);
    }

    @RequestMapping(value={"queryContractCustcluePage.json"}, name="\u67e5\u8be2\u5ba2\u6237\u7ebf\u7d22\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<CtCustclueReDomain> queryCustcluePage(HttpServletRequest request, String custrelPhone) {
        UserSession userSession = this.getUserSession(request);
        if (StringUtils.isBlank((String)custrelPhone) || EmptyUtil.isEmpty((Object)userSession) || StringUtils.isBlank((String)userSession.getTenantCode()) || StringUtils.isBlank((String)userSession.getUserPcode())) {
            this.logger.error(CODE + ".queryCustcluePage", (Object)"UserSession param is null");
            return new SupQueryResult();
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            param.put("memberPcode", userSession.getUserPcode());
        }
        param.put("custrelPhone", custrelPhone);
        return this.ctCustclueServiceRepository.queryCustcluePage(param);
    }
}

