/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qjsoft.laser.controller.order.utils.GinkgoResultException;
import com.qjsoft.laser.controller.order.utils.GinkgoSignException;
import com.qjsoft.laser.controller.order.utils.SM2;
import com.qjsoft.laser.controller.order.utils.SignUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class GinkgoRequestUtil {
    private static final Logger log = LoggerFactory.getLogger(GinkgoRequestUtil.class);
    private final String API_OAUTH;
    private final String API_USERINFO;
    private RestTemplate restTemplate = new RestTemplate();
    private ObjectMapper mapper = new ObjectMapper();
    private String tmpToken;

    public GinkgoRequestUtil() {
        this.API_OAUTH = "/v1/token/access";
        this.API_USERINFO = "/v1/datacenter/smartverification/encrypted/idcard/verify";
    }

    private void getToken(String ginkgoDomain, String appId, String appKey) throws JsonProcessingException {
        String url = ginkgoDomain + this.API_OAUTH;
        System.out.println("ginkgo token url: " + url);
        log.info("ginkgo token url: " + url);
        HashMap<String, String> req = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String nowFormat = sdf.format(new Date(System.currentTimeMillis()));
        req.put("appId", appId);
        req.put("timestamp", nowFormat);
        String nonce = SignUtil.createData(3);
        req.put("nonce", nonce);
        req.put("signature", SignUtil.SHA1(appId + nowFormat + nonce + appKey));
        System.out.println("ginkgo token request: " + this.mapper.writeValueAsString(req));
        log.info("ginkgo token request: " + this.mapper.writeValueAsString(req));
        HttpHeaders header = new HttpHeaders();
        header.set("Content-Type", "application/json;charset=UTF-8");
        header.set("Accept", "application/json");
        header.set("Charset", "UTF-8");
        this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(req, (MultiValueMap)header), HashMap.class, new Object[0]);
        Map response = (Map)this.restTemplate.postForObject(url, req, Map.class, new Object[0]);
        System.out.println("ginkgo token response: " + this.mapper.writeValueAsString((Object)response));
        log.info("ginkgo token response: " + this.mapper.writeValueAsString((Object)response));
        if (!"0000".equals(response.get("errCode"))) {
            throw new GinkgoResultException("ginkgo\u9274\u6743\u8ba4\u8bc1\u5931\u8d25");
        }
        this.tmpToken = (String)response.get("accessToken");
    }

    public Map<String, String> realNameAuth(String ginkgoDomain, String appId, String appKey, Map<String, Object> body, String cheryPrikey) throws IOException {
        ResponseEntity resp;
        String authorization;
        String url = ginkgoDomain + this.API_USERINFO;
        System.out.println("ginkgo real name auth url: " + url);
        log.info("ginkgo real name auth url: " + url);
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("data", body);
        System.out.println("ginkgo real name auth request: " + this.mapper.writeValueAsString(req));
        log.info("ginkgo real name auth request: " + this.mapper.writeValueAsString(req));
        String encData = SM2.sm2Encrypt(JSON.toJSONString(body), "0414bb7e9c3914bb65b85079b1dc6e1ca2a0ee04dd9bb55b2f8d31704a6dec0cca695739e128f9c931330e1c0f493be4d56244236434c9d344c4716ba64a4470ba");
        req.put("data", encData);
        System.out.println("ginkgo real name auth request [ENC]: " + this.mapper.writeValueAsString(req));
        log.info("ginkgo real name auth request [ENC]: " + this.mapper.writeValueAsString(req));
        try {
            authorization = SignUtil.getOpenBodySig(appId, appKey, JSON.toJSONString(req));
        }
        catch (Exception e) {
            throw new GinkgoSignException(e);
        }
        HttpHeaders header = new HttpHeaders();
        header.set("Authorization", authorization);
        header.set("Content-Type", "application/json;charset=UTF-8");
        header.set("Accept", "application/json");
        System.out.println("ginkgo real name auth request [headers]: " + this.mapper.writeValueAsString((Object)header));
        log.info("ginkgo real name auth request [headers]: " + this.mapper.writeValueAsString((Object)header));
        try {
            resp = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(req, (MultiValueMap)header), Map.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            log.error("ginkgo error: status" + e.getStatusCode() + " - " + e.getStatusText() + " - " + " " + e.getResponseBodyAsString());
            System.out.println("ginkgo error: " + e.getStatusCode() + " - " + e.getStatusText() + " - " + " " + e.getResponseBodyAsString());
            throw new GinkgoResultException(e);
        }
        catch (Exception e) {
            throw new GinkgoResultException(e);
        }
        log.info("ginkgo real name auth response: " + this.mapper.writeValueAsString((Object)resp));
        System.out.println("ginkgo real name auth response: " + this.mapper.writeValueAsString((Object)resp));
        if (resp.getStatusCode().value() != 200) {
            throw new GinkgoResultException("ginkgo\u5b9e\u540d\u8ba4\u8bc1 \u8bf7\u6c42\u9519\u8bef");
        }
        Map respBody = (Map)resp.getBody();
        if ("20000000".equals(respBody.get("errCode"))) {
            String rawData = SM2.sm2Decrypt((String)respBody.get("data"), cheryPrikey);
            System.out.println("ginkgo real name auth response [DEC]: " + this.mapper.writeValueAsString((Object)rawData));
            log.info("ginkgo real name auth response [DEC]: " + this.mapper.writeValueAsString((Object)rawData));
            Map data = (Map)this.mapper.readValue(rawData, HashMap.class);
            return data;
        }
        throw new GinkgoResultException("ginkgo\u5b9e\u540d\u8ba4\u8bc1 \u8bf7\u6c42\u9519\u8bef");
    }

    public static void main(String[] args) throws IOException {
        GinkgoRequestUtil util = new GinkgoRequestUtil();
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("keyType", "2");
        body.put("certNo", "522225198509150043");
        body.put("name", "\u90ed\u96ea");
        String cheryPrikey = "00f79255c9c27d48043bd99e53c8d579b16a4ca152aaa7e59c8d000c4097e7987b";
        Map<String, String> infoQryByToken = util.realNameAuth("https://test-api-open.chinaums.com", "10037e6f7c2188f4017c81d039310006", "ef2af39858354c80818773276c6b844c", body, cheryPrikey);
        System.out.println(JSONObject.toJSONString(infoQryByToken));
    }
}

