/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.utils;

import com.alibaba.fastjson.JSON;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);
    private static final int SIGN_EXPIRED_TIME = 300000;
    private static final String SIGN_KEY = "sign";
    private static final String TIMESTAMP_KEY = "timestamp";
    private static final String APP_KEY = "appKey";
    private static final String ACCESS_SECRET = "appSecret";

    public static Map<String, Object> checkSign(HttpServletRequest request, String appSecret) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String timeStamp = request.getParameter(TIMESTAMP_KEY);
        String appKey = request.getParameter(APP_KEY);
        if (StringUtils.isEmpty((String)appKey)) {
            resultMap.put("code", "0001");
            resultMap.put("msg", "appKey\u4e0d\u5408\u6cd5\uff01");
            resultMap.put("result", false);
            return resultMap;
        }
        if (null == timeStamp && System.currentTimeMillis() - Long.valueOf(timeStamp) > 300000L) {
            resultMap.put("code", "0002");
            resultMap.put("msg", "\u8bf7\u6c42\u8d85\u65f6");
            resultMap.put("result", false);
            return resultMap;
        }
        if (!SignUtil.signVerification(request, appSecret).booleanValue()) {
            resultMap.put("code", "0003");
            resultMap.put("msg", "\u7b7e\u540d\u9519\u8bef");
            resultMap.put("result", false);
            return resultMap;
        }
        resultMap.put("result", true);
        return resultMap;
    }

    private static Boolean signVerification(HttpServletRequest request, String appSecret) {
        Enumeration parameterNames = request.getParameterNames();
        HashMap<String, Object> params = new HashMap<String, Object>();
        while (parameterNames.hasMoreElements()) {
            String Name = (String)parameterNames.nextElement();
            if (SIGN_KEY.equals(Name)) continue;
            String Value = request.getParameter(Name);
            params.put(Name, Value);
        }
        log.info("======================================" + params + "=======================");
        String signKey = request.getParameter(SIGN_KEY);
        log.info("=================================" + signKey + "====================================");
        String sign = SignUtil.creatSign(params, appSecret);
        return sign.equals(signKey);
    }

    private static String creatSign(Map<String, Object> params, String appSecret) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(params);
        Set entries = treeMap.entrySet();
        StringBuilder temp = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : entries) {
            if (first) {
                first = false;
            } else {
                temp.append("&");
            }
            temp.append((String)entry.getKey()).append("=");
            Object value = entry.getValue();
            String valueString = "";
            if (null != value) {
                valueString = String.valueOf(value);
            }
            temp.append(valueString);
        }
        temp.append("&").append(ACCESS_SECRET).append("=").append(appSecret);
        log.info("====================" + temp.toString() + "=======================================================");
        log.info("================================" + temp.toString().toUpperCase() + "=============================");
        return SignUtil.md5(temp.toString()).toUpperCase();
    }

    private static String md5(String str) {
        return DigestUtils.md5Hex((byte[])str.getBytes(StandardCharsets.UTF_8));
    }

    public static String getRandomString2(int length) {
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        block5: for (int i = 0; i < length; ++i) {
            int number = random.nextInt(3);
            long result = 0L;
            switch (number) {
                case 0: {
                    result = Math.round(Math.random() * 25.0 + 65.0);
                    sb.append(String.valueOf((char)result));
                    continue block5;
                }
                case 1: {
                    result = Math.round(Math.random() * 25.0 + 97.0);
                    sb.append(String.valueOf((char)result));
                    continue block5;
                }
                case 2: {
                    sb.append(String.valueOf(new Random().nextInt(10)));
                }
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            String apiUrl = "https://dev-midend-c-manage.jetour.com.cn/web/oc/contract/loanResultNotify.json";
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            String nonce = SignUtil.getRandomString2(10);
            resultMap.put(TIMESTAMP_KEY, System.currentTimeMillis());
            resultMap.put("nonce", nonce);
            resultMap.put("name", "\u738b\u6653\u6c11");
            resultMap.put("age", "32");
            resultMap.put("school", "\u7b2c\u4e8c\u5e08\u8303\u5b66\u9662");
            resultMap.put(APP_KEY, APP_KEY);
            String sign = SignUtil.creatSign(resultMap, "accessSecret");
            resultMap.put(SIGN_KEY, sign);
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>(resultMap);
            Set entries = treeMap.entrySet();
            StringBuilder temp = new StringBuilder();
            boolean first = true;
            for (Map.Entry entry : entries) {
                if (first) {
                    first = false;
                } else {
                    temp.append("&");
                }
                temp.append((String)entry.getKey()).append("=");
                Object value = entry.getValue();
                String valueString = "";
                if (null != value) {
                    valueString = String.valueOf(value);
                }
                temp.append(valueString);
            }
            System.out.println(temp);
            HttpPost httpPost = new HttpPost(apiUrl);
            StringEntity stringEntity = new StringEntity(temp.toString(), "UTF-8");
            stringEntity.setContentType("application/x-www-form-urlencoded");
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.54 Safari/537.36");
            CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = execute.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            Map map = (Map)JSON.parse((String)result);
            System.out.println(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

