/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractproDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractproReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractEngineServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractproServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contractpro"}, name="\u8ba2\u5355\u6269\u5c55\u8868")
public class ContractproCon
extends SpringmvcController {
    private static String CODE = "oc.contractpro.con";
    @Autowired
    private OcContractproServiceRepository ocContractproServiceRepository;
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcContractEngineServiceRepository ocContractEngineServiceRepository;

    protected String getContext() {
        return "contractpro";
    }

    @RequestMapping(value={"saveContractpro.json"}, name="\u589e\u52a0\u8ba2\u5355\u6269\u5c55\u8868")
    @ResponseBody
    public HtmlJsonReBean saveContractpro(HttpServletRequest request, OcContractproDomain ocContractproDomain) {
        if (null == ocContractproDomain) {
            this.logger.error(CODE + ".saveContractpro", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractproDomain.setContractproType("url");
        ocContractproDomain.setTenantCode(this.getTenantCode(request));
        this.confirmReceipt(request, ocContractproDomain.getContractBillcode());
        return this.ocContractproServiceRepository.savecontractpro(ocContractproDomain);
    }

    private Boolean confirmReceipt(HttpServletRequest request, String contractBillcode) {
        String tenantCode = this.getTenantCode(request);
        Map getContractMap = this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode});
        OcContractReDomain contract = this.ocContractServiceRepository.getContractByCode(getContractMap);
        if (contract == null) {
            return false;
        }
        HtmlJsonReBean contractResult = this.sendContractNext(request, contractBillcode);
        if (null == contractResult || !contractResult.isSuccess()) {
            return false;
        }
        List ocContractGoodsDomainList = contract.getGoodsList();
        if (ocContractGoodsDomainList == null) {
            this.logger.error(CODE + ".confirmReceive.ocContractGoodsDomainList", (Object)"ocContractGoodsDomainList\u53c2\u6570\u4e3a\u7a7a");
        }
        return true;
    }

    private HtmlJsonReBean sendContractNext(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isEmpty((String)contractBillcode)) {
            this.logger.error(CODE + ".sendContractNext", (Object)"contractBillcode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String tenantCode = this.getTenantCode(request);
        Map map = this.getQueryMapParams(request);
        map.remove("tenantCode");
        map.remove("contractBillcode");
        return this.ocContractEngineServiceRepository.sendContractNext(contractBillcode, tenantCode, map);
    }

    @RequestMapping(value={"getContractpro.json"}, name="\u83b7\u53d6\u8ba2\u5355\u6269\u5c55\u8868\u4fe1\u606f")
    @ResponseBody
    public OcContractproReDomain getContractpro(Integer contractproId) {
        if (StringUtils.isBlank((Integer)contractproId)) {
            this.logger.error(CODE + ".getContractpro", (Object)"param is null");
            return null;
        }
        return this.ocContractproServiceRepository.getcontractpro(contractproId);
    }

    @RequestMapping(value={"updateContractpro.json"}, name="\u66f4\u65b0\u8ba2\u5355\u6269\u5c55\u8868")
    @ResponseBody
    public HtmlJsonReBean updateContractpro(HttpServletRequest request, OcContractproDomain ocContractproDomain) {
        if (null == ocContractproDomain) {
            this.logger.error(CODE + ".updateContractpro", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractproDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractproServiceRepository.updatecontractpro(ocContractproDomain);
    }

    @RequestMapping(value={"deleteContractpro.json"}, name="\u5220\u9664\u8ba2\u5355\u6269\u5c55\u8868")
    @ResponseBody
    public HtmlJsonReBean deleteContractpro(Integer contractproId) {
        if (StringUtils.isBlank((Integer)contractproId)) {
            this.logger.error(CODE + ".deleteContractpro", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractproServiceRepository.deletecontractpro(contractproId);
    }

    @RequestMapping(value={"queryContractproPage.json"}, name="\u67e5\u8be2\u8ba2\u5355\u6269\u5c55\u8868\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractproReDomain> queryContractproPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractproServiceRepository.querycontractproPage(param);
    }

    @RequestMapping(value={"updateContractproState.json"}, name="\u66f4\u65b0\u8ba2\u5355\u6269\u5c55\u8868\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractproState(String contractproId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractproId)) {
            this.logger.error(CODE + ".updateContractproState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractproServiceRepository.updatecontractproState(Integer.valueOf(contractproId), dataState, oldDataState, null);
    }
}

