/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.utils.fubon;

import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class JAVA_SDK_SecurityUtils {
    public static final String AES_MODE = "AES/CBC/PKCS5Padding";
    public static final String SHA256WITHRSA = "SHA256withRSA";
    public static final String SHA256 = "SHA-256";
    public static final String AES = "AES";
    public static final String RSA = "RSA";
    private static final byte[] AES_IV = JAVA_SDK_SecurityUtils.initIV("AES/CBC/PKCS5Padding");

    public static String encryptByBASE64(byte[] key) {
        return new BASE64Encoder().encodeBuffer(key).replaceAll("\r\n", "").replaceAll("\n", "");
    }

    public static byte[] decryptByBASE64(String key) throws IOException {
        return new BASE64Decoder().decodeBuffer(key.replaceAll("\r\n", "").replaceAll("\n", ""));
    }

    public static byte[] SHA256(byte[] data) throws Exception {
        MessageDigest sha = MessageDigest.getInstance(SHA256);
        sha.update(data);
        return sha.digest();
    }

    public static byte[] SHA2564WeChat(byte[] data) throws Exception {
        return Hex.encodeHexString((byte[])JAVA_SDK_SecurityUtils.SHA256(data)).getBytes();
    }

    public static byte[] SHA256withRSA(byte[] data, PrivateKey privateKey) throws Exception {
        Signature sig = Signature.getInstance(SHA256WITHRSA);
        sig.initSign(privateKey);
        sig.update(data);
        byte[] ret = sig.sign();
        return ret;
    }

    public static boolean verifyByPublicKey(byte[] data, PublicKey publicKey, byte[] signature) throws Exception {
        Signature sig = Signature.getInstance(SHA256WITHRSA);
        sig.initVerify(publicKey);
        sig.update(data);
        boolean ret = sig.verify(signature);
        return ret;
    }

    public static byte[] encryptByAES(byte[] data, byte[] pwd) throws Exception {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        SecretKeySpec keySpec = new SecretKeySpec(pwd, AES);
        cipher.init(1, (Key)keySpec, new IvParameterSpec(AES_IV));
        byte[] ret = cipher.doFinal(data);
        return ret;
    }

    public static byte[] decryptByAES(byte[] data, byte[] pwd) throws Exception {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        SecretKeySpec keySpec = new SecretKeySpec(pwd, AES);
        cipher.init(2, (Key)keySpec, new IvParameterSpec(AES_IV));
        byte[] ret = cipher.doFinal(data);
        return ret;
    }

    public static byte[] encryptByRSA(byte[] data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, key);
        byte[] output = cipher.doFinal(data);
        return output;
    }

    public static byte[] decryptByRSA(byte[] input, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, key);
        byte[] output = cipher.doFinal(input);
        return output;
    }

    private static byte[] initIV(String aesCbcPkcAlg) {
        try {
            Cipher cp = Cipher.getInstance(aesCbcPkcAlg);
            int blockSize = cp.getBlockSize();
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
        catch (Exception e) {
            int blockSize = 16;
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
    }

    public static String getRandomKey() {
        Random random = new Random();
        long longValue = random.nextLong();
        return String.format("%016x", longValue);
    }
}

