/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.order.constants.FinanceOrgEnum;
import com.qjsoft.laser.controller.order.constants.FinancialInstitutionEnum;
import com.qjsoft.laser.controller.order.constants.FinancialMappingEnum;
import com.qjsoft.laser.controller.order.controller.QueryFinancialConvert;
import com.qjsoft.laser.controller.order.controller.RestUtil;
import com.qjsoft.laser.controller.order.request.QueryBurPointCardRequest;
import com.qjsoft.laser.controller.order.request.QueryCityShopFinMQryRequest;
import com.qjsoft.laser.controller.order.request.QueryFinancialProductsRequest;
import com.qjsoft.laser.controller.order.request.QueryTFinanInStrRequest;
import com.qjsoft.laser.controller.order.response.FinancialProductsResponse;
import com.qjsoft.laser.controller.order.response.QueryAppStatusResponse;
import com.qjsoft.laser.controller.order.response.QueryFinancialProductsResponse;
import com.qjsoft.laser.controller.order.response.QueryTFinanInStrResponse;
import com.qjsoft.laser.controller.order.utils.fubon.SendFuBon;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class QueryFinancialProductsUtils {
    private static final Logger log = LoggerFactory.getLogger(QueryFinancialProductsUtils.class);
    @Autowired
    private QueryFinancialConvert convert;
    @Autowired
    private RestUtil restUtil;
    private RestTemplate restTemplate = new RestTemplate();
    private static String CODE = "Contract.QueryFinancialProductsUtils";
    private static final String DDFLAGTYPE = "financialInstitution";
    private static final String CHANNEL_ID = "QRXYK";

    public QueryFinancialProductsResponse<FinancialProductsResponse> callThirdPartyInterface(QueryFinancialProductsRequest request, String tenantCode) {
        QueryFinancialProductsResponse<FinancialProductsResponse> response = null;
        if (StringUtils.isBlank((String)request.getFinanceOrg())) {
            log.error("\u91d1\u878d\u673a\u6784\u8bc6\u522b\u7801\u5165\u53c2\u4e3a\u7a7a!");
            response = new QueryFinancialProductsResponse<FinancialProductsResponse>();
            response.fail("\u8bf7\u8bbe\u7f6e\u67e5\u8be2\u91d1\u878d\u7ed3\u6784!");
            return response;
        }
        switch (FinanceOrgEnum.getByCode(request.getFinanceOrg())) {
            case HUIYIN: {
                response = this.callHuiYin(request, tenantCode);
                break;
            }
            case FUBANG: {
                response = this.callFuBang(tenantCode);
                break;
            }
            default: {
                response = new QueryFinancialProductsResponse<FinancialProductsResponse>("-1", "\u672a\u5339\u914d\u5230\u91d1\u878d\u673a\u6784!");
            }
        }
        return response;
    }

    public QueryFinancialProductsResponse callHuiYin(QueryFinancialProductsRequest request, String tenantCode) {
        QueryFinancialProductsResponse queryFinancialProductsResponse = new QueryFinancialProductsResponse();
        String huiYinToken = "";
        String json = String.format("{\n\"secert\": \"aWNhcl90ZXN0X3VzZXJfMDAx\"\n}", "");
        try {
            Map mapToken = this.restUtil.post("http://icar.cheryfs.cn:16003/getToken", json, "");
            if (mapToken.containsKey("code") && "0".equals(mapToken.get("code")) && mapToken.containsKey("data")) {
                log.info("=======================" + mapToken.get("data") + "===================================================");
                Map dataMap = (Map)mapToken.get("data");
                huiYinToken = String.valueOf(dataMap.get("token"));
                log.info("=========" + CODE + "============", (Object)mapToken);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            queryFinancialProductsResponse.fail("\u83b7\u53d6token\u5931\u8d25");
            return queryFinancialProductsResponse;
        }
        if (!StringUtils.isBlank((String)huiYinToken)) {
            try {
                String param = request.getIcarStyleCode();
                Map map = this.restUtil.post("http://icar.cheryfs.cn:16003/product/list", param, huiYinToken);
                log.info("=========" + CODE + "============", (Object)map);
                return this.convert.convertHy(map);
            }
            catch (Exception e) {
                queryFinancialProductsResponse.fail("\u83b7\u53d6\u91d1\u878d\u4ea7\u54c1\u5931\u8d25");
                e.printStackTrace();
                return queryFinancialProductsResponse;
            }
        }
        queryFinancialProductsResponse.fail("token\u83b7\u53d6\u4e3a\u7a7a");
        return queryFinancialProductsResponse;
    }

    public QueryFinancialProductsResponse<FinancialProductsResponse> callFuBang(String tenantCode) {
        String ddFlagCode = "fubang_financeData";
        String financeData = this.getDdFlag(tenantCode, ddFlagCode, DDFLAGTYPE);
        QueryFinancialProductsResponse<FinancialProductsResponse> response = new QueryFinancialProductsResponse<FinancialProductsResponse>();
        if (StringUtils.isBlank((String)financeData)) {
            log.error("================" + CODE + "=====================\u67e5\u8be2\u5bcc\u90a6\u91d1\u878d\u4ea7\u54c1\u6570\u636e\u4e3a\u7a7a!");
            response.fail("\u67e5\u8be2\u5bcc\u90a6\u91d1\u878d\u6570\u636e\u4e3a\u7a7a!");
            return response;
        }
        List result = JSON.parseArray((String)financeData, FinancialProductsResponse.class);
        if (CollectionUtils.isEmpty((Collection)result)) {
            log.error("================" + CODE + "=====================\u5bcc\u90a6\u91d1\u878d\u4ea7\u54c1\u6570\u636e\u8f6c\u6362\u4e3a\u7a7a!");
            response.fail("\u83b7\u53d6\u5bcc\u90a6\u91d1\u878d\u4ea7\u54c1\u6570\u636e\u4e3a\u7a7a!");
            return response;
        }
        response.success("\u64cd\u4f5c\u6210\u529f!");
        response.setProductList(result);
        return response;
    }

    public QueryAppStatusResponse callFuBangQueryAppStatus(String tenantCode, String idCard) {
        String ddFlagCode = FinancialInstitutionEnum.FUBANG_APPLYQRYCARD.getCode();
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("channelID", (Object)CHANNEL_ID);
        jsonBody.put("idcard", (Object)idCard);
        String url = this.getDdFlag(tenantCode, ddFlagCode, DDFLAGTYPE) + FinancialInstitutionEnum.FUBANG_APPLYQRYCARD.getRequestUrl();
        QueryAppStatusResponse response = null;
        try {
            log.info("======callFuBangQueryAppStatus=======  jsonBody={},url={},tenantCode={}", new Object[]{jsonBody, url, tenantCode});
            String result = SendFuBon.sendFuBon(jsonBody, url, tenantCode);
            log.info("======callFuBangQueryAppStatus=======  result={}", (Object)result);
            if (StringUtils.isNotBlank((String)result)) {
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                if (jsonObject.containsKey((Object)"code") && "000000".equals(jsonObject.getString("code"))) {
                    response = jsonObject.containsKey((Object)"data") ? this.convert.convertFuBonAppStatus(jsonObject.getString("data")) : new QueryAppStatusResponse("-1", "\u5bcc\u90a6\u7533\u8bf7\u72b6\u6001\u67e5\u8be2\u4e3a\u7a7a!!");
                } else {
                    String message = "";
                    message = jsonObject.containsKey((Object)"message") ? jsonObject.getString("message") : "\u5bcc\u90a6\u7533\u8bf7\u72b6\u6001\u67e5\u8be2\u5931\u8d25!";
                    response = new QueryAppStatusResponse("-1", message);
                }
            } else {
                response = new QueryAppStatusResponse("-1", "\u5bcc\u90a6\u7533\u8bf7\u72b6\u6001\u67e5\u8be2\u4e3a\u7a7a!");
            }
        }
        catch (IOException e) {
            log.error("QueryFinancialProductsUtils.callFuBangQueryAppStatus \u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38 A!");
            response = new QueryAppStatusResponse("-1", "\u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38");
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("QueryFinancialProductsUtils.callFuBangQueryAppStatus \u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38 B!");
            response = new QueryAppStatusResponse("-1", "\u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38");
            e.printStackTrace();
        }
        return response;
    }

    public HtmlJsonReBean callFuBangBurPointCard(QueryBurPointCardRequest request, String tenantCode) {
        if (FinanceOrgEnum.FUBANG.equals((Object)FinanceOrgEnum.getByCode(request.getFinanceOrg()))) {
            request.setChannelID(CHANNEL_ID);
            if (!request.checkRequire()) {
                log.error("QueryFinancialProductsUtils.burPointCard \u8c03\u7528\u5bcc\u90a6\u9884\u5ba1\u6570\u636e\u91c7\u96c6 \u5fc5\u586b\u5165\u53c2\u5b58\u5728\u7a7a\u503c!");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6570\u636e\u4e0d\u5168!");
            }
            try {
                JSONObject json;
                String ddFlagCode = FinancialInstitutionEnum.FUBANG_BURPOINTCARD.getCode();
                String url = this.getDdFlag(tenantCode, ddFlagCode, DDFLAGTYPE) + FinancialInstitutionEnum.FUBANG_BURPOINTCARD.getRequestUrl();
                String carType = QueryFinancialProductsUtils.getDestinationFromDdFlag(FinanceOrgEnum.FUBANG.getCode(), FinancialMappingEnum.MODEL.getKey(), request.getQr_car_type(), tenantCode);
                String carColor = QueryFinancialProductsUtils.getDestinationFromDdFlag(FinanceOrgEnum.FUBANG.getCode(), FinancialMappingEnum.COLOR.getKey(), request.getQr_car_color(), tenantCode);
                if (StringUtils.isBlank((String)carType)) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8f66\u578b\u4e0d\u80fd\u5339\u914d\u6570\u636e\u5b57\u5178!");
                }
                if (StringUtils.isBlank((String)carColor)) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8f66\u8eab\u989c\u8272\u4e0d\u80fd\u5339\u914d\u6570\u636e\u5b57\u5178!");
                }
                request.setQr_car_color(carColor);
                request.setQr_car_type(carType);
                JSONObject jsonBody = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
                if (jsonBody.containsKey((Object)"financeOrg")) {
                    jsonBody.remove((Object)"financeOrg");
                }
                if (jsonBody.containsKey((Object)"contractBillcode")) {
                    jsonBody.remove((Object)"contractBillcode");
                }
                log.info("======callFuBangBurPointCard=======  jsonBody={},url={},tenantCode={}", new Object[]{jsonBody, url, tenantCode});
                String result = SendFuBon.sendFuBon(jsonBody, url, tenantCode);
                log.info("======callFuBangBurPointCard=======  result={}", (Object)result);
                if (StringUtils.isNotBlank((String)result) && null != (json = JSONObject.parseObject((String)result))) {
                    if (json.containsKey((Object)"code") && "000000".equals(json.getString("code"))) {
                        if (json.containsKey((Object)"data")) {
                            return new HtmlJsonReBean((Object)JSONObject.parseObject((String)json.getString("data")));
                        }
                        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5bcc\u90a6\u9884\u5ba1\u6570\u636e\u91c7\u96c6\u5931\u8d25!!");
                    }
                    String message = "";
                    message = json.containsKey((Object)"message") ? json.getString("message") : "\u5bcc\u90a6\u9884\u5ba1\u6570\u636e\u91c7\u96c6\u5931\u8d25!";
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, message);
                }
            }
            catch (Exception e) {
                log.error("QueryFinancialProductsUtils.callFuBangBurPointCard \u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38!======error:{}", (Object)e.getMessage());
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38!");
            }
        }
        return new HtmlJsonReBean();
    }

    public Map<String, Object> callHuiYinQueryAppResult(String idCardNo, String tenantCode) {
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            String huiYinToken = QueryFinancialProductsUtils.getHuiYinToken();
            String apiUrl = "http://icar.cheryfs.cn:16003/queryApproeResult/query";
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("icarOrderNo", idCardNo);
            String post = JSONObject.toJSONString(postData);
            HttpPost httpPost = new HttpPost(apiUrl);
            StringEntity stringEntity = new StringEntity(post, "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.addHeader("token", huiYinToken);
            httpPost.addHeader("Content-Type", "application/json;charset=utf-8");
            log.info("=================================================" + httpPost + "================================================");
            CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = execute.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            log.info(result + "==========================================================================");
            Map resultMap = (Map)JSON.parse((String)result);
            if (resultMap.containsKey("code")) {
                if ("0".equals(resultMap.get("code"))) {
                    return resultMap;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public HtmlJsonReBean callFuBangCityShopFinMQry(QueryCityShopFinMQryRequest request, String tenantCode) {
        if (request.checkFinanceOrgIsNull()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u8bbe\u7f6e\u91d1\u878d\u673a\u6784!");
        }
        if (!request.checkRequire()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5b58\u5728\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a!");
        }
        request.setChannelID(CHANNEL_ID);
        String ddFlagCode = FinancialInstitutionEnum.FUBANG_CITYSHOPFINMQRY.getCode();
        String url = this.getDdFlag(tenantCode, ddFlagCode, DDFLAGTYPE) + FinancialInstitutionEnum.FUBANG_CITYSHOPFINMQRY.getRequestUrl();
        JSONObject jsonBody = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
        if (jsonBody.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (jsonBody.containsKey((Object)"financeOrg")) {
            jsonBody.remove((Object)"financeOrg");
        }
        log.info("======callFuBangCityShopFinMQry=======  jsonBody={},url={},tenantCode={}", new Object[]{jsonBody, url, tenantCode});
        String result = SendFuBon.sendFuBon(jsonBody, url, tenantCode);
        log.info("======callFuBangCityShopFinMQry=======  result={}", (Object)result);
        if (StringUtils.isBlank((String)result)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u4e3a\u7a7a!");
        }
        JSONObject json = JSONObject.parseObject((String)result);
        String message = "";
        JSONObject data = null;
        if (json.containsKey((Object)"code")) {
            if (!"000000".equals(json.getString("code"))) {
                message = json.containsKey((Object)"message") ? json.getString("message") : "\u67e5\u8be2\u5931\u8d25!";
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, message);
            }
            data = JSONObject.parseObject((String)json.getString("data"));
        }
        return new HtmlJsonReBean(data);
    }

    public HtmlJsonReBean financialCalculation(QueryTFinanInStrRequest request, String tenantCode) {
        HtmlJsonReBean result;
        switch (FinanceOrgEnum.getByCode(request.getFinanceOrg())) {
            case FUBANG: {
                result = this.callFuBangTFinanInStr(request, tenantCode);
                break;
            }
            case HUIYIN: {
                result = this.huiYinFinancialCalculation(request);
                break;
            }
            default: {
                result = new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u80fd\u8bc6\u522b\u91d1\u878d\u673a\u6784\u7f16\u7801!");
            }
        }
        return result;
    }

    public HtmlJsonReBean callFuBangTFinanInStr(QueryTFinanInStrRequest request, String tenantCode) {
        if (!request.checkRequire()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5b58\u5728\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a!");
        }
        request.setChannelID(CHANNEL_ID);
        JSONObject jsonBody = JSONObject.parseObject((String)JSON.toJSONString((Object)request));
        String ddFlagCode = FinancialInstitutionEnum.FUBANG_TFINANINSTR.getCode();
        String url = this.getDdFlag(tenantCode, ddFlagCode, DDFLAGTYPE) + FinancialInstitutionEnum.FUBANG_TFINANINSTR.getRequestUrl();
        if (jsonBody.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a!");
        }
        log.info("======callFuBangCityShopFinMQry=======  jsonBody={},url={},tenantCode={}", new Object[]{jsonBody, url, tenantCode});
        String result = SendFuBon.sendFuBon(jsonBody, url, tenantCode);
        log.info("======callFuBangCityShopFinMQry=======  result={}", (Object)result);
        if (StringUtils.isBlank((String)result)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u4e3a\u7a7a!");
        }
        JSONObject json = JSONObject.parseObject((String)result);
        String message = "";
        QueryTFinanInStrResponse data = null;
        if (json.containsKey((Object)"code")) {
            if (!"000000".equals(json.getString("code"))) {
                message = json.containsKey((Object)"message") ? json.getString("message") : "\u67e5\u8be2\u5931\u8d25!";
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, message);
            }
            data = (QueryTFinanInStrResponse)JSONObject.parseObject((String)json.getString("data"), QueryTFinanInStrResponse.class);
        }
        return new HtmlJsonReBean(data);
    }

    public HtmlJsonReBean huiYinFinancialCalculation(QueryTFinanInStrRequest request) {
        if (!FinanceOrgEnum.HUIYIN.getCode().equals(request.getFinanceOrg())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u80fd\u8bc6\u522b\u91d1\u878d\u673a\u6784\u7f16\u7801!");
        }
        if (!request.checkRequire()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u6c42\u53c2\u6570\u5b58\u5728\u7a7a\u503c!");
        }
        QueryTFinanInStrResponse data = new QueryTFinanInStrResponse();
        try {
            BigDecimal carBuyAmt = new BigDecimal(request.getCarBuyAmt());
            BigDecimal dPayRatio = new BigDecimal(request.getDpayRatio());
            BigDecimal stageNumber = new BigDecimal(request.getStageNumber());
            Integer stageNumberInt = Integer.parseInt(stageNumber.toString());
            BigDecimal custRate = new BigDecimal(request.getCustRate());
            BigDecimal monthRate = custRate.divide(new BigDecimal(12), 10, RoundingMode.CEILING);
            BigDecimal dpayAmt = carBuyAmt.multiply(dPayRatio).setScale(2, RoundingMode.CEILING);
            BigDecimal perTotalAmt = carBuyAmt.subtract(dpayAmt).setScale(2, RoundingMode.CEILING);
            BigDecimal perRepayAmt = perTotalAmt.divide(stageNumber, 2, RoundingMode.CEILING);
            BigDecimal monthRatePlus = monthRate.add(new BigDecimal(1));
            BigDecimal molecule = perTotalAmt.multiply(monthRate).multiply(monthRatePlus.pow(stageNumberInt));
            BigDecimal denominator = monthRatePlus.pow(stageNumberInt);
            BigDecimal monthlyPaymentAmount = molecule.divide(denominator, 2, RoundingMode.CEILING);
            BigDecimal totalInterestA = monthlyPaymentAmount.multiply(stageNumber);
            BigDecimal totalInterest = totalInterestA.subtract(perTotalAmt);
            BigDecimal perIRRA = monthlyPaymentAmount.multiply(stageNumber);
            BigDecimal perIRRB = perIRRA.subtract(perTotalAmt);
            BigDecimal perIRR = perIRRB.divide(perTotalAmt, 2, RoundingMode.CEILING);
            data.setReturnCode("000000");
            data.setReturnMsg("\u8ba1\u7b97\u6210\u529f!");
            data.setDpayAmt(dpayAmt.setScale(2, RoundingMode.CEILING).toString());
            data.setPerIRR(perIRR.toString());
            data.setPerTotalAmt(perTotalAmt.setScale(2, RoundingMode.CEILING).toString());
            data.setTotalStageFeeAmt(totalInterest.setScale(2, RoundingMode.CEILING).toString());
            data.setPerRepayAmt(perRepayAmt.setScale(2, RoundingMode.CEILING).toString());
        }
        catch (Exception e) {
            log.error("QueryFinancialProductsUtils.huiYinFinancialCalculation \u91d1\u878d\u8ba1\u7b97\u5f02\u5e38!");
            e.printStackTrace();
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u91d1\u878d\u8ba1\u7b97\u9519\u8bef!");
        }
        return new HtmlJsonReBean((Object)data);
    }

    private String getDdFlag(String tenantCode, String ddFlagCode, String ddFlagType) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)ddFlagCode) || StringUtils.isBlank((String)ddFlagType)) {
            log.error("order.QueryFinancialProductsUtils.getDdFlag: params is null!!! tenantCode:{},ddFlagCode:{},ddFlagType:{}", new Object[]{tenantCode, ddFlagCode, ddFlagType});
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tenantCode).append("-").append(ddFlagType).append("-").append(ddFlagCode);
        String ddFlagKey = stringBuilder.toString();
        log.info("order.QueryFinancialProductsUtils.getDdFlag: ddFlagKey is ********** {}", (Object)ddFlagKey);
        String ddFlagValue = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ddFlagKey);
        log.info("order.QueryFinancialProductsUtils.getDdFlag: ddFlagValue is ********** {}", (Object)ddFlagValue);
        return ddFlagValue;
    }

    private static String getHuiYinToken() {
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            String apiUrl = "http://icar.cheryfs.cn:16003/getToken";
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("secert", "aWNhcl90ZXN0X3VzZXJfMDAx");
            String post = JSONObject.toJSONString(postData);
            HttpPost httpPost = new HttpPost(apiUrl);
            StringEntity stringEntity = new StringEntity(post, "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.addHeader("Content-Type", "application/json;charset=utf-8");
            log.info("=================================================" + httpPost + "================================================");
            CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = execute.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            log.info(result + "==========================================================================");
            Map resultMap = (Map)JSON.parse((String)result);
            if (resultMap.containsKey("code")) {
                if ("0".equals(resultMap.get("code"))) {
                    if (resultMap.containsKey("data")) {
                        log.info("=======================" + resultMap.get("data") + "===================================================");
                        Map dataMap = (Map)resultMap.get("data");
                        String huiYinToken = String.valueOf(dataMap.get("token"));
                        return huiYinToken;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDestinationFromDdFlag(String financialOrgCode, String mappingKey, String source, String tenantCode) {
        String destination;
        block7: {
            destination = null;
            String ddFlagType = "financialMapping";
            String sourceKey = "source";
            String destinationKey = "destination";
            String ddFlagValue = new QueryFinancialProductsUtils().getDdFlag(tenantCode, financialOrgCode, ddFlagType);
            log.info("\u4eceddFlag\u7684\u91d1\u878d\u673a\u6784\u6570\u636e\u6620\u5c04\u5173\u7cfb\u6570\u636e\u4e2d\u83b7\u53d6\u4e09\u65b9\u673a\u6784\u9700\u8981\u7684\u7f16\u7801 getDestinationFromDdFlag ddFlagValue:{}", (Object)ddFlagValue);
            if (StringUtils.isNotBlank((String)ddFlagValue)) {
                try {
                    JSONObject json = JSONObject.parseObject((String)ddFlagValue);
                    if (json.containsKey((Object)mappingKey)) {
                        List jsonArray = JSONObject.parseArray((String)json.getString(mappingKey), JSONObject.class);
                        if (CollectionUtils.isEmpty((Collection)jsonArray)) break block7;
                        log.info("getDestinationFromDdFlag.mappingKey:{} jsonArray \u4e0d\u4e3a\u7a7a! ", (Object)mappingKey);
                        for (JSONObject jsonObject : jsonArray) {
                            if (!source.equals(jsonObject.getString(sourceKey))) continue;
                            log.info("\u6bd4\u8f83source\u6210\u529f!");
                            destination = jsonObject.getString(destinationKey);
                            log.info("getDestinationFromDdFlag.ing.destination={}", (Object)destination);
                            break block7;
                        }
                        break block7;
                    }
                    log.error("============= ddFlagValue\u4e2d\u4e0d\u80fd\u83b7\u53d6 " + mappingKey + "  \u6570\u636e =========,");
                }
                catch (Exception e) {
                    log.error("\u8f6c\u6362\u91d1\u878d\u6620\u5c04\u6570\u636e\u9519\u8bef!");
                    throw new Exception("getDestinationFromDdFlag \u5339\u914d\u6570\u636e\u5b57\u5178\u9519\u8bef");
                }
            }
        }
        log.info("getDestinationFromDdFlag.end.destination={}", destination);
        return destination;
    }
}

