/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubDomain;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractSubReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractSubServiceRepository;
import com.qjsoft.laser.controller.facade.oc.repository.OcShoppingServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/oc/contractSub"}, name="\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
public class ContractSubCon
extends SpringmvcController {
    private static String CODE = "oc.contractSub.con";
    @Autowired
    private OcContractServiceRepository ocContractServiceRepository;
    @Autowired
    private OcContractSubServiceRepository ocContractSubServiceRepository;
    @Autowired
    private OcShoppingServiceRepository ocShoppingServiceRepository;

    protected String getContext() {
        return "contractSub";
    }

    @RequestMapping(value={"addContractSub.json"}, name="\u65b0\u589e\u4ed8\u6b3e\u91d1\u989d")
    @ResponseBody
    public HtmlJsonReBean addContractSub(HttpServletRequest request, String contractBillcode, BigDecimal contractSubGmoney) {
        this.logger.info("=================================   addContractSub  =======================================================");
        long start = System.nanoTime();
        if (StringUtils.isBlank((String)contractBillcode) || null == contractSubGmoney) {
            this.logger.error(CODE + ".addContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", this.getTenantCode(request));
        OcContractReDomain ocContractReDomain = this.ocContractServiceRepository.getContractByCode(map);
        if (null == ocContractReDomain) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("ocContractReDomain is null : " + ((Object)map).toString()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("userSession: " + ((Object)map).toString()));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u672a\u767b\u9646");
        }
        String userPcode = userSession.getUserPcode();
        if (!userPcode.equals(ocContractReDomain.getMemberBcode())) {
            this.logger.error(CODE + ".addContractSub.ocContractReDomain", (Object)("userPcode: " + userPcode));
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u65e0\u64cd\u4f5c\u6743\u9650");
        }
        OcContractSubDomain ocContractSubDomain = this.make(request, contractSubGmoney, ocContractReDomain);
        if (null == ocContractSubDomain) {
            this.logger.error(CODE + ".addContractSub.ocContractSubDomain", (Object)"ocContractSubDomain is null ");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String balancePayType = request.getParameter("balancePayType");
        this.logger.info("===========balancePayType===", (Object)balancePayType);
        HtmlJsonReBean ERRORCODE = this.getHtmlJsonReBean(balancePayType, contractSubGmoney, ocContractReDomain);
        if (ERRORCODE != null) {
            return ERRORCODE;
        }
        HtmlJsonReBean result = this.ocContractSubServiceRepository.saveContractSub(ocContractSubDomain);
        this.extracted(contractBillcode, map, ocContractReDomain, balancePayType, result);
        long end = (System.nanoTime() - start) / 1000000L;
        this.logger.info(" addContractSub\u63a5\u53e3\u82b1\u8d39\u65f6\u95f4 \uff1a " + end + " ms");
        this.logger.info(" \u8fd4\u56de\u7ed3\u679c \uff1a " + JSON.toJSONString((Object)result));
        this.logger.info("==============================================================================================================");
        return result;
    }

    private void extracted(String contractBillcode, Map<String, Object> map, OcContractReDomain ocContractReDomain, String balancePayType, HtmlJsonReBean result) {
        if (ocContractReDomain.getDataState() == 5 && result.isSuccess()) {
            OcContractReDomain contracts = this.ocContractServiceRepository.getContractOneByCode(map);
            String gname = contracts.getMemberGname();
            JSONObject json = JSONObject.parseObject((String)gname);
            if (StringUtils.isBlank((String)balancePayType)) {
                balancePayType = "1";
            }
            json.put("balancePayType", (Object)Integer.parseInt(balancePayType));
            OcContractDomain ocContractDomain = new OcContractDomain();
            try {
                ocContractDomain.setContractBillcode(contracts.getContractBillcode());
                ocContractDomain.setTenantCode(contracts.getTenantCode());
                ocContractDomain.setMemberGname(json.toJSONString());
                HtmlJsonReBean htmlJsonReBean = this.ocContractServiceRepository.updateContractByMemberGcode(contracts.getContractBillcode(), contracts.getTenantCode(), null, json.toJSONString());
                this.logger.info("=================\u5b50\u8ba2\u5355\u751f\u6210\u65f6  \u6dfb\u52a0\u5c3e\u6b3e\u652f\u4ed8\u65b9\u5f0f memberGname.balancePayType" + contractBillcode, (Object)htmlJsonReBean.isSuccess());
            }
            catch (Exception e) {
                this.logger.info("=================\u5b50\u8ba2\u5355\u751f\u6210\u65f6  \u6dfb\u52a0\u5c3e\u6b3e\u652f\u4ed8\u65b9\u5f0f balancePayType\u5931\u8d25" + contractBillcode);
                e.printStackTrace();
            }
        }
    }

    private HtmlJsonReBean getHtmlJsonReBean(String paymentType, BigDecimal contractSubGmoney, OcContractReDomain ocContractReDomain) {
        Integer dataState1 = ocContractReDomain.getDataState();
        if (1 == dataState1) {
            BigDecimal gmoney;
            BigDecimal earnest = ocContractReDomain.getContractEarnest();
            BigDecimal bigDecimal = gmoney = ocContractReDomain.getContractPaygmoney() == null ? new BigDecimal(0) : ocContractReDomain.getContractPaygmoney();
            if (earnest.subtract(gmoney).compareTo(contractSubGmoney) != 0) {
                this.logger.error("=============\u4f20\u5165\u91d1\u989d\u4e8e\u8ba1\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4======");
                this.logger.error("=============\u8ba1\u7b97\u89c4\u5219=\u9500\u552e\u4ef7-\u62b5\u6263=====ContractEarnest:" + earnest + "=======ContractPaygmoney:" + gmoney);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f20\u5165\u91d1\u989d\u4e8e\u8ba1\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4");
            }
        } else {
            BigDecimal bmoney = ocContractReDomain.getDataBmoney();
            BigDecimal paymoney = ocContractReDomain.getContractPaymoney() == null ? new BigDecimal(0) : ocContractReDomain.getContractPaymoney();
            BigDecimal paygmoney = ocContractReDomain.getContractPaygmoney() == null ? new BigDecimal(0) : ocContractReDomain.getContractPaygmoney();
            String dataStatestr = ocContractReDomain.getDataStatestr();
            if (StringUtils.isBlank((String)paymentType) || StringUtils.isNotBlank((String)paymentType) && "1".equals(paymentType)) {
                if (bmoney.subtract(paygmoney).compareTo(contractSubGmoney) != 0) {
                    this.logger.error("=============\u5168\u6b3e\u652f\u4ed8,\u4f20\u5165\u91d1\u989d\u4e8e\u8ba1\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4======");
                    this.logger.error("=============\u8ba1\u7b97\u89c4\u5219=DATA_BMONEY - CONTRACT_PAYMONEY - CONTRACT_PAYGMONEY========+DATA_BMONEY:" + bmoney + "==CONTRACT_PAYGMONEY" + paygmoney + "=====\u4f20\u5165\u91d1\u989d:" + contractSubGmoney);
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f20\u5165\u91d1\u989d\u4e8e\u8ba1\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4");
                }
            } else if (bmoney.subtract(paymoney).subtract(paygmoney).compareTo(contractSubGmoney) != 0) {
                this.logger.error("===========\u5c3e\u6b3e\u652f\u4ed8==\u4f20\u5165\u91d1\u989d\u4e8e\u8ba1\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4======");
                this.logger.error("=============\u8ba1\u7b97\u89c4\u5219=DATA_BMONEY - CONTRACT_PAYMONEY - CONTRACT_PAYGMONEY========+DATA_BMONEY:" + bmoney + "===CONTRACT_PAYMONEY:" + paymoney + "==CONTRACT_PAYGMONEY" + paygmoney + "=====\u4f20\u5165\u91d1\u989d:" + contractSubGmoney);
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f20\u5165\u91d1\u989d\u4e8e\u8ba1\u7b97\u91d1\u989d\u4e0d\u4e00\u81f4");
            }
        }
        return null;
    }

    private OcContractSubDomain make(HttpServletRequest request, BigDecimal contractSubGmoney, OcContractReDomain ocContractReDomain) {
        if (null == ocContractReDomain || null == request) {
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        OcContractSubDomain ocContractSubDomain = new OcContractSubDomain();
        ocContractSubDomain.setContractBillcode(ocContractReDomain.getContractBillcode());
        ocContractSubDomain.setContractSubGmoney(contractSubGmoney);
        ocContractSubDomain.setContractSubPmode("0");
        ocContractSubDomain.setContractSubPmoney(contractSubGmoney);
        ocContractSubDomain.setMemberCode(ocContractReDomain.getMemberCode());
        ocContractSubDomain.setMemberName(ocContractReDomain.getMemberName());
        ocContractSubDomain.setMemberCcode(ocContractReDomain.getMemberCcode());
        ocContractSubDomain.setMemberCname(ocContractReDomain.getMemberCname());
        ocContractSubDomain.setMemberBcode(userSession.getUserPcode());
        ocContractSubDomain.setMemberBname(userSession.getMerberCompname());
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        return ocContractSubDomain;
    }

    @RequestMapping(value={"saveContractSub.json"}, name="\u589e\u52a0\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveContractSub(HttpServletRequest request, OcContractSubDomain ocContractSubDomain) {
        if (null == ocContractSubDomain) {
            this.logger.error(CODE + ".saveContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractSubServiceRepository.saveContractSub(ocContractSubDomain);
    }

    @RequestMapping(value={"getContractSub.json"}, name="\u83b7\u53d6\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public OcContractSubReDomain getContractSub(Integer contractSubId) {
        if (StringUtils.isBlank((Integer)contractSubId)) {
            this.logger.error(CODE + ".getContractSub", (Object)"param is null");
            return null;
        }
        return this.ocContractSubServiceRepository.getContractSub(contractSubId);
    }

    @RequestMapping(value={"updateContractSub.json"}, name="\u66f4\u65b0\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateContractSub(HttpServletRequest request, OcContractSubDomain ocContractSubDomain) {
        if (null == ocContractSubDomain) {
            this.logger.error(CODE + ".updateContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        ocContractSubDomain.setTenantCode(this.getTenantCode(request));
        return this.ocContractSubServiceRepository.updateContractSub(ocContractSubDomain);
    }

    @RequestMapping(value={"deleteContractSub.json"}, name="\u5220\u9664\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteContractSub(Integer contractSubId) {
        if (StringUtils.isBlank((Integer)contractSubId)) {
            this.logger.error(CODE + ".deleteContractSub", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractSubServiceRepository.deleteContractSub(contractSubId);
    }

    @RequestMapping(value={"queryContractSubPage.json"}, name="\u67e5\u8be2\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<OcContractSubReDomain> queryContractSubPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.ocContractSubServiceRepository.queryContractSubPage(param);
    }

    @RequestMapping(value={"updateContractSubState.json"}, name="\u66f4\u65b0\u591a\u6b21\u4ed8\u6b3e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateContractSubState(String contractSubId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)contractSubId)) {
            this.logger.error(CODE + ".updateContractSubState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.ocContractSubServiceRepository.updateContractSubState(Integer.valueOf(contractSubId), dataState, oldDataState, null);
    }
}

