/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.order.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.oc.domain.OcContractReDomain;
import com.qjsoft.laser.controller.facade.oc.repository.OcContractServiceRepository;
import com.qjsoft.laser.controller.order.constants.FinanceOrgEnum;
import com.qjsoft.laser.controller.order.constants.FinancialInstitutionEnum;
import com.qjsoft.laser.controller.order.constants.FinancialMappingEnum;
import com.qjsoft.laser.controller.order.constants.RepaymentMethodEnum;
import com.qjsoft.laser.controller.order.controller.QueryFinancialConvert;
import com.qjsoft.laser.controller.order.controller.RestUtil;
import com.qjsoft.laser.controller.order.request.QueryBurPointCardRequest;
import com.qjsoft.laser.controller.order.request.QueryCityShopFinMQryRequest;
import com.qjsoft.laser.controller.order.request.QueryFinancialProductsRequest;
import com.qjsoft.laser.controller.order.request.QueryTFinanInStrRequest;
import com.qjsoft.laser.controller.order.request.ThirdOrderCardRequest;
import com.qjsoft.laser.controller.order.response.FinancialProductsResponse;
import com.qjsoft.laser.controller.order.response.QueryAppStatusResponse;
import com.qjsoft.laser.controller.order.response.QueryFinancialProductsResponse;
import com.qjsoft.laser.controller.order.response.QueryTFinanInStrResponse;
import com.qjsoft.laser.controller.order.utils.CommonUtils;
import com.qjsoft.laser.controller.order.utils.fubon.SendFuBon;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class QueryFinancialProductsUtils {
    private static final Logger log = LoggerFactory.getLogger(QueryFinancialProductsUtils.class);
    @Autowired
    private QueryFinancialConvert convert;
    @Autowired
    private RestUtil restUtil;
    private RestTemplate restTemplate = new RestTemplate();
    private static String CODE = "Contract.QueryFinancialProductsUtils";
    public static final String DDFLAGTYPE = "financialInstitution";
    private static final String CHANNEL_ID = "QRXYK";

    public QueryFinancialProductsResponse<FinancialProductsResponse> callThirdPartyInterface(QueryFinancialProductsRequest request, String tenantCode) {
        QueryFinancialProductsResponse<FinancialProductsResponse> response = null;
        if (StringUtils.isBlank((String)request.getFinanceOrg())) {
            log.error("\u91d1\u878d\u673a\u6784\u8bc6\u522b\u7801\u5165\u53c2\u4e3a\u7a7a!");
            response = new QueryFinancialProductsResponse<FinancialProductsResponse>();
            response.fail("\u8bf7\u8bbe\u7f6e\u67e5\u8be2\u91d1\u878d\u7ed3\u6784!");
            return response;
        }
        switch (FinanceOrgEnum.getByCode(request.getFinanceOrg())) {
            case HUIYIN: {
                response = this.callHuiYin(request, tenantCode);
                break;
            }
            case FUBANG: {
                response = this.callFuBang(tenantCode);
                break;
            }
            default: {
                response = new QueryFinancialProductsResponse<FinancialProductsResponse>("-1", "\u672a\u5339\u914d\u5230\u91d1\u878d\u673a\u6784!");
            }
        }
        if (ListUtil.isNotEmpty(response.getProductList())) {
            response.setProductList(this.conversionRadio(response.getProductList(), request.getTotalAmount()));
        }
        if (ListUtil.isNotEmpty(response.getBzProductList())) {
            response.setBzProductList(this.conversionRadio(response.getBzProductList(), request.getTotalAmount()));
        }
        if (ListUtil.isNotEmpty(response.getTxProductList())) {
            response.setTxProductList(this.conversionRadio(response.getTxProductList(), request.getTotalAmount()));
        }
        return response;
    }

    public QueryFinancialProductsResponse callHuiYin(QueryFinancialProductsRequest request, String tenantCode) {
        HashMap<String, Object> iCarMap = new HashMap<String, Object>();
        iCarMap.put("icarStyleCode", request.getIcarStyleCode());
        iCarMap.put("iCarStatus", "4");
        iCarMap.put("icarOrderNo", request.getiCarOrderNo());
        log.info("\u5f00\u59cb\u67e5\u8be2\u5fbd\u94f6\u91d1\u878d\u4ea7\u54c1\u7684\u53c2\u6570\uff1a" + iCarMap + "code:" + CODE);
        Map<String, Object> result = this.callHuiYinQueryAppResult(iCarMap);
        if (null == result) {
            QueryFinancialProductsResponse queryFinancialProductsResponse = new QueryFinancialProductsResponse();
            queryFinancialProductsResponse.fail("\u672a\u83b7\u53d6\u5230\u91d1\u878d\u4ea7\u54c1\u5217\u8868\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\u53c2\u6570\uff01");
            return queryFinancialProductsResponse;
        }
        result.put("totalAmount", request.getTotalAmount());
        return this.convert.convertHy(result);
    }

    public boolean cancelHYloanOrder(String iCardOrderNo) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("icarOrderNo", iCardOrderNo);
        queryMap.put("iCarStatus", "5");
        Map<String, Object> result = this.callHuiYinQueryAppResult(queryMap);
        String resultFlag = (String)result.get("code");
        return resultFlag != null && resultFlag.equals("0");
    }

    public Map<String, Object> queryHYApproveStatus(String iCarOrderNo) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("icarOrderNo", iCarOrderNo);
        queryMap.put("iCarStatus", "1");
        return this.callHuiYinQueryAppResult(queryMap);
    }

    public Map<String, Object> passCheckList(String iCarOrderNo, String deliveryCheckListUrl) {
        HashMap<String, Object> passMap = new HashMap<String, Object>();
        passMap.put("icarOrderNo", iCarOrderNo);
        passMap.put("deliveryCheckListUrl", deliveryCheckListUrl);
        passMap.put("iCarStatus", "2");
        return this.callHuiYinQueryAppResult(passMap);
    }

    public Map<String, Object> passVin(String iCarOrderNo, String vin) {
        HashMap<String, Object> passMap = new HashMap<String, Object>();
        passMap.put("icarOrderNo", iCarOrderNo);
        passMap.put("iCarStatus", "3");
        passMap.put("frameNumber", vin);
        return this.callHuiYinQueryAppResult(passMap);
    }

    public QueryFinancialProductsResponse<FinancialProductsResponse> callFuBang(String tenantCode) {
        String ddFlagCode = "fubang_financeData";
        String financeData = this.getDdFlag(tenantCode, ddFlagCode, DDFLAGTYPE);
        QueryFinancialProductsResponse<FinancialProductsResponse> response = new QueryFinancialProductsResponse<FinancialProductsResponse>();
        if (StringUtils.isBlank((String)financeData)) {
            log.error("================" + CODE + "=====================\u67e5\u8be2\u5bcc\u90a6\u91d1\u878d\u4ea7\u54c1\u6570\u636e\u4e3a\u7a7a!");
            response.fail("\u67e5\u8be2\u5bcc\u90a6\u91d1\u878d\u6570\u636e\u4e3a\u7a7a!");
            return response;
        }
        List result = JSON.parseArray((String)financeData, FinancialProductsResponse.class);
        if (CollectionUtils.isEmpty((Collection)result)) {
            log.error("================" + CODE + "=====================\u5bcc\u90a6\u91d1\u878d\u4ea7\u54c1\u6570\u636e\u8f6c\u6362\u4e3a\u7a7a!");
            response.fail("\u83b7\u53d6\u5bcc\u90a6\u91d1\u878d\u4ea7\u54c1\u6570\u636e\u4e3a\u7a7a!");
            return response;
        }
        response.success("\u64cd\u4f5c\u6210\u529f!");
        response.setProductList(result);
        return response;
    }

    public QueryAppStatusResponse callFuBangQueryAppStatus(String tenantCode, String idCard) {
        String ddFlagCode = FinancialInstitutionEnum.FUBANG_APPLYQRYCARD.getCode();
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("channelID", (Object)CHANNEL_ID);
        jsonBody.put("idcard", (Object)idCard);
        String url = this.getDdFlag(tenantCode, ddFlagCode, DDFLAGTYPE) + FinancialInstitutionEnum.FUBANG_APPLYQRYCARD.getRequestUrl();
        QueryAppStatusResponse response = null;
        try {
            log.info("======callFuBangQueryAppStatus=======  jsonBody={},url={},tenantCode={}", new Object[]{jsonBody, url, tenantCode});
            String result = SendFuBon.sendFuBon(jsonBody, url, tenantCode);
            log.info("======callFuBangQueryAppStatus=======  result={}", (Object)result);
            if (StringUtils.isNotBlank((String)result)) {
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                if (jsonObject.containsKey((Object)"code") && "000000".equals(jsonObject.getString("code"))) {
                    response = jsonObject.containsKey((Object)"data") ? this.convert.convertFuBonAppStatus(jsonObject.getString("data")) : new QueryAppStatusResponse("-1", "\u5bcc\u90a6\u7533\u8bf7\u72b6\u6001\u67e5\u8be2\u4e3a\u7a7a!!");
                } else {
                    String message = "";
                    message = jsonObject.containsKey((Object)"message") ? jsonObject.getString("message") : "\u5bcc\u90a6\u7533\u8bf7\u72b6\u6001\u67e5\u8be2\u5931\u8d25!";
                    response = new QueryAppStatusResponse("-1", message);
                }
            } else {
                response = new QueryAppStatusResponse("-1", "\u5bcc\u90a6\u7533\u8bf7\u72b6\u6001\u67e5\u8be2\u4e3a\u7a7a!");
            }
        }
        catch (IOException e) {
            log.error("QueryFinancialProductsUtils.callFuBangQueryAppStatus \u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38 A!");
            response = new QueryAppStatusResponse("-1", "\u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38");
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("QueryFinancialProductsUtils.callFuBangQueryAppStatus \u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38 B!");
            response = new QueryAppStatusResponse("-1", "\u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38");
            e.printStackTrace();
        }
        return response;
    }

    public HtmlJsonReBean callFuBangBurPointCard(QueryBurPointCardRequest request, String tenantCode) {
        if (FinanceOrgEnum.FUBANG.equals((Object)FinanceOrgEnum.getByCode(request.getFinanceOrg()))) {
            request.setChannelID(CHANNEL_ID);
            if (!request.checkRequire()) {
                log.error("QueryFinancialProductsUtils.burPointCard \u8c03\u7528\u5bcc\u90a6\u9884\u5ba1\u6570\u636e\u91c7\u96c6 \u5fc5\u586b\u5165\u53c2\u5b58\u5728\u7a7a\u503c!");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8ba2\u5355\u6570\u636e\u4e0d\u5168!");
            }
            try {
                JSONObject json;
                String ddFlagCode = FinancialInstitutionEnum.FUBANG_BURPOINTCARD.getCode();
                String url = this.getDdFlag(tenantCode, ddFlagCode, DDFLAGTYPE) + FinancialInstitutionEnum.FUBANG_BURPOINTCARD.getRequestUrl();
                String carType = QueryFinancialProductsUtils.getDestinationFromDdFlag(FinanceOrgEnum.FUBANG.getCode(), FinancialMappingEnum.MODEL.getKey(), request.getQr_car_type(), tenantCode);
                String carColor = QueryFinancialProductsUtils.getDestinationFromDdFlag(FinanceOrgEnum.FUBANG.getCode(), FinancialMappingEnum.COLOR.getKey(), request.getQr_car_color(), tenantCode);
                if (StringUtils.isBlank((String)carType)) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8f66\u578b\u4e0d\u80fd\u5339\u914d\u6570\u636e\u5b57\u5178!");
                }
                if (StringUtils.isBlank((String)carColor)) {
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8f66\u8eab\u989c\u8272\u4e0d\u80fd\u5339\u914d\u6570\u636e\u5b57\u5178!");
                }
                request.setQr_car_color(carColor);
                request.setQr_car_type(carType);
                JSONObject jsonBody = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
                if (jsonBody.containsKey((Object)"financeOrg")) {
                    jsonBody.remove((Object)"financeOrg");
                }
                if (jsonBody.containsKey((Object)"contractBillcode")) {
                    jsonBody.remove((Object)"contractBillcode");
                }
                log.info("======callFuBangBurPointCard=======  jsonBody={},url={},tenantCode={}", new Object[]{jsonBody, url, tenantCode});
                String result = SendFuBon.sendFuBon(jsonBody, url, tenantCode);
                log.info("======callFuBangBurPointCard=======  result={}", (Object)result);
                if (StringUtils.isNotBlank((String)result) && null != (json = JSONObject.parseObject((String)result))) {
                    if (json.containsKey((Object)"code") && "000000".equals(json.getString("code"))) {
                        if (json.containsKey((Object)"data")) {
                            return new HtmlJsonReBean((Object)JSONObject.parseObject((String)json.getString("data")));
                        }
                        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5bcc\u90a6\u9884\u5ba1\u6570\u636e\u91c7\u96c6\u5931\u8d25!!");
                    }
                    String message = "";
                    message = json.containsKey((Object)"message") ? json.getString("message") : "\u5bcc\u90a6\u9884\u5ba1\u6570\u636e\u91c7\u96c6\u5931\u8d25!";
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, message);
                }
            }
            catch (Exception e) {
                log.error("QueryFinancialProductsUtils.callFuBangBurPointCard \u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38!======error:{}", (Object)e.getMessage());
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8c03\u7528\u5bcc\u90a6\u63a5\u53e3\u5f02\u5e38!");
            }
        }
        return new HtmlJsonReBean();
    }

    private Map<String, Object> callHuiYinQueryAppResult(Map<String, Object> iCarMap) {
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            String huiYinToken = this.getHuiYinToken(String.valueOf(iCarMap.get("icarOrderNo")));
            String apiKey = "";
            if (!iCarMap.containsKey("iCarStatus")) {
                return new HashMap<String, Object>();
            }
            String iCarStatus = String.valueOf(iCarMap.get("iCarStatus"));
            iCarMap.remove("iCarStatus");
            if ("1".equals(iCarStatus)) {
                apiKey = "huiyin2";
            } else if ("2".equals(iCarStatus) || "3".equals(iCarStatus)) {
                apiKey = "huiyin3";
            } else if ("4".equals(iCarStatus)) {
                apiKey = "huiyin4";
                iCarMap.remove("icarOrderNo");
            } else if ("5".equals(iCarStatus)) {
                apiKey = "huiyin5";
            }
            String apiUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)QueryFinancialProductsUtils.getHyDDFlag(apiKey));
            String post = JSONObject.toJSONString(iCarMap);
            HttpPost httpPost = new HttpPost(apiUrl);
            StringEntity stringEntity = new StringEntity(post, "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.addHeader("token", huiYinToken);
            httpPost.addHeader("Content-Type", "application/json;charset=utf-8");
            log.info("=================================================" + httpPost + "================================================");
            CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = execute.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            log.info(result + "==========================================================================");
            Map resultMap = (Map)JSON.parse((String)result);
            if (resultMap.containsKey("code")) {
                if ("0".equals(resultMap.get("code"))) {
                    return resultMap;
                }
                return new HashMap<String, Object>();
            }
            return new HashMap<String, Object>();
        }
        catch (Exception e) {
            log.error("--  \u8c03\u7528\u5fbd\u94f6\u63a5\u53e3\u5f02\u5e38  --", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    public static String getHyDDFlag(String ddFlagType) {
        return "2020121500000001".concat("-").concat(DDFLAGTYPE).concat("-").concat(ddFlagType);
    }

    public HtmlJsonReBean callFuBangCityShopFinMQry(QueryCityShopFinMQryRequest request, String tenantCode) {
        if (request.checkFinanceOrgIsNull()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u8bbe\u7f6e\u91d1\u878d\u673a\u6784!");
        }
        if (!request.checkRequire()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5b58\u5728\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a!");
        }
        request.setChannelID(CHANNEL_ID);
        String ddFlagCode = FinancialInstitutionEnum.FUBANG_CITYSHOPFINMQRY.getCode();
        String url = this.getDdFlag(tenantCode, ddFlagCode, DDFLAGTYPE) + FinancialInstitutionEnum.FUBANG_CITYSHOPFINMQRY.getRequestUrl();
        JSONObject jsonBody = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
        if (jsonBody.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (jsonBody.containsKey((Object)"financeOrg")) {
            jsonBody.remove((Object)"financeOrg");
        }
        log.info("======callFuBangCityShopFinMQry=======  jsonBody={},url={},tenantCode={}", new Object[]{jsonBody, url, tenantCode});
        String result = SendFuBon.sendFuBon(jsonBody, url, tenantCode);
        log.info("======callFuBangCityShopFinMQry=======  result={}", (Object)result);
        if (StringUtils.isBlank((String)result)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u4e3a\u7a7a!");
        }
        JSONObject json = JSONObject.parseObject((String)result);
        String message = "";
        JSONObject data = null;
        if (json.containsKey((Object)"code")) {
            if (!"000000".equals(json.getString("code"))) {
                message = json.containsKey((Object)"message") ? json.getString("message") : "\u67e5\u8be2\u5931\u8d25!";
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, message);
            }
            data = JSONObject.parseObject((String)json.getString("data"));
        }
        return new HtmlJsonReBean(data);
    }

    public HtmlJsonReBean financialCalculation(QueryTFinanInStrRequest request, String tenantCode) {
        HtmlJsonReBean result;
        if (null == FinanceOrgEnum.getByCode(request.getFinanceOrg())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u80fd\u8bc6\u522b\u91d1\u878d\u673a\u6784\u7f16\u7801\uff01");
        }
        switch (FinanceOrgEnum.getByCode(request.getFinanceOrg())) {
            case FUBANG: {
                result = this.callFuBangTFinanInStr(request, tenantCode);
                break;
            }
            case HUIYIN: {
                result = this.huiYinFinancialCalculation(request);
                break;
            }
            default: {
                result = new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u80fd\u8bc6\u522b\u91d1\u878d\u673a\u6784\u7f16\u7801!");
            }
        }
        return result;
    }

    public HtmlJsonReBean callFuBangTFinanInStr(QueryTFinanInStrRequest request, String tenantCode) {
        if (!request.checkRequire()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5b58\u5728\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a!");
        }
        request.setChannelID(CHANNEL_ID);
        JSONObject jsonBody = JSONObject.parseObject((String)JSON.toJSONString((Object)request));
        String ddFlagCode = FinancialInstitutionEnum.FUBANG_TFINANINSTR.getCode();
        String url = this.getDdFlag(tenantCode, ddFlagCode, DDFLAGTYPE) + FinancialInstitutionEnum.FUBANG_TFINANINSTR.getRequestUrl();
        if (jsonBody.isEmpty()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a!");
        }
        log.info("======callFuBangCityShopFinMQry=======  jsonBody={},url={},tenantCode={}", new Object[]{jsonBody, url, tenantCode});
        String result = SendFuBon.sendFuBon(jsonBody, url, tenantCode);
        log.info("======callFuBangCityShopFinMQry=======  result={}", (Object)result);
        if (StringUtils.isBlank((String)result)) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u67e5\u8be2\u4e3a\u7a7a!");
        }
        JSONObject json = JSONObject.parseObject((String)result);
        String message = "";
        QueryTFinanInStrResponse data = null;
        if (json.containsKey((Object)"code")) {
            if (!"000000".equals(json.getString("code"))) {
                message = json.containsKey((Object)"message") ? json.getString("message") : "\u67e5\u8be2\u5931\u8d25!";
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, message);
            }
            data = (QueryTFinanInStrResponse)JSONObject.parseObject((String)json.getString("data"), QueryTFinanInStrResponse.class);
            if (StringUtils.isNotBlank((String)data.getPerRate())) {
                data.setPerRate(new BigDecimal(data.getPerRate()).multiply(new BigDecimal(100)).setScale(4, RoundingMode.CEILING).toString());
            }
        }
        return new HtmlJsonReBean(data);
    }

    public HtmlJsonReBean huiYinFinancialCalculation(QueryTFinanInStrRequest request) {
        if (!FinanceOrgEnum.HUIYIN.getCode().equals(request.getFinanceOrg())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4e0d\u80fd\u8bc6\u522b\u91d1\u878d\u673a\u6784\u7f16\u7801!");
        }
        if (!request.checkRequire()) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u6c42\u53c2\u6570\u5b58\u5728\u7a7a\u503c!");
        }
        if (StringUtils.isBlank((String)request.getCustRate())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5ba2\u6237\u8fd8\u6b3e\u5229\u7387\u4e3a\u7a7a!");
        }
        if (StringUtils.isBlank((String)request.getRepaymentMethod())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u9009\u62e9\u8fd8\u6b3e\u65b9\u5f0f!");
        }
        QueryTFinanInStrResponse data = new QueryTFinanInStrResponse();
        log.info("\u5fbd\u94f6\u91d1\u878d\u8ba1\u7b97 \u5165\u53c2==" + JSONObject.toJSONString((Object)request));
        try {
            BigDecimal carBuyAmt = new BigDecimal(request.getCarBuyAmt());
            BigDecimal dPayRatio = new BigDecimal(request.getDpayRatio());
            BigDecimal stageNumber = new BigDecimal(request.getStageNumber());
            Integer stageNumberInt = Integer.parseInt(stageNumber.toString());
            BigDecimal custRate = new BigDecimal(request.getCustRate()).divide(new BigDecimal(100), 16, RoundingMode.CEILING);
            log.info("A: carBuyAmt:" + carBuyAmt.toString() + " dPayRatio:" + dPayRatio.toString() + " stageNumber:" + stageNumber.toString() + " stageNumberInt:" + stageNumberInt + " custRate:" + custRate.toString());
            BigDecimal dpayAmt = carBuyAmt.multiply(dPayRatio).setScale(2, RoundingMode.CEILING);
            BigDecimal perTotalAmt = carBuyAmt.subtract(dpayAmt).setScale(2, RoundingMode.CEILING);
            BigDecimal perRepayAmt = perTotalAmt.divide(stageNumber, 2, RoundingMode.CEILING);
            log.info("B: dpayAmt:" + dpayAmt.toString() + " perTotalAmt:" + perTotalAmt.toString() + " perRepayAmt:" + perRepayAmt.toString());
            BigDecimal monthlyPaymentAmount = null;
            BigDecimal perIRR = null;
            BigDecimal totalInterest = null;
            BigDecimal monthRate = null;
            BigDecimal lastPeriodAmount = null;
            if (RepaymentMethodEnum.BZDK.getCode().equals(request.getRepaymentMethod())) {
                monthRate = custRate.divide(new BigDecimal(12), 10, RoundingMode.CEILING);
                BigDecimal monthRatePlus = monthRate.add(new BigDecimal(1));
                BigDecimal molecule = perTotalAmt.multiply(monthRate).multiply(monthRatePlus.pow(stageNumberInt));
                BigDecimal denominator = monthRatePlus.pow(stageNumberInt).subtract(new BigDecimal(1));
                monthlyPaymentAmount = molecule.divide(denominator, 2, RoundingMode.CEILING);
                BigDecimal perIRRA = monthlyPaymentAmount.multiply(stageNumber);
                BigDecimal perIRRB = perIRRA.subtract(perTotalAmt);
                perIRR = perIRRB.multiply(new BigDecimal(100)).divide(perTotalAmt, 6, RoundingMode.CEILING);
                BigDecimal totalInterestA = monthlyPaymentAmount.multiply(stageNumber);
                totalInterest = totalInterestA.subtract(perTotalAmt);
                log.info("bzdk C: monthRate:{},monthRatePlus:{},molecule:{},denominator:{},monthlyPaymentAmount:{},perIRRA:{},perIRRB:{},perIRR:{},totalInterestA:{},totalInterest:{}", new Object[]{monthRate, monthRatePlus, molecule, denominator, monthlyPaymentAmount, perIRRA, perIRRB, perIRR, totalInterestA, totalInterest});
            }
            if (RepaymentMethodEnum.TXDK.getCode().equals(request.getRepaymentMethod())) {
                monthlyPaymentAmount = perTotalAmt.multiply(custRate.divide(stageNumber, 10, RoundingMode.CEILING)).setScale(2, RoundingMode.CEILING);
                totalInterest = monthlyPaymentAmount.multiply(stageNumber).setScale(2, RoundingMode.CEILING);
                lastPeriodAmount = monthlyPaymentAmount.add(perTotalAmt).setScale(2, RoundingMode.CEILING);
                BigDecimal txMonthRate = totalInterest.divide(perTotalAmt.multiply(stageNumber), 16, RoundingMode.CEILING);
                perIRR = txMonthRate.multiply(new BigDecimal(100)).multiply(new BigDecimal(12)).setScale(6, RoundingMode.CEILING);
                data.setLastPeriodAmount(lastPeriodAmount.toString());
                log.info("txdk C: monthlyPaymentAmount:{},totalInterest:{},lastPeriodAmount:{},txMonthRate:{},perIRR:{}", new Object[]{monthlyPaymentAmount, totalInterest, lastPeriodAmount, txMonthRate, perIRR});
            }
            data.setReturnCode("000000");
            data.setReturnMsg("\u8ba1\u7b97\u6210\u529f!");
            data.setDpayAmt(dpayAmt.setScale(2, RoundingMode.CEILING).toString());
            data.setPerRate(perIRR.toString());
            data.setPerTotalAmt(perTotalAmt.setScale(2, RoundingMode.CEILING).toString());
            data.setTotalStageFeeAmt(totalInterest.setScale(2, RoundingMode.CEILING).toString());
            data.setPerRepayAmt(perRepayAmt.setScale(2, RoundingMode.CEILING).toString());
            data.setPerTotalStageAmt(monthlyPaymentAmount.setScale(2, RoundingMode.CEILING).toString());
        }
        catch (Exception e) {
            log.error("QueryFinancialProductsUtils.huiYinFinancialCalculation \u91d1\u878d\u8ba1\u7b97\u5f02\u5e38!");
            e.printStackTrace();
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u91d1\u878d\u8ba1\u7b97\u9519\u8bef!");
        }
        return new HtmlJsonReBean((Object)data);
    }

    private String getDdFlag(String tenantCode, String ddFlagCode, String ddFlagType) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)ddFlagCode) || StringUtils.isBlank((String)ddFlagType)) {
            log.error("order.QueryFinancialProductsUtils.getDdFlag: params is null!!! tenantCode:{},ddFlagCode:{},ddFlagType:{}", new Object[]{tenantCode, ddFlagCode, ddFlagType});
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(tenantCode).append("-").append(ddFlagType).append("-").append(ddFlagCode);
        String ddFlagKey = stringBuilder.toString();
        log.info("order.QueryFinancialProductsUtils.getDdFlag: ddFlagKey is ********** {}", (Object)ddFlagKey);
        String ddFlagValue = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ddFlagKey);
        log.info("order.QueryFinancialProductsUtils.getDdFlag: ddFlagValue is ********** {}", (Object)ddFlagValue);
        return ddFlagValue;
    }

    public String getHuiYinToken(String iCarOrderNo) {
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            String token = "2020121500000001".concat("-").concat(DDFLAGTYPE).concat("-").concat("huiyin1");
            String apiUrl = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)token);
            HashMap<String, String> postData = new HashMap<String, String>();
            String secret = "2020121500000001".concat("-").concat("secretKey").concat("-").concat("huiyin_secretKey");
            String secretKey = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)secret);
            postData.put("secert", secretKey);
            postData.put("userCode", iCarOrderNo);
            String post = JSONObject.toJSONString(postData);
            HttpPost httpPost = new HttpPost(apiUrl);
            StringEntity stringEntity = new StringEntity(post, "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.addHeader("Content-Type", "application/json;charset=utf-8");
            log.info("=================================================" + httpPost + "================================================");
            CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = execute.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            log.info(result + "==========================================================================");
            Map resultMap = (Map)JSON.parse((String)result);
            if (resultMap.containsKey("code")) {
                if ("0".equals(resultMap.get("code"))) {
                    if (resultMap.containsKey("data")) {
                        log.info("=======================" + resultMap.get("data") + "===================================================");
                        Map dataMap = (Map)resultMap.get("data");
                        String huiYinToken = String.valueOf(dataMap.get("token"));
                        return huiYinToken;
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDestinationFromDdFlag(String financialOrgCode, String mappingKey, String source, String tenantCode) {
        String destination;
        block7: {
            destination = null;
            String ddFlagType = "financialMapping";
            String sourceKey = "source";
            String destinationKey = "destination";
            String ddFlagValue = new QueryFinancialProductsUtils().getDdFlag(tenantCode, financialOrgCode, ddFlagType);
            log.info("\u4eceddFlag\u7684\u91d1\u878d\u673a\u6784\u6570\u636e\u6620\u5c04\u5173\u7cfb\u6570\u636e\u4e2d\u83b7\u53d6\u4e09\u65b9\u673a\u6784\u9700\u8981\u7684\u7f16\u7801 getDestinationFromDdFlag ddFlagValue:{}", (Object)ddFlagValue);
            if (StringUtils.isNotBlank((String)ddFlagValue)) {
                try {
                    JSONObject json = JSONObject.parseObject((String)ddFlagValue);
                    if (json.containsKey((Object)mappingKey)) {
                        List jsonArray = JSONObject.parseArray((String)json.getString(mappingKey), JSONObject.class);
                        if (CollectionUtils.isEmpty((Collection)jsonArray)) break block7;
                        log.info("getDestinationFromDdFlag.mappingKey:{} jsonArray \u4e0d\u4e3a\u7a7a! ", (Object)mappingKey);
                        for (JSONObject jsonObject : jsonArray) {
                            if (!source.equals(jsonObject.getString(sourceKey))) continue;
                            log.info("\u6bd4\u8f83source\u6210\u529f!");
                            destination = jsonObject.getString(destinationKey);
                            log.info("getDestinationFromDdFlag.ing.destination={}", (Object)destination);
                            break block7;
                        }
                        break block7;
                    }
                    log.error("============= ddFlagValue\u4e2d\u4e0d\u80fd\u83b7\u53d6 " + mappingKey + "  \u6570\u636e =========,");
                }
                catch (Exception e) {
                    log.error("\u8f6c\u6362\u91d1\u878d\u6620\u5c04\u6570\u636e\u9519\u8bef!");
                    throw new Exception("getDestinationFromDdFlag \u5339\u914d\u6570\u636e\u5b57\u5178\u9519\u8bef");
                }
            }
        }
        log.info("getDestinationFromDdFlag.end.destination={}", destination);
        return destination;
    }

    private String calculatePaymentRadio(String totalAmount) {
        BigDecimal smallAmount = new BigDecimal("0.0025");
        BigDecimal totalAmountBig = new BigDecimal(totalAmount);
        BigDecimal middleAmount = totalAmountBig.subtract(smallAmount);
        BigDecimal maxPaymentRadio = middleAmount.divide(totalAmountBig, 2, 5);
        BigDecimal max = new BigDecimal("0.75");
        BigDecimal min = new BigDecimal("0.15");
        if (maxPaymentRadio.compareTo(max) == 1) {
            maxPaymentRadio = max;
        }
        if (maxPaymentRadio.compareTo(min) == -1) {
            maxPaymentRadio = min;
        }
        maxPaymentRadio = maxPaymentRadio.multiply(new BigDecimal("100"));
        return String.valueOf(maxPaymentRadio.intValue());
    }

    private String checkMinPaymentRadio(String minPaymentRadio) {
        BigDecimal min = new BigDecimal("15");
        BigDecimal minRadio = new BigDecimal(minPaymentRadio);
        if (min.compareTo(minRadio) == 1) {
            minRadio = min;
        }
        return String.valueOf(minRadio);
    }

    private List<FinancialProductsResponse> conversionRadio(List<FinancialProductsResponse> list, String totalAmount) {
        ArrayList<FinancialProductsResponse> financialProductsResponseList = new ArrayList<FinancialProductsResponse>();
        for (FinancialProductsResponse financialProductsResponse : list) {
            financialProductsResponse.setMaxPaymentRadio(this.calculatePaymentRadio(totalAmount));
            financialProductsResponse.setMinPaymentRadio(this.checkMinPaymentRadio(financialProductsResponse.getMinPaymentRadio()));
            financialProductsResponseList.add(financialProductsResponse);
        }
        return financialProductsResponseList;
    }

    public static HtmlJsonReBean thirdOrderCard(String contractBillcode, OcContractServiceRepository ocContractServiceRepository) {
        ThirdOrderCardRequest req;
        block10: {
            req = new ThirdOrderCardRequest();
            try {
                String financeOrg;
                JSONObject financialJson;
                JSONObject memberGnameJson;
                String memberGname;
                log.info("B\u7aef\u72b6\u6001\u901a\u77e5\u63a5\u53e3 QueryFinancialProductsUtils.thirdOrderCard:\u63a8\u9001\u5bcc\u90a6\u8f66\u8f86\u5230\u5e97\u4fe1\u606f!");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("contractBillcode", contractBillcode);
                OcContractReDomain order = ocContractServiceRepository.getContractByCode(params);
                if (null == order || !StringUtils.isNotBlank((String)(memberGname = order.getMemberGname())) || null == (memberGnameJson = JSONObject.parseObject((String)memberGname))) break block10;
                String financial = memberGnameJson.containsKey((Object)"financial") ? memberGnameJson.getString("financial") : null;
                JSONObject jSONObject = financialJson = StringUtils.isNotBlank((String)financial) ? JSONObject.parseObject((String)financial) : null;
                if (null == financialJson) break block10;
                String string = financeOrg = financialJson.containsKey((Object)"financialOrg") ? financialJson.getString("financialOrg") : null;
                if (FinanceOrgEnum.FUBANG.getCode().equals(financeOrg)) {
                    String realName = memberGnameJson.containsKey((Object)"realName") ? memberGnameJson.getString("realName") : null;
                    String approveResult = memberGnameJson.containsKey((Object)"approveResult") ? memberGnameJson.getString("approveResult") : null;
                    JSONObject approveResultJson = StringUtils.isNotBlank((String)approveResult) ? JSONObject.parseObject((String)approveResult) : null;
                    req.setChannelID(CHANNEL_ID);
                    req.setName(realName);
                    req.setIcard_order_no(contractBillcode);
                    req.setApp_no(null != approveResultJson ? approveResultJson.getString("appNo") : null);
                    req.setOrder_time(DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
                    req.setOrder_branch(memberGnameJson.containsKey((Object)"deliveryStore") ? memberGnameJson.getString("deliveryStore") : null);
                    log.info("B\u7aef\u72b6\u6001\u901a\u77e5\u63a5\u53e3 QueryFinancialProductsUtils.thirdOrderCard:\u63a8\u9001\u5bcc\u90a6\u8f66\u8f86\u5230\u5e97\u4fe1\u606f \u5165\u53c2 req:" + JSONObject.toJSONString((Object)req));
                    if (!req.checkRequired()) {
                        log.error(CODE + ".thirdOrderCard \u63a8\u9001\u5bcc\u90a6\u8f66\u8f86\u5230\u5e97\u4fe1\u606f\u5165\u53c2\u5b58\u5728\u7a7a\u503c request:{}", (Object)req);
                        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63a8\u9001\u5bcc\u90a6\u8f66\u8f86\u5230\u5e97\u4fe1\u606f\u5165\u53c2\u5b58\u5728\u7a7a\u503c!");
                    }
                    break block10;
                }
                log.info("\u9009\u62e9\u91d1\u878d\u673a\u6784\u4e0d\u4e3a\u5bcc\u90a6,\u9000\u51fa\u63a8\u9001 \u5bcc\u90a6\u9762\u7b7e\u7533\u8bf7\u4fe1\u606f\u5904\u7406!");
                return new HtmlJsonReBean((Object)"\u9009\u62e9\u91d1\u878d\u673a\u6784\u4e0d\u4e3a\u5bcc\u90a6,\u9000\u51fa\u63a8\u9001 \u5bcc\u90a6\u9762\u7b7e\u7533\u8bf7\u4fe1\u606f\u5904\u7406!");
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("QueryFinancialProductsUtils.thirdOrderCard :\u63a8\u9001\u5bcc\u90a6\u8f66\u8f86\u5230\u5e97\u4fe1\u606f\u5f02\u5e38!");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u63a8\u9001\u5bcc\u90a6\u8f66\u8f86\u5230\u5e97\u4fe1\u606f\u5f02\u5e38!");
            }
        }
        String tenantCode = "2020121500000001";
        String ddFlagCode = FinancialInstitutionEnum.FUBANG_THIRDORDERCARD.getCode();
        String url = CommonUtils.getDdFlag(tenantCode, ddFlagCode, DDFLAGTYPE) + FinancialInstitutionEnum.FUBANG_THIRDORDERCARD.getRequestUrl();
        try {
            JSONObject jsonBody = JSONObject.parseObject((String)JSON.toJSONString((Object)req));
            if (jsonBody.isEmpty()) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a!");
            }
            String result = SendFuBon.sendFuBon(jsonBody, url, tenantCode);
            log.info(CODE + ".thirdOrderCard \u51fa\u53c2 result:{}", (Object)result);
            JSONObject data = null;
            if (StringUtils.isNotBlank((String)result)) {
                String code;
                JSONObject resultJson = JSON.parseObject((String)result);
                String string = code = resultJson.containsKey((Object)"code") ? resultJson.getString("code") : null;
                if ("000000".equals(code)) {
                    data = resultJson.containsKey((Object)"data") ? JSON.parseObject((String)resultJson.getString("data")) : null;
                } else {
                    String errorMessage = "\u63a8\u9001\u5bcc\u90a6\u8f66\u8f86\u5230\u5e97\u4fe1\u606f\u5931\u8d25!";
                    return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, resultJson.containsKey((Object)"message") ? resultJson.getString("message") : errorMessage);
                }
            }
            return new HtmlJsonReBean(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(CODE + ".thirdOrderCard \u8f6c\u6362 request\u4e3ajson\u5f02\u5e38");
            return new HtmlJsonReBean((Object)"\u63a8\u9001\u5bcc\u90a6\u8f66\u8f86\u5230\u5e97\u4fe1\u606f\u540c\u6b65\u5f02\u5e38!");
        }
    }
}

