/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pay.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.facade.pte.domain.BankHtmlForm;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtfchannelReDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtePtradeParticipantDomain;
import com.qjsoft.laser.controller.facade.pte.domain.PtradeBean;
import com.qjsoft.laser.controller.facade.pte.repository.PtePtradeServiceRepository;
import com.qjsoft.laser.controller.pay.bean.PayChannel;
import com.qjsoft.laser.controller.pay.bean.PayCommit;
import com.qjsoft.laser.controller.pay.bean.PayInfo;
import com.qjsoft.laser.controller.pay.facade.PayServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pte/pay"}, name="\u7528\u6237\u652f\u4ed8\u670d\u52a1")
public class PayCon
extends SpringmvcController {
    private static String CODE = "pte.pay.con";
    @Autowired
    private PtePtradeServiceRepository ptePtradeServiceRepository;
    @Autowired
    PayServiceRepository payServiceRepository;

    protected String getContext() {
        return "pay";
    }

    @RequestMapping(value={"saveOrderToPay.json"}, name="\u652f\u4ed8\u4e0b\u5355")
    @ResponseBody
    public PayInfo saveOrderToPay(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error(CODE + ".saveOrderToPay.contractBillcode", (Object)"contractBillcode is null");
            return null;
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".saveOrderToPay.oauthEnvCode", (Object)"oauthEnvCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveOrderToPay.userSession", (Object)"userSession is null");
            return null;
        }
        PayInfo payInfo = this.payServiceRepository.savePay(userSession.getUserPcode(), contractBillcode, "PAY", this.getTenantCode(request));
        if (null == payInfo) {
            return null;
        }
        List<PayChannel> payChannelList = this.payServiceRepository.getPayChannel(userSession.getUserPcode(), oauthEnvCode, this.getTenantCode(request), "PAY");
        payInfo.setPayChannelList(payChannelList);
        return payInfo;
    }

    @RequestMapping(value={"paymentCommit.json"}, name="\u652f\u4ed8\u786e\u8ba4")
    @ResponseBody
    public BankHtmlForm paymentCommit(HttpServletRequest request, String payCommitStr, String ptradeSeqno) {
        if (StringUtils.isBlank((String)ptradeSeqno) || StringUtils.isBlank((String)payCommitStr)) {
            this.logger.error(CODE + ".paymentCommit.contractBillcode", (Object)"contractBillcode is null");
            return null;
        }
        String oauthEnvCode = this.getOauthEnvCode(request);
        if (StringUtils.isBlank((String)oauthEnvCode)) {
            this.logger.error(CODE + ".paymentCommit.oauthEnvCode", (Object)"oauthEnvCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".paymentCommit.userSession", (Object)"userSession is null");
            return null;
        }
        List payCommitList = (List)JsonUtil.buildNormalBinder().getJsonToList(payCommitStr, PayCommit.class);
        String tenantCode = this.getTenantCode(request);
        if (null == payCommitList || payCommitList.isEmpty()) {
            return null;
        }
        Map<String, PtePtfchannelReDomain> channelMap = this.payServiceRepository.queryChannel(oauthEnvCode, tenantCode, "PAY");
        if (null == channelMap || channelMap.isEmpty()) {
            return null;
        }
        ArrayList<PtePtradeParticipantDomain> ptradeParticipantList = new ArrayList<PtePtradeParticipantDomain>();
        String fchannelMode = "0";
        for (PayCommit payCommit : payCommitList) {
            PtePtfchannelReDomain ptePtfchannelReDomain = channelMap.get(payCommit.getFchannelCode());
            if (null == ptePtfchannelReDomain) {
                return null;
            }
            PtePtradeParticipantDomain ptePtradeParticipantDomain = new PtePtradeParticipantDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)ptePtfchannelReDomain);
                BeanUtils.copyAllPropertys((Object)ptePtradeParticipantDomain, (Object)payCommit);
                ptePtradeParticipantDomain.setFchannelClassifyCode(ptePtfchannelReDomain.getFchannelType());
                fchannelMode = ptePtfchannelReDomain.getFchannelModel();
            }
            catch (Exception e) {
                this.logger.error(CODE + ".paymentCommit.e", (Throwable)e);
                return null;
            }
            ptradeParticipantList.add(ptePtradeParticipantDomain);
        }
        PtradeBean ptradeBean = new PtradeBean();
        ptradeBean.setPtradeSeqno(ptradeSeqno);
        ptradeBean.setPartList(ptradeParticipantList);
        ptradeBean.setTenantCode(tenantCode);
        ptradeBean.setFchannelMode(fchannelMode);
        BankHtmlForm bankHtmlForm = this.ptePtradeServiceRepository.sendParticipantByPtrade(ptradeBean);
        return bankHtmlForm;
    }

    @RequestMapping(value={"mockQj.json"}, name="\u652f\u4ed8mock\uff08\u5343\u5320\u652f\u4ed8\uff09")
    public void mockQj(HttpServletRequest request, HttpServletResponse response) {
        Map map = this.getQueryMapParams(request);
        Object out_trade_no = map.get("out_trade_no");
        Object tenantCode = map.get("tenantCode");
        Object notify_url = map.get("notify_url");
        Object return_url = map.get("return_url");
        HashMap mapRead = new HashMap();
        mapRead.put("\u5546\u6237\u8d26\u6237", map.get("seller_account_name"));
        mapRead.put("\u8d39\u7528", map.get("total_fee"));
        mapRead.put("\u63cf\u8ff0", map.get("subject"));
        mapRead.put("\u5546\u6237ID", map.get("seller_id"));
        mapRead.put("\u5408\u4f5cID", map.get("partner"));
        mapRead.put("E-mail", map.get("seller_email"));
        mapRead.put("\u6d41\u6c34\u53f7", out_trade_no);
        StringBuffer html = new StringBuffer();
        html.append("<!DOCTYPE html>\n");
        html.append("<html>");
        html.append("<head>\n");
        html.append("<meta charset=\"utf-8\">\n");
        html.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no\">\n");
        html.append("<title>\u5343\u5320\u652f\u4ed8</title>\n");
        html.append("</head>\n");
        html.append("<style type=\"text/css\">                \n");
        html.append("*{                                       \n");
        html.append("\tpadding:0;                             \n");
        html.append("\tmargin:0;                              \n");
        html.append("\tfont-family: '\u5fae\u8f6f\u96c5\u9ed1';               \n");
        html.append("\tfont-size:13px;                        \n");
        html.append("}\t                                       \n");
        html.append("ul li{                                   \n");
        html.append("\tlist-style: none;                      \n");
        html.append("}                                        \n");
        html.append(".t-box{                                  \n");
        html.append("      display: -moz-box;                 \n");
        html.append("      display:-webkit-box;               \n");
        html.append("      display: box;                      \n");
        html.append("  }                                      \n");
        html.append("  .t-box-flex1{                          \n");
        html.append("      -moz-box-flex:1;                   \n");
        html.append("      -webkit-box-flex:1;                \n");
        html.append("      box-flex:1;                        \n");
        html.append("      width:0%                           \n");
        html.append("   }                                     \n");
        html.append(".auto{                                   \n");
        html.append("\twidth:90%;                             \n");
        html.append("\tmargin:0 5%;                           \n");
        html.append("}                                        \n");
        html.append(".pay-ul {                                \n");
        html.append("\tmargin-top:30px;                       \n");
        html.append("}                                        \n");
        html.append(".pay-ul li{                              \n");
        html.append("\tmargin:12px 0;                         \n");
        html.append("}                                        \n");
        html.append(".pay-ul label{                           \n");
        html.append("\twidth:6rem;                            \n");
        html.append("\tdisplay:block;                         \n");
        html.append("\tline-height:35px;                      \n");
        html.append("\ttext-align: right;                     \n");
        html.append("}                                        \n");
        html.append(".pay-ul input{                           \n");
        html.append("\tpadding:8px 3px;                       \n");
        html.append("\twidth:100%;                            \n");
        html.append("\tborder:1px solid #e0e0e0;              \n");
        html.append("\tborder-radius:2px;                     \n");
        html.append("}                                        \n");
        html.append(".pay-ul .pay-btn {                       \n");
        html.append("\tmargin-top:20px;                       \n");
        html.append("}                                        \n");
        html.append(".pay-btn input{                          \n");
        html.append("\twidth:80%;                             \n");
        html.append("\tcursor: pointer;                       \n");
        html.append("\tborder:0;                              \n");
        html.append("\tborder-radius:3px;                     \n");
        html.append("\toutline: none                          \n");
        html.append("}                                        \n");
        html.append(".pay-btn input[type=\"submit\"]{         \n");
        html.append("\tcolor:#fff;                            \n");
        html.append("\tbackground:#e52222;                    \n");
        html.append("\tmargin:0 5% 0 15%;                     \n");
        html.append("}                                        \n");
        html.append(".pay-btn input[type=\"button\"]{         \n");
        html.append("\tcolor:#fff;                            \n");
        html.append("\tbackground:#999;                       \n");
        html.append("\tmargin:0 15% 0 5%;                     \n");
        html.append("}                                        \n");
        html.append("</style>                                 \n");
        html.append("<body>\n");
        html.append("<ul class=\"auto pay-ul\">\n");
        String htmlStr = null;
        htmlStr = "<li class=\"t-box\">";
        for (Map.Entry entry : mapRead.entrySet()) {
            htmlStr = htmlStr + "<label>" + (String)entry.getKey() + "\uff1a</label><div class=\"t-box-flex1\"><input type=\"text\" value=\"" + entry.getValue().toString() + "\" readonly=\"true\"/></div><br/>\n";
            html.append(htmlStr);
        }
        HashMap<String, Long> mapModify = new HashMap<String, Long>();
        mapModify.put("\u8d44\u91d1\u6d41\u6c34\u53f7", System.currentTimeMillis());
        for (Map.Entry entry : mapModify.entrySet()) {
            htmlStr = "<label>" + (String)entry.getKey() + "\uff1a</label><div class=\"t-box-flex1\"><input id=\"trade_no\" type=\"text\" value=\"" + entry.getValue().toString() + "\"/></div><br/>\n";
            html.append(htmlStr);
        }
        htmlStr = htmlStr + "</li>";
        html.append("<li class=\"t-box pay-btn\" >\n");
        html.append("<div class=\"t-box-flex1\"><input type=\"submit\" value=\"\u6210\u529f\" onclick=\"ajax('TRADE_SUCCESS');\"></div>\n");
        html.append("<div class=\"t-box-flex1\"><input type=\"button\" value=\"\u5931\u8d25\" onclick=\"ajax('TRADE_FAULURE');\"></div>\n");
        html.append("</li>\n");
        html.append("</ul>\n");
        html.append("</body>\n");
        html.append("<script>\n");
        html.append("var xhr = new XMLHttpRequest();\n");
        html.append("var formData = new FormData();\n");
        html.append("formData.append('out_trade_no', '#{out_trade_no}');\n".replace("#{out_trade_no}", out_trade_no.toString()));
        html.append("formData.append('notify_url', '#{notify_url}');\n".replace("#{notify_url}", notify_url.toString()));
        html.append("formData.append('tenantCode', '#{tenantCode}');\n".replace("#{tenantCode}", tenantCode.toString()));
        html.append("formData.append('exterface', 'trade_status_sync');\n");
        html.append("xhr.withCredentials = true;\n");
        html.append("function ajax(trade_status) {\n");
        html.append("formData.append('trade_status', trade_status);\n");
        html.append("formData.append('trade_no', document.getElementById('trade_no').value);\n");
        html.append("xhr.open('POST', '#{commitUrl}');\n".replace("#{commitUrl}", notify_url.toString()));
        html.append("xhr.send(formData);\n");
        html.append("xhr.onreadystatechange = function () {\n");
        html.append("if (xhr.readyState==4 && xhr.status==200) {\n");
        html.append("location.href = '#{return_url}';\n".replace("#{return_url}", return_url.toString()));
        html.append("} else {console.log(xhr.readyState + '--' + xhr.status); }\n");
        html.append("}\n");
        html.append("}\n");
        html.append("</script>\n");
        html.append("</html>");
        try {
            response.getWriter().print(html.toString());
        }
        catch (IOException e) {
            this.logger.error(CODE + ".mockQj.print.ex", (Throwable)e);
        }
    }

    @ResponseBody
    @RequestMapping(value={"mockQjNotify.json"}, name="\u652f\u4ed8mock\uff08\u5343\u5320\u652f\u4ed8\uff09\u5f02\u6b65\u901a\u77e5\u652f\u4ed8\u7ed3\u679c")
    public String mockQjNotify(HttpServletRequest request) {
        String result;
        Map map = this.getQueryMapParams(request);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("trade_status", map.get("trade_status").toString());
        params.put("trade_no", map.get("trade_no").toString());
        params.put("out_trade_no", map.get("out_trade_no").toString());
        params.put("tenantCode", map.get("tenantCode").toString());
        params.put("exterface", "trade_status_sync");
        String notifyUrl = (String)map.get("notify_url");
        try {
            result = WebUtils.doPost((String)notifyUrl, params, (int)100000, (int)100000);
        }
        catch (IOException e) {
            this.logger.error(CODE + ".mockQjNotify.ex", (Throwable)e);
            return "\u53d1\u9001\u5931\u8d25";
        }
        if ("null".equals(result)) {
            return "ok";
        }
        this.logger.info(CODE + ".mockQjNotify.post.failure", (Object)result);
        return result;
    }
}

