/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pfs.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pfs.domain.PfsModelDomain;
import com.qjsoft.laser.controller.facade.pfs.domain.PfsModelReDomain;
import com.qjsoft.laser.controller.facade.pfs.repository.PfsMmodelServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pfs/pfsmodel"}, name="\u6a21\u677f\u660e\u7ec6")
public class PfsModelCon
extends SpringmvcController {
    private static String CODE = "pfs.pfsmodel.con";
    @Autowired
    private PfsMmodelServiceRepository pfsMmodelServiceRepository;

    protected String getContext() {
        return "pfsmodel";
    }

    @RequestMapping(value={"savePfsModel.json"}, name="\u589e\u52a0\u6a21\u677f\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean savePfsModel(HttpServletRequest request, PfsModelDomain pfsmodelDomain) {
        if (null == pfsmodelDomain) {
            this.logger.error(CODE + ".savePfsModel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pfsmodelDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsMmodelServiceRepository.saveModel(pfsmodelDomain);
    }

    @RequestMapping(value={"getPfsModel.json"}, name="\u83b7\u53d6\u6a21\u677f\u660e\u7ec6\u4fe1\u606f")
    @ResponseBody
    public PfsModelReDomain getPfsModel(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".getPfsModel", (Object)"param is null");
            return null;
        }
        return this.pfsMmodelServiceRepository.getModel(Integer.valueOf(modelId));
    }

    @RequestMapping(value={"updatePfsModel.json"}, name="\u66f4\u65b0\u6a21\u677f\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean updatePfsModel(HttpServletRequest request, PfsModelDomain pfsmodelDomain) {
        if (null == pfsmodelDomain) {
            this.logger.error(CODE + ".updatePfsModel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pfsmodelDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsMmodelServiceRepository.updateModel(pfsmodelDomain);
    }

    @RequestMapping(value={"deletePfsModel.json"}, name="\u5220\u9664\u6a21\u677f\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean deletePfsModel(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".deletePfsModel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pfsMmodelServiceRepository.deleteModel(Integer.valueOf(modelId));
    }

    @RequestMapping(value={"queryPfsModelPage.json"}, name="\u67e5\u8be2\u6a21\u677f\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PfsModelReDomain> queryPfsModelPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pfsMmodelServiceRepository.queryModelPage(param);
    }

    @RequestMapping(value={"updatePfsModelState.json"}, name="\u66f4\u65b0\u6a21\u677f\u660e\u7ec6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePfsModelState(String modelId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".updatePfsModelState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pfsMmodelServiceRepository.updateModelState(Integer.valueOf(modelId), dataState, oldDataState);
    }
}

