/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.pfs.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pfs.domain.PfsModelDomain;
import com.qjsoft.laser.controller.facade.pfs.domain.PfsModelReDomain;
import com.qjsoft.laser.controller.facade.pfs.repository.PfsMemmodelTagServiceRepository;
import com.qjsoft.laser.controller.facade.pfs.repository.PfsMmodelServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pfs/pfsmodel"}, name="\u6a21\u677f\u660e\u7ec6")
public class PfsModelCon
extends SpringmvcController {
    private static String CODE = "pfs.pfsmodel.con";
    @Autowired
    private PfsMmodelServiceRepository pfsMmodelServiceRepository;
    @Autowired
    private PfsMemmodelTagServiceRepository pfsMemmodelTagServiceRepository;

    protected String getContext() {
        return "pfsmodel";
    }

    @RequestMapping(value={"savePfsModel.json"}, name="\u589e\u52a0\u6a21\u677f\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean savePfsModel(HttpServletRequest request, PfsModelDomain pfsmodelDomain) {
        if (null == pfsmodelDomain) {
            this.logger.error(CODE + ".savePfsModel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String modelName = pfsmodelDomain.getModelName();
        if (this.checkName(request, modelName, ".savePfsModel", "\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0");
        }
        pfsmodelDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsMmodelServiceRepository.saveModel(pfsmodelDomain);
    }

    private boolean checkName(HttpServletRequest request, String modelName, String s, String s2) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("modelName", modelName);
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult result = this.pfsMmodelServiceRepository.queryModelPage(param);
        if (result.getList() != null && result.getList().size() > 0) {
            this.logger.error(CODE + s, (Object)s2);
            return true;
        }
        return false;
    }

    @RequestMapping(value={"getPfsModel.json"}, name="\u83b7\u53d6\u6a21\u677f\u660e\u7ec6\u4fe1\u606f")
    @ResponseBody
    public PfsModelReDomain getPfsModel(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".getPfsModel", (Object)"param is null");
            return null;
        }
        return this.pfsMmodelServiceRepository.getModel(Integer.valueOf(modelId));
    }

    @RequestMapping(value={"updatePfsModel.json"}, name="\u66f4\u65b0\u6a21\u677f\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean updatePfsModel(HttpServletRequest request, PfsModelDomain pfsmodelDomain) {
        if (null == pfsmodelDomain) {
            this.logger.error(CODE + ".updatePfsModel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pfsmodelDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsMmodelServiceRepository.updateModel(pfsmodelDomain);
    }

    @RequestMapping(value={"deletePfsModel.json"}, name="\u5220\u9664\u6a21\u677f\u660e\u7ec6")
    @ResponseBody
    public HtmlJsonReBean deletePfsModel(HttpServletRequest request, String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".deletePfsModel", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PfsModelReDomain model = this.pfsMmodelServiceRepository.getModel(Integer.valueOf(modelId));
        String modelCode = model.getModelCode();
        String tenantCode = this.getTenantCode(request);
        this.pfsMemmodelTagServiceRepository.deleteMemmodelTagByCode(tenantCode, modelCode);
        return this.pfsMmodelServiceRepository.deleteModel(Integer.valueOf(modelId));
    }

    @RequestMapping(value={"queryPfsModelPage.json"}, name="\u67e5\u8be2\u6a21\u677f\u660e\u7ec6\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PfsModelReDomain> queryPfsModelPage(HttpServletRequest request) {
        Map param = this.makeMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pfsMmodelServiceRepository.queryModelPage(param);
    }

    @RequestMapping(value={"updatePfsModelState.json"}, name="\u66f4\u65b0\u6a21\u677f\u660e\u7ec6\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updatePfsModelState(String modelId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".updatePfsModelState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pfsMmodelServiceRepository.updateModelState(Integer.valueOf(modelId), dataState, oldDataState);
    }

    @RequestMapping(value={"updatePfsModelName.json"}, name="\u66f4\u65b0\u6a21\u677f\u660e\u7ec6\u540d\u5b57")
    @ResponseBody
    public HtmlJsonReBean updatePfsModelName(HttpServletRequest request, String modelName, String modelCode) {
        if (StringUtils.isBlank((String)modelCode)) {
            this.logger.error(CODE + ".updatePfsModelName", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (this.checkName(request, modelName, ".updatePfsModelName", "\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("modelCode", modelCode);
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult result = this.pfsMmodelServiceRepository.queryModelPage(param);
        List list = result.getList();
        if (null == list || list.isEmpty()) {
            this.logger.error(CODE + ".updatePfsModelName", (Object)"list is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PfsModelReDomain pfsmodelDomain = (PfsModelReDomain)list.get(0);
        pfsmodelDomain.setModelName(modelName);
        return this.pfsMmodelServiceRepository.updateModel((PfsModelDomain)pfsmodelDomain);
    }

    @RequestMapping(value={"savePfsModelForPlate.json"}, name="\u589e\u52a0\u6a21\u677f\u660e\u7ec6\u7ed9\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean savePfsModelForPlate(HttpServletRequest request, PfsModelDomain pfsmodelDomain) {
        if (null == pfsmodelDomain) {
            this.logger.error(CODE + ".savePfsModelForPlate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        String modelName = pfsmodelDomain.getModelName();
        if (this.checkName(request, modelName, ".savePfsModelForPlate", "\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0");
        }
        pfsmodelDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsMmodelServiceRepository.saveModel(pfsmodelDomain);
    }

    @RequestMapping(value={"getPfsModelForPlate.json"}, name="\u83b7\u53d6\u6a21\u677f\u660e\u7ec6\u4fe1\u606f\u7ed9\u5e73\u53f0")
    @ResponseBody
    public PfsModelReDomain getPfsModelForPlate(String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".getPfsModelForPlate", (Object)"param is null");
            return null;
        }
        return this.pfsMmodelServiceRepository.getModel(Integer.valueOf(modelId));
    }

    @RequestMapping(value={"updatePfsModelForPlate.json"}, name="\u66f4\u65b0\u6a21\u677f\u660e\u7ec6\u7ed9\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean updatePfsModelForPlate(HttpServletRequest request, PfsModelDomain pfsmodelDomain) {
        if (null == pfsmodelDomain) {
            this.logger.error(CODE + ".updatePfsModelForPlate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pfsmodelDomain.setTenantCode(this.getTenantCode(request));
        return this.pfsMmodelServiceRepository.updateModel(pfsmodelDomain);
    }

    @RequestMapping(value={"deletePfsModelForPlate.json"}, name="\u5220\u9664\u6a21\u677f\u660e\u7ec6\u7ed9\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean deletePfsModelForPlate(HttpServletRequest request, String modelId) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".deletePfsModelForPlate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PfsModelReDomain model = this.pfsMmodelServiceRepository.getModel(Integer.valueOf(modelId));
        String modelCode = model.getModelCode();
        String tenantCode = this.getTenantCode(request);
        this.pfsMemmodelTagServiceRepository.deleteMemmodelTagByCode(tenantCode, modelCode);
        return this.pfsMmodelServiceRepository.deleteModel(Integer.valueOf(modelId));
    }

    @RequestMapping(value={"queryPfsModelPageForPlate.json"}, name="\u67e5\u8be2\u6a21\u677f\u660e\u7ec6\u5206\u9875\u5217\u8868\u7ed9\u5e73\u53f0")
    @ResponseBody
    public SupQueryResult<PfsModelReDomain> queryPfsModelPageForPlate(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pfsMmodelServiceRepository.queryModelPage(param);
    }

    @RequestMapping(value={"updatePfsModelStateForPlate.json"}, name="\u66f4\u65b0\u6a21\u677f\u660e\u7ec6\u72b6\u6001\u7ed9\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean updatePfsModelStateForPlate(String modelId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)modelId)) {
            this.logger.error(CODE + ".updatePfsModelStateForPlate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pfsMmodelServiceRepository.updateModelState(Integer.valueOf(modelId), dataState, oldDataState);
    }

    @RequestMapping(value={"updatePfsModelNameForPlate.json"}, name="\u66f4\u65b0\u6a21\u677f\u660e\u7ec6\u540d\u5b57\u7ed9\u5e73\u53f0")
    @ResponseBody
    public HtmlJsonReBean updatePfsModelNameForPlate(HttpServletRequest request, String modelName, String modelCode) {
        if (StringUtils.isBlank((String)modelCode)) {
            this.logger.error(CODE + ".updatePfsModelNameForPlate", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (this.checkName(request, modelName, ".updatePfsModelNameForPlate", "\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539")) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539");
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("modelCode", modelCode);
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult result = this.pfsMmodelServiceRepository.queryModelPage(param);
        List list = result.getList();
        if (null == list || list.isEmpty()) {
            this.logger.error(CODE + ".updatePfsModelName", (Object)"list is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PfsModelReDomain pfsmodelDomain = (PfsModelReDomain)list.get(0);
        pfsmodelDomain.setModelName(modelName);
        return this.pfsMmodelServiceRepository.updateModel((PfsModelDomain)pfsmodelDomain);
    }
}

