/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.promotion.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDisDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmPromotionSupDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmUserCouponReDomain;
import com.qjsoft.laser.controller.facade.pm.repository.PmPromotionServiceRepository;
import com.qjsoft.laser.controller.facade.pm.repository.PmUserCouponServiceRepository;
import com.qjsoft.laser.controller.facade.rs.domain.RsSkuReDomain;
import com.qjsoft.laser.controller.facade.rs.repository.RsGoodsClassServiceRepository;
import com.qjsoft.laser.controller.facade.rs.repository.RsSkuServiceRepository;
import com.qjsoft.laser.controller.facade.tm.domain.TmProappEnvReDomain;
import com.qjsoft.laser.controller.facade.tm.repository.TmProappServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class PromotionSupCon
extends SpringmvcController {
    private static String CODE = "pm.promotionsup.con";
    @Autowired
    private PmPromotionServiceRepository pmPromotionServiceRepository;
    @Autowired
    private RsGoodsClassServiceRepository rsGoodsClassServiceRepository;
    @Autowired
    private RsSkuServiceRepository rsSkuServiceRepository;
    @Autowired
    private TmProappServiceRepository tmProappServiceRepository;
    @Autowired
    private PmUserCouponServiceRepository pmUserCouponServiceRepository;
    protected static String TYPE_PLAT = "plat";
    protected static String TYPE_BUS = "bus";
    protected static String TYPE_USER = "user";
    protected static String TYPE_STORE = "store";

    protected String getContext() {
        return "promotionsup";
    }

    protected PmPromotionReDomain getPromotionPro(HttpServletRequest request, Integer promotionId) {
        return this.getPromotionplus(promotionId);
    }

    protected PmPromotionReDomain getPromotionByCodePro(HttpServletRequest request, String promotionCode) {
        if (StringUtils.isBlank((String)promotionCode)) {
            this.logger.error(CODE + ".getPromotionByCode", (Object)"param is null");
            return null;
        }
        return this.pmPromotionServiceRepository.getPromotionByCode(this.getTenantCode(request), promotionCode);
    }

    protected HtmlJsonReBean updatePromotionStatePro(String promotionId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), dataState, oldDataState);
    }

    protected HtmlJsonReBean deletePromotionPlus(String promotionId) {
        String[] pidStrArray;
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".deletePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        for (String pidStr : pidStrArray = promotionId.split(",")) {
            PmPromotionReDomain promotion = this.pmPromotionServiceRepository.getPromotion(Integer.valueOf(Integer.parseInt(pidStr)));
            if (null == promotion || promotion.getDataState() != 0) {
                this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
            }
            this.pmPromotionServiceRepository.deletePromotion(Integer.valueOf(Integer.parseInt(pidStr)));
        }
        return new HtmlJsonReBean();
    }

    protected HtmlJsonReBean promotionStateStart(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(1), Integer.valueOf(3));
    }

    protected HtmlJsonReBean promotionStateStop(String promotionId) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(3), Integer.valueOf(1));
    }

    protected SupQueryResult<PmPromotionReDomain> promotionPageAll(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    protected SupQueryResult<PmPromotionReDomain> promotionPage(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode, Integer promotionOrgin, String type) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        Map param = this.assemMapMemberParam(request);
        String saveMemberCode = "";
        if (StringUtils.isBlank((String)type)) {
            saveMemberCode = this.checkMemquaPlat(request) ? this.getTeananMemberCode(request) : userSession.getUserPcode();
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
        } else if (TYPE_BUS.equals(type)) {
            saveMemberCode = StringUtils.isNotBlank((String)userSession.getUserinfoParentCode()) ? userSession.getUserinfoParentCode() : userSession.getUserPcode();
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
        } else if (TYPE_STORE.equals(type)) {
            param.put("memberCcode", userSession.getUserPcode());
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)saveMemberCode)) {
                param.put("memberCode", saveMemberCode);
            }
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
            if (null != promotionOrgin) {
                param.put("promotionOrgin", promotionOrgin);
            }
        }
        if (TYPE_STORE.equals(type)) {
            param.remove("memberCode");
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    protected SupQueryResult<PmPromotionReDomain> getpromotionPageForStore(HttpServletRequest request, String pbCode, String promotionType, String promotionPcode, Integer promotionOrgin, String type) {
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return null;
        }
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
            if (StringUtils.isNotBlank((String)promotionType)) {
                param.put("promotionType", promotionType);
            }
            if (StringUtils.isNotBlank((String)promotionPcode)) {
                param.put("promotionPcode", promotionPcode);
            }
            if (null != promotionOrgin) {
                param.put("promotionOrgin", promotionOrgin);
            }
        }
        return this.pmPromotionServiceRepository.queryPromotionPage(param);
    }

    protected PmPromotionReDomain getPromotionplus(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error(CODE + ".getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionId);
        return pmPromotionReDomain;
    }

    protected HtmlJsonReBean updatePromotionPlus(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".updatePromotion", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".updatePromotion", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain.getPromotionId()) {
            this.logger.error(CODE + ".updatePromotion.PromotionId", (Object)"promotionId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "");
        }
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(userSession.getUserPcode());
        promotionDomain.setMemberName(userSession.getUserName());
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionDomain.getPromotionId());
        if (null == pmPromotionReDomain || pmPromotionReDomain.getDataState() != 0) {
            this.logger.error(CODE + ".updatePromotion", (Object)" datastate canot update");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u8425\u9500\u6d3b\u52a8\u5df2\u7ecf\u5f00\u59cb\u6216\u7ed3\u675f\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        return this.pmPromotionServiceRepository.updatePromotion(promotionDomain);
    }

    protected HtmlJsonReBean savePromotionPlus(HttpServletRequest request, String paramStr, String channelCode, String memberCode, String pbCode, String type) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PmPromotionDomain promotionDomain = (PmPromotionDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmPromotionDomain.class);
        if (null == promotionDomain) {
            this.logger.error(CODE + ".savePromotionPlus", (Object)"promotionDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        promotionDomain.setPbCode(pbCode);
        String saveMemberCode = "";
        String saveMemberName = "";
        if (StringUtils.isBlank((String)type)) {
            if (this.checkMemquaPlat(request)) {
                saveMemberCode = this.getTeananMemberCode(request);
                saveMemberName = "\u5e73\u53f0";
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
        } else if (TYPE_PLAT.equals(type)) {
            saveMemberCode = this.getTeananMemberCode(request);
            saveMemberName = "\u5e73\u53f0";
        } else if (TYPE_BUS.equals(type)) {
            if (StringUtils.isNotBlank((String)userSession.getUserinfoParentCode())) {
                saveMemberCode = userSession.getUserinfoParentCode();
                saveMemberName = userSession.getUserinfoParentName();
            } else {
                saveMemberCode = userSession.getUserPcode();
                saveMemberName = userSession.getMerberCompname();
            }
        } else if (TYPE_USER.equals(type)) {
            saveMemberCode = userSession.getUserPcode();
            saveMemberName = userSession.getMerberCompname();
        }
        if (StringUtils.isNotBlank((String)channelCode)) {
            ArrayList<PmPromotionDisDomain> pmPromotionDisLists = promotionDomain.getPmPromotionDisList();
            if (null == pmPromotionDisLists) {
                pmPromotionDisLists = new ArrayList<PmPromotionDisDomain>();
                promotionDomain.setPmPromotionDisList(pmPromotionDisLists);
            }
            PmPromotionDisDomain pmPromotionDisDomain = new PmPromotionDisDomain();
            pmPromotionDisDomain.setChannelCode(this.getChannelByMem(userSession.getUserPcode(), request));
            pmPromotionDisDomain.setChannelName(userSession.getUserName());
            pmPromotionDisDomain.setMemberCode(saveMemberCode);
            pmPromotionDisDomain.setMemberName(saveMemberName);
            pmPromotionDisLists.add(pmPromotionDisDomain);
        }
        if (StringUtils.isNotBlank((String)memberCode)) {
            ArrayList<PmPromotionSupDomain> pmPromotionSupDomains = promotionDomain.getPmPromotionSupList();
            if (null == pmPromotionSupDomains) {
                pmPromotionSupDomains = new ArrayList<PmPromotionSupDomain>();
                promotionDomain.setPmPromotionSupList(pmPromotionSupDomains);
            }
            PmPromotionSupDomain pmPromotionSupDomain = new PmPromotionSupDomain();
            pmPromotionSupDomain.setPpsupMemcode(saveMemberCode);
            pmPromotionSupDomain.setPpsupName(saveMemberName);
            pmPromotionSupDomains.add(pmPromotionSupDomain);
        }
        promotionDomain.setAppmanageIcode(this.getProappCode(request));
        promotionDomain.setTenantCode(this.getTenantCode(request));
        promotionDomain.setMemberCode(saveMemberCode);
        promotionDomain.setMemberName(saveMemberName);
        return this.pmPromotionServiceRepository.savePromotion(promotionDomain);
    }

    protected SupQueryResult<RsSkuReDomain> querySkuMotherPage(HttpServletRequest request, String type, String userMemberCode) {
        Map param = null;
        if (StringUtils.isBlank((String)type) && StringUtils.isNotBlank((String)userMemberCode) && null != (param = this.assemMapParam(request))) {
            param.put("memberCode", userMemberCode);
        }
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            param = this.checkMemquaPlat(request) ? this.getPlatMemberCodeQueryMapParams(request) : this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_PLAT.equals(type)) {
            param = this.getPlatMemberCodeQueryMapParams(request);
        } else if (TYPE_BUS.equals(type)) {
            param = this.getBusMemberCodeQueryMapParams(request);
        } else if (TYPE_USER.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        }
        if (null != param && null != param.get("goodsClassParentcode") && StringUtils.isNotBlank((String)param.get("goodsClassParentcode").toString())) {
            List classList = this.rsGoodsClassServiceRepository.getGoodsClass((String)param.get("goodsClassParentcode"), (String)param.get("goodsClassType"), this.getNowChannel(request), this.getTenantCode(request));
            if (ListUtil.isNotEmpty((Collection)classList)) {
                String classtreeCode = "";
                for (String string : classList) {
                    if (StringUtils.isNotBlank((String)classtreeCode)) {
                        classtreeCode = classtreeCode + ",";
                    }
                    classtreeCode = classtreeCode + string;
                }
                param.put("classtreeCode", classtreeCode);
            } else {
                return null;
            }
        }
        return this.querySkuMain(param);
    }

    protected SupQueryResult<RsSkuReDomain> querySkuMain(Map<String, Object> param) {
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.rsSkuServiceRepository.querySkuOnePage(param);
    }

    public SupQueryResult<TmProappEnvReDomain> queryProappEnvPageUser(HttpServletRequest request, String type, String userMemberCode) {
        Map param = null;
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            param = this.checkMemquaPlat(request) ? this.getPlatMemberCodeQueryMapParams(request) : this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_PLAT.equals(type)) {
            param = this.getPlatMemberCodeQueryMapParams(request);
        } else if (TYPE_BUS.equals(type)) {
            UserSession userSession = this.getUserSession(request);
            param = this.assemMapParam(request);
            param.put("tginfoCode", userSession.getUserPcode());
        } else if (TYPE_USER.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        }
        return this.tmProappServiceRepository.queryProappEnvPage(param);
    }

    public HtmlJsonReBean sendPromotion(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error(CODE + ".getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionId);
        if (null == pmPromotionReDomain) {
            return null;
        }
        return this.pmPromotionServiceRepository.sendPromotionById(promotionId);
    }

    public HtmlJsonReBean sendPromotionDeleteGoods(Integer promotionId) {
        if (StringUtils.isBlank((Integer)promotionId)) {
            this.logger.error(CODE + ".getPromotion", (Object)"param is null");
            return null;
        }
        PmPromotionReDomain pmPromotionReDomain = this.pmPromotionServiceRepository.getPromotion(promotionId);
        if (null == pmPromotionReDomain) {
            return null;
        }
        return this.pmPromotionServiceRepository.sendPromotionDeleteGoods(promotionId);
    }

    public SupQueryResult<PmUserCouponReDomain> queryUsercouponPagePlus(HttpServletRequest request, String pbCode, String type, String userMemberCode) {
        Map param = this.assemMapBuyParam(request);
        if (StringUtils.isBlank((String)type) && StringUtils.isNotBlank((String)userMemberCode) && null != (param = this.assemMapParam(request))) {
            param.put("memberCode", userMemberCode);
        }
        if (StringUtils.isBlank((String)type) && StringUtils.isBlank((String)userMemberCode)) {
            param = this.checkMemquaPlat(request) ? this.getPlatMemberCodeQueryMapParams(request) : this.getMemberCodeQueryMapParams(request);
        } else if (TYPE_PLAT.equals(type)) {
            param = this.assemMapParam(request);
        } else if (TYPE_BUS.equals(type)) {
            param = this.assemMapParam(request);
            UserSession userSession = this.getUserSession(request);
            param.put("channelCode", this.getChannelByMem(userSession.getUserPcode(), request));
        } else if (TYPE_USER.equals(type)) {
            param = this.getMemberCodeQueryMapParams(request);
        }
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
            if (StringUtils.isNotBlank((String)pbCode)) {
                param.put("pbCode", pbCode);
            }
        }
        return this.pmUserCouponServiceRepository.queryUserCouponPage(param);
    }

    public HtmlJsonReBean promotionStateStopAndDelete(String promotionId, Integer oldDataState) {
        if (StringUtils.isBlank((String)promotionId)) {
            this.logger.error(CODE + ".updatePromotionState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmPromotionServiceRepository.updatePromotionState(Integer.valueOf(promotionId), Integer.valueOf(3), oldDataState);
    }

    public static void main(String[] args) {
    }
}

