/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.promotion.controller;

import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.fm.domain.FmFileReDomainBean;
import com.qjsoft.laser.controller.facade.fm.repository.FileServiceRepository;
import com.qjsoft.laser.controller.facade.pm.domain.PmDistributeDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmDistributeReDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmDistributeUserDomain;
import com.qjsoft.laser.controller.facade.pm.domain.PmDistributeUserReDomain;
import com.qjsoft.laser.controller.facade.pm.repository.PmDistributeServiceRepository;
import com.qjsoft.laser.controller.facade.um.domain.UmUserReDomainBean;
import com.qjsoft.laser.controller.facade.um.domain.UmUserinfoReDomainBean;
import com.qjsoft.laser.controller.facade.um.repository.UserServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ExcelReaderUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/pm/distribute"}, name="\u53d1\u5238\u6d3b\u52a8\u8bbe\u7f6e")
public class DistributeCon
extends SpringmvcController {
    private static String CODE = "pm.distribute.con";
    @Autowired
    private PmDistributeServiceRepository pmDistributeServiceRepository;
    @Autowired
    private FileServiceRepository fileServiceRepository;
    @Autowired
    private UserServiceRepository userServiceRepository;

    protected String getContext() {
        return "distribute";
    }

    @RequestMapping(value={"checkDistributeUserFile.json"}, name="\u9644\u4ef6\u68c0\u67e5")
    @ResponseBody
    public HtmlJsonReBean checkUserFile(HttpServletRequest request, String userFile) {
        if (StringUtils.isEmpty((String)userFile)) {
            this.logger.error(CODE + ".checkUserFile", (Object)"userFile is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userFile\u53c2\u6570\u4e3a\u7a7a");
        }
        String fileCode = userFile.substring(userFile.lastIndexOf("/") + 1, userFile.lastIndexOf("."));
        FmFileReDomainBean fileByCode = this.fileServiceRepository.getFileByCode(fileCode, this.getTenantCode(request));
        if (fileByCode != null) {
            HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
            stringStringHashMap.put("userinfoPhone", "\u624b\u673a\u53f7");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileByCode.getFileContext());
            List lists = ExcelReaderUtils.parseExcelByStream((InputStream)byteArrayInputStream, PmDistributeUserDomain.class, stringStringHashMap);
            if (ListUtil.isNotEmpty((Collection)lists)) {
                List pmDistributeUserReDomains = (List)lists.get(0);
                int line = 1;
                HashMap<String, Integer> PhoneMap = new HashMap<String, Integer>();
                for (PmDistributeUserDomain pmDistributeUserReDomain : pmDistributeUserReDomains) {
                    String userinfoPhone = pmDistributeUserReDomain.getUserinfoPhone();
                    if (PhoneMap.containsKey(userinfoPhone)) {
                        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7b2c" + String.valueOf(line) + "\u884c\u624b\u673a\u53f7" + userinfoPhone + "\u4e0e\u7b2c" + ((Integer)PhoneMap.get(userinfoPhone)).toString() + "\u884c\u91cd\u590d");
                    }
                    PhoneMap.put(userinfoPhone, line);
                    UmUserReDomainBean userByUserPhone = this.userServiceRepository.getUserByUserPhone(userinfoPhone, this.getTenantCode(request));
                    if (userByUserPhone == null) {
                        return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7b2c" + String.valueOf(line) + "\u884c\u624b\u673a\u53f7" + userinfoPhone + "\u4e0d\u5b58\u5728");
                    }
                    ++line;
                }
            }
        }
        return new HtmlJsonReBean((Object)"\u6210\u529f");
    }

    @RequestMapping(value={"saveDistribute.json"}, name="\u589e\u52a0\u53d1\u5238\u6d3b\u52a8\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean saveDistribute(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveDistribute", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "paramStr\u53c2\u6570\u4e3a\u7a7a");
        }
        PmDistributeDomain pmDistributeDomain = (PmDistributeDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, PmDistributeDomain.class);
        if (null == pmDistributeDomain) {
            this.logger.error(CODE + ".saveDistribute", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (ListUtil.isEmpty((Collection)pmDistributeDomain.getPmDistributeCouponList())) {
            this.logger.error(CODE + ".saveDistribute", (Object)"\u4f18\u60e0\u5238\u4e3a\u7a7a");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u4f18\u60e0\u5238\u4e3a\u7a7a");
        }
        if (pmDistributeDomain.getDistributeType() == 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("userinfoQuality", "dealer");
            param.put("userinfoBtateBlak", 0);
            param.put("order", true);
            param.put("fuzzy", true);
            SupQueryResult umUserinfoReDomainBeanSupQueryResult = this.userServiceRepository.queryUserinfoPage(param);
            List umUserinfoList = umUserinfoReDomainBeanSupQueryResult.getList();
            if (ListUtil.isNotEmpty((Collection)umUserinfoList)) {
                List<PmDistributeUserReDomain> pmDistributeUser = this.createPmDistributeUser(umUserinfoList);
                pmDistributeDomain.setPmDistributeUserList(pmDistributeUser);
                pmDistributeDomain.setUserNum(Integer.valueOf(pmDistributeUser.size()));
            }
        } else if (pmDistributeDomain.getDistributeType() == 1) {
            if (ListUtil.isNotEmpty((Collection)pmDistributeDomain.getPmDistributeUserList())) {
                pmDistributeDomain.setUserNum(Integer.valueOf(pmDistributeDomain.getPmDistributeUserList().size()));
            } else if (StringUtils.isNotBlank((String)pmDistributeDomain.getUserFile())) {
                List<PmDistributeUserReDomain> pmDistributeUser = this.createPmDistributeUserByFile(pmDistributeDomain.getUserFile(), this.getTenantCode(request));
                pmDistributeDomain.setPmDistributeUserList(pmDistributeUser);
                pmDistributeDomain.setUserNum(Integer.valueOf(pmDistributeUser.size()));
            }
        }
        if (ListUtil.isEmpty((Collection)pmDistributeDomain.getPmDistributeUserList())) {
            this.logger.error(CODE + ".saveDistribute", (Object)"user\u4e3a\u7a7a");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "user\u4e3a\u7a7a");
        }
        pmDistributeDomain.setTenantCode(this.getTenantCode(request));
        return this.pmDistributeServiceRepository.saveDistribute(pmDistributeDomain);
    }

    private List<PmDistributeUserReDomain> createPmDistributeUserByFile(String userFile, String tenant) {
        String fileCode = userFile.substring(userFile.lastIndexOf("/") + 1, userFile.lastIndexOf("."));
        FmFileReDomainBean fileByCode = this.fileServiceRepository.getFileByCode(fileCode, tenant);
        if (fileByCode != null) {
            HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
            stringStringHashMap.put("userinfoPhone", "\u624b\u673a\u53f7");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileByCode.getFileContext());
            List lists = ExcelReaderUtils.parseExcelByStream((InputStream)byteArrayInputStream, PmDistributeUserReDomain.class, stringStringHashMap);
            if (ListUtil.isNotEmpty((Collection)lists)) {
                List pmDistributeUserReDomains = (List)lists.get(0);
                for (PmDistributeUserDomain pmDistributeUserReDomain : pmDistributeUserReDomains) {
                    String userinfoPhone = pmDistributeUserReDomain.getUserinfoPhone();
                    UmUserReDomainBean userByUserPhone = this.userServiceRepository.getUserByUserPhone(userinfoPhone, tenant);
                    if (userByUserPhone == null) continue;
                    pmDistributeUserReDomain.setUserinfoCode(userByUserPhone.getUserPcode());
                    pmDistributeUserReDomain.setUserName(userByUserPhone.getUserRelname());
                }
                return pmDistributeUserReDomains;
            }
        }
        return new ArrayList<PmDistributeUserReDomain>();
    }

    private List<PmDistributeUserReDomain> createPmDistributeUser(List<UmUserinfoReDomainBean> umUserinfoList) {
        ArrayList<PmDistributeUserReDomain> pmDistributeUserList = new ArrayList<PmDistributeUserReDomain>();
        for (UmUserinfoReDomainBean umUserinfoReDomainBean : umUserinfoList) {
            PmDistributeUserReDomain pmDistributeUserReDomain = new PmDistributeUserReDomain();
            pmDistributeUserReDomain.setUserinfoCode(umUserinfoReDomainBean.getUserinfoCode());
            pmDistributeUserReDomain.setUserinfoPhone(umUserinfoReDomainBean.getUserinfoPhone());
            pmDistributeUserReDomain.setUserName(umUserinfoReDomainBean.getUserinfoCompname());
            pmDistributeUserList.add(pmDistributeUserReDomain);
        }
        return pmDistributeUserList;
    }

    @RequestMapping(value={"getDistribute.json"}, name="\u83b7\u53d6\u53d1\u5238\u6d3b\u52a8\u8bbe\u7f6e\u4fe1\u606f")
    @ResponseBody
    public PmDistributeReDomain getDistribute(Integer distributeId) {
        if (StringUtils.isBlank((Integer)distributeId)) {
            this.logger.error(CODE + ".getDistribute", (Object)"param is null");
            return null;
        }
        PmDistributeReDomain distribute = this.pmDistributeServiceRepository.getDistribute(distributeId);
        return distribute;
    }

    @RequestMapping(value={"updateDistribute.json"}, name="\u66f4\u65b0\u53d1\u5238\u6d3b\u52a8\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean updateDistribute(HttpServletRequest request, PmDistributeDomain pmDistributeDomain) {
        if (null == pmDistributeDomain) {
            this.logger.error(CODE + ".updateDistribute", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        pmDistributeDomain.setTenantCode(this.getTenantCode(request));
        return this.pmDistributeServiceRepository.updateDistribute(pmDistributeDomain);
    }

    @RequestMapping(value={"deleteDistribute.json"}, name="\u5220\u9664\u53d1\u5238\u6d3b\u52a8\u8bbe\u7f6e")
    @ResponseBody
    public HtmlJsonReBean deleteDistribute(Integer distributeId) {
        if (StringUtils.isBlank((Integer)distributeId)) {
            this.logger.error(CODE + ".deleteDistribute", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmDistributeServiceRepository.deleteDistribute(distributeId);
    }

    @RequestMapping(value={"queryDistributePage.json"}, name="\u67e5\u8be2\u53d1\u5238\u6d3b\u52a8\u8bbe\u7f6e\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<PmDistributeReDomain> queryDistributePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.pmDistributeServiceRepository.queryDistributePage(param);
    }

    @RequestMapping(value={"updateDistributeState.json"}, name="\u64a4\u92b7\u53d1\u5238\u6d3b\u52a8")
    @ResponseBody
    public HtmlJsonReBean updateDistributeState(HttpServletRequest request, String distributeCode, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)distributeCode)) {
            this.logger.error(CODE + ".updateDistributeState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.pmDistributeServiceRepository.updateDistributeStateByCode(this.getTenantCode(request), distributeCode, Integer.valueOf(2), oldDataState, null);
    }
}

