/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.qa.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.dd.domain.DdFalgSettingReDomain;
import com.qjsoft.laser.controller.facade.dd.repository.DdFalgSettingServiceRepository;
import com.qjsoft.laser.controller.facade.qa.domain.QaBugDomainBean;
import com.qjsoft.laser.controller.facade.qa.domain.QaBugReDomainBean;
import com.qjsoft.laser.controller.facade.qa.domain.QaBuglistDomainBean;
import com.qjsoft.laser.controller.facade.qa.repository.BugServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/qa/bug"}, name="\u95ee\u7b54")
public class BugCon
extends SpringmvcController {
    private static String CODE = "qa.bug.con";
    @Autowired
    private BugServiceRepository bugServiceRepository;
    @Autowired
    private DdFalgSettingServiceRepository ddFalgSettingServiceRepository;

    protected String getContext() {
        return "bug";
    }

    @RequestMapping(value={"saveBug.json"}, name="\u589e\u52a0\u95ee\u7b54")
    @ResponseBody
    public HtmlJsonReBean saveBug(HttpServletRequest request, QaBugDomainBean qaBugDomainBean) {
        if (null == qaBugDomainBean) {
            this.logger.error(CODE + ".saveBug", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveBug", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        qaBugDomainBean.setTenantCode(this.getTenantCode(request));
        qaBugDomainBean.setUserCode(userSession.getUserCode());
        qaBugDomainBean.setUserName(userSession.getUserName());
        return this.bugServiceRepository.saveBug(qaBugDomainBean);
    }

    @RequestMapping(value={"getBug.json"}, name="\u83b7\u53d6\u95ee\u7b54\u4fe1\u606f")
    @ResponseBody
    public QaBugReDomainBean getBug(Integer bugId) {
        if (StringUtils.isBlank((Integer)bugId)) {
            this.logger.error(CODE + ".getBug", (Object)"param is null");
            return null;
        }
        return this.bugServiceRepository.getBug(bugId);
    }

    @RequestMapping(value={"updateBug.json"}, name="\u66f4\u65b0\u95ee\u7b54")
    @ResponseBody
    public HtmlJsonReBean updateBug(HttpServletRequest request, QaBugDomainBean qaBugDomainBean) {
        if (null == qaBugDomainBean) {
            this.logger.error(CODE + ".updateBug", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        qaBugDomainBean.setTenantCode(this.getTenantCode(request));
        return this.bugServiceRepository.updateBug(qaBugDomainBean);
    }

    @RequestMapping(value={"deleteBug.json"}, name="\u5220\u9664\u95ee\u7b54")
    @ResponseBody
    public HtmlJsonReBean deleteBug(Integer bugId) {
        if (StringUtils.isBlank((Integer)bugId)) {
            this.logger.error(CODE + ".deleteBug", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.bugServiceRepository.deleteBug(bugId);
    }

    @RequestMapping(value={"queryBugPage.json"}, name="\u67e5\u8be2\u95ee\u7b54\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<QaBugReDomainBean> queryBugPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.bugServiceRepository.queryBugPage(param);
    }

    @RequestMapping(value={"updateBugState.json"}, name="\u66f4\u65b0\u95ee\u7b54\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateBugState(String bugId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)bugId)) {
            this.logger.error(CODE + ".updateBugState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.bugServiceRepository.updateBugState(Integer.valueOf(bugId), dataState, oldDataState);
    }

    @RequestMapping(value={"replyBug.json"}, name="\u95ee\u7b54\u95ee\u9898")
    @ResponseBody
    public HtmlJsonReBean replyBug(HttpServletRequest request, QaBuglistDomainBean qaBuglistDomainBean) {
        if (null == qaBuglistDomainBean) {
            this.logger.error(CODE + ".replyBug", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        qaBuglistDomainBean.setTenantCode(this.getTenantCode(request));
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveBug", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        qaBuglistDomainBean.setUserCode(userSession.getUserCode());
        qaBuglistDomainBean.setUserName(userSession.getUserName());
        return this.bugServiceRepository.replyBug(qaBuglistDomainBean, Integer.valueOf(1), Integer.valueOf(0));
    }

    @RequestMapping(value={"queryBugPageYY.json"}, name="\u8fd0\u8425\u7aef\u67e5\u8be2\u95ee\u7b54\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<QaBugReDomainBean> queryBugPageYY(HttpServletRequest request) {
        SupQueryResult qaBugReDomainBeanList;
        List qaBugReDomainBeanS;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null != (qaBugReDomainBeanS = (qaBugReDomainBeanList = this.bugServiceRepository.queryBugPage(param)).getList()) && qaBugReDomainBeanS.size() > 0) {
            for (QaBugReDomainBean qaBugReDomainBean : qaBugReDomainBeanS) {
                DdFalgSettingReDomain ddFalgSettingReDomain;
                if (null != qaBugReDomainBean.getBugSort()) {
                    ddFalgSettingReDomain = this.ddFalgSettingServiceRepository.getFalgSetting(qaBugReDomainBean.getBugSort());
                    String one = null;
                    if (null != ddFalgSettingReDomain) {
                        one = ddFalgSettingReDomain.getFlagSettingInfo();
                    }
                    qaBugReDomainBean.setOne(one);
                }
                if (null == qaBugReDomainBean.getBugType()) continue;
                ddFalgSettingReDomain = this.ddFalgSettingServiceRepository.getFalgSetting(qaBugReDomainBean.getBugSort());
                String two = null;
                if (null != ddFalgSettingReDomain) {
                    two = ddFalgSettingReDomain.getFlagSettingInfo();
                }
                qaBugReDomainBean.setOne(two);
            }
        }
        return qaBugReDomainBeanList;
    }

    @RequestMapping(value={"getBugYY.json"}, name="\u8fd0\u8425\u7aef\u67e5\u770b\u95ee\u9898\u8be6\u60c5")
    @ResponseBody
    public QaBugReDomainBean getBugYY(Integer bugId) {
        if (StringUtils.isBlank((Integer)bugId)) {
            this.logger.error(CODE + ".getBugYY", (Object)"bugId is null");
            return null;
        }
        QaBugReDomainBean qaBugReDomainBean = this.bugServiceRepository.getBug(bugId);
        HashMap<String, Object> bugListMap = new HashMap<String, Object>();
        bugListMap.put("bugId", bugId);
        bugListMap.put("tenantCode", qaBugReDomainBean.getTenantCode());
        List qaBuglistDomainBeanList = this.bugServiceRepository.queryBuglist(bugListMap);
        qaBugReDomainBean.setBugList(qaBuglistDomainBeanList);
        return qaBugReDomainBean;
    }

    @RequestMapping(value={"saveBugListYY.json"}, name="\u8fd0\u8425\u7aef\u7b54\u590d")
    @ResponseBody
    public HtmlJsonReBean saveBugListYY(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveBugListYY", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        QaBuglistDomainBean qaBuglistDomainBean = (QaBuglistDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, QaBuglistDomainBean.class);
        qaBuglistDomainBean.setUserCode(userSession.getUserPcode());
        qaBuglistDomainBean.setUserName(userSession.getUserName());
        qaBuglistDomainBean.setTenantCode(this.getTenantCode(request));
        return this.bugServiceRepository.replyBug(qaBuglistDomainBean, Integer.valueOf(1), Integer.valueOf(0));
    }

    @RequestMapping(value={"updateShowYY.json"}, name="\u8fd0\u8425\u7aef\u662f\u5426\u5c55\u793a")
    @ResponseBody
    public HtmlJsonReBean updateShowYY(Integer bugId, Integer bugShow, Integer oldDataState) {
        if (null == bugId) {
            this.logger.error(CODE + ".updateShowYY", (Object)"bugId is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.bugServiceRepository.updateBugShowById(bugId, bugShow, oldDataState);
    }

    @RequestMapping(value={"getBugPageWAP.json"}, name="wap\u7aef\u67e5\u770b\u95ee\u7b54\u5217\u8868")
    @ResponseBody
    public SupQueryResult<QaBugReDomainBean> getBugPageWAP(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.put("bugShow", 0);
        return this.bugServiceRepository.queryBugPage(param);
    }

    @RequestMapping(value={"getBugPageMy.json"}, name="wap\u7aef\u67e5\u770b\u6211\u7684\u95ee\u7b54")
    @ResponseBody
    public SupQueryResult<QaBugReDomainBean> getBugPageMy(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        UserSession userSession = this.getUserSession(request);
        param.put("userCode", userSession.getUserPcode());
        SupQueryResult qaBugReDomainBeanList = this.bugServiceRepository.queryBugPage(param);
        List qaBugReDomainBeanS = qaBugReDomainBeanList.getList();
        if (null != qaBugReDomainBeanS && qaBugReDomainBeanS.size() > 0) {
            for (QaBugReDomainBean qaBugReDomainBean : qaBugReDomainBeanS) {
                DdFalgSettingReDomain ddFalgSettingReDomain;
                if (null != qaBugReDomainBean.getBugSort()) {
                    ddFalgSettingReDomain = this.ddFalgSettingServiceRepository.getFalgSetting(qaBugReDomainBean.getBugSort());
                    String one = null;
                    if (null != ddFalgSettingReDomain) {
                        one = ddFalgSettingReDomain.getFlagSettingInfo();
                    }
                    qaBugReDomainBean.setOne(one);
                }
                if (null == qaBugReDomainBean.getBugType()) continue;
                ddFalgSettingReDomain = this.ddFalgSettingServiceRepository.getFalgSetting(qaBugReDomainBean.getBugSort());
                String two = null;
                if (null != ddFalgSettingReDomain) {
                    two = ddFalgSettingReDomain.getFlagSettingInfo();
                }
                qaBugReDomainBean.setOne(two);
            }
        }
        return qaBugReDomainBeanList;
    }

    @RequestMapping(value={"saveBugWAP.json"}, name="wap\u7aef\u63d0\u51fa\u95ee\u9898")
    @ResponseBody
    public HtmlJsonReBean saveBugWAP(HttpServletRequest request, String paramStr) {
        if (StringUtils.isEmpty((String)paramStr)) {
            this.logger.error(CODE + ".saveBugWAP", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        QaBugDomainBean qaBugDomainBean = (QaBugDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, QaBugDomainBean.class);
        UserSession userSession = this.getUserSession(request);
        qaBugDomainBean.setBugQq(userSession.getUserQq());
        qaBugDomainBean.setBugEmail(userSession.getUserEmial());
        qaBugDomainBean.setBugTel(userSession.getUserTel());
        qaBugDomainBean.setBugShow(Integer.valueOf(0));
        qaBugDomainBean.setBugDir(Integer.valueOf(0));
        qaBugDomainBean.setUserCode(userSession.getUserPcode());
        qaBugDomainBean.setUserName(userSession.getUserName());
        qaBugDomainBean.setTenantCode(this.getTenantCode(request));
        return this.bugServiceRepository.saveBug(qaBugDomainBean);
    }

    @RequestMapping(value={"queryDictionarieOne.json"}, name="\u67e5\u770b\u4e00\u7ea7\u5206\u7c7b")
    @ResponseBody
    public SupQueryResult<DdFalgSettingReDomain> queryDictionarieOne() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flagSettingScope", "qa_");
        map.put("fuzzy", true);
        return this.ddFalgSettingServiceRepository.queryFalgSettingPage(map);
    }

    @RequestMapping(value={"queryDictionarieTwo.json"}, name="\u67e5\u770b\u4e8c\u7ea7\u5206\u7c7b")
    @ResponseBody
    public SupQueryResult<DdFalgSettingReDomain> queryDictionarieTwo(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        return this.ddFalgSettingServiceRepository.queryFalgSettingPage(param);
    }
}

