/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.qt.controller;

import cn.hutool.core.util.IdUtil;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.qt.domain.QtRecruitCompanyDomain;
import com.qjsoft.laser.controller.facade.qt.domain.QtRecruitCompanyReDomain;
import com.qjsoft.laser.controller.facade.qt.repository.QtRecruitCompanyServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/qt/recruitCompany"}, name="\u62db\u8058\u516c\u53f8\u670d\u52a1")
public class QtRecruitCompanyCon
extends SpringmvcController {
    private static String CODE = "qt.recruitCompany.con";
    @Autowired
    private QtRecruitCompanyServiceRepository qtRecruitCompanyServiceRepository;

    protected String getContext() {
        return "recruitCompany";
    }

    @RequestMapping(value={"saveRecruitCompany.json"}, name="\u589e\u52a0\u62db\u8058\u516c\u53f8\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRecruitCompany(HttpServletRequest request, QtRecruitCompanyDomain qtRecruitCompanyDomain) {
        if (null == qtRecruitCompanyDomain) {
            this.logger.error(CODE + ".saveRecruitCompany", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        qtRecruitCompanyDomain.setTenantCode(this.getTenantCode(request));
        this.makeParam(request, qtRecruitCompanyDomain);
        return this.qtRecruitCompanyServiceRepository.saverecruitCompany(qtRecruitCompanyDomain);
    }

    private void makeParam(HttpServletRequest request, QtRecruitCompanyDomain qtRecruitCompanyDomain) {
        UserSession userSession = this.getUserSession(request);
        qtRecruitCompanyDomain.setRecruitCompanyCode(this.getSnowflakeId());
        qtRecruitCompanyDomain.setUserCode(userSession.getUserCode());
        qtRecruitCompanyDomain.setUserName(userSession.getUserName());
    }

    public synchronized String getSnowflakeId() {
        return String.valueOf(IdUtil.getSnowflake((long)1L, (long)1L).nextId());
    }

    @RequestMapping(value={"getRecruitCompany.json"}, name="\u83b7\u53d6\u62db\u8058\u516c\u53f8\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public QtRecruitCompanyReDomain getRecruitCompany(Integer recruitCompanyId) {
        if (StringUtils.isBlank((Integer)recruitCompanyId)) {
            this.logger.error(CODE + ".getRecruitCompany", (Object)"param is null");
            return null;
        }
        return this.qtRecruitCompanyServiceRepository.getrecruitCompany(recruitCompanyId);
    }

    @RequestMapping(value={"updateRecruitCompany.json"}, name="\u66f4\u65b0\u62db\u8058\u516c\u53f8\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRecruitCompany(HttpServletRequest request, QtRecruitCompanyDomain qtRecruitCompanyDomain) {
        if (null == qtRecruitCompanyDomain) {
            this.logger.error(CODE + ".updateRecruitCompany", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        qtRecruitCompanyDomain.setTenantCode(this.getTenantCode(request));
        return this.qtRecruitCompanyServiceRepository.updaterecruitCompany(qtRecruitCompanyDomain);
    }

    @RequestMapping(value={"deleteRecruitCompany.json"}, name="\u5220\u9664\u62db\u8058\u516c\u53f8\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRecruitCompany(Integer recruitCompanyId) {
        if (StringUtils.isBlank((Integer)recruitCompanyId)) {
            this.logger.error(CODE + ".deleteRecruitCompany", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.qtRecruitCompanyServiceRepository.deleterecruitCompany(recruitCompanyId);
    }

    @RequestMapping(value={"queryRecruitCompanyPage.json"}, name="\u67e5\u8be2\u62db\u8058\u516c\u53f8\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<QtRecruitCompanyReDomain> queryRecruitCompanyPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.qtRecruitCompanyServiceRepository.queryrecruitCompanyPage(param);
    }

    @RequestMapping(value={"updateRecruitCompanyState.json"}, name="\u66f4\u65b0\u62db\u8058\u516c\u53f8\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRecruitCompanyState(String recruitCompanyId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)recruitCompanyId)) {
            this.logger.error(CODE + ".updateRecruitCompanyState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.qtRecruitCompanyServiceRepository.updaterecruitCompanyState(Integer.valueOf(recruitCompanyId), dataState, oldDataState, null);
    }
}

