/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.qt.controller;

import com.qjsoft.laser.controller.common.util.ExportExcelUtlis;
import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.qt.domain.QtQuestproOptionDomain;
import com.qjsoft.laser.controller.facade.qt.domain.QtQuesttempListReDomain;
import com.qjsoft.laser.controller.facade.qt.domain.QtQuesttempReDomain;
import com.qjsoft.laser.controller.facade.qt.domain.QtQuestuserDomain;
import com.qjsoft.laser.controller.facade.qt.domain.QtQuestuserReDomain;
import com.qjsoft.laser.controller.facade.qt.domain.QtQuestuserValueDomain;
import com.qjsoft.laser.controller.facade.qt.domain.QtQuestuserValueReDomain;
import com.qjsoft.laser.controller.facade.qt.repository.QtQuesttempServiceRepository;
import com.qjsoft.laser.controller.facade.qt.repository.QtQuestuserServiceRepository;
import com.qjsoft.laser.controller.qt.qtexceltemplate.ExcelExportTemplate;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/qt/Questuser"}, name="\u7528\u6237\u6570\u636e\u670d\u52a1")
public class QuestuserCon
extends SpringmvcController {
    private static String CODE = "qt.Questuser.con";
    @Autowired
    private QtQuestuserServiceRepository qtQuestuserServiceRepository;
    @Autowired
    private QtQuesttempServiceRepository qtQuesttempServiceRepository;

    protected String getContext() {
        return "Questuser";
    }

    @RequestMapping(value={"saveQuestuser.json"}, name="\u589e\u52a0\u7528\u6237\u6570\u636e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveQuestuser(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveQuestuser", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "userSession");
        }
        QtQuestuserDomain qtQuestuserDomain = (QtQuestuserDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, QtQuestuserDomain.class);
        if (StringUtils.isBlank((String)qtQuestuserDomain.getQuesttempCode())) {
            this.logger.error(CODE + ".saveQuest.questtempCode", (Object)"questtempCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "questtempCode is null");
        }
        String tenantCode = this.getTenantCode(request);
        QtQuesttempReDomain qtQuesttempReDomain = this.qtQuesttempServiceRepository.getQuesttempByCode(tenantCode, qtQuestuserDomain.getQuesttempCode());
        if (null == qtQuesttempReDomain) {
            this.logger.error(CODE + ".saveQuest.qtQuesttempReDomain", (Object)"qtQuesttempReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "qtQuesttempReDomain is null");
        }
        qtQuestuserDomain.setMemberBcode(qtQuesttempReDomain.getMemberBcode());
        qtQuestuserDomain.setMemberBname(qtQuesttempReDomain.getMemberBname());
        qtQuestuserDomain.setTenantCode(tenantCode);
        qtQuestuserDomain.setMemberCode(userSession.getUserPcode());
        qtQuestuserDomain.setMemberName(userSession.getMerberCompname());
        qtQuestuserDomain.setAppmanageIcode(userSession.getUserPhone());
        qtQuestuserDomain.setUserCode(userSession.getUserPhone());
        qtQuestuserDomain.setUserName(userSession.getUserName());
        return this.qtQuestuserServiceRepository.saveQuestuser(qtQuestuserDomain);
    }

    @RequestMapping(value={"getQuestuser.json"}, name="\u83b7\u53d6\u7528\u6237\u6570\u636e\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public QtQuestuserReDomain getQuestuser(Integer questuserId) {
        if (StringUtils.isBlank((Integer)questuserId)) {
            this.logger.error(CODE + ".getQuestuser", (Object)"param is null");
            return null;
        }
        return this.qtQuestuserServiceRepository.getQuestuser(questuserId);
    }

    @RequestMapping(value={"updateQuestuser.json"}, name="\u66f4\u65b0\u7528\u6237\u6570\u636e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateQuestuser(HttpServletRequest request, QtQuestuserDomain qtQuestuserDomain) {
        if (null == qtQuestuserDomain) {
            this.logger.error(CODE + ".updateQuestuser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        qtQuestuserDomain.setTenantCode(this.getTenantCode(request));
        return this.qtQuestuserServiceRepository.updateQuestuser(qtQuestuserDomain);
    }

    @RequestMapping(value={"updateQuestValue.json"}, name="\u66f4\u65b0\u7528\u6237\u586b\u5199\u4fe1\u606f")
    @ResponseBody
    public HtmlJsonReBean updateQuestValue(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".updateQuestValue", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        HtmlJsonReBean htmlJsonReBean = null;
        try {
            UserSession userSession = this.getUserSession(request);
            String tenantCode = this.getTenantCode(request);
            QtQuestuserDomain qtQuestuserDomain = (QtQuestuserDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, QtQuestuserDomain.class);
            this.logger.info("updateQuestValue.qtQuestuserDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)qtQuestuserDomain));
            if (qtQuestuserDomain.getQtQuestuserValueDomainList().size() == 0) {
                this.logger.error(CODE + ".saveQuest.qtQuestuserValueDomainList", (Object)"qtQuestuserValueDomainList is null");
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "qtQuestuserValueDomainList is null");
            }
            List qtQuestuserValueDomainList = qtQuestuserDomain.getQtQuestuserValueDomainList();
            for (QtQuestuserValueDomain valueDomain : qtQuestuserValueDomainList) {
                valueDomain.setTenantCode(tenantCode);
                htmlJsonReBean = this.qtQuestuserServiceRepository.updateQuestuserValue(valueDomain);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getMessage();
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"deleteQuestuser.json"}, name="\u5220\u9664\u7528\u6237\u6570\u636e\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteQuestuser(Integer questuserId) {
        if (StringUtils.isBlank((Integer)questuserId)) {
            this.logger.error(CODE + ".deleteQuestuser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.qtQuestuserServiceRepository.deleteQuestuser(questuserId);
    }

    @RequestMapping(value={"queryQuestuserPage.json"}, name="\u67e5\u8be2\u7528\u6237\u6570\u636e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<QtQuestuserReDomain> queryQuestuserPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        SupQueryResult qtQuestuserReDomainSupQueryResult = this.qtQuestuserServiceRepository.queryQuestuserPage(param);
        ArrayList<QtQuestuserReDomain> data = new ArrayList<QtQuestuserReDomain>();
        if (qtQuestuserReDomainSupQueryResult.getList().size() > 0) {
            List list = qtQuestuserReDomainSupQueryResult.getList();
            for (QtQuestuserReDomain qtQuestuserReDomain : list) {
                String questtempCode = qtQuestuserReDomain.getQuesttempCode();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("questtempCode", questtempCode);
                map.put("tenantCode", this.getTenantCode(request));
                SupQueryResult qtQuesttempReDomainSupQueryResult = this.qtQuesttempServiceRepository.queryQuesttempPage(map);
                if (qtQuesttempReDomainSupQueryResult.getList().size() > 0) {
                    QtQuesttempReDomain qtQuesttempReDomain = (QtQuesttempReDomain)qtQuesttempReDomainSupQueryResult.getList().get(0);
                    qtQuestuserReDomain.setQtQuesttempReDomain(qtQuesttempReDomain);
                    Date gmtCreate = qtQuesttempReDomain.getQuesttempStart();
                    Date questtempEnd = qtQuesttempReDomain.getQuesttempEnd();
                    String memo = "\u672a\u77e5";
                    long now = new Date().getTime();
                    if (gmtCreate != null && questtempEnd != null) {
                        if (now < gmtCreate.getTime()) {
                            memo = "\u672a\u5f00\u59cb";
                        } else if (now > gmtCreate.getTime() && now < questtempEnd.getTime()) {
                            memo = "\u8fdb\u884c\u4e2d";
                        } else if (now > questtempEnd.getTime()) {
                            memo = "\u5df2\u7ed3\u675f";
                        }
                    }
                    String nows = new Long(new Date().getTime()).toString();
                    qtQuesttempReDomain.setQuesttempContext(nows);
                    qtQuesttempReDomain.setMemo(memo);
                    qtQuestuserReDomain.setQtQuesttempReDomain(qtQuesttempReDomain);
                }
                data.add(qtQuestuserReDomain);
            }
        }
        qtQuestuserReDomainSupQueryResult.setList(data);
        return qtQuestuserReDomainSupQueryResult;
    }

    @RequestMapping(value={"exportQuestuserPage.json"}, name="\u5bfc\u51fa\u7528\u6237\u6570\u636e\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public void exportQuestuserPage(HttpServletRequest request, HttpServletResponse response) {
        SupQueryResult<QtQuestuserReDomain> qtQuestuserReDomainSupQueryResult = this.queryQuestuserPage(request);
        if (qtQuestuserReDomainSupQueryResult.getList().size() > 0) {
            List list = qtQuestuserReDomainSupQueryResult.getList();
            ArrayList<QtQuestuserReDomain> data = new ArrayList<QtQuestuserReDomain>();
            String strDateFormat = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat sdf = new SimpleDateFormat(strDateFormat);
            for (QtQuestuserReDomain qtQuestuserReDomain : list) {
                Date gmtCreate = qtQuestuserReDomain.getGmtCreate();
                if (gmtCreate != null) {
                    String start = sdf.format(gmtCreate);
                    qtQuestuserReDomain.setChannelCode(start);
                }
                String questtempCode = qtQuestuserReDomain.getQuesttempCode();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("questtempCode", questtempCode);
                map.put("tenantCode", this.getTenantCode(request));
                SupQueryResult qtQuesttempReDomainSupQueryResult = this.qtQuesttempServiceRepository.queryQuesttempPage(map);
                String memo = "\u672a\u77e5";
                if (qtQuesttempReDomainSupQueryResult.getList().size() > 0) {
                    QtQuesttempReDomain qtQuesttempReDomain = (QtQuesttempReDomain)qtQuesttempReDomainSupQueryResult.getList().get(0);
                    Date gmtCreates = qtQuesttempReDomain.getQuesttempStart();
                    Date questtempEnds = qtQuesttempReDomain.getQuesttempEnd();
                    long now = new Date().getTime();
                    if (gmtCreates != null && questtempEnds != null) {
                        if (now < gmtCreates.getTime()) {
                            memo = "\u672a\u5f00\u59cb";
                        } else if (now > gmtCreates.getTime() && now < questtempEnds.getTime()) {
                            memo = "\u8fdb\u884c\u4e2d";
                        } else if (now > questtempEnds.getTime()) {
                            memo = "\u5df2\u7ed3\u675f";
                        }
                    }
                }
                qtQuestuserReDomain.setAppmanageIcode(memo);
                Integer dataState = qtQuestuserReDomain.getDataState();
                String state = "";
                if (dataState != null) {
                    if (dataState == 0) {
                        state = "\u8fdb\u884c\u4e2d";
                    } else if (dataState == 1) {
                        state = "\u5df2\u53d6\u6d88";
                    }
                }
                qtQuestuserReDomain.setProappCode(state);
                data.add(qtQuestuserReDomain);
            }
            this.queryContractPageComHy(request, null, null, data, response);
        }
    }

    protected void queryContractPageComHy(HttpServletRequest request, String fileName, Map<String, Object> param, List<QtQuestuserReDomain> list, HttpServletResponse response) {
        this.logger.info("\u8fdb\u5165queryContractPageComHy===========");
        this.logger.info("\u8fdb\u5165queryContractPageComHy====a=======");
        String excelTemplate = "";
        this.logger.info("\u8fdb\u5165queryContractPageComHy====b=======");
        this.logger.info("\u8fdb\u5165queryContractPageComHy====c=======");
        this.logger.info("\u8fdb\u5165queryContractPageComHy====b=======");
        if (StringUtils.isBlank((String)fileName)) {
            fileName = "\u79ef\u5206\u5217\u8868";
        }
        UserSession userSession = this.getUserSession(request);
        this.logger.info("\u8fdb\u5165queryContractPageComHy====e=======");
        String userCode = null == userSession ? "" : userSession.getUserCode();
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        this.logger.info("\u8fdb\u5165queryContractPageComHy====f=======");
        infoMap.put("headMap", ExcelExportTemplate.covertOrderPointsExcels());
        excelTemplate = "xs";
        fileName = "\u79ef\u5206\u5217\u8868";
        this.logger.info("\u8fdb\u5165queryContractPageComHy====g=======");
        infoMap.put("userCode", userCode);
        infoMap.put("fileName", fileName);
        try {
            this.logger.info("\u8fdb\u5165queryContractPageComHy====h=======");
            this.exportComExcels(request, param, infoMap, excelTemplate, list, response);
        }
        catch (Exception e) {
            this.logger.error(CODE + ".queryContractPageComHy.exportExcel", (Object)"\u5bfc\u51fa\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportComExcels(HttpServletRequest request, Map<String, Object> paramMap, Map<String, Object> infoMap, String excelTemplate, List<QtQuestuserReDomain> list, HttpServletResponse response) {
        List headMapList;
        String startDate;
        this.logger.info("\u8fdb\u5165exportComExcels=====================");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        this.logger.info("\u8fdb\u5165exportComExcels===========a==========");
        long timeMillis = System.currentTimeMillis();
        String formatData = sdf.format(timeMillis);
        this.logger.info("\u8fdb\u5165exportComExcels=========b============");
        String fileName = null == infoMap.get("fileName") ? "" : (String)infoMap.get("fileName");
        this.logger.info("\u8fdb\u5165exportComExcels=========c============");
        String endDate = null == infoMap.get("endDate") ? "" : (String)infoMap.get("endDate");
        this.logger.info("\u8fdb\u5165exportComExcels=========d============");
        String string = startDate = null == infoMap.get("startDate") ? "" : (String)infoMap.get("startDate");
        if (StringUtils.isEmpty((String)excelTemplate) && excelTemplate.equals("lr")) {
            fileName = startDate + "-" + endDate + "-" + fileName;
            this.logger.info("\u8fdb\u5165exportComExcels====e=================");
        } else {
            fileName = formatData + "-" + fileName;
            this.logger.info("\u8fdb\u5165exportComExcels=======f==============");
        }
        this.logger.info("\u8fdb\u5165exportComExcels======11111111===============");
        ArrayList<String> excelHeader = new ArrayList<String>();
        Object headMap = infoMap.get("headMap");
        if (null == headMap) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMap", (Object)(" =:= " + infoMap));
        }
        if (ListUtil.isEmpty((Collection)(headMapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(headMap), Map.class)))) {
            this.logger.error("SpringmvnNewController.exportComExcel.headMapList", (Object)(" is null " + JsonUtil.buildNormalBinder().toJson(headMap)));
        }
        this.logger.info("\u8fdb\u5165exportComExcels======2222222===============");
        for (Map map : headMapList) {
            String showName = map.get("showName").toString();
            excelHeader.add(showName);
        }
        this.logger.info("\u8fdb\u5165exportComExcels======333333333===============", excelHeader);
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        HSSFRow row = sheet.createRow(0);
        for (short i = 0; i < headers.length; i = (short)(i + 1)) {
            HSSFCell cell = row.createCell(i);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
            HSSFCellStyle setBorder = workbook.createCellStyle();
            HSSFFont font = workbook.createFont();
            font.setFontName("\u4eff\u5b8b_GB2312");
            font.setFontHeightInPoints((short)10);
            font.setBoldweight((short)700);
            setBorder.setFont(font);
            cell.setCellStyle(setBorder);
        }
        boolean index = false;
        ArrayList<String[]> dataList = new ArrayList<String[]>();
        ArrayList<String> data = null;
        List<Map<String, Object>> fromDataList = this.getAllFields(list);
        this.logger.info("\u8fdb\u5165exportComExcels======4444444444===============", fromDataList);
        for (Map<String, Object> map : fromDataList) {
            data = new ArrayList<String>();
            for (Map map1 : headMapList) {
                String beanName = map1.get("dataName").toString();
                String value = "";
                if (StringUtils.isNotBlank((String)beanName)) {
                    String string2 = value = null == map.get(beanName) ? "" : String.valueOf(map.get(beanName));
                    if ("null".equals(value)) {
                        value = "";
                    }
                }
                data.add(value);
            }
            String[] array = data.toArray(new String[data.size()]);
            dataList.add(array);
            this.logger.info("\u8fdb\u5165exportComExcels======5555555===============", dataList);
        }
        try {
            ExportExcelUtlis.exportExcel((HSSFSheet)sheet, (HSSFRow)row, (String[])headers, dataList, (String)"yyyy-MM-dd HH:mm:ss", (int)0);
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.exportExcel", (Object)"Exception");
        }
        this.logger.info("\u8fdb\u5165exportComExcels======666666===============");
        String fileType = "xls";
        String tempPath = request.getSession().getServletContext().getRealPath("/") + "../../temp/" + fileName + "." + fileType;
        if (StringUtils.isBlank((String)tempPath)) {
            this.logger.error("SpringmvnNewController.exportComExcel.tempPath", (Object)tempPath);
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(tempPath);
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            this.logger.info("success=====================la");
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("content-Disposition", "attachment;filename=" + URLEncoder.encode("\u7ebf\u4e0b\u6d3b\u52a8\u7edf\u8ba1\u5217\u8868.xls", "utf-8"));
            response.setHeader("Access-Control-Expose-Headers", "content-Disposition");
            ServletOutputStream outputStreams = response.getOutputStream();
            workbook.write((OutputStream)outputStreams);
            outputStreams.flush();
            outputStreams.close();
            this.logger.info("success==========D:\\1.xls -----===========la");
        }
        catch (IOException e) {
            this.logger.error("SpringmvnNewController.exportComExcel.close", (Throwable)e);
        }
        finally {
            if (null != outputStream) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException e) {}
            }
        }
        byte[] bytes = null;
        try {
            bytes = ExportExcelUtlis.InputStreamByteArray((String)tempPath);
            this.logger.info("success==========bytes-----===========la");
        }
        catch (Exception e) {
            this.logger.error("SpringmvnNewController.exportComExcel.InputStreamByteArray", (Object)"Exception");
        }
    }

    public List<Map<String, Object>> getAllFields(List<QtQuestuserReDomain> list) {
        ArrayList<Map<String, Object>> datamap = new ArrayList<Map<String, Object>>();
        for (QtQuestuserReDomain cmChannelClearReDomain : list) {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            for (Class<?> clazz = cmChannelClearReDomain.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            }
            HashMap<String, String> maps = new HashMap<String, String>();
            this.logger.info("fieldList.size()-----------", (Object)fieldList.size());
            for (Field field : fieldList) {
                this.logger.info("field.getName()-----------", (Object)field.getName());
                if ("questtempName".equals(field.getName())) {
                    maps.put("questtempName", cmChannelClearReDomain.getQuesttempName());
                    continue;
                }
                if ("questtempCode".equals(field.getName())) {
                    maps.put("questtempCode", cmChannelClearReDomain.getQuesttempCode());
                    continue;
                }
                if ("channelCode".equals(field.getName())) {
                    maps.put("channelCode", cmChannelClearReDomain.getChannelCode());
                    continue;
                }
                if ("questtempPhone".equals(field.getName())) {
                    maps.put("questtempPhone", cmChannelClearReDomain.getQuesttempPhone());
                    continue;
                }
                if ("memberName".equals(field.getName())) {
                    maps.put("memberName", cmChannelClearReDomain.getMemberName());
                    continue;
                }
                if ("questtempAreaname".equals(field.getName())) {
                    maps.put("questtempAreaname", cmChannelClearReDomain.getQuesttempAreaname());
                    continue;
                }
                if ("appmanageIcode".equals(field.getName())) {
                    maps.put("appmanageIcode", cmChannelClearReDomain.getAppmanageIcode());
                    continue;
                }
                if ("proappCode".equals(field.getName())) {
                    maps.put("proappCode", cmChannelClearReDomain.getProappCode());
                    continue;
                }
                if (!"memo".equals(field.getName())) continue;
                maps.put("memo", cmChannelClearReDomain.getMemo());
            }
            datamap.add(maps);
            this.logger.info("datamap----------", datamap);
        }
        return datamap;
    }

    @RequestMapping(value={"queryQuestuserPageByUser.json"}, name="\u67e5\u8be2\u7528\u6237\u6570\u636e\u670d\u52a1\u5206\u9875\u5217\u8868\uff08\u7528\u6237\uff09")
    @ResponseBody
    public SupQueryResult<QtQuestuserReDomain> queryQuestuserPageByUser(HttpServletRequest request) {
        UserSession userSession;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null == (userSession = this.getUserSession(request))) {
            this.logger.error(CODE + ".saveQuest.userSession", (Object)"userSession is null");
            return null;
        }
        param.put("memberCode", userSession.getUserPcode());
        SupQueryResult result = this.qtQuestuserServiceRepository.queryQuestuserPage(param);
        List list = result.getList();
        if (null != list && list.size() > 0) {
            for (QtQuestuserReDomain qtQuestuserReDomain : list) {
                HashMap<String, String> param1 = new HashMap<String, String>();
                param1.put("questuserCode", qtQuestuserReDomain.getQuestuserCode());
                List list1 = this.qtQuestuserServiceRepository.queryQuestuserValuePage(param1).getList();
                qtQuestuserReDomain.setQtQuestuserValueReDomainList(list1);
            }
        }
        return result;
    }

    @RequestMapping(value={"updateQuestuserState.json"}, name="\u66f4\u65b0\u7528\u6237\u6570\u636e\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateQuestuserState(String questuserId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)questuserId)) {
            this.logger.error(CODE + ".updateQuestuserState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.qtQuestuserServiceRepository.updateQuestuserState(Integer.valueOf(questuserId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveQuestuserValue.json"}, name="\u589e\u52a0\u7528\u6237\u6570\u636e\u5bf9\u5e94\u503c\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveQuestuserValue(HttpServletRequest request, QtQuestuserValueDomain qtQuestuserValueDomain) {
        if (null == qtQuestuserValueDomain) {
            this.logger.error(CODE + ".saveQuestuserValue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        qtQuestuserValueDomain.setTenantCode(this.getTenantCode(request));
        return this.qtQuestuserServiceRepository.saveQuestuserValue(qtQuestuserValueDomain);
    }

    @RequestMapping(value={"getQuestuserValue.json"}, name="\u83b7\u53d6\u7528\u6237\u6570\u636e\u5bf9\u5e94\u503c\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public QtQuestuserValueReDomain getQuestuserValue(Integer questuserValueId) {
        if (StringUtils.isBlank((Integer)questuserValueId)) {
            this.logger.error(CODE + ".getQuestuserValue", (Object)"param is null");
            return null;
        }
        return this.qtQuestuserServiceRepository.getQuestuserValue(questuserValueId);
    }

    @RequestMapping(value={"updateQuestuserValue.json"}, name="\u66f4\u65b0\u7528\u6237\u6570\u636e\u5bf9\u5e94\u503c\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateQuestuserValue(HttpServletRequest request, QtQuestuserValueDomain qtQuestuserValueDomain) {
        if (null == qtQuestuserValueDomain) {
            this.logger.error(CODE + ".updateQuestuserValue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        qtQuestuserValueDomain.setTenantCode(this.getTenantCode(request));
        return this.qtQuestuserServiceRepository.updateQuestuserValue(qtQuestuserValueDomain);
    }

    @RequestMapping(value={"deleteQuestuserValue.json"}, name="\u5220\u9664\u7528\u6237\u6570\u636e\u5bf9\u5e94\u503c\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteQuestuserValue(Integer questuserValueId) {
        if (StringUtils.isBlank((Integer)questuserValueId)) {
            this.logger.error(CODE + ".deleteQuestuserValue", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.qtQuestuserServiceRepository.deleteQuestuserValue(questuserValueId);
    }

    @RequestMapping(value={"queryQuestuserValuePage.json"}, name="\u67e5\u8be2\u7528\u6237\u6570\u636e\u5bf9\u5e94\u503c\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<QtQuestuserValueReDomain> queryQuestuserValuePage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.qtQuestuserServiceRepository.queryQuestuserValuePage(param);
    }

    @RequestMapping(value={"updateQuestuserValueState.json"}, name="\u66f4\u65b0\u7528\u6237\u6570\u636e\u5bf9\u5e94\u503c\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateQuestuserValueState(String questuserValueId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)questuserValueId)) {
            this.logger.error(CODE + ".updateQuestuserValueState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.qtQuestuserServiceRepository.updateQuestuserValueState(Integer.valueOf(questuserValueId), dataState, oldDataState);
    }

    @RequestMapping(value={"saveQuest.json"}, name="\u589e\u52a0\u95ee\u5377\u7ed3\u679c\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveQuest(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveQuestuser", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveQuest.userSession", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        QtQuestuserDomain qtQuestuserDomain = (QtQuestuserDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, QtQuestuserDomain.class);
        if (null == qtQuestuserDomain) {
            this.logger.error(CODE + ".saveQuest.qtQuestuserDomain", (Object)"qtQuestuserDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "qtQuestuserDomain is null");
        }
        if (StringUtils.isBlank((String)qtQuestuserDomain.getQuesttempCode())) {
            this.logger.error(CODE + ".saveQuest.questtempCode", (Object)"questtempCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "questtempCode is null");
        }
        String tenantCode = this.getTenantCode(request);
        QtQuesttempReDomain qtQuesttempReDomain = this.qtQuesttempServiceRepository.getQuesttempByCode(tenantCode, qtQuestuserDomain.getQuesttempCode());
        if (null == qtQuesttempReDomain) {
            this.logger.error(CODE + ".saveQuest.qtQuesttempReDomain", (Object)"qtQuesttempReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "qtQuesttempReDomain is null");
        }
        qtQuestuserDomain.setMemberBcode(qtQuesttempReDomain.getMemberBcode());
        qtQuestuserDomain.setMemberBname(qtQuesttempReDomain.getMemberBname());
        qtQuestuserDomain.setTenantCode(tenantCode);
        qtQuestuserDomain.setMemberCode(userSession.getUserPcode());
        qtQuestuserDomain.setMemberName(userSession.getMerberCompname());
        qtQuestuserDomain.setAppmanageIcode(userSession.getUserPhone());
        qtQuestuserDomain.setUserCode(userSession.getUserPhone());
        qtQuestuserDomain.setUserName(userSession.getUserName());
        return this.qtQuestuserServiceRepository.saveQuestuser(qtQuestuserDomain);
    }

    @RequestMapping(value={"getQuestuserYY.json"}, name="\u8fd0\u8425\u7aef\u67e5\u770b\u7ed3\u679c\u4fe1\u606f")
    @ResponseBody
    public QtQuesttempReDomain getQuestuserYY(HttpServletRequest request, String questuserCode) {
        if (null == questuserCode) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"paramStr is null");
            return null;
        }
        QtQuestuserReDomain qtQuestuserReDomain = this.qtQuestuserServiceRepository.getQuestuserByCode(this.getTenantCode(request), questuserCode);
        if (null == qtQuestuserReDomain) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"qtQuestuserReDomain is null");
            return null;
        }
        QtQuesttempReDomain qtQuesttempReDomain = this.qtQuesttempServiceRepository.getQuesttempByCode(qtQuestuserReDomain.getTenantCode(), qtQuestuserReDomain.getQuesttempCode());
        if (null == qtQuesttempReDomain) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"qtQuestuserReDomain is null");
            return null;
        }
        List qtQuesttempListReDomainList = qtQuesttempReDomain.getQtQuesttempListReDomainList();
        if (ListUtil.isEmpty((Collection)qtQuesttempListReDomainList)) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"qtQuesttempListReDomainList is null");
            return null;
        }
        List qtQuestuserReDomainList = qtQuestuserReDomain.getQtQuestuserValueReDomainList();
        if (ListUtil.isEmpty((Collection)qtQuestuserReDomainList)) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"qtQuestuserReDomainList is null");
            return null;
        }
        HashMap<String, QtQuestuserValueReDomain> valueMap = new HashMap<String, QtQuestuserValueReDomain>();
        for (QtQuestuserValueReDomain qtQuestuserValueReDomain : qtQuestuserReDomainList) {
            valueMap.put(qtQuestuserValueReDomain.getQuesttempListCode(), qtQuestuserValueReDomain);
        }
        for (QtQuesttempListReDomain qtQuesttempListReDomain : qtQuesttempListReDomainList) {
            QtQuestuserValueReDomain qtQuestuserValueReDomain = (QtQuestuserValueReDomain)valueMap.get(qtQuesttempListReDomain.getQuesttempListCode());
            if (ListUtil.isEmpty((Collection)qtQuesttempListReDomain.getQuestproOptionList())) {
                if (null == qtQuestuserValueReDomain) continue;
                qtQuesttempListReDomain.setValue(qtQuestuserValueReDomain.getQuestuserValueValue());
                continue;
            }
            String valuestr = qtQuestuserValueReDomain.getQuestuserValueValue();
            for (QtQuestproOptionDomain qtQuestproOptionDomain : qtQuesttempListReDomain.getQuestproOptionList()) {
                if (valuestr.indexOf(qtQuestproOptionDomain.getQuestproOptionCode()) < 0) continue;
                qtQuestproOptionDomain.setValue(qtQuestproOptionDomain.getQuestproOptionCode());
            }
        }
        return qtQuesttempReDomain;
    }

    @RequestMapping(value={"queryQuestuserPagePCtoC.json"}, name="PC\u7aef\u4f01\u4e1a\u67e5\u770b\u6570\u636e\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<QtQuestuserReDomain> queryQuestuserPagePCtoC(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.remove("userName");
        param.remove("userCode");
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult result = this.qtQuestuserServiceRepository.queryQuestuserPage(param);
        List list = result.getList();
        if (null != list && list.size() > 0) {
            for (QtQuestuserReDomain qtQuestuserReDomain : list) {
                HashMap<String, String> param1 = new HashMap<String, String>();
                param1.put("questuserCode", qtQuestuserReDomain.getQuestuserCode());
                List list1 = this.qtQuestuserServiceRepository.queryQuestuserValuePage(param1).getList();
                qtQuestuserReDomain.setQtQuestuserValueReDomainList(list1);
            }
        }
        return result;
    }

    @RequestMapping(value={"getQuestuserPC.json"}, name="PC\u7aef\u4f01\u4e1a\u67e5\u770b\u7ed3\u679c\u8be6\u7ec6\u4fe1\u606f")
    @ResponseBody
    public QtQuesttempReDomain getQuestuserPC(HttpServletRequest request, String questtempCode) {
        if (null == questtempCode) {
            this.logger.error(CODE + ".getQuestuserPC", (Object)"questtempCode is null");
            return null;
        }
        QtQuesttempReDomain qtQuesttempReDomain = this.qtQuesttempServiceRepository.getQuesttempByCode(this.getTenantCode(request), questtempCode);
        if (null == qtQuesttempReDomain) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"qtQuestuserReDomain is null");
            return null;
        }
        List qtQuesttempListReDomainList = qtQuesttempReDomain.getQtQuesttempListReDomainList();
        if (ListUtil.isEmpty((Collection)qtQuesttempListReDomainList)) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"qtQuesttempListReDomainList is null");
            return null;
        }
        if ("3".equals(qtQuesttempReDomain.getQuesttempShort())) {
            return qtQuesttempReDomain;
        }
        for (QtQuesttempListReDomain qtQuesttempListReDomain : qtQuesttempListReDomainList) {
            List questproOptionList = qtQuesttempListReDomain.getQuestproOptionList();
            if (ListUtil.isEmpty((Collection)questproOptionList)) {
                this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"questproOptionList is null");
                return null;
            }
            for (QtQuestproOptionDomain qtQuestproOptionDomain : questproOptionList) {
                String optionCode = qtQuestproOptionDomain.getQuestproOptionCode();
                HashMap<String, Object> optionMap = new HashMap<String, Object>();
                optionMap.put("fuzzy", true);
                optionMap.put("questuserValueValue", optionCode);
                SupQueryResult qtQuestuserValueReDomainList = this.qtQuestuserServiceRepository.queryQuestuserValuePage(optionMap);
                Long total = qtQuestuserValueReDomainList.getTotal();
                if (null == total) continue;
                qtQuestproOptionDomain.setValue(total.toString());
            }
        }
        return qtQuesttempReDomain;
    }

    @RequestMapping(value={"getQuestPC.json"}, name="PC\u7aef\u4f01\u4e1a\u67e5\u770b\u62a5\u540d\u8be6\u60c5")
    @ResponseBody
    public SupQueryResult<QtQuestuserReDomain> getQuestPC(HttpServletRequest request) {
        QtQuestuserReDomain qtQuestuserReDomain;
        SupQueryResult qtQuestuserReDomainS;
        List qtQuestuserReDomainList;
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        if (null != (qtQuestuserReDomainList = (qtQuestuserReDomainS = this.qtQuestuserServiceRepository.queryQuestuserPage(param)).getList()) && qtQuestuserReDomainList.size() > 0 && null != (qtQuestuserReDomain = (QtQuestuserReDomain)qtQuestuserReDomainList.get(0))) {
            String qUserCode = qtQuestuserReDomain.getQuestuserCode();
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("questuserCode", qUserCode);
            qtQuestuserReDomain.setQtQuestuserValueReDomainList(this.qtQuestuserServiceRepository.queryQuestuserValuePage(valueMap).getList());
        }
        return qtQuestuserReDomainS;
    }

    @RequestMapping(value={"saveQuestWAP.json"}, name="wap\u7aef\u589e\u52a0\u95ee\u5377\u7ed3\u679c\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveQuestWAP(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveQuestWAP", (Object)"paramStr is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        UserSession userSession = this.getUserSession(request);
        if (null == userSession) {
            this.logger.error(CODE + ".saveQuest.userSession", (Object)"userSession is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        QtQuestuserDomain qtQuestuserDomain = (QtQuestuserDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject(paramStr, QtQuestuserDomain.class);
        if (null == qtQuestuserDomain) {
            this.logger.error(CODE + ".saveQuest.qtQuestuserDomain", (Object)"qtQuestuserDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "qtQuestuserDomain is null");
        }
        if (StringUtils.isBlank((String)qtQuestuserDomain.getQuesttempCode())) {
            this.logger.error(CODE + ".saveQuest.questtempCode", (Object)"questtempCode is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "questtempCode is null");
        }
        String tenantCode = this.getTenantCode(request);
        QtQuesttempReDomain qtQuesttempReDomain = this.qtQuesttempServiceRepository.getQuesttempByCode(tenantCode, qtQuestuserDomain.getQuesttempCode());
        if (null == qtQuesttempReDomain) {
            this.logger.error(CODE + ".saveQuest.qtQuesttempReDomain", (Object)"qtQuesttempReDomain is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "qtQuesttempReDomain is null");
        }
        qtQuestuserDomain.setMemberBcode(qtQuesttempReDomain.getMemberBcode());
        qtQuestuserDomain.setMemberBname(qtQuesttempReDomain.getMemberBname());
        qtQuestuserDomain.setTenantCode(tenantCode);
        qtQuestuserDomain.setMemberCode(userSession.getUserPcode());
        qtQuestuserDomain.setMemberName(userSession.getMerberCompname());
        qtQuestuserDomain.setAppmanageIcode(userSession.getUserPhone());
        qtQuestuserDomain.setUserCode(userSession.getUserCode());
        qtQuestuserDomain.setUserName(userSession.getUserName());
        return this.qtQuestuserServiceRepository.saveQuestuser(qtQuestuserDomain);
    }

    @RequestMapping(value={"queryQuestuserPageWAP.json"}, name="WAP\u7aef\u5458\u5de5\u67e5\u770b\u6570\u636e\u4fe1\u606f")
    @ResponseBody
    public SupQueryResult<QtQuestuserReDomain> queryQuestuserPagePCtoB(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        param.remove("userName");
        param.put("tenantCode", this.getTenantCode(request));
        SupQueryResult result = this.qtQuestuserServiceRepository.queryQuestuserPage(param);
        List list = result.getList();
        if (null != list && list.size() > 0) {
            for (QtQuestuserReDomain qtQuestuserReDomain : list) {
                HashMap<String, String> param1 = new HashMap<String, String>();
                param1.put("questuserCode", qtQuestuserReDomain.getQuestuserCode());
                List list1 = this.qtQuestuserServiceRepository.queryQuestuserValuePage(param1).getList();
                qtQuestuserReDomain.setQtQuestuserValueReDomainList(list1);
            }
        }
        return result;
    }

    @RequestMapping(value={"getQuestuserPageWAP.json"}, name="WAP\u7aef\u5458\u5de5\u67e5\u770b\u7ed3\u679c\u8be6\u7ec6\u4fe1\u606f")
    @ResponseBody
    public QtQuesttempReDomain getQuestuserPageWAP(HttpServletRequest request, String questtempCode) {
        if (null == questtempCode) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"questtempCode is null");
            return null;
        }
        UserSession userSession = this.getUserSession(request);
        String userCode = userSession.getUserCode();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", userCode);
        map.put("questtempCode", questtempCode);
        List qtQuestuserDomainList = this.qtQuestuserServiceRepository.queryQuestuserPage(map).getList();
        if (null == qtQuestuserDomainList || qtQuestuserDomainList.size() == 0) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"qtQuestuserDomainList is null");
            return null;
        }
        QtQuestuserReDomain qtQuestuserReDomain = (QtQuestuserReDomain)qtQuestuserDomainList.get(0);
        if (null == qtQuestuserReDomain) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"qtQuestuserReDomain is null");
            return null;
        }
        QtQuesttempReDomain qtQuesttempReDomain = this.qtQuesttempServiceRepository.getQuesttempByCode(qtQuestuserReDomain.getTenantCode(), qtQuestuserReDomain.getQuesttempCode());
        if (null == qtQuesttempReDomain) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"qtQuesttempReDomain is null");
            return null;
        }
        List qtQuesttempListReDomainList = qtQuesttempReDomain.getQtQuesttempListReDomainList();
        if (ListUtil.isEmpty((Collection)qtQuesttempListReDomainList)) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"qtQuesttempListReDomainList is null");
            return null;
        }
        HashMap<String, String> valueMap1 = new HashMap<String, String>();
        valueMap1.put("questuserCode", qtQuestuserReDomain.getQuestuserCode());
        valueMap1.put("tenantCode", qtQuestuserReDomain.getTenantCode());
        List qtQuestuserValueReDomainList = this.qtQuestuserServiceRepository.queryQuestuserValuePage(valueMap1).getList();
        if (ListUtil.isEmpty((Collection)qtQuestuserValueReDomainList)) {
            this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"qtQuestuserValueReDomainList is null");
            return null;
        }
        String type = qtQuesttempReDomain.getQuesttempShort();
        if ("1".equals(type)) {
            QtQuesttempListReDomain qtQuesttempListReDomain = (QtQuesttempListReDomain)qtQuesttempListReDomainList.get(0);
            List questproOptionList = qtQuesttempListReDomain.getQuestproOptionList();
            if (ListUtil.isEmpty((Collection)questproOptionList)) {
                this.logger.error(CODE + ".getQuestuserPageWAP", (Object)"questproOptionList is null");
                return null;
            }
            for (QtQuestproOptionDomain qtQuestproOptionDomain : questproOptionList) {
                String optionCode = qtQuestproOptionDomain.getQuestproOptionCode();
                HashMap<String, Object> optionMap = new HashMap<String, Object>();
                optionMap.put("fuzzy", true);
                optionMap.put("questuserValueValue", optionCode);
                SupQueryResult qtQuestuserValueDomainList = this.qtQuestuserServiceRepository.queryQuestuserValuePage(optionMap);
                Long total = qtQuestuserValueDomainList.getTotal();
                if (null == total) continue;
                qtQuestproOptionDomain.setValue(total.toString());
            }
            return qtQuesttempReDomain;
        }
        HashMap<String, QtQuestuserValueReDomain> valueMap = new HashMap<String, QtQuestuserValueReDomain>();
        for (QtQuestuserValueReDomain qtQuestuserValueReDomain : qtQuestuserValueReDomainList) {
            valueMap.put(qtQuestuserValueReDomain.getQuesttempListCode(), qtQuestuserValueReDomain);
        }
        for (QtQuesttempListReDomain qtQuesttempListReDomain : qtQuesttempListReDomainList) {
            QtQuestuserValueReDomain qtQuestuserValueReDomain = (QtQuestuserValueReDomain)valueMap.get(qtQuesttempListReDomain.getQuesttempListCode());
            if (null == qtQuestuserValueReDomain) continue;
            if (ListUtil.isEmpty((Collection)qtQuesttempListReDomain.getQuestproOptionList())) {
                if (null == qtQuestuserValueReDomain) continue;
                qtQuesttempListReDomain.setValue(qtQuestuserValueReDomain.getQuestuserValueValue());
                continue;
            }
            String valuestr = qtQuestuserValueReDomain.getQuestuserValueValue();
            for (QtQuestproOptionDomain qtQuestproOptionDomain : qtQuesttempListReDomain.getQuestproOptionList()) {
                if (valuestr.indexOf(qtQuestproOptionDomain.getQuestproOptionCode()) < 0) continue;
                qtQuestproOptionDomain.setValue(qtQuestproOptionDomain.getQuestproOptionCode());
            }
        }
        return qtQuesttempReDomain;
    }

    @RequestMapping(value={"signUpActive.json"}, name="\u62a5\u540d\u53c2\u52a0\u6d3b\u52a8")
    @ResponseBody
    public HtmlJsonReBean signUpActive(HttpServletRequest request) {
        Map startMap = this.assemMapParam(request);
        if (startMap.containsKey("questtempCode") && StringUtils.isEmpty((String)String.valueOf(startMap.get("questtempCode")))) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "questtempCode is null");
        }
        String questtempCode = String.valueOf(startMap.get("questtempCode"));
        UserSession userSession = this.getUserSession(request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", userSession.getUserPcode());
        map.put("questtempCode", questtempCode);
        map.put("tenantCode", this.getTenantCode(request));
        SupQueryResult supQueryResult = this.qtQuestuserServiceRepository.queryQuestuserPage(map);
        if (null != supQueryResult && ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
            this.logger.error(CODE + ".signUpActive.supQueryResult.null", (Object)((Object)map).toString());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u5df2\u62a5\u540d");
        }
        if (null == userSession) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u7528\u6237\u672a\u767b\u5f55");
        }
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("questtempCode", questtempCode);
        tempMap.put("tenantCode", this.getTenantCode(request));
        SupQueryResult tempSupQueryResult = this.qtQuesttempServiceRepository.queryQuesttempPage(tempMap);
        if (null == tempSupQueryResult || ListUtil.isEmpty((Collection)tempSupQueryResult.getList())) {
            this.logger.error(CODE + ".signUpActive.questtempCode", (Object)((Object)tempMap).toString());
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u6d3b\u52a8\u5f02\u5e38");
        }
        QtQuesttempReDomain questtempByCode = (QtQuesttempReDomain)tempSupQueryResult.getList().get(0);
        if (!this.getState(new Date(), questtempByCode.getQuesttempSentry())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62a5\u540d\u672a\u5f00\u59cb");
        }
        if (this.getState(new Date(), questtempByCode.getQuesttempEentry())) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62a5\u540d\u5df2\u7ed3\u675f");
        }
        Integer questtempNum = questtempByCode.getQuesttempNum();
        if (0 != questtempNum) {
            map.remove("memberCode");
            map.put("page", 1);
            map.put("rows", 1);
            this.logger.error(CODE + ".signUpActive.map.again", (Object)((Object)map).toString());
            SupQueryResult numSupQueryResult = this.qtQuestuserServiceRepository.queryQuestuserPage(map);
            Integer recordCount = numSupQueryResult.getPageTools().getRecordCount();
            if (questtempNum - recordCount < 0) {
                return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u62a5\u540d\u4eba\u6570\u5df2\u6ee1");
            }
        }
        QtQuestuserDomain qtQuestuserDomain = new QtQuestuserDomain();
        qtQuestuserDomain.setTenantCode(this.getTenantCode(request));
        qtQuestuserDomain.setMemberCode(userSession.getUserPcode());
        qtQuestuserDomain.setMemberName(userSession.getUserName());
        if (startMap.containsKey("phone")) {
            qtQuestuserDomain.setQuesttempPhone(String.valueOf(startMap.get("phone")));
        }
        qtQuestuserDomain.setQuesttempCode(questtempCode);
        qtQuestuserDomain.setQuesttempName(questtempByCode.getQuesttempName());
        qtQuestuserDomain.setQuesttempRemark(questtempByCode.getQuesttempRemark());
        qtQuestuserDomain.setQuesttempType("1");
        if (startMap.containsKey("addr")) {
            qtQuestuserDomain.setQuesttempAreaname(String.valueOf(startMap.get("addr")));
        }
        this.qtQuestuserServiceRepository.saveQuestuser(qtQuestuserDomain);
        if (!startMap.containsKey("memo") || StringUtils.isNotBlank((String)String.valueOf(startMap.containsKey("memo")))) {
            // empty if block
        }
        return new HtmlJsonReBean();
    }

    private boolean getState(Date dayStart, Date dayEnd) {
        long now = System.currentTimeMillis();
        long startTime = dayStart.getTime();
        long endTime = dayEnd.getTime();
        return endTime < startTime;
    }
}

