/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.rec.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitEnrollReDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitReDomain;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitFileServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rec/recruit"}, name="\u62db\u52df\u670d\u52a1")
public class RecruitCon
extends SpringmvcController {
    private static String CODE = "rec.recruit.con";
    @Autowired
    private RecRecruitServiceRepository recRecruitServiceRepository;
    @Autowired
    private RecRecruitEnrollServiceRepository recRecruitEnrollServiceRepository;
    @Autowired
    private RecRecruitOtherServiceRepository recRecruitOtherServiceRepository;
    @Autowired
    private RecRecruitFileServiceRepository recRecruitFileServiceRepository;

    protected String getContext() {
        return "recruit";
    }

    @RequestMapping(value={"saveRecruit.json"}, name="\u589e\u52a0\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRecruit(HttpServletRequest request, String paramStr) {
        if (null == paramStr) {
            this.logger.error(CODE + ".saveRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RecRecruitDomain recRecruitDomain = (RecRecruitDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RecRecruitDomain.class);
        recRecruitDomain.setTenantCode(this.getTenantCode(request));
        UserSession userSession = this.getUserSession(request);
        if (null != userSession) {
            recRecruitDomain.setMemberBname(userSession.getUserName());
            recRecruitDomain.setMemberBcode(userSession.getUserPcode());
        }
        return this.recRecruitServiceRepository.saveRecruit(recRecruitDomain);
    }

    @RequestMapping(value={"getRecruit.json"}, name="\u83b7\u53d6\u62db\u52df\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public RecRecruitReDomain getRecruit(HttpServletRequest request, Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error(CODE + ".getRecruit", (Object)"param is null");
            return null;
        }
        RecRecruitReDomain recRecruitReDomain = this.recRecruitServiceRepository.getRecruit(recruitId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", this.getTenantCode(request));
        map.put("recruitCode", recRecruitReDomain.getRecruitCode());
        List recRecruitEnrollReDomainList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(map).getList();
        recRecruitReDomain.setRecRecruitEnrollReDomainList(recRecruitEnrollReDomainList);
        List recRecruitFileReDomainList = this.recRecruitFileServiceRepository.queryRecruitFilePage(map).getList();
        recRecruitReDomain.setRecRecruitFileReDomainList(recRecruitFileReDomainList);
        List recRecruitOtherReDomainList = this.recRecruitOtherServiceRepository.queryRecruitOtherPage(map).getList();
        recRecruitReDomain.setRecRecruitOtherReDomainList(recRecruitOtherReDomainList);
        return recRecruitReDomain;
    }

    @RequestMapping(value={"updateRecruit.json"}, name="\u66f4\u65b0\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRecruit(HttpServletRequest request, RecRecruitDomain recRecruitDomain) {
        if (null == recRecruitDomain) {
            this.logger.error(CODE + ".updateRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        recRecruitDomain.setTenantCode(this.getTenantCode(request));
        return this.recRecruitServiceRepository.updateRecruit(recRecruitDomain);
    }

    @RequestMapping(value={"deleteRecruit.json"}, name="\u5220\u9664\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRecruit(Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error(CODE + ".deleteRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recRecruitServiceRepository.deleteRecruit(recruitId);
    }

    @RequestMapping(value={"queryRecruitPage.json"}, name="\u67e5\u8be2\u62db\u52df\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RecRecruitReDomain> queryRecruitPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String map = param.toString();
        String dataState = request.getParameter("dataState");
        String recruitCode = request.getParameter("recruitCode");
        String recruitName = request.getParameter("recruitName");
        String memberBname = request.getParameter("memberBname");
        String recruitSdate = request.getParameter("recruitSdate");
        String recruitEdate = request.getParameter("recruitEdate");
        String recruitSdateQstart = request.getParameter("recruitSdateQstart");
        String recruitEdateQend = request.getParameter("recruitEdateQend");
        this.logger.info("map---------------------------------------" + map.toString());
        this.logger.info("recruitCode---------------------------------------" + recruitCode + "\n" + "recruitName---------------------------------------" + recruitName + "\n" + "memberBname---------------------------------------" + memberBname + "\n" + "recruitSdate---------------------------------------" + recruitSdate + "\n" + "recruitEdate---------------------------------------" + recruitEdate + "\n" + "recruitSdate---------------------------------------" + recruitSdate + "\n" + "recruitSdateQstart---------------------------------------" + recruitSdateQstart + "\n" + "recruitEdateQend---------------------------------------" + recruitEdateQend + "\n");
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
            param.put("orderStr", "GMT_CREATE desc");
        }
        SupQueryResult supQueryResult = this.recRecruitServiceRepository.queryRecruitPage(param);
        List list = supQueryResult.getList();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> mapParm = new HashMap<String, Object>();
            mapParm.put("fuzzy", false);
            mapParm.put("tenantCode", ((RecRecruitReDomain)list.get(i)).getTenantCode());
            mapParm.put("recruitCode", ((RecRecruitReDomain)list.get(i)).getRecruitCode());
            List enrollList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(mapParm).getList();
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollCount(Integer.valueOf(enrollList.size()));
            this.logger.error("controller----------------------------\u62a5\u540d\u6570\u91cfcount-----------------------" + ((RecRecruitReDomain)list.get(i)).getRecruitEnrollCount());
            System.out.println("controller----------------------------\u62a5\u540d\u6570\u91cfcount-----------------------" + ((RecRecruitReDomain)list.get(i)).getRecruitEnrollCount());
            int count = 0;
            for (RecRecruitEnrollReDomain rr : enrollList) {
                if (null == rr.getRecruitEnrollQstate() || rr.getRecruitEnrollQstate() != 1) continue;
                ++count;
            }
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollQstate(Integer.valueOf(count));
            this.logger.error("controller----------------------------\u5ba1\u6838\u901a\u8fc7count-----------------------" + count);
            System.out.println("controller----------------------------\u5ba1\u6838\u901a\u8fc7count-----------------------" + count);
        }
        supQueryResult.setList(list);
        return supQueryResult;
    }

    @RequestMapping(value={"updateRecruitState.json"}, name="\u66f4\u65b0\u62db\u52df\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRecruitState(String recruitId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)recruitId)) {
            this.logger.error(CODE + ".updateRecruitState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recRecruitServiceRepository.updateRecruitState(Integer.valueOf(recruitId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryCountByState.json"}, name="\u62db\u52df\u5217\u8868\u7684\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean queryCountByState(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        this.logger.error("queryCountByState----------------------------wweiwenhong-----------------------" + tenantCode);
        System.out.println("tenantCode----------------------------wweiwenhong-----------------------" + tenantCode);
        String recruitType = request.getParameter("recruitType");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryCountByState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        int dataState = 0;
        System.out.println("recruitType----------------------------wweiwenhong-----------------------" + recruitType);
        return this.recRecruitServiceRepository.queryCountByState(tenantCode, dataState, recruitType);
    }
}

