/*
 * Decompiled with CFR 0.152.
 */
package com.qjsoft.laser.controller.rec.controller;

import com.qjsoft.laser.controller.core.auth.UserSession;
import com.qjsoft.laser.controller.core.bean.HtmlJsonReBean;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitEnrollDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitPersonnelReDomain;
import com.qjsoft.laser.controller.facade.rec.domain.RecRecruitReDomain;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitEnrollServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitFileServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitOtherServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitPersonnelServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitServiceAreaServiceRepository;
import com.qjsoft.laser.controller.facade.rec.repository.RecRecruitServiceRepository;
import com.qjsoft.laser.controller.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rec/recruit"}, name="\u62db\u52df\u670d\u52a1")
public class RecruitCon
extends SpringmvcController {
    private static String CODE = "rec.recruit.con";
    @Autowired
    private RecRecruitServiceRepository recRecruitServiceRepository;
    @Autowired
    private RecRecruitEnrollServiceRepository recRecruitEnrollServiceRepository;
    @Autowired
    private RecRecruitOtherServiceRepository recRecruitOtherServiceRepository;
    @Autowired
    private RecRecruitFileServiceRepository recRecruitFileServiceRepository;
    @Autowired
    private RecRecruitPersonnelServiceRepository recRecruitPersonnelServiceRepository;
    @Autowired
    private RecRecruitServiceAreaServiceRepository recRecruitServiceAreaServiceRepository;

    protected String getContext() {
        return "recruit";
    }

    @RequestMapping(value={"saveRecruit.json"}, name="\u589e\u52a0\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean saveRecruit(HttpServletRequest request, String paramStr) {
        UserSession userSession;
        this.logger.error("saveRecruit----------------------------------paramStr------------------------------" + paramStr);
        if (null == paramStr) {
            this.logger.error(CODE + ".saveRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        RecRecruitReDomain recRecruitReDomain = (RecRecruitReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RecRecruitReDomain.class);
        if (null == recRecruitReDomain) {
            this.logger.error(CODE + ".recRecruitReDomain", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        if (null != recRecruitReDomain) {
            recRecruitReDomain.setTenantCode(this.getTenantCode(request));
        }
        if (null != (userSession = this.getUserSession(request))) {
            recRecruitReDomain.setMemberBname(userSession.getUserName());
            recRecruitReDomain.setMemberBcode(userSession.getUserPcode());
        }
        return this.recRecruitServiceRepository.saveRecruit(recRecruitReDomain);
    }

    @RequestMapping(value={"getRecruit.json"}, name="\u83b7\u53d6\u62db\u52df\u670d\u52a1\u4fe1\u606f")
    @ResponseBody
    public RecRecruitReDomain getRecruit(HttpServletRequest request, Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error(CODE + ".getRecruit", (Object)"param is null");
            return null;
        }
        RecRecruitReDomain recRecruitReDomain = this.recRecruitServiceRepository.getRecruit(recruitId);
        List recRecruitEnrollDomainList = null;
        List recRecruitFileDomainList = null;
        List recRecruitOtherReDomainList = null;
        String tenantCode = this.getTenantCode(request);
        HashMap<String, String> map = null;
        if (null != recRecruitReDomain && StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitCode())) {
            map = new HashMap<String, String>();
            map.put("tenantCode", tenantCode);
            map.put("recruitCode", recRecruitReDomain.getRecruitCode());
            recRecruitEnrollDomainList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(map).getList();
            recRecruitReDomain.setRecRecruitEnrollList(recRecruitEnrollDomainList);
            recRecruitFileDomainList = this.recRecruitFileServiceRepository.queryRecruitFilePage(map).getList();
            recRecruitReDomain.setRecRecruitFileDomainList(recRecruitFileDomainList);
            recRecruitOtherReDomainList = this.recRecruitOtherServiceRepository.queryRecruitOtherPage(map).getList();
            recRecruitReDomain.setRecRecruitOtherDomainList(recRecruitOtherReDomainList);
        }
        if (StringUtils.isNotBlank((String)recRecruitReDomain.getRecruitType()) && recRecruitReDomain.getRecruitType().equals("02")) {
            SupQueryResult supQueryResult = this.recRecruitPersonnelServiceRepository.queryRecRecruitPersonnelPage(map);
            List recRecruitPersonnelReDomainList = null;
            if (ListUtil.isNotEmpty((Collection)supQueryResult.getList())) {
                recRecruitPersonnelReDomainList = supQueryResult.getList();
                for (int i = 0; i < recRecruitPersonnelReDomainList.size(); ++i) {
                    HashMap<String, String> map0 = new HashMap<String, String>();
                    map0.put("tenantCode", tenantCode);
                    map0.put("memberCode", ((RecRecruitPersonnelReDomain)recRecruitPersonnelReDomainList.get(i)).getMemberCode());
                    System.out.println("map0---------------------xxxxxxx---------------------------------------------" + map0);
                    SupQueryResult supQueryResult0 = this.recRecruitServiceAreaServiceRepository.queryRecRecruitServiceAreaPage(map0);
                    System.out.println("supQueryResult0.size------------------------xxxxxxxx--------------------------------" + supQueryResult0.getList());
                    ((RecRecruitPersonnelReDomain)recRecruitPersonnelReDomainList.get(i)).setRecRecruitServiceAreaReDomainList(supQueryResult0.getList());
                }
            }
            recRecruitReDomain.setRecRecruitPersonnelReDomainList(recRecruitPersonnelReDomainList);
        }
        return recRecruitReDomain;
    }

    @RequestMapping(value={"updateRecruit.json"}, name="\u66f4\u65b0\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean updateRecruit(HttpServletRequest request, String paramStr) {
        System.out.println("-----------------------------------paramStr10--------------------------------" + paramStr);
        RecRecruitReDomain recRecruitReDomain = (RecRecruitReDomain)JsonUtil.buildNormalBinder().getJsonToObject(paramStr, RecRecruitReDomain.class);
        if (null == recRecruitReDomain) {
            this.logger.error(CODE + ".updateRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        recRecruitReDomain.setTenantCode(this.getTenantCode(request));
        System.out.println("gengxin1-----------------------------------------------------------------------------------");
        return this.recRecruitServiceRepository.updateRecruit((RecRecruitDomain)recRecruitReDomain);
    }

    @RequestMapping(value={"deleteRecruit.json"}, name="\u5220\u9664\u62db\u52df\u670d\u52a1")
    @ResponseBody
    public HtmlJsonReBean deleteRecruit(Integer recruitId) {
        if (StringUtils.isBlank((Integer)recruitId)) {
            this.logger.error(CODE + ".deleteRecruit", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recRecruitServiceRepository.deleteRecruit(recruitId);
    }

    @RequestMapping(value={"queryRecruitPage.json"}, name="\u67e5\u8be2\u62db\u52df\u670d\u52a1\u5206\u9875\u5217\u8868")
    @ResponseBody
    public SupQueryResult<RecRecruitReDomain> queryRecruitPage(HttpServletRequest request) {
        Map param = this.assemMapParam(request);
        String map = param.toString();
        String dataState = request.getParameter("dataState");
        String recruitCode = request.getParameter("recruitCode");
        String recruitName = request.getParameter("recruitName");
        String memberBname = request.getParameter("memberBname");
        String recruitSdate = request.getParameter("recruitSdate");
        String recruitEdate = request.getParameter("recruitEdate");
        String recruitSdateQstart = request.getParameter("recruitSdateQstart");
        String recruitEdateQend = request.getParameter("recruitEdateQend");
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", false);
            param.put("orderStr", "GMT_CREATE desc");
        }
        System.out.println("param-----------------RecruitCon------------queryRecruitPage------------------------" + param);
        SupQueryResult supQueryResult = this.recRecruitServiceRepository.queryRecruitPage(param);
        List list = supQueryResult.getList();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> mapParm = new HashMap<String, Object>();
            mapParm.put("fuzzy", false);
            mapParm.put("tenantCode", ((RecRecruitReDomain)list.get(i)).getTenantCode());
            mapParm.put("recruitCode", ((RecRecruitReDomain)list.get(i)).getRecruitCode());
            List enrollList = this.recRecruitEnrollServiceRepository.queryRecruitEnrollPage(mapParm).getList();
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollCount(Integer.valueOf(enrollList.size()));
            this.logger.error("controller----------------------------\u62a5\u540d\u6570\u91cfcount-----------------------" + ((RecRecruitReDomain)list.get(i)).getRecruitEnrollCount());
            int count = 0;
            for (RecRecruitEnrollDomain rr : enrollList) {
                if (null == rr.getRecruitEnrollQstate() || rr.getRecruitEnrollQstate() != 1) continue;
                ++count;
            }
            ((RecRecruitReDomain)list.get(i)).setRecruitEnrollQstate(Integer.valueOf(count));
            this.logger.error("controller----------------------------\u5ba1\u6838\u901a\u8fc7count-----------------------" + count);
        }
        supQueryResult.setList(list);
        return supQueryResult;
    }

    @RequestMapping(value={"updateRecruitState.json"}, name="\u66f4\u65b0\u62db\u52df\u670d\u52a1\u72b6\u6001")
    @ResponseBody
    public HtmlJsonReBean updateRecruitState(String recruitId, Integer dataState, Integer oldDataState) {
        if (StringUtils.isBlank((String)recruitId)) {
            this.logger.error(CODE + ".updateRecruitState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.recRecruitServiceRepository.updateRecruitState(Integer.valueOf(recruitId), dataState, oldDataState, null);
    }

    @RequestMapping(value={"queryCountByState.json"}, name="\u62db\u52df\u5217\u8868\u7684\u7edf\u8ba1\u6570\u636e")
    @ResponseBody
    public HtmlJsonReBean queryCountByState(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String recruitType = request.getParameter("recruitType");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryCountByState", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        int dataState = 0;
        return this.recRecruitServiceRepository.queryCountByState(tenantCode, dataState);
    }

    @RequestMapping(value={"queryCountByState1.json"}, name="\u62db\u52df\u5217\u8868\u7684\u7edf\u8ba1\u6570\u636e1")
    @ResponseBody
    public HtmlJsonReBean queryCountByState1(HttpServletRequest request) {
        String tenantCode = this.getTenantCode(request);
        String recruitType = request.getParameter("recruitType");
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error(CODE + ".queryCountByState1", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        int dataState = 0;
        return this.recRecruitServiceRepository.queryCountByState1(tenantCode, dataState, recruitType);
    }
}

